/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor$1;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.FilePermission;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.ImageLayout;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

public class MediaLibAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    public static final int COPY_MASK = 128;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    public static final int DATATYPE_MASK = 127;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_BYTE_COPIED = 128;
    public static final int TAG_SHORT_COPIED = 130;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    protected Raster raster;
    protected Rectangle rect;
    protected int numBands;
    protected int[] bandOffsets;
    protected int formatTag;
    protected mediaLibImage[] mlimages;
    private static boolean useMlibVar = false;
    private static boolean useMlibVarSet = false;
    static Class class$com$sun$media$jai$mlib$MediaLibAccessor;

    public MediaLibAccessor(Raster raster, Rectangle rectangle, int n) {
        block18: {
            block17: {
                this.mlimages = null;
                this.raster = raster;
                this.rect = new Rectangle(rectangle);
                this.formatTag = n;
                if ((n & 0x80) != 0) break block17;
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                this.numBands = componentSampleModel.getNumBands();
                this.bandOffsets = componentSampleModel.getBandOffsets();
                int n2 = raster.getDataBuffer().getOffset();
                n2 += (rectangle.y - raster.getSampleModelTranslateY()) * componentSampleModel.getScanlineStride() + (rectangle.x - raster.getSampleModelTranslateX()) * componentSampleModel.getPixelStride();
                int n3 = componentSampleModel.getScanlineStride();
                switch (n & 0x7F) {
                    case 0: {
                        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n3, n2, (Object)dataBufferByte.getData());
                        break block18;
                    }
                    case 2: {
                        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n3, n2, (Object)dataBufferShort.getData());
                        break block18;
                    }
                    case 3: {
                        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n3, n2, (Object)dataBufferInt.getData());
                        break block18;
                    }
                    case 4: {
                        DataBufferFloat dataBufferFloat = (DataBufferFloat)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n3, n2, (Object)dataBufferFloat.getData());
                        break block18;
                    }
                    case 5: {
                        DataBufferDouble dataBufferDouble = (DataBufferDouble)raster.getDataBuffer();
                        this.mlimages = new mediaLibImage[1];
                        this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n3, n2, (Object)dataBufferDouble.getData());
                        break block18;
                    }
                    case 1: {
                        throw new IllegalArgumentException(JaiI18N.getString("MediaLibAccessor0"));
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(n & 0x7F) + JaiI18N.getString("MediaLibAccessor1"));
                    }
                }
            }
            this.numBands = raster.getNumBands();
            this.bandOffsets = new int[this.numBands];
            int n4 = 0;
            while (n4 < this.numBands) {
                this.bandOffsets[n4] = n4;
                ++n4;
            }
            int n5 = rectangle.width * this.numBands;
            switch (n & 0x7F) {
                case 0: {
                    byte[] byArray = new byte[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n5, 0, (Object)byArray);
                    break;
                }
                case 2: {
                    short[] sArray = new short[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n5, 0, (Object)sArray);
                    break;
                }
                case 3: {
                    int[] nArray = new int[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n5, 0, (Object)nArray);
                    break;
                }
                case 4: {
                    float[] fArray = new float[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n5, 0, (Object)fArray);
                    break;
                }
                case 5: {
                    double[] dArray = new double[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n5, 0, (Object)dArray);
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException(JaiI18N.getString("MediaLibAccessor0"));
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(n & 0x7F) + JaiI18N.getString("MediaLibAccessor1"));
                }
            }
            this.copyDataFromRaster();
        }
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
                break;
            }
        }
    }

    public final void clampDataArrays() {
        int n;
        if (!this.isDataCopy()) {
            return;
        }
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            return;
        }
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[0];
            if (nArray[n2] < 32) {
                bl = true;
            }
            if (nArray[n2] != n) {
                bl2 = false;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        n = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n == 1 && bl2 && nArray[0] == 16) {
            int n3 = 0;
            while (n3 < nArray.length) {
                dArray[n3] = 65535.0;
                dArray2[n3] = 0.0;
                ++n3;
            }
        } else if (n == 2 && bl2 && nArray[0] == 16) {
            int n4 = 0;
            while (n4 < nArray.length) {
                dArray[n4] = 32767.0;
                dArray2[n4] = -32768.0;
                ++n4;
            }
        } else if (n == 3 && bl2 && nArray[0] == 32) {
            int n5 = 0;
            while (n5 < nArray.length) {
                dArray[n5] = 2.147483647E9;
                dArray2[n5] = -2.147483648E9;
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < nArray.length) {
                dArray[n6] = (1 << nArray[n6]) - 1;
                dArray2[n6] = 0.0;
                ++n6;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        int n4 = 0;
        while (n4 < this.numBands) {
            double[] dArray3 = this.mlimages[0].getDoubleData();
            int n5 = n4;
            double d2 = dArray[n4];
            double d3 = dArray2[n4];
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n5;
                int n8 = 0;
                while (n8 < n) {
                    double d4 = dArray3[n7];
                    if (d4 < d3) {
                        dArray3[n7] = d3;
                    } else if (d4 > d2) {
                        dArray3[n7] = d2;
                    }
                    n7 += this.numBands;
                    ++n8;
                }
                n5 += n3;
                ++n6;
            }
            ++n4;
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        int n4 = 0;
        while (n4 < this.numBands) {
            float[] fArray3 = this.mlimages[0].getFloatData();
            int n5 = n4;
            float f2 = fArray[n4];
            float f3 = fArray2[n4];
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n5;
                int n8 = 0;
                while (n8 < n) {
                    float f4 = fArray3[n7];
                    if (f4 < f3) {
                        fArray3[n7] = f3;
                    } else if (f4 > f2) {
                        fArray3[n7] = f2;
                    }
                    n7 += this.numBands;
                    ++n8;
                }
                n5 += n3;
                ++n6;
            }
            ++n4;
        }
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        int n4 = 0;
        while (n4 < this.numBands) {
            int[] nArray3 = this.mlimages[0].getIntData();
            int n5 = n4;
            int n6 = nArray[n4];
            int n7 = nArray2[n4];
            int n8 = 0;
            while (n8 < n2) {
                int n9 = n5;
                int n10 = 0;
                while (n10 < n) {
                    int n11 = nArray3[n9];
                    if (n11 < n7) {
                        nArray3[n9] = n7;
                    } else if (n11 > n6) {
                        nArray3[n9] = n6;
                    }
                    n9 += this.numBands;
                    ++n10;
                }
                n5 += n3;
                ++n8;
            }
            ++n4;
        }
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void copyDataFromRaster() {
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            Object object;
            int n;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.raster.getSampleModel();
            int n2 = componentSampleModel.getScanlineStride();
            int n3 = componentSampleModel.getPixelStride();
            int n4 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n2 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n3;
            int[] nArray = componentSampleModel.getBankIndices();
            int[] nArray2 = componentSampleModel.getBandOffsets();
            int[] nArray3 = this.raster.getDataBuffer().getOffsets();
            if (nArray3.length == 1) {
                n = 0;
                while (n < this.numBands) {
                    int n5 = n++;
                    nArray2[n5] = nArray2[n5] + (nArray3[0] + n4);
                }
            } else if (nArray3.length == nArray2.length) {
                n = 0;
                while (n < this.numBands) {
                    int n6 = n;
                    nArray2[n6] = nArray2[n6] + (nArray3[n] + n4);
                    ++n;
                }
            }
            Object object2 = null;
            switch (this.getDataType()) {
                case 0: {
                    object = new byte[this.numBands][];
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        object[n7] = this.mlimages[0].getByteData();
                        ++n7;
                    }
                    object2 = object;
                    break;
                }
                case 2: {
                    short[][] sArray = new short[this.numBands][];
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        sArray[n8] = this.mlimages[0].getShortData();
                        ++n8;
                    }
                    object2 = sArray;
                    break;
                }
                case 3: {
                    int[][] nArray4 = new int[this.numBands][];
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        nArray4[n9] = this.mlimages[0].getIntData();
                        ++n9;
                    }
                    object2 = nArray4;
                    break;
                }
                case 4: {
                    float[][] fArray = new float[this.numBands][];
                    int n10 = 0;
                    while (n10 < this.numBands) {
                        fArray[n10] = this.mlimages[0].getFloatData();
                        ++n10;
                    }
                    object2 = fArray;
                    break;
                }
                case 5: {
                    double[][] dArray = new double[this.numBands][];
                    int n11 = 0;
                    while (n11 < this.numBands) {
                        dArray[n11] = this.mlimages[0].getDoubleData();
                        ++n11;
                    }
                    object2 = dArray;
                    break;
                }
            }
            object = null;
            switch (componentSampleModel.getDataType()) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                    byte[][] byArray = new byte[this.numBands][];
                    int n12 = 0;
                    while (n12 < this.numBands) {
                        byArray[n12] = dataBufferByte.getData(nArray[n12]);
                        ++n12;
                    }
                    object = byArray;
                    break;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                    short[][] sArray = new short[this.numBands][];
                    int n13 = 0;
                    while (n13 < this.numBands) {
                        sArray[n13] = dataBufferShort.getData(nArray[n13]);
                        ++n13;
                    }
                    object = sArray;
                    break;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                    int[][] nArray5 = new int[this.numBands][];
                    int n14 = 0;
                    while (n14 < this.numBands) {
                        nArray5[n14] = dataBufferInt.getData(nArray[n14]);
                        ++n14;
                    }
                    object = nArray5;
                    break;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)this.raster.getDataBuffer();
                    float[][] fArray = new float[this.numBands][];
                    int n15 = 0;
                    while (n15 < this.numBands) {
                        fArray[n15] = dataBufferFloat.getData(nArray[n15]);
                        ++n15;
                    }
                    object = fArray;
                    break;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)this.raster.getDataBuffer();
                    double[][] dArray = new double[this.numBands][];
                    int n16 = 0;
                    while (n16 < this.numBands) {
                        dArray[n16] = dataBufferDouble.getData(nArray[n16]);
                        ++n16;
                    }
                    object = dArray;
                    break;
                }
            }
            Image.Reformat((Object)object2, (Object)object, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray2, (int)n2, (int)n3);
        } else {
            switch (this.getDataType()) {
                case 3: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                    break;
                }
                case 4: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                    break;
                }
                case 5: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                    break;
                }
            }
        }
    }

    public final void copyDataToRaster() {
        if (this.isDataCopy()) {
            WritableRaster writableRaster = (WritableRaster)this.raster;
            if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
                Object object;
                int n;
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
                int n2 = componentSampleModel.getScanlineStride();
                int n3 = componentSampleModel.getPixelStride();
                int n4 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n2 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n3;
                int[] nArray = componentSampleModel.getBankIndices();
                int[] nArray2 = componentSampleModel.getBandOffsets();
                int[] nArray3 = this.raster.getDataBuffer().getOffsets();
                if (nArray3.length == 1) {
                    n = 0;
                    while (n < this.numBands) {
                        int n5 = n++;
                        nArray2[n5] = nArray2[n5] + (nArray3[0] + n4);
                    }
                } else if (nArray3.length == nArray2.length) {
                    n = 0;
                    while (n < this.numBands) {
                        int n6 = n;
                        nArray2[n6] = nArray2[n6] + (nArray3[n] + n4);
                        ++n;
                    }
                }
                Object object2 = null;
                switch (this.getDataType()) {
                    case 0: {
                        object = new byte[this.numBands][];
                        int n7 = 0;
                        while (n7 < this.numBands) {
                            object[n7] = this.mlimages[0].getByteData();
                            ++n7;
                        }
                        object2 = object;
                        break;
                    }
                    case 2: {
                        short[][] sArray = new short[this.numBands][];
                        int n8 = 0;
                        while (n8 < this.numBands) {
                            sArray[n8] = this.mlimages[0].getShortData();
                            ++n8;
                        }
                        object2 = sArray;
                        break;
                    }
                    case 3: {
                        int[][] nArray4 = new int[this.numBands][];
                        int n9 = 0;
                        while (n9 < this.numBands) {
                            nArray4[n9] = this.mlimages[0].getIntData();
                            ++n9;
                        }
                        object2 = nArray4;
                        break;
                    }
                    case 4: {
                        float[][] fArray = new float[this.numBands][];
                        int n10 = 0;
                        while (n10 < this.numBands) {
                            fArray[n10] = this.mlimages[0].getFloatData();
                            ++n10;
                        }
                        object2 = fArray;
                        break;
                    }
                    case 5: {
                        double[][] dArray = new double[this.numBands][];
                        int n11 = 0;
                        while (n11 < this.numBands) {
                            dArray[n11] = this.mlimages[0].getDoubleData();
                            ++n11;
                        }
                        object2 = dArray;
                        break;
                    }
                }
                object = null;
                Object object3 = null;
                switch (componentSampleModel.getDataType()) {
                    case 0: {
                        DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                        byte[][] byArray = new byte[this.numBands][];
                        int n12 = 0;
                        while (n12 < this.numBands) {
                            byArray[n12] = dataBufferByte.getData(nArray[n12]);
                            ++n12;
                        }
                        object = byArray[0];
                        object3 = byArray;
                        break;
                    }
                    case 2: {
                        DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                        short[][] sArray = new short[this.numBands][];
                        int n13 = 0;
                        while (n13 < this.numBands) {
                            sArray[n13] = dataBufferShort.getData(nArray[n13]);
                            ++n13;
                        }
                        object3 = sArray;
                        break;
                    }
                    case 3: {
                        DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                        int[][] nArray5 = new int[this.numBands][];
                        int n14 = 0;
                        while (n14 < this.numBands) {
                            nArray5[n14] = dataBufferInt.getData(nArray[n14]);
                            ++n14;
                        }
                        object3 = nArray5;
                        break;
                    }
                    case 4: {
                        DataBufferFloat dataBufferFloat = (DataBufferFloat)this.raster.getDataBuffer();
                        float[][] fArray = new float[this.numBands][];
                        int n15 = 0;
                        while (n15 < this.numBands) {
                            fArray[n15] = dataBufferFloat.getData(nArray[n15]);
                            ++n15;
                        }
                        object3 = fArray;
                        break;
                    }
                    case 5: {
                        DataBufferDouble dataBufferDouble = (DataBufferDouble)this.raster.getDataBuffer();
                        double[][] dArray = new double[this.numBands][];
                        int n16 = 0;
                        while (n16 < this.numBands) {
                            dArray[n16] = dataBufferDouble.getData(nArray[n16]);
                            ++n16;
                        }
                        object3 = dArray;
                        break;
                    }
                }
                Image.Reformat((Object)object3, (Object)object2, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray2, (int)n2, (int)n3, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands);
            } else {
                switch (this.getDataType()) {
                    case 3: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                        break;
                    }
                    case 4: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                        break;
                    }
                    case 5: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                        break;
                    }
                }
            }
        }
    }

    public static final int findCompatibleTag(Raster[] rasterArray, Raster raster) {
        int n;
        int n2;
        SampleModel sampleModel = raster.getSampleModel();
        int n3 = sampleModel.getDataType();
        int n4 = sampleModel.getDataType();
        boolean bl = sampleModel instanceof ComponentSampleModel;
        if (rasterArray != null) {
            n2 = rasterArray.length;
            int n5 = 0;
            while (n5 < n2) {
                SampleModel sampleModel2 = rasterArray[n5].getSampleModel();
                if (!(sampleModel2 instanceof ComponentSampleModel)) {
                    bl = false;
                }
                if ((n = sampleModel2.getTransferType()) > n4) {
                    n4 = n;
                }
                ++n5;
            }
        }
        if (!(bl || n4 != 0 && n4 != 1 && n4 != 2)) {
            n4 = 3;
        }
        n2 = n4 | 0x80;
        if (!bl) {
            return n2;
        }
        SampleModel[] sampleModelArray = rasterArray == null ? new SampleModel[]{} : new SampleModel[rasterArray.length];
        int n6 = 0;
        while (n6 < sampleModelArray.length) {
            sampleModelArray[n6] = rasterArray[n6].getSampleModel();
            if (n3 != sampleModelArray[n6].getDataType()) {
                return n2;
            }
            ++n6;
        }
        if (MediaLibAccessor.isPixelSequential(sampleModel)) {
            n = 0;
            while (n < sampleModelArray.length) {
                if (!MediaLibAccessor.isPixelSequential(sampleModelArray[n])) {
                    return n2;
                }
                ++n;
            }
            int n7 = 0;
            while (n7 < sampleModelArray.length) {
                if (!MediaLibAccessor.hasMatchingBandOffsets((ComponentSampleModel)sampleModel, (ComponentSampleModel)sampleModelArray[n7])) {
                    return n2;
                }
                ++n7;
            }
            return n3;
        }
        return n2;
    }

    public final int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public final int getDataType() {
        return this.formatTag & 0x7F;
    }

    public final double[] getDoubleParameters(int n, double[] dArray) {
        double[] dArray2 = new double[this.numBands];
        int n2 = 0;
        while (n2 < this.numBands) {
            dArray2[n2] = dArray[this.bandOffsets[n2 + n]];
            ++n2;
        }
        return dArray2;
    }

    public final int[] getIntParameters(int n, int[] nArray) {
        int[] nArray2 = new int[this.numBands];
        int n2 = 0;
        while (n2 < this.numBands) {
            nArray2[n2] = nArray[this.bandOffsets[n2 + n]];
            ++n2;
        }
        return nArray2;
    }

    public static final int getMediaLibDataType(int n) {
        int n2 = n & 0x7F;
        switch (n2) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public final mediaLibImage[] getMediaLibImages() {
        return this.mlimages;
    }

    public static final boolean hasMatchingBandOffsets(ComponentSampleModel componentSampleModel, ComponentSampleModel componentSampleModel2) {
        int[] nArray;
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray2.length != (nArray = componentSampleModel2.getBandOffsets()).length) {
            return false;
        }
        int n = 0;
        while (n < nArray2.length) {
            if (nArray2[n] != nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final boolean hasSameNumBands(ParameterBlock parameterBlock, ImageLayout imageLayout) {
        int n = parameterBlock.getNumSources();
        if (n > 0) {
            SampleModel sampleModel;
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            int n2 = renderedImage.getSampleModel().getNumBands();
            int n3 = 1;
            while (n3 < n) {
                renderedImage = parameterBlock.getRenderedSource(n3);
                if (renderedImage.getSampleModel().getNumBands() != n2) {
                    return false;
                }
                ++n3;
            }
            if (imageLayout != null && (sampleModel = imageLayout.getSampleModel(null)) != null && sampleModel.getNumBands() != n2) {
                return false;
            }
        }
        return true;
    }

    public final boolean isDataCopy() {
        return (this.formatTag & 0x80) == 128;
    }

    public static final boolean isMediaLibCompatible(RenderedImage renderedImage) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        return sampleModel instanceof ComponentSampleModel && sampleModel.getDataType() != 1 && sampleModel.getNumBands() <= 4 && (colorModel == null || colorModel instanceof ComponentColorModel);
    }

    public static final boolean isMediaLibCompatible(ParameterBlock parameterBlock) {
        if (!MediaLibAccessor.useMlib()) {
            return false;
        }
        int n = parameterBlock.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            Object object = parameterBlock.getSource(n2);
            if (!(object instanceof RenderedImage) || !MediaLibAccessor.isMediaLibCompatible((RenderedImage)object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isMediaLibCompatible(ParameterBlock parameterBlock, ImageLayout imageLayout) {
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock)) {
            return false;
        }
        if (imageLayout != null) {
            SampleModel sampleModel = imageLayout.getSampleModel(null);
            if (!(sampleModel == null || sampleModel instanceof ComponentSampleModel && sampleModel.getDataType() != 1 && sampleModel.getNumBands() <= 4)) {
                return false;
            }
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (colorModel != null && !(colorModel instanceof ComponentColorModel)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean isPixelSequential(SampleModel sampleModel) {
        ComponentSampleModel componentSampleModel = null;
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        componentSampleModel = (ComponentSampleModel)sampleModel;
        int n = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        int[] nArray2 = componentSampleModel.getBankIndices();
        if (n != nArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= n || nArray2[n2] != nArray2[0]) {
                return false;
            }
            int n3 = n2 + 1;
            while (n3 < nArray.length) {
                if (nArray[n2] == nArray[n3]) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private static void setUseMlib() {
        try {
            Serializable serializable;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (class$com$sun$media$jai$mlib$MediaLibAccessor != null ? class$com$sun$media$jai$mlib$MediaLibAccessor : (class$com$sun$media$jai$mlib$MediaLibAccessor = MediaLibAccessor.class$("com.sun.media.jai.mlib.MediaLibAccessor"))).getClassLoader() != null) {
                serializable = new FilePermission("/usr/bin/uname", "execute");
                securityManager.checkPermission((Permission)serializable);
            }
            if (!(useMlibVar = (serializable = (Boolean)AccessController.doPrivileged(new MediaLibAccessor$1())).booleanValue())) {
                System.err.println(JaiI18N.getString("MediaLibAccessor2"));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor3"));
        }
        catch (ClassFormatError classFormatError) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor3"));
        }
        catch (SecurityException securityException) {
            useMlibVar = false;
            System.err.println(JaiI18N.getString("MediaLibAccessor4"));
        }
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            fArray[n] = (float)dArray[n];
            ++n;
        }
        return fArray;
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            nArray[n] = (int)dArray[n];
            ++n;
        }
        return nArray;
    }

    private static synchronized boolean useMlib() {
        if (!useMlibVarSet) {
            MediaLibAccessor.setUseMlib();
            useMlibVarSet = true;
        }
        return useMlibVar;
    }
}

