/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

final class PeriodicShiftOpImage
extends OpImage {
    private int[] xTrans;
    private int[] yTrans;
    private TranslateIntOpImage[] images;
    private Rectangle[] bounds;

    public PeriodicShiftOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, int n, int n2) {
        super(renderedImage, null, tileCache, PeriodicShiftOpImage.layoutHelper(imageLayout, renderedImage), false);
        this.xTrans = new int[]{-n, -n, this.width - n, this.width - n};
        this.yTrans = new int[]{-n2, this.height - n2, -n2, this.height - n2};
        this.images = new TranslateIntOpImage[4];
        int n3 = 0;
        while (n3 < 4) {
            this.images[n3] = new TranslateIntOpImage(renderedImage, this.xTrans[n3], this.yTrans[n3]);
            ++n3;
        }
        Rectangle rectangle = this.getBounds();
        this.bounds = new Rectangle[4];
        int n4 = 0;
        while (n4 < 4) {
            this.bounds[n4] = rectangle.intersection(this.images[n4].getBounds());
            ++n4;
        }
    }

    public final Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        int n3 = 0;
        while (n3 < 4) {
            Rectangle rectangle3 = rectangle2.intersection(this.bounds[n3]);
            if (!rectangle3.isEmpty()) {
                JDKWorkarounds.setRect(writableRaster, this.images[n3].getData(rectangle3));
            }
            ++n3;
        }
        return writableRaster;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        return imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout(renderedImage);
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        int n2 = 0;
        while (n2 < 4) {
            Rectangle rectangle3 = rectangle.intersection(this.bounds[n2]);
            if (!rectangle3.isEmpty()) {
                rectangle3.translate(-this.xTrans[n2], -this.yTrans[n2]);
                rectangle2 = rectangle2 == null ? rectangle3 : rectangle2.union(rectangle3);
            }
            ++n2;
        }
        return rectangle2;
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        int n2 = 0;
        while (n2 < 4) {
            Rectangle rectangle3 = rectangle;
            rectangle3.translate(this.xTrans[n2], this.yTrans[n2]);
            Rectangle rectangle4 = rectangle3.intersection(this.getBounds());
            if (!rectangle4.isEmpty()) {
                rectangle2 = rectangle2 == null ? rectangle4 : rectangle2.union(rectangle4);
            }
            ++n2;
        }
        return rectangle2;
    }
}

