/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class PolarToComplexOpImage
extends PointOpImage {
    private double phaseGain = 1.0;
    private double phaseBias = 0.0;

    public PolarToComplexOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, TileCache tileCache, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, tileCache, imageLayout, true);
        int n = 2 * Math.min(renderedImage.getSampleModel().getNumBands(), renderedImage2.getSampleModel().getNumBands());
        if (this.sampleModel.getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n);
        }
        switch (renderedImage2.getSampleModel().getTransferType()) {
            case 0: {
                this.phaseGain = 0.024639942381096416;
                this.phaseBias = -Math.PI;
                break;
            }
            case 2: {
                this.phaseGain = 1.9175345033660654E-4;
                this.phaseBias = -Math.PI;
                break;
            }
            case 1: {
                this.phaseGain = 9.587526218325454E-5;
                this.phaseBias = -Math.PI;
                break;
            }
            case 3: {
                this.phaseGain = 2.925836159896768E-9;
                this.phaseBias = -Math.PI;
                break;
            }
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3, rectangle.height, rectangle.width);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("PolarToComplexOpImage0"));
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            byte[] byArray = rasterAccessor3.getByteDataArray(n11);
            byte[] byArray2 = rasterAccessor3.getByteDataArray(n12);
            byte[] byArray3 = rasterAccessor.getByteDataArray(n10);
            byte[] byArray4 = rasterAccessor2.getByteDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = byArray3[n24] & 0xFF;
                    double d3 = (double)(byArray4[n25] & 0xFF) * this.phaseGain + this.phaseBias;
                    byArray[n22] = ImageUtil.clampRoundByte(d2 * Math.cos(d3));
                    byArray2[n23] = ImageUtil.clampRoundByte(d2 * Math.sin(d3));
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            double[] dArray = rasterAccessor3.getDoubleDataArray(n11);
            double[] dArray2 = rasterAccessor3.getDoubleDataArray(n12);
            double[] dArray3 = rasterAccessor.getDoubleDataArray(n10);
            double[] dArray4 = rasterAccessor2.getDoubleDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = dArray3[n24];
                    double d3 = dArray4[n25] * this.phaseGain + this.phaseBias;
                    dArray[n22] = d2 * Math.cos(d3);
                    dArray2[n23] = d2 * Math.sin(d3);
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            float[] fArray = rasterAccessor3.getFloatDataArray(n11);
            float[] fArray2 = rasterAccessor3.getFloatDataArray(n12);
            float[] fArray3 = rasterAccessor.getFloatDataArray(n10);
            float[] fArray4 = rasterAccessor2.getFloatDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = fArray3[n24];
                    double d3 = (double)fArray4[n25] * this.phaseGain + this.phaseBias;
                    fArray[n22] = ImageUtil.clampFloat(d2 * Math.cos(d3));
                    fArray2[n23] = ImageUtil.clampFloat(d2 * Math.sin(d3));
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            int[] nArray = rasterAccessor3.getIntDataArray(n11);
            int[] nArray2 = rasterAccessor3.getIntDataArray(n12);
            int[] nArray3 = rasterAccessor.getIntDataArray(n10);
            int[] nArray4 = rasterAccessor2.getIntDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = nArray3[n24];
                    double d3 = (double)nArray4[n25] * this.phaseGain + this.phaseBias;
                    nArray[n22] = ImageUtil.clampRoundInt(d2 * Math.cos(d3));
                    nArray2[n23] = ImageUtil.clampRoundInt(d2 * Math.sin(d3));
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            short[] sArray = rasterAccessor3.getShortDataArray(n11);
            short[] sArray2 = rasterAccessor3.getShortDataArray(n12);
            short[] sArray3 = rasterAccessor.getShortDataArray(n10);
            short[] sArray4 = rasterAccessor2.getShortDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = sArray3[n24];
                    double d3 = (double)sArray4[n25] * this.phaseGain + this.phaseBias;
                    sArray[n22] = ImageUtil.clampRoundShort(d2 * Math.cos(d3));
                    sArray2[n23] = ImageUtil.clampRoundShort(d2 * Math.sin(d3));
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int n, int n2) {
        int n3 = rasterAccessor3.getPixelStride();
        int n4 = rasterAccessor3.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            short[] sArray = rasterAccessor3.getShortDataArray(n11);
            short[] sArray2 = rasterAccessor3.getShortDataArray(n12);
            short[] sArray3 = rasterAccessor.getShortDataArray(n10);
            short[] sArray4 = rasterAccessor2.getShortDataArray(n10);
            int n13 = rasterAccessor3.getOffsetForBand(n11);
            int n14 = rasterAccessor3.getOffsetForBand(n12);
            int n15 = rasterAccessor.getOffsetForBand(n10);
            int n16 = rasterAccessor2.getOffsetForBand(n10);
            int n17 = n13;
            int n18 = n14;
            int n19 = n15;
            int n20 = n16;
            int n21 = 0;
            while (n21 < n) {
                int n22 = n17;
                int n23 = n18;
                int n24 = n19;
                int n25 = n20;
                int n26 = 0;
                while (n26 < n2) {
                    double d2 = sArray3[n24] & 0xFFFF;
                    double d3 = (double)(sArray4[n25] & 0xFFFF) * this.phaseGain + this.phaseBias;
                    sArray[n22] = ImageUtil.clampRoundUShort(d2 * Math.cos(d3));
                    sArray2[n23] = ImageUtil.clampRoundUShort(d2 * Math.sin(d3));
                    n22 += n3;
                    n23 += n3;
                    n24 += n5;
                    n25 += n7;
                    ++n26;
                }
                n17 += n4;
                n18 += n4;
                n19 += n6;
                n20 += n8;
                ++n21;
            }
            ++n10;
        }
    }
}

