/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineBicubic2OpImage;
import com.sun.media.jai.opimage.AffineBicubicOpImage;
import com.sun.media.jai.opimage.AffineBilinearOpImage;
import com.sun.media.jai.opimage.AffineGeneralOpImage;
import com.sun.media.jai.opimage.AffineNearestBinaryOpImage;
import com.sun.media.jai.opimage.AffineNearestOpImage;
import com.sun.media.jai.opimage.CRIFImpl;
import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import com.sun.media.jai.opimage.TransposeBinaryOpImage;
import com.sun.media.jai.opimage.TransposeOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.TileCache;

public class RotateCRIF
extends CRIFImpl {
    public RotateCRIF() {
        super("rotate");
    }

    public final RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        Object object = parameterBlock.getObjectParameter(3);
        Interpolation interpolation = (Interpolation)object;
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        double d2 = 57.29577951308232 * (double)f4;
        double d3 = Math.round(d2);
        if (Math.abs(d3 - d2) < 1.0E-4) {
            int n = (int)d3 % 360;
            if (n < 0) {
                n += 360;
            }
            if (n == 0) {
                return new CopyOpImage(renderedImage, tileCache, imageLayout);
            }
            int n2 = Math.round(f2);
            int n3 = Math.round(f3);
            if (n % 90 == 0 && (double)Math.abs(f2 - (float)n2) < 1.0E-4 && (double)Math.abs(f3 - (float)n3) < 1.0E-4) {
                int n4 = -1;
                int n5 = 0;
                int n6 = 0;
                int n7 = renderedImage.getMinX();
                int n8 = renderedImage.getMinY();
                int n9 = n7 + renderedImage.getWidth();
                int n10 = n8 + renderedImage.getHeight();
                if (n == 90) {
                    n4 = 4;
                    n5 = n2 - (n10 - n3);
                    n6 = n3 - (n2 - n7);
                } else if (n == 180) {
                    n4 = 5;
                    n5 = 2 * n2 - n9;
                    n6 = 2 * n3 - n10;
                } else {
                    n4 = 6;
                    n5 = n2 - (n3 - n8);
                    n6 = n3 - (n9 - n2);
                }
                TransposeOpImage transposeOpImage = bl ? new TransposeBinaryOpImage(renderedImage, tileCache, imageLayout, n4) : new TransposeOpImage(renderedImage, tileCache, imageLayout, n4);
                int n11 = transposeOpImage.getMinX();
                int n12 = transposeOpImage.getMinY();
                return new TranslateIntOpImage(transposeOpImage, n5 - n11, n6 - n12);
            }
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f4, f2, f3);
        if (interpolation instanceof InterpolationNearest) {
            if (bl) {
                return new AffineNearestBinaryOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
            }
            return new AffineNearestOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        return new AffineGeneralOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
    }

    public final RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    public final Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        float f2;
        float f3;
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        float f4 = parameterBlock.getFloatParameter(0);
        float f5 = parameterBlock.getFloatParameter(1);
        float f6 = parameterBlock.getFloatParameter(2);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(3);
        int n = 0;
        double d2 = (double)(180.0f * f6) / Math.PI;
        double d3 = Math.round(d2);
        n = Math.abs(d3 - d2) < 1.0E-4 ? (int)d3 : (int)d2;
        if (n % 360 == 0) {
            return new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        }
        float f7 = renderableImage.getMinX();
        float f8 = renderableImage.getMinY();
        float f9 = renderableImage.getWidth();
        float f10 = renderableImage.getHeight();
        float f11 = f7 + f9 - 1.0f;
        float f12 = f8 + f10 - 1.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        if (n % 270 == 0) {
            if (n < 0) {
                f13 = f10 - f12 - 1.0f;
                f14 = f7;
                f15 = f10 - f8 - 1.0f;
                f16 = f11;
                return new Rectangle2D.Float(f13, f14, f15 - f13 + 1.0f, f16 - f14 + 1.0f);
            }
            f13 = f8;
            f14 = f9 - f11 - 1.0f;
            f15 = f12;
            f16 = f9 - f7 - 1.0f;
            return new Rectangle2D.Float(f13, f14, f15 - f13 + 1.0f, f16 - f14 + 1.0f);
        }
        if (n % 180 == 0) {
            f13 = f9 - f11 - 1.0f;
            f14 = f10 - f12 - 1.0f;
            f15 = f9 - f7 - 1.0f;
            f16 = f10 - f8 - 1.0f;
            return new Rectangle2D.Float(f13, f14, f15 - f13 + 1.0f, f16 - f14 + 1.0f);
        }
        if (n % 90 == 0) {
            if (n < 0) {
                f13 = f8;
                f14 = f9 - f11 - 1.0f;
                f15 = f12;
                f16 = f9 - f7 - 1.0f;
                return new Rectangle2D.Float(f13, f14, f15 - f13 + 1.0f, f16 - f14 + 1.0f);
            }
            f13 = f10 - f12 - 1.0f;
            f14 = f7;
            f15 = f10 - f8 - 1.0f;
            f16 = f11;
            return new Rectangle2D.Float(f13, f14, f15 - f13 + 1.0f, f16 - f14 + 1.0f);
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f6, f4, f5);
        float f17 = renderableImage.getMinX();
        float f18 = renderableImage.getMinY();
        float f19 = renderableImage.getWidth();
        float f20 = renderableImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f17, f18), new Point2D.Float(f17 + f19, f18), new Point2D.Float(f17 + f19, f18 + f20), new Point2D.Float(f17, f18 + f20)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f21 = Float.MAX_VALUE;
        float f22 = Float.MAX_VALUE;
        float f23 = -3.4028235E38f;
        float f24 = -3.4028235E38f;
        int n2 = 0;
        while (n2 < 4) {
            f3 = (float)point2DArray[n2].getX();
            f2 = (float)point2DArray[n2].getY();
            f21 = Math.min(f21, f3);
            f22 = Math.min(f22, f2);
            f23 = Math.max(f23, f3);
            f24 = Math.max(f24, f2);
            ++n2;
        }
        f3 = f23 - f21;
        f2 = f24 - f22;
        return new Rectangle2D.Float(f21, f22, f3, f2);
    }

    public final RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f4, f2, f3);
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }
}

