/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;
import javax.media.jai.TileCache;

final class ScaleGeneralOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    Rational half = new Rational(1L, 2L);
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;
    int dwidth;
    int dheight;
    int[] xpos;
    int[] ypos;
    int[] xfracvalues;
    int[] yfracvalues;
    float[] xfracvaluesFloat;
    float[] yfracvaluesFloat;
    int srcPixelStride;
    int srcScanlineStride;

    public ScaleGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, f2, f3, f4, f5, interpolation, true);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray3 = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            byte[] byArray3 = byArray[n4];
            byte[] byArray4 = byArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = 0;
                while (n11 < this.dwidth) {
                    int n12 = this.xfracvalues[n11];
                    int n13 = this.xpos[n11];
                    int n14 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n14 = n13 + n10 - n14;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    while (n17 < this.interp_height) {
                        int n18 = n14;
                        int n19 = 0;
                        while (n19 < this.interp_width) {
                            nArray3[n16][n15++] = byArray4[n14] & 0xFF;
                            n14 += this.srcPixelStride;
                            ++n19;
                        }
                        ++n16;
                        n15 = 0;
                        n14 = n18 + this.srcScanlineStride;
                        ++n17;
                    }
                    int n20 = this.interp.interpolate(nArray3, n12, n9);
                    if (n20 > 255) {
                        n20 = 255;
                    } else if (n20 < 0) {
                        n20 = 0;
                    }
                    byArray3[n8] = (byte)(n20 & 0xFF);
                    n8 += n2;
                    ++n11;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        this.dwidth = rectangle.width;
        this.dheight = rectangle.height;
        this.srcPixelStride = rasterAccessor.getPixelStride();
        this.srcScanlineStride = rasterAccessor.getScanlineStride();
        this.ypos = new int[this.dheight];
        this.xpos = new int[this.dwidth];
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 2: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 1: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 3: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 4: {
                this.preComputePositionsFloat(rectangle, n, n2);
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 5: {
                this.preComputePositionsFloat(rectangle, n, n2);
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        double[][] dArray3 = new double[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            double[] dArray4 = dArray[n4];
            double[] dArray5 = dArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                float f2 = this.yfracvaluesFloat[n7];
                int n9 = this.ypos[n7] + n6;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    double d2;
                    float f3 = this.xfracvaluesFloat[n10];
                    int n11 = this.xpos[n10];
                    int n12 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n12 = n11 + n9 - n12;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 < this.interp_height) {
                        int n16 = n12;
                        int n17 = 0;
                        while (n17 < this.interp_width) {
                            dArray3[n14][n13++] = dArray5[n12];
                            n12 += this.srcPixelStride;
                            ++n17;
                        }
                        ++n14;
                        n13 = 0;
                        n12 = n16 + this.srcScanlineStride;
                        ++n15;
                    }
                    dArray4[n8] = d2 = this.interp.interpolate(dArray3, f3, f2);
                    n8 += n2;
                    ++n10;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        float[][] fArray3 = new float[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            float[] fArray4 = fArray[n4];
            float[] fArray5 = fArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                float f2 = this.yfracvaluesFloat[n7];
                int n9 = this.ypos[n7] + n6;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    float f3 = this.xfracvaluesFloat[n10];
                    int n11 = this.xpos[n10];
                    int n12 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n12 = n11 + n9 - n12;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 < this.interp_height) {
                        int n16 = n12;
                        int n17 = 0;
                        while (n17 < this.interp_width) {
                            fArray3[n14][n13++] = fArray5[n12];
                            n12 += this.srcPixelStride;
                            ++n17;
                        }
                        ++n14;
                        n13 = 0;
                        n12 = n16 + this.srcScanlineStride;
                        ++n15;
                    }
                    float f4 = this.interp.interpolate(fArray3, f3, f2);
                    if (f4 > Float.MAX_VALUE) {
                        f4 = Float.MAX_VALUE;
                    } else if (f4 < -3.4028235E38f) {
                        f4 = -3.4028235E38f;
                    }
                    fArray4[n8] = f4;
                    n8 += n2;
                    ++n10;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray5 = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            int[] nArray6 = nArray[n4];
            int[] nArray7 = nArray3[n4];
            int n5 = nArray2[n4];
            int n6 = nArray4[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = 0;
                while (n11 < this.dwidth) {
                    int n12;
                    int n13 = this.xfracvalues[n11];
                    int n14 = this.xpos[n11];
                    int n15 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n15 = n14 + n10 - n15;
                    int n16 = 0;
                    int n17 = 0;
                    int n18 = 0;
                    while (n18 < this.interp_height) {
                        int n19 = n15;
                        int n20 = 0;
                        while (n20 < this.interp_width) {
                            nArray5[n17][n16++] = nArray7[n15];
                            n15 += this.srcPixelStride;
                            ++n20;
                        }
                        ++n17;
                        n16 = 0;
                        n15 = n19 + this.srcScanlineStride;
                        ++n18;
                    }
                    nArray6[n8] = n12 = this.interp.interpolate(nArray5, n13, n9);
                    n8 += n2;
                    ++n11;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.yfracvaluesFloat = new float[this.dheight];
        long l2 = n4;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n5 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n5 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        this.xfracvaluesFloat = new float[this.dwidth];
        long l7 = n3;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n6 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n6 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n7 = 0;
        while (n7 < this.dwidth) {
            this.xpos[n7] = (n6 - n) * this.srcPixelStride;
            this.xfracvaluesFloat[n7] = (float)l9 / (float)l10;
            n6 = (int)((long)n6 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n6;
                l9 -= l10;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.dheight) {
            this.ypos[n8] = (n5 - n2) * this.srcScanlineStride;
            this.yfracvaluesFloat[n8] = (float)l4 / (float)l5;
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n5;
                l4 -= l5;
            }
            ++n8;
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.yfracvalues = new int[this.dheight];
        long l2 = n4;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n5 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n5 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        this.xfracvalues = new int[this.dwidth];
        long l7 = n3;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n6 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n6 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n7 = 0;
        while (n7 < this.dwidth) {
            this.xpos[n7] = (n6 - n) * this.srcPixelStride;
            this.xfracvalues[n7] = (int)((float)l9 / (float)l10 * (float)this.one);
            n6 = (int)((long)n6 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n6;
                l9 -= l10;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.dheight) {
            this.ypos[n8] = (n5 - n2) * this.srcScanlineStride;
            this.yfracvalues[n8] = (int)((float)l4 / (float)l5 * (float)this.one);
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n5;
                l4 -= l5;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray3 = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = 0;
                while (n11 < this.dwidth) {
                    int n12 = this.xfracvalues[n11];
                    int n13 = this.xpos[n11];
                    int n14 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n14 = n13 + n10 - n14;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    while (n17 < this.interp_height) {
                        int n18 = n14;
                        int n19 = 0;
                        while (n19 < this.interp_width) {
                            nArray3[n16][n15++] = sArray4[n14];
                            n14 += this.srcPixelStride;
                            ++n19;
                        }
                        ++n16;
                        n15 = 0;
                        n14 = n18 + this.srcScanlineStride;
                        ++n17;
                    }
                    int n20 = this.interp.interpolate(nArray3, n12, n9);
                    if (n20 > Short.MAX_VALUE) {
                        n20 = Short.MAX_VALUE;
                    } else if (n20 < Short.MIN_VALUE) {
                        n20 = Short.MIN_VALUE;
                    }
                    sArray3[n8] = (short)n20;
                    n8 += n2;
                    ++n11;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray3 = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = 0;
                while (n11 < this.dwidth) {
                    int n12 = this.xfracvalues[n11];
                    int n13 = this.xpos[n11];
                    int n14 = this.interp_left * this.srcPixelStride + this.interp_top * this.srcScanlineStride;
                    n14 = n13 + n10 - n14;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    while (n17 < this.interp_height) {
                        int n18 = n14;
                        int n19 = 0;
                        while (n19 < this.interp_width) {
                            nArray3[n16][n15++] = sArray4[n14] & 0xFFFF;
                            n14 += this.srcPixelStride;
                            ++n19;
                        }
                        ++n16;
                        n15 = 0;
                        n14 = n18 + this.srcScanlineStride;
                        ++n17;
                    }
                    int n20 = this.interp.interpolate(nArray3, n12, n9);
                    if (n20 > 65536) {
                        n20 = 65536;
                    } else if (n20 < 0) {
                        n20 = 0;
                    }
                    sArray3[n8] = (short)(n20 & 0xFFFF);
                    n8 += n2;
                    ++n11;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }
}

