/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineBicubic2OpImage;
import com.sun.media.jai.opimage.AffineBicubicOpImage;
import com.sun.media.jai.opimage.AffineBilinearOpImage;
import com.sun.media.jai.opimage.AffineGeneralOpImage;
import com.sun.media.jai.opimage.AffineNearestOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.TileCache;

public class ShearRIF
implements RenderedImageFactory {
    public final RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        int n = parameterBlock.getIntParameter(1);
        float f3 = parameterBlock.getFloatParameter(2);
        float f4 = parameterBlock.getFloatParameter(3);
        Object object = parameterBlock.getObjectParameter(4);
        Interpolation interpolation = (Interpolation)object;
        AffineTransform affineTransform = new AffineTransform();
        if (n == 0) {
            affineTransform.setTransform(1.0, 0.0, f2, 1.0, f3, 0.0);
        } else {
            affineTransform.setTransform(1.0, f2, 0.0, 1.0, 0.0, f4);
        }
        if (interpolation instanceof InterpolationNearest) {
            return new AffineNearestOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        return new AffineGeneralOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
    }
}

