/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ColorModelProxy;
import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.SampleModelProxy;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.RemoteImage;

public class SerializableRenderedImage
implements RenderedImage,
Runnable,
Serializable {
    private static final int SERVER_TIMEOUT = 60000;
    private static final String CLOSE_MESSAGE = "CLOSE";
    private transient boolean isServer;
    private boolean isSourceRemote;
    private transient RenderedImage source;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int minTileX;
    protected int minTileY;
    protected int numXTiles;
    protected int numYTiles;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected transient SampleModel sampleModel = null;
    protected transient ColorModel colorModel = null;
    protected transient Vector sources = null;
    protected transient Hashtable properties = null;
    private boolean useDeepCopy;
    private Rectangle imageBounds;
    private transient Raster imageRaster;
    private InetAddress host;
    private int port;
    private transient boolean serverOpen = false;
    private transient ServerSocket serverSocket = null;
    private transient Thread serverThread;
    private static transient Hashtable remoteReferenceCount;

    SerializableRenderedImage() {
    }

    public SerializableRenderedImage(RenderedImage renderedImage) {
        this(renderedImage, false);
    }

    public SerializableRenderedImage(RenderedImage renderedImage, boolean bl) {
        this.isServer = true;
        this.useDeepCopy = bl;
        this.source = renderedImage;
        this.isSourceRemote = renderedImage instanceof RemoteImage;
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.minTileX = renderedImage.getMinTileX();
        this.minTileY = renderedImage.getMinTileY();
        this.numXTiles = renderedImage.getNumXTiles();
        this.numYTiles = renderedImage.getNumYTiles();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        this.sources = renderedImage.getSources();
        if (this.sources == null) {
            this.sources = new Vector();
        }
        this.properties = new Hashtable();
        String[] stringArray = renderedImage.getPropertyNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.properties.put(stringArray[n], renderedImage.getProperty(stringArray[n]));
                ++n;
            }
        }
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        try {
            this.host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
        this.serverOpen = false;
    }

    private void closeClient() {
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject(CLOSE_MESSAGE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            outputStream.close();
            objectOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private Socket connectToServer() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return socket;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        if (this.isServer || this.isSourceRemote) {
            return this.source.copyData(writableRaster);
        }
        Raster raster = null;
        if (writableRaster == null) {
            raster = this.getData(this.imageBounds);
            writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(raster.getMinX(), raster.getMinY()));
        } else {
            raster = this.getData(writableRaster.getBounds());
            writableRaster.setDataElements(raster.getMinX(), raster.getMinY(), raster);
        }
        return writableRaster;
    }

    private static synchronized void decrementRemoteReferenceCount(Object object) {
        Integer n;
        if (remoteReferenceCount != null && (n = (Integer)remoteReferenceCount.get(object)) != null) {
            if (n == 1) {
                remoteReferenceCount.remove(object);
            } else {
                remoteReferenceCount.put(object, new Integer(n - 1));
            }
        }
    }

    protected void finalize() {
        if (this.isServer) {
            if (this.serverOpen) {
                this.serverOpen = false;
                try {
                    this.serverThread.join(120000L);
                }
                catch (Exception exception) {}
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.closeClient();
        }
        super.finalize();
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getData() {
        if (this.isServer || this.isSourceRemote) {
            return this.source.getData();
        }
        return this.getData(this.imageBounds);
    }

    public Raster getData(Rectangle rectangle) {
        Raster raster = null;
        if (this.isServer || this.isSourceRemote) {
            raster = this.source.getData(rectangle);
        } else if (this.useDeepCopy) {
            raster = this.imageRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        } else {
            Socket socket = this.connectToServer();
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            try {
                objectOutputStream.writeObject(rectangle);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            RasterProxy rasterProxy = null;
            try {
                rasterProxy = (RasterProxy)objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            raster = rasterProxy != null ? rasterProxy.getRaster() : null;
            try {
                outputStream.close();
                objectOutputStream.close();
                inputStream.close();
                objectInputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            if (this.imageBounds.equals(rectangle)) {
                this.closeClient();
                this.imageRaster = raster;
                this.useDeepCopy = true;
            }
        }
        return raster;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinTileX() {
        return this.minTileX;
    }

    public int getMinTileY() {
        return this.minTileY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNumXTiles() {
        return this.numXTiles;
    }

    public int getNumYTiles() {
        return this.numYTiles;
    }

    public Object getProperty(String string) {
        Object v = this.properties.get(string);
        return v == null ? Image.UndefinedProperty : v;
    }

    public String[] getPropertyNames() {
        String[] stringArray = null;
        if (!this.properties.isEmpty()) {
            stringArray = new String[this.properties.size()];
            Enumeration enumeration = this.properties.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Vector getSources() {
        return this.sources;
    }

    public Raster getTile(int n, int n2) {
        if (this.isServer || this.isSourceRemote) {
            return this.source.getTile(n, n2);
        }
        int n3 = this.tileGridXOffset + n * this.tileWidth;
        int n4 = this.tileGridYOffset + n2 * this.tileHeight;
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        return this.getData(rectangle);
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getWidth() {
        return this.width;
    }

    private static synchronized void incrementRemoteReferenceCount(Object object) {
        if (remoteReferenceCount == null) {
            remoteReferenceCount = new Hashtable();
            remoteReferenceCount.put(object, new Integer(1));
        } else {
            Integer n = (Integer)remoteReferenceCount.get(object);
            if (n == null) {
                remoteReferenceCount.put(object, new Integer(1));
            } else {
                remoteReferenceCount.put(object, new Integer(n + 1));
            }
        }
    }

    private synchronized void openServer() {
        if (!this.serverOpen) {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setSoTimeout(60000);
            this.port = this.serverSocket.getLocalPort();
            this.serverThread = new Thread(this);
            this.serverThread.start();
            this.serverOpen = true;
            SerializableRenderedImage.incrementRemoteReferenceCount(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        Serializable serializable;
        Object object;
        this.isServer = false;
        this.source = null;
        this.serverOpen = false;
        this.serverSocket = null;
        this.serverThread = null;
        this.colorModel = null;
        objectInputStream.defaultReadObject();
        if (this.isSourceRemote) {
            object = (String)objectInputStream.readObject();
            serializable = (Long)objectInputStream.readObject();
            this.source = new RemoteImage(String.valueOf(object) + "::" + (Long)serializable, null);
        }
        object = (SampleModelProxy)objectInputStream.readObject();
        this.sampleModel = ((SampleModelProxy)object).getSampleModel();
        serializable = (ColorModelProxy)objectInputStream.readObject();
        this.colorModel = ((ColorModelProxy)serializable).getColorModel();
        this.sources = (Vector)objectInputStream.readObject();
        this.properties = (Hashtable)objectInputStream.readObject();
        if (this.useDeepCopy) {
            RasterProxy rasterProxy = (RasterProxy)objectInputStream.readObject();
            this.imageRaster = rasterProxy.getRaster();
        }
    }

    public void run() {
        this.serviceClient();
    }

    private void serviceClient() {
        while (this.serverOpen) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                inputStream = socket.getInputStream();
                outputStream = socket.getOutputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            Object object = null;
            try {
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            if (object instanceof String && ((String)object).equals(CLOSE_MESSAGE)) {
                SerializableRenderedImage.decrementRemoteReferenceCount(this);
            } else if (object instanceof Rectangle) {
                Raster raster = this.source.getData((Rectangle)object);
                RasterProxy rasterProxy = raster != null ? new RasterProxy(raster) : null;
                try {
                    objectOutputStream.writeObject(rasterProxy);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
            try {
                objectOutputStream.close();
                objectInputStream.close();
                outputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        Object object;
        if (!this.useDeepCopy) {
            try {
                this.openServer();
            }
            catch (Exception exception) {
                if (exception instanceof SocketException && this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
                this.serverOpen = false;
                this.useDeepCopy = true;
            }
        }
        objectOutputStream.defaultWriteObject();
        if (this.isSourceRemote) {
            object = this.source.getClass().getName();
            objectOutputStream.writeObject(this.source.getProperty(String.valueOf(object) + ".serverName"));
            objectOutputStream.writeObject(this.source.getProperty(String.valueOf(object) + ".id"));
        }
        object = this.sources;
        boolean bl = false;
        int n = 0;
        while (n < ((Vector)object).size()) {
            if (!(((Vector)object).get(n) instanceof Serializable)) {
                if (!bl) {
                    object = (Vector)this.sources.clone();
                    bl = true;
                }
                ((Vector)object).remove(n);
                continue;
            }
            ++n;
        }
        Hashtable hashtable = this.properties;
        boolean bl2 = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (this.properties.get(k2) instanceof Serializable) continue;
            if (!bl2) {
                hashtable = (Hashtable)this.properties.clone();
                bl2 = true;
            }
            hashtable.remove(k2);
        }
        objectOutputStream.writeObject(new SampleModelProxy(this.sampleModel));
        objectOutputStream.writeObject(new ColorModelProxy(this.colorModel));
        objectOutputStream.writeObject(object);
        objectOutputStream.writeObject(hashtable);
        if (this.useDeepCopy) {
            objectOutputStream.writeObject(new RasterProxy(this.source.getData()));
        }
    }
}

