/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape.view;

import edu.mit.broad.cytoscape.view.CollapsiblePanel$CollapsableTitledBorder;
import edu.mit.broad.cytoscape.view.CollapsiblePanel$ExpandAndCollapseAction;
import edu.mit.broad.genome.JarResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class CollapsiblePanel
extends JPanel {
    CollapsiblePanel$CollapsableTitledBorder border;
    Border collapsedBorderLine = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    Border expandedBorderLine = null;
    AbstractButton titleComponent;
    static final int COLLAPSED = 0;
    static final int EXPANDED = 1;
    ImageIcon[] iconArrow = this.createExpandAndCollapseIcon();
    JButton arrow = this.createArrowButton();
    JPanel panel;
    JPanel emptyPanel = new JPanel();
    boolean collapsed;

    public CollapsiblePanel(JRadioButton jRadioButton) {
        jRadioButton.addItemListener(new CollapsiblePanel$ExpandAndCollapseAction(this, null));
        this.titleComponent = jRadioButton;
        this.collapsed = !jRadioButton.isSelected();
        this.commonConstructor();
    }

    public CollapsiblePanel(String string) {
        this.arrow.setText(string);
        this.titleComponent = this.arrow;
        this.collapsed = true;
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.setLayout(new BorderLayout());
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "Center");
        this.add((Component)this.panel, "Center");
        this.setCollapsed(this.collapsed);
        this.placeTitleComponent();
        this.emptyPanel.setSize(new Dimension(400, 550));
        this.emptyPanel.setPreferredSize(new Dimension(400, 550));
    }

    private void placeTitleComponent() {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.border.getComponentRect(rectangle, insets);
        this.titleComponent.setBounds(rectangle2);
    }

    public final void setTitleComponentText(String string) {
        if (this.titleComponent instanceof JButton) {
            this.titleComponent.setText(string);
        }
        this.placeTitleComponent();
    }

    public final JPanel getContentPane() {
        return this.panel;
    }

    public final void setCollapsed(boolean bl) {
        if (bl) {
            this.remove(this.panel);
            this.add((Component)this.emptyPanel, "Center");
            this.arrow.setIcon(this.iconArrow[0]);
            this.border = new CollapsiblePanel$CollapsableTitledBorder(this, this.collapsedBorderLine, this.titleComponent);
        } else {
            this.remove(this.emptyPanel);
            this.add((Component)this.panel, "Center");
            this.arrow.setIcon(this.iconArrow[1]);
            this.border = new CollapsiblePanel$CollapsableTitledBorder(this, this.expandedBorderLine, this.titleComponent);
        }
        this.setBorder(this.border);
        this.collapsed = bl;
        this.updateUI();
    }

    public final boolean isCollapsed() {
        return this.collapsed;
    }

    private ImageIcon[] createExpandAndCollapseIcon() {
        ImageIcon[] imageIconArray = new ImageIcon[2];
        URL uRL = JarResources.toURL("arrow_collapsed.gif");
        if (uRL != null) {
            imageIconArray[0] = new ImageIcon(uRL);
        }
        if ((uRL = JarResources.toURL("arrow_expanded.gif")) != null) {
            imageIconArray[1] = new ImageIcon(uRL);
        }
        return imageIconArray;
    }

    private JButton createArrowButton() {
        JButton jButton = new JButton("arrow", this.iconArrow[0]);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(2);
        jButton.setMargin(new Insets(0, 0, 3, 0));
        Font font = BorderFactory.createTitledBorder("Sample").getTitleFont();
        Color color = BorderFactory.createTitledBorder("Sample").getTitleColor();
        jButton.setFont(font);
        jButton.setForeground(color);
        jButton.setFocusable(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(new CollapsiblePanel$ExpandAndCollapseAction(this, null));
        return jButton;
    }
}

