/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape.view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.cytoscape.CytoscapeLaunch;
import edu.mit.broad.cytoscape.EnrichmentMapParameters;
import edu.mit.broad.cytoscape.view.CollapsiblePanel;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$1;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$10;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$11;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$12;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$2;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$3;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$4;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$5;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$6;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$7;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$8;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$9;
import edu.mit.broad.cytoscape.view.EnrichmentMapParameterPanel$FormattedTextFieldAction;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import xapps.api.vtools.ParamSetFormForAFew;
import xtools.munge.CollapseDataset;

public class EnrichmentMapParameterPanel
extends JPanel {
    CollapsiblePanel Parameters;
    DecimalFormat decFormat;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField combinedConstantTextField;
    private JFormattedTextField GCTFileName1TextField;
    private JFormattedTextField GCTFileName2TextField;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    private boolean similarityCutOffChanged = false;
    public static final ImageIcon similarityLogo = JarResources.getImageIcon("GSEA_similarityLogo.png");
    private JPanel similarityPanel;
    private JLabel combinedCutoff;
    EnrichmentMapParameters params;

    public EnrichmentMapParameterPanel(String string, String string2) {
        this.params = new EnrichmentMapParameters(string, string2);
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createExpression1FilePanel();
        JPanel jPanel2 = this.createParametersPanel();
        JPanel jPanel3 = this.createBottomPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 10));
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        this.GCTFileName1TextField.setToolTipText(this.params.getExpressionFilePath());
    }

    public EnrichmentMapParameterPanel(String[] stringArray) {
        this.params = new EnrichmentMapParameters("", "");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = this.createDatasetPanel(stringArray);
        JPanel jPanel3 = this.createParametersPanel();
        JPanel jPanel4 = this.createBottomPanel();
        StringBuffer stringBuffer = EnrichmentMapParameterPanel._createColStr();
        if (stringArray.length > 1) {
            jPanel.setLayout(new FormLayout(stringBuffer.toString(), "175dlu,4dlu,260dlu,4dlu"));
        } else {
            jPanel.setLayout(new FormLayout(stringBuffer.toString(), "100dlu,4dlu,260dlu,4dlu"));
        }
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)jPanel2, cellConstraints.xywh(1, 1, 5, 1));
        jPanel.add((Component)jPanel3, cellConstraints.xy(3, 3));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel4, "South");
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 10));
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        this.GCTFileName1TextField.setToolTipText(this.params.getExpressionFilePath());
    }

    private JPanel createParametersPanel() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setBorder(new CompoundBorder(new TitledBorder(new LineBorder(Color.black), "Enrichment Map Parameters", 2, 2, new Font("Dialog", 1, 12), Color.black), this.getBorder()));
        this.addPropertyChangeListener(new EnrichmentMapParameterPanel$1(this));
        jPanel.setLayout(new FormLayout("4dlu, 4dlu, 65dlu, 4dlu, 30dlu, 90dlu, 4dlu, 30dlu, 4dlu, 4dlu,15dlu,80dlu,4dlu", "15dlu, 4dlu, 15dlu, 4dlu, 200dlu"));
        ((FormLayout)jPanel.getLayout()).setRowGroups(new int[][]{{1, 3}});
        JLabel jLabel = new JLabel(" ");
        JLabel jLabel2 = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(3);
        this.pvalueTextField.addPropertyChangeListener("value", new EnrichmentMapParameterPanel$FormattedTextFieldAction(this, null));
        String string = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(string);
        jLabel2.setToolTipText(string);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setToolTipText(string);
        jPanel.add((Component)jLabel2, cellConstraints.xy(3, 1));
        jPanel.add((Component)this.pvalueTextField, cellConstraints.xy(5, 1));
        jPanel.add((Component)jLabel, cellConstraints.xy(11, 1));
        JLabel jLabel3 = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(3);
        this.qvalueTextField.addPropertyChangeListener("value", new EnrichmentMapParameterPanel$FormattedTextFieldAction(this, null));
        String string2 = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(string2);
        jLabel3.setToolTipText(string2);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setToolTipText(string2);
        jPanel.add((Component)jLabel3, cellConstraints.xy(3, 3));
        jPanel.add((Component)this.qvalueTextField, cellConstraints.xy(5, 3));
        jPanel.add((Component)jLabel, cellConstraints.xy(11, 3));
        JLabel jLabel4 = new JLabel("Similarity Cutoff:");
        this.jaccard = new JRadioButton("Jaccard Coefficient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.jaccard.setToolTipText("Jaccard Coefficient = [size of (A intersect B)] / [size of (A union B)]");
        this.overlap = new JRadioButton("Overlap Coefficient");
        this.overlap.setActionCommand("overlap");
        this.overlap.setToolTipText("Overlap Coefficient = [size of (A intersect B)] / [size of (minimum( A , B))]");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        this.combined.setToolTipText("Combined Constant = k; Combined Coefficient = (k * Overlap) + ((1-k) * Jaccard)");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jaccard);
        buttonGroup.add(this.overlap);
        buttonGroup.add(this.combined);
        this.jaccard.addActionListener(new EnrichmentMapParameterPanel$2(this));
        this.overlap.addActionListener(new EnrichmentMapParameterPanel$3(this));
        this.combined.addActionListener(new EnrichmentMapParameterPanel$4(this));
        JLabel jLabel5 = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(3);
        this.coeffecientTextField.addPropertyChangeListener("value", new EnrichmentMapParameterPanel$FormattedTextFieldAction(this, null));
        String string3 = "Sets the Jaccard or Overlap coefficient cutoff \nonly edges with a Jaccard or Overlap coefficient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(string3);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        this.combinedCutoff = new JLabel("Combined Constant");
        this.combinedConstantTextField = new JFormattedTextField(this.decFormat);
        this.combinedConstantTextField.setColumns(3);
        this.combinedConstantTextField.addPropertyChangeListener("value", new EnrichmentMapParameterPanel$FormattedTextFieldAction(this, null));
        this.combinedConstantTextField.setValue(0.5);
        this.combinedCutoff.setForeground(Color.GRAY);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Advanced Options");
        JPanel jPanel4 = collapsiblePanel.getContentPane();
        CellConstraints cellConstraints2 = new CellConstraints();
        jPanel4.setLayout(new FormLayout("1dlu, 1dlu, 30dlu,35dlu, 1dlu, 30dlu, 90dlu, 1dlu, 30dlu,120dlu", "15dlu, 15dlu,15dlu,15dlu,15dlu,5dlu,100dlu"));
        jPanel4.add((Component)jLabel4, cellConstraints2.xywh(3, 1, 5, 1));
        jPanel4.add((Component)this.jaccard, cellConstraints2.xywh(4, 2, 4, 1));
        jPanel4.add((Component)this.coeffecientTextField, cellConstraints2.xywh(9, 2, 1, 3));
        jPanel4.add((Component)this.overlap, cellConstraints2.xywh(4, 3, 4, 1));
        jPanel4.add((Component)this.combined, cellConstraints2.xywh(4, 4, 4, 1));
        jPanel4.add((Component)this.combinedCutoff, cellConstraints2.xy(7, 5, CellConstraints.CENTER, CellConstraints.DEFAULT));
        jPanel4.add((Component)this.combinedConstantTextField, cellConstraints2.xy(9, 5));
        this.combinedConstantTextField.setEnabled(false);
        jPanel4.add((Component)new JLabel("", similarityLogo, 0), cellConstraints2.xywh(2, 7, 9, 1));
        jPanel.add((Component)collapsiblePanel, cellConstraints.xywh(3, 5, 11, 1));
        collapsiblePanel.setCollapsed(false);
        collapsiblePanel.setCollapsed(true);
        return jPanel;
    }

    private void createExpression1FilePanel(PanelBuilder panelBuilder, CellConstraints cellConstraints, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1000, 60));
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("*Expression (Dataset 1):");
        jLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton jButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(15);
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        jButton.setText("...");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new EnrichmentMapParameterPanel$5(this));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.GCTFileName1TextField, "Center");
        jPanel2.add((Component)jButton, "East");
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(3, n));
    }

    private void createExpression2FilePanel(PanelBuilder panelBuilder, CellConstraints cellConstraints, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1000, 60));
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("*Expression (Dataset 2):");
        jLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton jButton = new JButton();
        this.GCTFileName2TextField = new JFormattedTextField();
        this.GCTFileName2TextField.setColumns(15);
        this.GCTFileName2TextField.setText(this.params.getExpression2FilePath());
        jButton.setText("...");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new EnrichmentMapParameterPanel$6(this));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.GCTFileName2TextField, "Center");
        jPanel2.add((Component)jButton, "East");
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(3, n));
    }

    private JPanel createExpression1FilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1000, 60));
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("*Expression (Dataset 1):");
        jLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton jButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(15);
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        jButton.setText("...");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new EnrichmentMapParameterPanel$7(this));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.GCTFileName1TextField, "Center");
        jPanel2.add((Component)jButton, "East");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.createInstruction(), "Center");
        this.add((Component)this.createBottomPanel(), "South");
        return jPanel;
    }

    private JTextArea createInstruction() {
        String string = "*If you are using GSEAPreranked and you would like to see the expression values in the heat map instead of the ranks change this default setting.";
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setRows(2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(600, 20));
        return jTextArea;
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.combinedCutoff.setForeground(Color.GRAY);
            this.combinedConstantTextField.setEnabled(false);
            this.params.setSimilarityMetric("JACCARD");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("overlap")) {
            this.combinedCutoff.setForeground(Color.GRAY);
            this.combinedConstantTextField.setEnabled(false);
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("combined")) {
            this.combinedCutoff.setForeground(Color.BLACK);
            this.combinedConstantTextField.setEnabled(true);
            this.params.setSimilarityMetric("COMBINED");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
        this.similarityPanel.revalidate();
    }

    private void selectGCTFileButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.params.getEdbdir());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Expression File", "gct", "rnk", "txt");
        File file = null;
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file != null) {
            this.params.setExpressionFilePath(file.getAbsolutePath());
            this.GCTFileName1TextField.setText(file.getAbsolutePath());
            this.GCTFileName1TextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectGCTFile2ButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.params.getEdbdir());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Expression File", "gct", "rnk", "txt");
        File file = null;
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        if (file != null) {
            this.params.setExpression2FilePath(file.getAbsolutePath());
            this.GCTFileName2TextField.setText(file.getAbsolutePath());
            this.GCTFileName2TextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton();
        jButton.setText("Build Enrichment Map");
        jButton.addActionListener(new EnrichmentMapParameterPanel$8(this));
        jButton.setEnabled(true);
        jPanel.add(jButton);
        return jPanel;
    }

    private void BuildActionPerformed(ActionEvent actionEvent) {
        CytoscapeLaunch cytoscapeLaunch = new CytoscapeLaunch(this.params);
        cytoscapeLaunch.launch();
    }

    private JPanel createDatasetPanel(String[] stringArray) {
        Arrays.sort(stringArray);
        int n = stringArray.length * 5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        StringBuffer stringBuffer = EnrichmentMapParameterPanel._createColStr();
        StringBuffer stringBuffer2 = EnrichmentMapParameterPanel._createRowStr(n + 2);
        PanelBuilder panelBuilder = ParamSetFormForAFew.createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel("Dataset 1:");
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addActionListener(new EnrichmentMapParameterPanel$9(this));
        jComboBox.setSelectedIndex(0);
        int n2 = 3;
        panelBuilder.addSeparator("Dataset 1", cellConstraints.xyw(1, 1, 4));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n2));
        panelBuilder.add(jComboBox, cellConstraints.xy(3, n2));
        this.createExpression1FilePanel(panelBuilder, cellConstraints, n2 += 2);
        n2 += 2;
        if (stringArray.length > 1) {
            JLabel jLabel2 = new JLabel("Dataset 2:");
            JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray);
            jComboBox2.addActionListener(new EnrichmentMapParameterPanel$10(this));
            jComboBox2.setSelectedIndex(1);
            panelBuilder.addSeparator("Dataset 2", cellConstraints.xyw(1, n2, 4));
            panelBuilder.add((Component)jLabel2, cellConstraints.xy(1, n2 += 2));
            panelBuilder.add(jComboBox2, cellConstraints.xy(3, n2));
            this.createExpression2FilePanel(panelBuilder, cellConstraints, n2 += 2);
            n2 += 2;
        }
        panelBuilder.add((Component)this.createInstruction(), cellConstraints.xy(3, n2));
        return panelBuilder.getPanel();
    }

    private String getExpressionFile(String string) {
        File[] fileArray;
        File file;
        String string2 = null;
        File file2 = new File(string);
        if (!file2.getName().equalsIgnoreCase("edb")) {
            file2 = new File(string + System.getProperty("file.separator") + "edb");
        }
        if (file2.exists() && file2.isDirectory() && (file = file2.getParentFile()).exists() && file.isDirectory() && (fileArray = file.listFiles(new EnrichmentMapParameterPanel$11(this))).length == 1) {
            String string3 = fileArray[0].getAbsolutePath();
            try {
                Object object;
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string3)));
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                while ((string4 = bufferedReader.readLine()) != null) {
                    object = string4.split("\t");
                    if (((String[])object).length == 2) {
                        hashMap.put(object[0], object[1]);
                        continue;
                    }
                    if (((String[])object).length != 3) continue;
                    hashMap.put(object[0] + " " + object[1], object[2]);
                }
                object = "";
                if (hashMap.containsKey("param collapse")) {
                    object = (String)hashMap.get("param collapse");
                }
                if (hashMap.containsKey("param rnk")) {
                    string2 = (String)hashMap.get("param rnk");
                } else if (hashMap.containsKey("param res")) {
                    String string5 = (String)hashMap.get("param res");
                    if (!new File(string5).exists()) {
                        Application.getWindowManager().showConfirm("Unable to find expression file: " + string5);
                    }
                    if (((String)object).equalsIgnoreCase("false")) {
                        string2 = string5;
                    } else {
                        Properties properties = new Properties();
                        properties.put("res", string5);
                        String string6 = hashMap.containsKey("param rpt_label") ? (String)hashMap.get("param rpt_label") : "";
                        properties.put("rpt_label", string6);
                        String string7 = hashMap.containsKey("param mode") ? (String)hashMap.get("param mode") : "";
                        properties.put("mode", string7);
                        String string8 = hashMap.containsKey("param chip") ? (String)hashMap.get("param chip") : "";
                        properties.put("chip", string8);
                        String string9 = hashMap.containsKey("param include_only_symbols") ? (String)hashMap.get("param include_only_symbols") : "";
                        properties.put("include_only_symbols", string9);
                        String string10 = hashMap.containsKey("param out") ? (String)hashMap.get("param out") : "";
                        properties.put("out", string10);
                        properties.put("gui", "false");
                        if (!(string6.equalsIgnoreCase("") || string7.equalsIgnoreCase("") || string8.equalsIgnoreCase("") || string9.equalsIgnoreCase("") || string10.equalsIgnoreCase(""))) {
                            CollapseDataset collapseDataset = new CollapseDataset(properties);
                            try {
                                collapseDataset.execute();
                                File file3 = collapseDataset.getReport().getReportDir();
                                File file4 = new File(string5);
                                String string11 = file4.getName();
                                String string12 = "";
                                string12 = string11.replace(".gct", "_collapsed_to_symbols.gct");
                                string2 = file3 + System.getProperty("file.separator") + string12;
                            }
                            catch (Throwable throwable) {
                                System.out.println(throwable.getMessage());
                            }
                        } else if (file2.exists() && file2.isDirectory()) {
                            File[] fileArray2 = file2.listFiles(new EnrichmentMapParameterPanel$12(this));
                            if (fileArray.length == 1) {
                                string2 = fileArray[0].getAbsolutePath();
                            }
                        } else {
                            string2 = "Unable to get expresion File";
                        }
                    }
                } else {
                    string2 = "Unable to get expresion File";
                }
            }
            catch (IOException iOException) {
                System.out.println("Unable to open rpt file:" + string3);
            }
        }
        return string2;
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("120dlu,      4dlu,        380dlu,   4dlu,  10dlu");
    }

    private static StringBuffer _createRowStr(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pref, 10dlu,");
        for (int i2 = 0; i2 < n + 1; ++i2) {
            stringBuffer.append("pref, 5dlu");
            if (n == i2 - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }

    static final /* synthetic */ void access$100(EnrichmentMapParameterPanel enrichmentMapParameterPanel, ActionEvent actionEvent) {
        enrichmentMapParameterPanel.selectJaccardOrOverlapActionPerformed(actionEvent);
    }

    static final /* synthetic */ void access$200(EnrichmentMapParameterPanel enrichmentMapParameterPanel, ActionEvent actionEvent) {
        enrichmentMapParameterPanel.selectGCTFileButtonActionPerformed(actionEvent);
    }

    static final /* synthetic */ void access$300(EnrichmentMapParameterPanel enrichmentMapParameterPanel, ActionEvent actionEvent) {
        enrichmentMapParameterPanel.selectGCTFile2ButtonActionPerformed(actionEvent);
    }

    static final /* synthetic */ void access$400(EnrichmentMapParameterPanel enrichmentMapParameterPanel, ActionEvent actionEvent) {
        enrichmentMapParameterPanel.BuildActionPerformed(actionEvent);
    }

    static final /* synthetic */ String access$500(EnrichmentMapParameterPanel enrichmentMapParameterPanel, String string) {
        return enrichmentMapParameterPanel.getExpressionFile(string);
    }

    static final /* synthetic */ JFormattedTextField access$600(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.GCTFileName1TextField;
    }

    static final /* synthetic */ JFormattedTextField access$700(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.GCTFileName2TextField;
    }

    static final /* synthetic */ JFormattedTextField access$800(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.pvalueTextField;
    }

    static final /* synthetic */ JFormattedTextField access$900(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.qvalueTextField;
    }

    static final /* synthetic */ JFormattedTextField access$1000(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.coeffecientTextField;
    }

    static final /* synthetic */ boolean access$1102(EnrichmentMapParameterPanel enrichmentMapParameterPanel, boolean bl) {
        enrichmentMapParameterPanel.similarityCutOffChanged = bl;
        return enrichmentMapParameterPanel.similarityCutOffChanged;
    }

    static final /* synthetic */ JFormattedTextField access$1200(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.combinedConstantTextField;
    }

    static final /* synthetic */ boolean access$1100(EnrichmentMapParameterPanel enrichmentMapParameterPanel) {
        return enrichmentMapParameterPanel.similarityCutOffChanged;
    }
}

