/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.JarResources$1;
import edu.mit.broad.genome.JarResources$2;
import edu.mit.broad.genome.JarResources$NotFoundIcon;
import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.parsers.ParseUtils;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import xapps.gsea.GseaWebResources;

public class JarResources {
    public static Icon ICON_NOT_FOUND;
    public static Icon ICON_UNKNOWN_DATA_FORMAT;
    private static final String PKG_GENOME = "edu/mit/broad/genome/";
    private static final String PKG_RESOURCE = "edu/mit/broad/genome/resources/";
    private static Logger klog;
    private static ClassLoader kClassLoader;

    public static final String getBuildInfo() {
        try {
            URL uRL = JarResources.toURL("build.properties");
            return ParseUtils.slurp(uRL, false);
        }
        catch (Throwable throwable) {
            klog.error(throwable);
            return "Cannot read build info";
        }
    }

    private JarResources() {
    }

    public static final URL toURL(String string) {
        return kClassLoader.getResource(PKG_RESOURCE + string);
    }

    public static final URL toURLFromPkgPath(String string) {
        return kClassLoader.getResource(string);
    }

    public static final String getHelpURL(String string) {
        string = string.replace('.', '_');
        return GseaWebResources.getGseaBaseURL() + "/doc/GSEAUserGuideFrame.html?" + string;
    }

    public static final String getWikiErrorURL(String string) {
        return GseaWebResources.getGseaBaseURL() + "/wiki/index.php/" + string;
    }

    public static final JButton createHelpButton(String string) {
        Action action = JarResources.createHelpAction(string);
        if (action != null) {
            return new JButton(action);
        }
        return new JButton("Help broken: " + string);
    }

    public static final Action createHelpAction(String string) {
        String string2 = JarResources.getHelpURL(string);
        if (string2 == null || string2.length() == 0) {
            string2 = "Help broken for key: " + string;
            klog.warn(string2);
        }
        String string3 = string2;
        return new JarResources$1("Help", JarResources.getIcon("Help16_v2.gif"), string3);
    }

    public static final Action createHelpAction(StandardException standardException) {
        String string = JarResources.getWikiErrorURL("" + standardException.getErrorCode());
        if (string == null || string.length() == 0) {
            string = "Help broken for key: " + standardException.getErrorCode();
            klog.warn(string);
        }
        String string2 = string;
        return new JarResources$2("Help for error " + standardException.getErrorCode(), JarResources.getIcon("Help16_v2.gif"), string2);
    }

    public static final Icon getIcon(String string) {
        URL uRL = null;
        try {
            uRL = JarResources.toURL(string);
            if (uRL != null) {
                return new ImageIcon(uRL);
            }
        }
        catch (Throwable throwable) {
            klog.error(throwable);
        }
        klog.warn("could not find resource: " + string + " url: " + uRL + " ... using default icon instead.");
        return ICON_NOT_FOUND;
    }

    public static final ImageIcon getImageIcon(String string) {
        return (ImageIcon)JarResources.getIcon(string);
    }

    public static final Image getImage(String string) {
        return ((ImageIcon)JarResources.getIcon(string)).getImage();
    }

    static {
        try {
            kClassLoader = JarResources.class.getClassLoader();
            klog = XLogger.getLogger(JarResources.class);
            if (!GraphicsEnvironment.isHeadless()) {
                klog.debug("Loading basic icons ...");
                URL uRL = kClassLoader.getResource("edu/mit/broad/genome/resources/IconNotFound.gif");
                if (uRL == null) {
                    System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                    System.err.println("Expected location: edu/mit/broad/genome/resources/IconNotFound.gif");
                    ICON_NOT_FOUND = null;
                    ICON_UNKNOWN_DATA_FORMAT = null;
                } else {
                    Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                    if (image == null) {
                        System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                        System.err.println("Expected location: resources/IconNotFound.gif");
                    }
                    ICON_NOT_FOUND = new JarResources$NotFoundIcon(image);
                    URL uRL2 = kClassLoader.getResource("edu/mit/broad/genome/resources/UnknownDataFormat16.gif");
                    if (uRL2 != null) {
                        image = Toolkit.getDefaultToolkit().getImage(uRL2);
                        ICON_UNKNOWN_DATA_FORMAT = new ImageIcon(image);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Fatal error initializing JarResources " + throwable.getMessage());
        }
    }
}

