/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.math.FrequencyMap;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.utils.ArrayUtils;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AlgUtils {
    private static final Logger klog = XLogger.getLogger(AlgUtils.class);

    private AlgUtils() {
    }

    public static final Set getAllMembers(GeneSet[] geneSetArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            hashSet.addAll(geneSetArray[i2].getMembersS());
        }
        return hashSet;
    }

    public static final int getMaxSize(FrequencyMap[] frequencyMapArray) {
        int n = 0;
        for (int i2 = 0; i2 < frequencyMapArray.length; ++i2) {
            int n2 = frequencyMapArray[i2].getSize();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static final LabelledVector getGeneSetSizes(GeneSetMatrix geneSetMatrix) {
        Vector vector = new Vector(geneSetMatrix.getNumGeneSets());
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            vector.setElement(i2, geneSetMatrix.getGeneSet(i2).getNumMembers());
        }
        return new LabelledVector(geneSetMatrix.getGeneSetNamesL(true), vector, true);
    }

    public static final int countTotal(TObjectIntHashMap tObjectIntHashMap) {
        int n = 0;
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        int n2 = tObjectIntHashMap.size();
        while (n2-- > 0) {
            tObjectIntIterator.advance();
            n += tObjectIntIterator.value();
        }
        return n;
    }

    public static final String[] findRowNamesInAAndNotInB(Dataset dataset, Dataset dataset2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            if (dataset2.getRowIndex(string) != -1) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final int[] rowNames2Indices(String[] stringArray, Dataset dataset, boolean bl) {
        int n;
        if (dataset == null) {
            throw new NullPointerException("Dataset arg cant be null");
        }
        if (stringArray == null) {
            throw new NullPointerException("Names arr arg cant be null");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            n = dataset.getRowIndex(stringArray[i2]);
            if (n == -1 && bl) {
                throw new RuntimeException("ds doesnt contain: " + stringArray[i2]);
            }
            if (n == -1) continue;
            arrayList.add(new Integer(n));
        }
        klog.debug("Number of hits = " + arrayList.size());
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public static final Integer[] createRowNumberArray(Dataset dataset, boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        Integer[] integerArray = new Integer[dataset.getNumRow()];
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            integerArray[i2] = new Integer(n++);
        }
        return integerArray;
    }

    public static final java.util.Vector createRowNumberVector(Dataset dataset, boolean bl) {
        java.util.Vector<Integer> vector = new java.util.Vector<Integer>(dataset.getNumRow());
        int n = 0;
        if (bl) {
            n = 1;
        }
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            vector.addElement(new Integer(n++));
        }
        return vector;
    }

    public static final Set getRowNames(int n, int n2, Dataset dataset) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = n; i2 <= n2; ++i2) {
            if (i2 < 0 || i2 >= dataset.getNumRow()) continue;
            hashSet.add(dataset.getRowName(i2));
        }
        return hashSet;
    }

    public static final int getMaxNumRows(Dataset[] datasetArray) {
        int[] nArray = new int[datasetArray.length];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            nArray[i2] = datasetArray[i2].getNumRow();
        }
        return XMath.max(nArray);
    }

    public static final int getMaxSize(RankedList[] rankedListArray) {
        int[] nArray = new int[rankedListArray.length];
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            nArray[i2] = rankedListArray[i2].getSize();
        }
        return XMath.max(nArray);
    }

    public static final int getMaxNumCols(Dataset[] datasetArray) {
        int[] nArray = new int[datasetArray.length];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            nArray[i2] = datasetArray[i2].getNumCol();
        }
        return XMath.max(nArray);
    }

    public static final int getTotalNumCols(Dataset[] datasetArray) {
        int n = 0;
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            n += datasetArray[i2].getNumCol();
        }
        return n;
    }

    public static final float getMaxValue(Dataset[] datasetArray) {
        float f2 = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            Matrix matrix = datasetArray[i2].getMatrix();
            float f3 = matrix.max().value;
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static final float getMinValue(Dataset[] datasetArray) {
        float f2 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            Matrix matrix = datasetArray[i2].getMatrix();
            float f3 = matrix.min().value;
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static final String[] getUniqueMemberNames(GeneSetMatrix[] geneSetMatrixArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            hashSet.addAll(geneSetMatrixArray[i2].getAllMemberNamesOnlyOnceS());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static final String[] getUniqueMemberNames(GeneSet[] geneSetArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            hashSet.addAll(geneSetArray[i2].getMembersS());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static final String[] getUniqueGeneSetNames(GeneSetMatrix[] geneSetMatrixArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            String[] stringArray = geneSetMatrixArray[i2].getGeneSetNames(false);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                hashSet.add(stringArray[i3]);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static final String[] getAllPobNames(PersistentObject[] persistentObjectArray, boolean bl) {
        List list = AlgUtils.getAllPobNamesL(persistentObjectArray, bl);
        return list.toArray(new String[list.size()]);
    }

    public static final List getAllPobNamesL(PersistentObject[] persistentObjectArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            if (bl) {
                arrayList.add(AuxUtils.getAuxNameOnlyNoHash(persistentObjectArray[i2].getName()));
                continue;
            }
            arrayList.add(persistentObjectArray[i2].getName());
        }
        return arrayList;
    }

    public static final Set getAllPobNamesS(PersistentObject[] persistentObjectArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            hashSet.add(persistentObjectArray[i2].getName());
        }
        return hashSet;
    }

    public static final Set getAllPobNamesFromAuxNamesS(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            hashSet.add(AuxUtils.getAuxNameOnlyNoHash(string));
        }
        return hashSet;
    }

    public static final GeneSet[] getAllGeneSets_ensureuniquename(GeneSetMatrix[] geneSetMatrixArray) {
        HashSet<GeneSet> hashSet = new HashSet<GeneSet>();
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            GeneSet[] geneSetArray = geneSetMatrixArray[i2].getGeneSets();
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (hashSet.contains(geneSetArray[i3].getName())) {
                    throw new RuntimeException("Non-unique fset: " + geneSetArray[i3].getName() + " in gmx: " + geneSetMatrixArray[i2].getName());
                }
                hashSet.add(geneSetArray[i3]);
            }
        }
        return hashSet.toArray(new FSet[hashSet.size()]);
    }

    public static final int getMaxMemberCount(List list) {
        int n = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneSet geneSet = (GeneSet)list.get(i2);
            if (n >= geneSet.getNumMembers()) continue;
            n = geneSet.getNumMembers();
        }
        return n;
    }

    public static final int getMaxMemberCount(GeneSet[] geneSetArray) {
        int n = 0;
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (n >= geneSetArray[i2].getNumMembers()) continue;
            n = geneSetArray[i2].getNumMembers();
        }
        return n;
    }

    public static final Set unionRowNames(Dataset[] datasetArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            hashSet.addAll(datasetArray[i2].getRowNames());
        }
        return hashSet;
    }

    public static final Set intersectRowNames(Dataset[] datasetArray) {
        FrequencyMap frequencyMap = new FrequencyMap("some");
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            frequencyMap.addAll(datasetArray[i2].getRowNames());
        }
        return frequencyMap.getElements(datasetArray.length);
    }

    public static final void ensureUniqueColNames(Dataset[] datasetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            for (int i3 = 0; i3 < datasetArray[i2].getNumCol(); ++i3) {
                if (hashSet.contains(datasetArray[i2].getColumnName(i3))) {
                    throw new IllegalArgumentException("Duplicate column names (acorss datasets): " + datasetArray[i2].getColumnName(i3) + " in dataset: " + datasetArray[i2].getName());
                }
                hashSet.add(datasetArray[i2].getColumnName(i3));
            }
        }
    }

    public static final int getTotalNumOfGeneSets(GeneSetMatrix[] geneSetMatrixArray) {
        int n = 0;
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            n += geneSetMatrixArray[i2].getNumGeneSets();
        }
        return n;
    }

    public static final int getTotalNumOfGeneSets_ignore_duplicate_gmxs_by_name(GeneSetMatrix[] geneSetMatrixArray) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        for (int i2 = 0; i2 < geneSetMatrixArray.length; ++i2) {
            if (hashSet.contains(geneSetMatrixArray[i2].getName())) continue;
            n += geneSetMatrixArray[i2].getNumGeneSets();
            hashSet.add(geneSetMatrixArray[i2].getName());
        }
        return n;
    }

    public static final GeneSet unionAll(String string, GeneSet[] geneSetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray[i2].getNumMembers(); ++i3) {
                hashSet.add(geneSetArray[i2].getMember(i3));
            }
        }
        return new FSet(string, hashSet);
    }

    public static final int unionAllCount(GeneSet[] geneSetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray[i2].getNumMembers(); ++i3) {
                hashSet.add(geneSetArray[i2].getMember(i3));
            }
        }
        return hashSet.size();
    }

    public static final GeneSet unionAll(String string, Collection[] collectionArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < collectionArray.length; ++i2) {
            hashSet.addAll(collectionArray[i2]);
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet subtract(GeneSet geneSet, GeneSet geneSet2) {
        return AlgUtils.subtract("subtracted_" + geneSet.getName(), geneSet, geneSet2);
    }

    public static final GeneSet subtract(String string, GeneSet geneSet, GeneSet geneSet2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string2 = geneSet.getMember(i2);
            if (geneSet2.isMember(string2)) continue;
            arrayList.add(string2);
        }
        return new FSet(string, arrayList, false);
    }

    public static final Set subtract(Collection collection, Collection collection2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (collection2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static final Set subtract(String[] stringArray, String[] stringArray2) {
        return AlgUtils.subtract(ArrayUtils.toSet(stringArray), ArrayUtils.toSet(stringArray2));
    }

    public static final TObjectIntHashMap frequencyMap(GeneSet[] geneSetArray) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray[i2].getNumMembers(); ++i3) {
                if (tObjectIntHashMap.containsKey(geneSetArray[i2].getMember(i3))) {
                    int n = tObjectIntHashMap.get(geneSetArray[i2].getMember(i3));
                    tObjectIntHashMap.put(geneSetArray[i2].getMember(i3), ++n);
                    continue;
                }
                tObjectIntHashMap.put(geneSetArray[i2].getMember(i3), 1);
            }
        }
        return tObjectIntHashMap;
    }

    public static final int getNumOfMembers(Dataset dataset, GeneSet geneSet) {
        int n = 0;
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            if (!geneSet.isMember(dataset.getRowName(i2))) continue;
            ++n;
        }
        return n;
    }

    public static final int getNumOfMembers(RankedList rankedList, GeneSet geneSet) {
        int n = 0;
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            if (!geneSet.isMember(rankedList.getRankName(i2))) continue;
            ++n;
        }
        return n;
    }

    public static final int getNumOfMembers(Set set, GeneSet geneSet) {
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!geneSet.isMember(string)) continue;
            ++n;
        }
        return n;
    }

    public static final int getNumGenes(boolean bl, GeneSet[] geneSetArray) {
        AbstractCollection abstractCollection = bl ? new HashSet() : new ArrayList();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            abstractCollection.addAll(geneSetArray[i2].getMembers());
        }
        return abstractCollection.size();
    }

    public static final GeneSet intersectAll(String string, GeneSet[] geneSetArray) {
        return GeneSetGenerators.createIntersectionGeneSet(string, geneSetArray);
    }

    public static final GeneSet intersectAll(String string, Collection[] collectionArray) {
        GeneSet geneSet = AlgUtils.unionAll(string + "tmpunion", collectionArray);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string2 = geneSet.getMember(i2);
            boolean bl = true;
            for (int i3 = 0; i3 < collectionArray.length; ++i3) {
                if (collectionArray[i3].contains(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashSet.add(string2);
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet intersect(String string, GeneSet geneSet, GeneSet geneSet2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string2 = geneSet.getMember(i2);
            if (!geneSet2.isMember(string2)) continue;
            hashSet.add(string2);
        }
        return new FSet(string, hashSet);
    }

    public static final int intersectSize(GeneSet geneSet, GeneSet geneSet2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            if (!geneSet2.isMember(string)) continue;
            hashSet.add(string);
        }
        return hashSet.size();
    }

    public static final int intersectSize(RankedList rankedList, RankedList rankedList2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            String string = rankedList.getRankName(i2);
            if (!rankedList2.isMember(string)) continue;
            hashSet.add(string);
        }
        return hashSet.size();
    }

    public static final int intersectSize(GeneSet geneSet, GeneSet[] geneSetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        FSet fSet = new FSet("b", geneSetArray);
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            if (!fSet.isMember(string)) continue;
            hashSet.add(string);
        }
        return hashSet.size();
    }

    public static final String getComboName(EnrichmentDb[] enrichmentDbArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < enrichmentDbArray.length; ++i2) {
            stringBuffer.append(enrichmentDbArray[i2]);
            if (i2 == enrichmentDbArray.length - 1) continue;
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static final Set getGeneSetNamesS(EnrichmentResult[] enrichmentResultArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            hashSet.add(enrichmentResultArray[i2].getGeneSet().getName());
        }
        return hashSet;
    }

    public static final GeneSet[] getGeneSets(EnrichmentResult[] enrichmentResultArray) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            arrayList.add(enrichmentResultArray[i2].getGeneSet());
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final Set getTemplateNamesS(Template[] templateArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            hashSet.add(templateArray[i2].getName());
        }
        return hashSet;
    }

    public static final Set getTemplateNamesS(EnrichmentResult[] enrichmentResultArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            hashSet.add(enrichmentResultArray[i2].getTemplate().getName());
        }
        return hashSet;
    }

    public static final void enforceNoDuplicates(EnrichmentResult[] enrichmentResultArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < enrichmentResultArray.length; ++i2) {
            String string = enrichmentResultArray[i2].getTemplate().getName() + "_" + enrichmentResultArray[i2].getGeneSet().getName();
            if (hashSet.contains(string)) {
                throw new IllegalStateException("Duplicated dtg: " + string);
            }
            hashSet.add(string);
        }
    }
}

