/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.alg.CorrMetric;
import edu.mit.broad.genome.alg.DatasetBuilder;
import edu.mit.broad.genome.alg.DatasetGenerators$CollapseStruc;
import edu.mit.broad.genome.alg.DatasetGenerators$CollapsedDataset;
import edu.mit.broad.genome.alg.DatasetGenerators$RowByScoreComparator;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.alg.Imputer;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.math.ColorScheme;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.ColorDatasetImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.ScoredDatasetImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.MissingValueDatasetParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.ArrayUtils;
import edu.mit.broad.genome.utils.Strings;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.map.ProbeMergeMode;
import edu.mit.broad.vdb.sampledb.State;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xtools.api.param.BadParamException;

public class DatasetGenerators {
    private final Logger log = XLogger.getLogger(DatasetGenerators.class);

    public final Dataset orderRows_by_ova_score(Dataset dataset) {
        ArrayList arrayList = new ArrayList(dataset.getRowNames());
        Collections.sort(arrayList, new DatasetGenerators$RowByScoreComparator(dataset));
        return new DatasetGenerators().orderDatasetRows(dataset.getName() + "_ord", arrayList, dataset);
    }

    public final String[] getColumnNamesByPrefix(String string, Dataset dataset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            if (!dataset.getColumnName(i2).toUpperCase().startsWith(string.toUpperCase())) continue;
            arrayList.add(dataset.getColumnName(i2));
        }
        this.log.info("# of matches by prefix " + string + " : " + arrayList.size());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final Dataset createPairwiseDataset(Dataset dataset, CorrMetric corrMetric, boolean bl, boolean bl2) {
        float f2;
        Vector vector;
        int n;
        Object object;
        int n2;
        Matrix matrix;
        String[] stringArray;
        if (bl) {
            stringArray = dataset.getRowNamesArray();
            matrix = new Matrix(dataset.getNumRow(), dataset.getNumRow());
            for (n2 = 0; n2 < dataset.getNumRow(); ++n2) {
                object = dataset.getRow(n2);
                for (n = 0; n < dataset.getNumRow(); ++n) {
                    vector = dataset.getRow(n);
                    f2 = (float)corrMetric.getCorr((Vector)object, vector);
                    matrix.setElement(n2, n, f2);
                }
            }
        } else {
            stringArray = dataset.getColumnNamesArray();
            matrix = new Matrix(dataset.getNumCol(), dataset.getNumCol());
            for (n2 = 0; n2 < dataset.getNumCol(); ++n2) {
                object = dataset.getColumn(n2);
                for (n = 0; n < dataset.getNumCol(); ++n) {
                    vector = dataset.getColumn(n);
                    f2 = (float)corrMetric.getCorr((Vector)object, vector);
                    matrix.setElement(n2, n, f2);
                }
            }
        }
        Dataset dataset2 = new DefaultDataset(dataset.getName() + "_pwd", matrix, stringArray, stringArray, true);
        if (bl2) {
            object = new ArrayList();
            block4: for (n = 0; n < dataset2.getNumRow(); ++n) {
                for (int i2 = 0; i2 < dataset2.getNumCol(); ++i2) {
                    if (n == i2 || dataset2.getElement(n, i2) == 0.0f) continue;
                    object.add(dataset2.getRowName(n));
                    continue block4;
                }
            }
            dataset2 = new DatasetGenerators().extractRows(dataset2, (List)object);
        }
        return dataset2;
    }

    public final Dataset createComboDataset_append_columns(String string, Dataset dataset, Dataset dataset2) {
        ArrayList arrayList = new ArrayList(dataset.getColumnNames());
        arrayList.addAll(dataset2.getColumnNames());
        String[] stringArray = dataset.getRowNamesArray();
        Matrix matrix = new Matrix(stringArray.length, arrayList.size());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            int n;
            int n2 = 0;
            for (n = 0; n < dataset.getNumCol(); ++n) {
                matrix.setElement(i2, n2++, dataset.getElement(i2, n));
            }
            for (n = 0; n < dataset2.getNumCol(); ++n) {
                matrix.setElement(i2, n2++, dataset2.getElement(stringArray[i2], n));
            }
        }
        return new DefaultDataset(string, matrix, stringArray, arrayList.toArray(new String[arrayList.size()]), true, null);
    }

    public final List getComboMarkers(Dataset dataset, Template[] templateArray, int n, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            DatasetTemplate datasetTemplate = new DatasetGenerators().extract(dataset, templateArray[i2]);
            ScoredDataset scoredDataset = new DatasetMetrics().scoreDataset(datasetTemplate);
            arrayList.addAll(scoredDataset.getNamesOfUpOrDnXRanks(n, bl));
        }
        return arrayList;
    }

    public final Dataset createDatasetOrderedByMarkerGenes(String string, Dataset dataset, Template[] templateArray, int n, boolean bl) {
        List list = this.getComboMarkers(dataset, templateArray, n, bl);
        List list2 = this.getOrderedColNames(dataset, templateArray, true);
        return this.extractSortedRowsAndColumns(dataset, list, list2);
    }

    public final List getOrderedColNames(Dataset dataset, Template[] templateArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Errors errors = new Errors();
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            Template$Class template$Class = bl ? templateArray[i2].getClass(0) : templateArray[i2].getClass(1);
            List list = template$Class.extractColumnNames(dataset);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                String string = list.get(i3).toString();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    continue;
                }
                errors.add(string);
            }
        }
        errors.barfIfNotEmptyRuntime();
        return arrayList;
    }

    public final ColorDataset createColorDataset(int n, RankedList rankedList, ColorScheme colorScheme) {
        Range[] rangeArray = RangeFactory.createRanges(n, 0.0, (double)rankedList.getSize());
        Vector vector = rankedList.getScoresV(false);
        Matrix matrix = new Matrix(1, rangeArray.length);
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            matrix.setElement(0, i2, (float)vector.mean((int)rangeArray[i2].getMin(), (int)rangeArray[i2].getMax()));
        }
        return new ColorDatasetImpl((Dataset)new DefaultDataset("foo", matrix, null), colorScheme);
    }

    public final Dataset createDiscDatasetFromAPCalls(Dataset dataset) {
        APMMatrix aPMMatrix = ((DefaultDataset)dataset).getAPMMatrix();
        return new DefaultDataset(dataset.getName() + "_ap_discz", (Matrix)aPMMatrix, dataset.getRowNames(), dataset.getColumnNames(), true, dataset.getAnnot());
    }

    public final Dataset log2(Dataset dataset) {
        Matrix matrix = dataset.getMatrix();
        Matrix matrix2 = new Matrix(matrix, false);
        matrix2.log2();
        return new DefaultDataset(dataset.getName() + "_log2", matrix2, dataset.getRowNames(), dataset.getColumnNames(), true, false, false, dataset.getAnnot(), DatasetGenerators._getAPM(dataset));
    }

    public final Dataset exp2(Dataset dataset) {
        Matrix matrix = dataset.getMatrix();
        Matrix matrix2 = new Matrix(matrix, false);
        matrix2.exp(2.0);
        return new DefaultDataset(dataset.getName() + "_nat", matrix2, dataset.getRowNames(), dataset.getColumnNames(), true, false, false, dataset.getAnnot(), DatasetGenerators._getAPM(dataset));
    }

    private static APMMatrix _getAPM(Dataset dataset) {
        APMMatrix aPMMatrix = null;
        if (dataset instanceof DefaultDataset) {
            aPMMatrix = ((DefaultDataset)dataset).getAPMMatrix();
        }
        return aPMMatrix;
    }

    public final LabelledVector collapseIntoOneMetaSample(Dataset dataset) {
        String[] stringArray = new String[dataset.getNumRow()];
        Vector vector = new Vector(dataset.getNumRow());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Vector vector2 = dataset.getRow(i2);
            vector.setElement(i2, vector2.mean());
            stringArray[i2] = dataset.getRowName(i2);
        }
        return new LabelledVector(dataset.getName() + "_meta", stringArray, vector);
    }

    public final Dataset collapse(Dataset dataset, Chip chip) {
        return this.collapse(dataset, chip, true, 0);
    }

    public final Dataset collapse(Dataset dataset) {
        return this.collapse(dataset, dataset.getAnnot().getChip());
    }

    public final Dataset collapse(Dataset dataset, Chip chip, boolean bl, int n) {
        return this.collapse_core((Dataset)dataset, (Chip)chip, (boolean)bl, (int)n).symbolized;
    }

    public final DatasetGenerators$CollapsedDataset collapse_core(Dataset dataset, Chip chip, boolean bl, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        HashMap hashMap = new HashMap();
        NullSymbolMode nullSymbolMode = bl ? Chip.OMIT_NULLS : Chip.REPLACE_WITH_PROBEID;
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            object5 = dataset.getRowName(i2);
            object4 = chip.getSymbol((String)object5, nullSymbolMode);
            if (object4 != null && bl && ((String)object5).equals(object4) || object4 == null) continue;
            Object object6 = hashMap.get(object4);
            if (object6 == null) {
                object6 = new DatasetGenerators$CollapseStruc((String)object4);
            }
            DatasetGenerators$CollapseStruc.access$000((DatasetGenerators$CollapseStruc)object6, (String)object5);
            hashMap.put(object4, object6);
        }
        Matrix matrix = new Matrix(hashMap.size(), dataset.getNumCol());
        object5 = new ArrayList();
        object4 = hashMap.keySet().iterator();
        int n2 = 0;
        while (object4.hasNext()) {
            Vector[] vectorArray;
            object3 = object4.next();
            object2 = (DatasetGenerators$CollapseStruc)hashMap.get(object3);
            object5.add(((DatasetGenerators$CollapseStruc)object2).symbol);
            object = ((DatasetGenerators$CollapseStruc)object2).getProbes();
            if (((String[])object).length == 1) {
                vectorArray = object[0];
                matrix.setRow(n2, dataset.getRow((String)vectorArray));
            } else {
                vectorArray = dataset.getRows(new FSet("foo", "foo", (String[])object));
                if (n == 0) {
                    matrix.setRow(n2, XMath.maxVector(vectorArray));
                } else {
                    matrix.setRow(n2, XMath.medianVector(vectorArray));
                }
            }
            ++n2;
        }
        object3 = dataset.getName() + "_collapsed_to_symbols";
        object2 = new AnnotImpl(new FeatureAnnotImpl((String)object3, (List)object5, null, VdbRuntimeResources.getChip_Gene_Symbol()), dataset.getAnnot().getSampleAnnot_global());
        object = new DatasetGenerators$CollapsedDataset();
        object.orig = dataset;
        object.symbolized = new DefaultDataset((String)object3, matrix, (List)object5, dataset.getColumnNames(), true, (Annot)object2);
        object.symbolCollapseStrucMap = hashMap;
        return object;
    }

    public final RankedList collapse(RankedList rankedList, Chip chip, boolean bl, int n) {
        Object object;
        Object object2;
        Object object3;
        if (rankedList == null) {
            throw new IllegalArgumentException("Param origRL cannot be null");
        }
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        HashMap hashMap = new HashMap();
        NullSymbolMode nullSymbolMode = bl ? Chip.OMIT_NULLS : Chip.REPLACE_WITH_PROBEID;
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            object3 = rankedList.getRankName(i2);
            object2 = chip.getSymbol((String)object3, nullSymbolMode);
            if (object2 != null && bl && ((String)object3).equals(object2) || object2 == null) continue;
            Object object4 = hashMap.get(object2);
            if (object4 == null) {
                object4 = new DatasetGenerators$CollapseStruc((String)object2);
            }
            DatasetGenerators$CollapseStruc.access$000((DatasetGenerators$CollapseStruc)object4, (String)object3);
            hashMap.put(object2, object4);
        }
        Vector vector = new Vector(hashMap.size());
        object3 = new ArrayList();
        object2 = hashMap.keySet().iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            Object object5;
            object = object2.next();
            DatasetGenerators$CollapseStruc datasetGenerators$CollapseStruc = (DatasetGenerators$CollapseStruc)hashMap.get(object);
            object3.add(datasetGenerators$CollapseStruc.symbol);
            String[] stringArray = datasetGenerators$CollapseStruc.getProbes();
            if (stringArray.length == 1) {
                object5 = stringArray[0];
                vector.setElement(n2, rankedList.getScore((String)object5));
            } else {
                object5 = rankedList.getScores(new FSet("foo", "foo", stringArray));
                if (n == 0) {
                    vector.setElement(n2, XMath.max((float[])object5));
                } else {
                    vector.setElement(n2, XMath.median((float[])object5));
                }
            }
            ++n2;
        }
        object = rankedList.getName() + "_collapsed";
        if (vector.getSize() == 0) {
            throw new BadParamException("The collapsed dataset was empty when used with chip:" + chip.getName(), 1005);
        }
        return RankedListGenerators.sortByVectorAndGetRankedList(vector, SortMode.REAL, Order.DESCENDING, (List)object3).cloneShallowRL((String)object);
    }

    public final Dataset naturalize(Dataset dataset) {
        Matrix matrix = dataset.getMatrix();
        Matrix matrix2 = new Matrix(matrix.getNumRow(), matrix.getNumCol());
        for (int i2 = 0; i2 < matrix.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < matrix.getNumCol(); ++i3) {
                matrix2.setElement(i2, i3, (float)Math.pow(2.0, matrix.getElement(i2, i3)));
            }
        }
        return new DefaultDataset(dataset.getName() + "_nat", matrix2, dataset.getRowNames(), dataset.getColumnNames(), true, false, false, dataset.getAnnot());
    }

    public final Dataset normalize(Dataset dataset) {
        Matrix matrix = dataset.getMatrix().cloneDeep();
        matrix.normalize(true);
        return new DefaultDataset(dataset.getName() + "_norm", matrix, dataset.getRowNames(), dataset.getColumnNames(), true, false, false, dataset.getAnnot());
    }

    public final Dataset appendColumnwise(String string, Dataset[] datasetArray) {
        int n = 0;
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            n += datasetArray[i2].getNumCol();
        }
        Matrix matrix = new Matrix(datasetArray[0].getNumRow(), n);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (int i3 = 0; i3 < datasetArray.length; ++i3) {
            for (int i4 = 0; i4 < datasetArray[i3].getNumCol(); ++i4) {
                arrayList.add(datasetArray[i3].getColumnName(i4));
                matrix.setColumn(n2++, datasetArray[i3].getColumn(i4));
            }
        }
        FeatureAnnot featureAnnot = datasetArray[0].getAnnot().getFeatureAnnot();
        SampleAnnotImpl sampleAnnotImpl = new SampleAnnotImpl(string, arrayList, null);
        return new DefaultDataset(string, matrix, datasetArray[0].getRowNames(), arrayList, true, (Annot)new AnnotImpl(featureAnnot, sampleAnnotImpl));
    }

    public final Dataset transpose(Dataset dataset) {
        Matrix matrix = new Matrix(dataset.getMatrix(), false);
        matrix.transpose();
        Annot annot = dataset.getAnnot();
        return new DefaultDataset(dataset.getName() + "_transposed", matrix, dataset.getColumnNames(), dataset.getRowNames(), true, null);
    }

    public final Dataset createComboDataset(String string, Dataset[] datasetArray, boolean bl) {
        Set set = bl ? AlgUtils.unionRowNames(datasetArray) : AlgUtils.intersectRowNames(datasetArray);
        String[] stringArray = set.toArray(new String[set.size()]);
        int n = AlgUtils.getTotalNumCols(datasetArray);
        AlgUtils.ensureUniqueColNames(datasetArray);
        this.log.debug("ComboDataset rowNames: " + stringArray.length + " colSize: " + n);
        Matrix matrix = new Matrix(stringArray.length, n);
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            this.log.info("Combining Dataset: " + datasetArray[i2].getName() + " " + (i2 + 1) + " / " + datasetArray.length);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                int n3 = datasetArray[i2].getRowIndex(stringArray[i3]);
                Vector vector = n3 != -1 ? datasetArray[i2].getRow(n3) : new Vector(datasetArray[i2].getNumCol(), Float.NaN);
                for (int i4 = 0; i4 < vector.getSize(); ++i4) {
                    matrix.setElement(i3, n2 + i4, vector.getElement(i4));
                }
                if (i2 == 0) {
                    arrayList2.add(stringArray[i3]);
                }
                if (i3 % 4000 != 0) continue;
                System.out.println("Combined row: " + i3 + " / " + stringArray.length);
            }
            arrayList.addAll(datasetArray[i2].getColumnNames());
            n2 += datasetArray[i2].getNumCol();
        }
        if (n2 != n) {
            throw new IllegalStateException("Prog error: currCol: " + n2 + " totNumCols: " + n);
        }
        return new DefaultDataset(string, matrix, arrayList2, arrayList, true, null);
    }

    public final Dataset createComboDataset(String string, Dataset[] datasetArray, GeneSet geneSet, boolean bl) {
        if (datasetArray == null) {
            throw new IllegalArgumentException("Param dss cant be null");
        }
        int n = 0;
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            n += datasetArray[i2].getNumCol();
            arrayList.addAll(datasetArray[i2].getColumnNames());
        }
        Matrix matrix = new Matrix(geneSet.getNumMembers(), n);
        for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
            String string2 = geneSet.getMember(i3);
            int n2 = 0;
            for (int i4 = 0; i4 < datasetArray.length; ++i4) {
                for (int i5 = 0; i5 < datasetArray[i4].getNumCol(); ++i5) {
                    int n3 = datasetArray[i4].getRowIndex(string2);
                    if (n3 != -1) {
                        matrix.setElement(i3, n2++, datasetArray[i4].getElement(n3, i5));
                        continue;
                    }
                    matrix.setElement(i3, n2++, Float.NaN);
                }
            }
        }
        return new DefaultDataset(string, matrix, geneSet.getMembersArray(), arrayList.toArray(new String[arrayList.size()]), true);
    }

    public static final boolean isAuxDataset(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter ds cannot be null");
        }
        return Strings.contains(dataset.getName(), "@");
    }

    public final Dataset matrix2dataset(String string, Matrix[] matrixArray, boolean bl) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        int n;
        if (bl) {
            int n2;
            n = matrixArray[0].getNumRow();
            for (n2 = 0; n2 < matrixArray.length; ++n2) {
                if (matrixArray[n2].getNumRow() == n) continue;
                throw new IllegalArgumentException("Unequal number of rows: " + n + " in matrix: " + n2);
            }
            arrayList2 = new ArrayList<String>(n);
            for (n2 = 0; n2 < n; ++n2) {
                arrayList2.add("gene." + n2);
            }
            arrayList = new ArrayList();
            for (n2 = 0; n2 < matrixArray.length; ++n2) {
                for (int i2 = 0; i2 < matrixArray[n2].getNumCol(); ++i2) {
                    arrayList.add("sample." + n2);
                }
            }
        } else {
            int n3;
            n = matrixArray[0].getNumCol();
            for (n3 = 0; n3 < matrixArray.length; ++n3) {
                if (matrixArray[n3].getNumCol() == n) continue;
                throw new IllegalArgumentException("Unequal number of cols: " + n + " in matrix: " + n3);
            }
            arrayList = new ArrayList<String>(n);
            for (n3 = 0; n3 < n; ++n3) {
                arrayList.add("sample." + n3);
            }
            arrayList2 = new ArrayList();
            n3 = 0;
            for (int i3 = 0; i3 < matrixArray.length; ++i3) {
                for (int i4 = 0; i4 < matrixArray[i3].getNumRow(); ++i4) {
                    arrayList2.add("gene." + n3++);
                }
            }
        }
        Matrix matrix = new Matrix(matrixArray, true);
        return new DefaultDataset(string, matrix, arrayList2, arrayList, true, null);
    }

    public final Dataset matrix2dataset(String string, Matrix matrix) {
        return this.matrix2dataset(string, new Matrix[]{matrix}, true);
    }

    public final Dataset vector2dataset(String string, Vector[] vectorArray) {
        Matrix matrix = new Matrix(vectorArray, true, false);
        return this.matrix2dataset(string, matrix);
    }

    public final Dataset matrix2dataset(String string, File file) {
        String string2;
        int n = ParseUtils.countLines(file, true);
        int n2 = ParseUtils.countColumns(file, 1, true);
        this.log.info("nrows = " + n + " ncols = " + n2);
        Matrix matrix = new Matrix(n, n2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n3 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            int n4 = 0;
            while (stringTokenizer.hasMoreElements()) {
                float f2 = Float.parseFloat(stringTokenizer.nextToken());
                matrix.setElement(n3, n4, f2);
                ++n4;
            }
            ++n3;
        }
        bufferedReader.close();
        return this.matrix2dataset(string, matrix);
    }

    public final Dataset orderDatasetColumns(String string, int[] nArray, Dataset dataset) {
        Matrix matrix = new Matrix(dataset.getNumRow(), nArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n = nArray[i2];
            matrix.setColumn(i2, dataset.getColumn(n));
            arrayList.add(dataset.getColumnName(n));
        }
        return new DefaultDataset(string, matrix, dataset.getRowNames(), arrayList, true, false, true, dataset.getAnnot(), DatasetGenerators._getAPM(dataset));
    }

    public final Dataset orderDatasetColumns(String string, List list, Dataset dataset, boolean bl) {
        String[] stringArray = list.toArray(new String[list.size()]);
        return this.orderDatasetColumns(string, stringArray, dataset, bl);
    }

    public final Dataset orderDatasetColumns(String string, String[] stringArray, Dataset dataset, boolean bl) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Order names cannot be null or empty: " + stringArray);
        }
        if (stringArray.length > dataset.getNumCol()) {
            throw new IllegalArgumentException("# of orders: " + stringArray.length + " cannot be more than # of cols: " + dataset.getNumCol());
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (dataset.getColumnIndex(stringArray[i2]) == i2) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.log.debug("Already ordered dataset!");
            return dataset;
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), stringArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string2;
            int n = dataset.getColumnIndex(stringArray[i3]);
            if (n == -1 && stringArray[i3].endsWith(".cel")) {
                string2 = stringArray[i3].substring(0, stringArray[i3].length() - 4);
                n = dataset.getColumnIndex(string2);
            }
            if (n == -1 && stringArray[i3].endsWith(".CEL")) {
                string2 = stringArray[i3].substring(0, stringArray[i3].length() - 4);
                n = dataset.getColumnIndex(string2);
            }
            if (!bl) {
                // empty if block
            }
            if (n == -1) {
                throw new IllegalArgumentException("Invalid order name specified >" + stringArray[i3] + "< Not found in dataset. Dataset cols are\n" + dataset.getColumnNames());
            }
            matrix.setColumn(i3, dataset.getColumn(n));
            arrayList.add(dataset.getColumnName(n));
        }
        return new DefaultDataset(string, matrix, dataset.getRowNames(), arrayList, true, false, true, dataset.getAnnot());
    }

    public final Dataset orderDatasetRows(String string, List list, Dataset dataset) {
        String[] stringArray = list.toArray(new String[list.size()]);
        return this.orderDatasetRows(string, stringArray, dataset);
    }

    public final Dataset orderDatasetRows(String string, String[] stringArray, Dataset dataset) {
        if (stringArray.length != dataset.getNumRow()) {
            throw new MismatchedSizeException("order", stringArray.length, "dataset rows", dataset.getNumRow());
        }
        Matrix matrix = new Matrix(stringArray.length, dataset.getNumCol());
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n = dataset.getRowIndex(stringArray[i2]);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid order name specified >" + stringArray[i2] + "< Not found in dataset. Rows are: " + dataset.getRowNames());
            }
            matrix.setRow(i2, dataset.getRow(n));
            arrayList.add(dataset.getRowName(n));
        }
        return new DefaultDataset(string, matrix, arrayList, dataset.getColumnNames(), true, true, false, dataset.getAnnot(), DatasetGenerators._getAPM(dataset));
    }

    public final Dataset orderDatasetRowsAndColumns(String string, String[] stringArray, Dataset dataset, boolean bl) {
        Dataset dataset2 = this.orderDatasetRows(string, stringArray, dataset);
        return this.orderDatasetColumns(string, stringArray, dataset2, bl);
    }

    public final Dataset orderDatasetRowsAndColumns(String string, List list, Dataset dataset, boolean bl) {
        Dataset dataset2 = this.orderDatasetRows(string, list, dataset);
        return this.orderDatasetColumns(string, list, dataset2, bl);
    }

    public final Dataset orderDatasetRowsAndColumns(String string, String[] stringArray, String[] stringArray2, Dataset dataset, boolean bl) {
        Dataset dataset2 = this.orderDatasetRows(string, stringArray, dataset);
        return this.orderDatasetColumns(string, stringArray2, dataset2, bl);
    }

    public final Dataset orderDatasetRowsAndColumns(String string, int[] nArray, int[] nArray2, Dataset dataset) {
        int n;
        if (nArray == null) {
            throw new IllegalArgumentException("Param rowIndexOrder cannot be null");
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException("Param colIndexOrder cannot be null");
        }
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            stringArray[n] = dataset.getRowName(nArray[n]);
        }
        for (n = 0; n < nArray2.length; ++n) {
            stringArray2[n] = dataset.getColumnName(nArray2[n]);
        }
        return this.orderDatasetRowsAndColumns(string, stringArray, stringArray2, dataset, true);
    }

    public final Dataset orderDatasetRowsAndColumns(String string, List list, List list2, Dataset dataset, boolean bl) {
        Dataset dataset2 = this.orderDatasetRows(string, list, dataset);
        return this.orderDatasetColumns(string, list2, dataset2, bl);
    }

    public final Dataset[] split(Dataset dataset, Template[] templateArray) {
        Dataset[] datasetArray = new Dataset[templateArray.length];
        Matrix[] matrixArray = new Matrix[templateArray.length];
        ArrayList arrayList = new ArrayList(dataset.getRowNames());
        Collections.copy(arrayList, dataset.getRowNames());
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            ArrayList<String> arrayList2 = new ArrayList<String>(templateArray[i2].getNumItems());
            matrixArray[i2] = new Matrix(dataset.getNumRow(), templateArray[i2].getNumItems());
            int[] nArray = templateArray[i2].getProfilePositionsOrdered();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n = nArray[i3];
                matrixArray[i2].setColumn(i3, dataset.getColumn(n));
                arrayList2.add(dataset.getColumnName(n));
            }
            System.out.println("---------");
            String string = dataset.getName().concat("@").concat(templateArray[i2].getName());
            datasetArray[i2] = new DefaultDataset(string, matrixArray[i2], arrayList, arrayList2, true, dataset.getAnnot());
        }
        return datasetArray;
    }

    public final Dataset[] extractByTemplateClasses(Dataset dataset, Template template) {
        Dataset[] datasetArray = new Dataset[template.getNumClasses()];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            Template$Class template$Class = template.getClass(i2);
            datasetArray[i2] = this.extract(dataset, template$Class);
        }
        return datasetArray;
    }

    public final DatasetTemplate extract(Dataset dataset, Template template) {
        return DatasetGenerators.extract(dataset, template, true);
    }

    public final Dataset[] extract_ds(Dataset dataset, Template[] templateArray, boolean bl) {
        DatasetTemplate[] datasetTemplateArray = this.extract(dataset, templateArray);
        return DatasetTemplate.toDatasets(datasetTemplateArray, bl);
    }

    public final DatasetTemplate[] extract(Dataset dataset, Template[] templateArray) {
        DatasetTemplate[] datasetTemplateArray = new DatasetTemplate[templateArray.length];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            Template template = templateArray[i2];
            datasetTemplateArray[i2] = this.extract(dataset, template);
        }
        return datasetTemplateArray;
    }

    public final Dataset extract(Dataset dataset, Template$Class template$Class) {
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        if (template$Class == null) {
            throw new IllegalArgumentException("Parameter tc cannot be null");
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), template$Class.getSize());
        ArrayList<String> arrayList = new ArrayList<String>(template$Class.getSize());
        int[] nArray = template$Class.getOrderedProfilePositions();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n = nArray[i2];
            matrix.setColumn(i2, dataset.getColumn(n));
            arrayList.add(dataset.getColumnName(n));
        }
        String string = NamingConventions.generateName(dataset, template$Class, true);
        return new DefaultDataset(string, matrix, dataset.getRowNames(), arrayList, true, false, true, dataset.getAnnot());
    }

    public static final synchronized DatasetTemplate extract(Dataset dataset, Template template, boolean bl) {
        return TemplateFactory.extract(dataset, template, bl);
    }

    public final Dataset extractRows(String string, Dataset dataset, List list) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter newName cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter probenames cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        DatasetBuilder datasetBuilder = new DatasetBuilder(string, dataset.getColumnNames());
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2 = (String)list.get(i2);
            int n2 = dataset.getRowIndex(string2);
            if (n2 == -1) {
                ++n;
                continue;
            }
            arrayList.add(string2);
            datasetBuilder.addRow(n2, dataset);
        }
        if (n != 0) {
            this.log.warn("Not all probes had matches. Total probes:" + list.size() + " missing number:" + n + " hits:" + arrayList.size());
        }
        return datasetBuilder.generate(dataset.getAnnot());
    }

    public final Dataset extractRows(String string, Dataset dataset, Set set) {
        return this.extractRows(string, dataset, new ArrayList(set));
    }

    public final Dataset extractRows(String string, Dataset dataset, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = dataset.getRowName(nArray[i2]);
        }
        return this.extractRows(string, dataset, stringArray);
    }

    public final Dataset extractRows(String string, Dataset dataset, int[] nArray, boolean bl) {
        if (bl) {
            return this.extractRows(string, dataset, nArray);
        }
        TIntArrayList tIntArrayList = new TIntArrayList();
        TIntArrayList tIntArrayList2 = new TIntArrayList(nArray);
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            if (tIntArrayList2.contains(i2)) continue;
            tIntArrayList.add(i2);
        }
        return this.extractRows(string, dataset, tIntArrayList.toNativeArray());
    }

    public final Dataset extractRows_exclude_row(String string, Dataset dataset, int n) {
        ArrayList arrayList = new ArrayList(dataset.getRowNames());
        arrayList.remove(dataset.getRowName(n));
        return this.extractRows(string, dataset, arrayList);
    }

    public final Dataset extractRows(String string, Dataset dataset, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Parameter rowNames cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return this.extractRows(string, dataset, arrayList);
    }

    public final Dataset[] extractDatasets(Dataset dataset, GeneSet[] geneSetArray, boolean bl) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param fullDs cannot be null");
        }
        if (geneSetArray == null) {
            throw new IllegalArgumentException("Param gsets cannot be null");
        }
        Dataset[] datasetArray = new Dataset[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2] == null) {
                throw new IllegalArgumentException("Param gsets cannot be null at index: " + i2);
            }
            GeneSet geneSet = geneSetArray[i2];
            String string = AuxUtils.getAuxNameOnlyNoHash(geneSet.getName());
            if (bl) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                    if (dataset.getColumnIndex(geneSet.getMember(i3)) != -1) {
                        arrayList.add(geneSet.getMember(i3));
                        continue;
                    }
                    arrayList2.add(geneSet.getMember(i3));
                }
                datasetArray[i2] = new DatasetGenerators().extractColumns(dataset.getName() + "xtracted_ncols_" + arrayList.size() + "_" + string, dataset, arrayList);
                if (arrayList2.size() == 0) continue;
                this.log.warn("Some specified samples were not found in the dataset: " + arrayList2.size());
                System.out.println(arrayList2);
                continue;
            }
            datasetArray[i2] = new DatasetGenerators().extractRows(dataset.getName() + "xtracted_rows_" + string, dataset, geneSet);
        }
        return datasetArray;
    }

    public final Dataset extractRows(Dataset dataset, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String string = NamingConventions.generateName(dataset, geneSet, true);
        return this.extractRows(string, dataset, geneSet.getMembers());
    }

    public final Dataset extractRows_with_apm(Dataset dataset, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        APMMatrix aPMMatrix = ((DefaultDataset)dataset).getAPMMatrix();
        Dataset dataset2 = this.extractRows(dataset, geneSet.getMembers());
        APMMatrix aPMMatrix2 = new APMMatrix(dataset2.getNumRow(), dataset2.getNumCol());
        for (int i2 = 0; i2 < dataset2.getNumRow(); ++i2) {
            int n = dataset.getRowIndex(dataset2.getRowName(i2));
            for (int i3 = 0; i3 < dataset2.getNumCol(); ++i3) {
                aPMMatrix2.setElement(i2, i3, aPMMatrix.getElement(n, i3));
            }
        }
        return ((DefaultDataset)dataset2).cloneShallow(aPMMatrix2);
    }

    public final Dataset extractRows(Dataset dataset, List list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter names cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String string = dataset.getName() + "_nrows" + list.size();
        return this.extractRows(string, dataset, list);
    }

    public final Dataset extractSortedRowsAndColumns(Dataset dataset, List list, List list2) {
        Dataset dataset2 = this.extractColumns("foo", dataset, list2);
        return this.extractRows(dataset.getName() + "_rows_cols_sorted", dataset2, list);
    }

    public final Dataset extractRowsSorted(ScoredDataset scoredDataset, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter fset cannot be null");
        }
        if (scoredDataset == null) {
            throw new IllegalArgumentException("Parameter fullSds cannot be null");
        }
        FSet fSet = new FSet(geneSet, scoredDataset);
        String string = NamingConventions.generateName((Dataset)scoredDataset, geneSet, true);
        return this.extractRows(string, (Dataset)scoredDataset, fSet.getMembers());
    }

    public final ScoredDataset extractRowsSds(String string, ScoredDataset scoredDataset, int[] nArray) {
        if (scoredDataset == null) {
            throw new IllegalArgumentException("Parameter fullSds cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Parameter rowIndices cannot be null");
        }
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(scoredDataset.getRow(nArray[i2]));
        }
        return ((ScoredDatasetImpl)scoredDataset).extractSds(string, new FSet(string, arrayList, false));
    }

    public final ScoredDataset extractRowsSds(ScoredDataset scoredDataset, int[] nArray) {
        return this.extractRowsSds(scoredDataset.getName() + "_" + nArray.length, scoredDataset, nArray);
    }

    public final Dataset extractRowsSorted(ScoredDataset scoredDataset, Template template, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        if (scoredDataset == null) {
            throw new IllegalArgumentException("Parameter fullSds cannot be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Parameter t cannot be null");
        }
        FSet fSet = new FSet(geneSet, scoredDataset);
        Dataset dataset = new DatasetGenerators().extract((Dataset)scoredDataset, template).getDataset(false);
        String string = NamingConventions.generateName((Dataset)scoredDataset, geneSet, true);
        return this.extractRows(string, dataset, fSet.getMembers());
    }

    public final Dataset extractRows(String string, Dataset dataset, GeneSet geneSet) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        return this.extractRows(string, dataset, geneSet.getMembers());
    }

    public final Dataset extractRows(String string, Dataset dataset, GeneSet geneSet, boolean bl) {
        if (bl) {
            return this.extractRows(string, dataset, geneSet);
        }
        return this.extractRows(string, dataset, GeneSetGenerators.subtractGeneSet(dataset.getRowNamesGeneSet(), geneSet));
    }

    public final Dataset extractRowsAndColumns_with_apm(String string, Dataset dataset, GeneSet geneSet, String[] stringArray, APMMatrix aPMMatrix) {
        Dataset dataset2 = this.extractRows(dataset, geneSet);
        dataset2 = this.extractColumns(string, dataset2, stringArray);
        ((DefaultDataset)dataset2).cloneShallow(aPMMatrix);
        return dataset2;
    }

    public final Dataset truncateRows(int n, Dataset dataset) {
        int[] nArray = ArrayUtils.fill(0, n, 1);
        return new DefaultDataset(NamingConventions.generateName((PersistentObject)dataset, "truncated." + n), nArray, dataset);
    }

    public final Dataset[] createMappedDatasets(ProbeMergeMode probeMergeMode, Map map, Dataset dataset, Dataset dataset2) {
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (dataset.getRowIndex(stringArray[i2]) == -1) continue;
            hashSet.add(stringArray[i2]);
        }
        String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        this.log.debug("For mapping: dsA: " + dataset.getNumRow() + " of which # with mappings: " + stringArray2.length);
        Dataset dataset3 = this.createMappedDataset(probeMergeMode, stringArray2, map, dataset2);
        Dataset dataset4 = this.extractRows("mapped_" + dataset.getName(), dataset, dataset3.getRowNames());
        return new Dataset[]{dataset4, dataset3};
    }

    public final Dataset[] createMappedDatasetsS(ProbeMergeMode probeMergeMode, Map map, Dataset dataset, Dataset dataset2) {
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (dataset.getRowIndex(stringArray[i2]) == -1) continue;
            hashSet.add(stringArray[i2]);
        }
        String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        this.log.debug("For mapping: dsA: " + dataset.getNumRow() + " of which # with mappings: " + stringArray2.length);
        Dataset dataset3 = this.createMappedDatasetS(probeMergeMode, stringArray2, map, dataset2);
        Dataset dataset4 = this.extractRows("mapped_" + dataset.getName(), dataset, dataset3.getRowNames());
        return new Dataset[]{dataset4, dataset3};
    }

    public final Dataset createMappedDataset(ProbeMergeMode probeMergeMode, Map map, Dataset dataset) {
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        return this.createMappedDataset(probeMergeMode, stringArray, map, dataset);
    }

    public final Dataset createMappedDatasetS(ProbeMergeMode probeMergeMode, Map map, Dataset dataset) {
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        return this.createMappedDatasetS(probeMergeMode, stringArray, map, dataset);
    }

    public final Dataset createMappedDataset(ProbeMergeMode probeMergeMode, String[] stringArray, Map map, Dataset dataset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Vector> arrayList2 = new ArrayList<Vector>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n;
            Object v = map.get(stringArray[i2]);
            if (v == null) {
                throw new IllegalArgumentException("Bad mapping -- null value in map structure for a name: " + stringArray[i2]);
            }
            String[] stringArray2 = (String[])v;
            Vector vector = null;
            boolean bl = false;
            if (stringArray2.length > 1) {
                if (probeMergeMode == ProbeMergeMode.AVERAGE_MULTI_PROBES) {
                    n = 0;
                    vector = new Vector(dataset.getNumCol());
                    for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                        int n2 = dataset.getRowIndex(stringArray2[i3]);
                        if (n2 == -1) {
                            this.log.warn("Missing probe -- no row in datasetB for the mapped B probe: " + stringArray2[i3]);
                            continue;
                        }
                        Vector vector2 = dataset.getRow(n2);
                        vector.sum(vector2);
                        ++n;
                    }
                    if (n == 0) {
                        this.log.warn("For probe A: " + stringArray[i2] + " none of the mapped B probes " + stringArray2.length + " were found in the dataset B being mapped: " + dataset.getName());
                    } else {
                        vector.divide(n);
                        bl = true;
                    }
                } else if (probeMergeMode != ProbeMergeMode.OMIT_MULTI_PROBES) {
                    throw new RuntimeException("Unknown mappingmode: " + probeMergeMode);
                }
            } else if (stringArray2.length == 1) {
                n = dataset.getRowIndex(stringArray2[0]);
                if (n == -1) {
                    this.log.warn("B probe with a valid mapping to DatasetA was not found in DatasetB: >" + stringArray2[0] + "<");
                } else {
                    vector = dataset.getRow(n);
                    bl = true;
                }
            } else {
                throw new IllegalStateException("Bad mapping structure - no mappings at all for: " + stringArray[i2]);
            }
            if (!bl) continue;
            arrayList.add(stringArray[i2]);
            arrayList2.add(vector);
        }
        Matrix matrix = new Matrix(arrayList2.size(), dataset.getNumCol());
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            matrix.setRow(i4, (Vector)arrayList2.get(i4));
        }
        return new DefaultDataset("mapped_" + dataset.getName(), matrix, arrayList, dataset.getColumnNames(), true, true, false, null);
    }

    public final Dataset createMappedDatasetS(ProbeMergeMode probeMergeMode, String[] stringArray, Map map, Dataset dataset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Vector> arrayList2 = new ArrayList<Vector>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n;
            Object v = map.get(stringArray[i2]);
            if (v == null) {
                throw new IllegalArgumentException("Bad mapping -- null value in map structure for A name: " + stringArray[i2]);
            }
            Set set = (Set)v;
            String[] stringArray2 = set.toArray(new String[set.size()]);
            Vector vector = null;
            boolean bl = false;
            if (stringArray2.length > 1) {
                if (probeMergeMode == ProbeMergeMode.AVERAGE_MULTI_PROBES) {
                    n = 0;
                    vector = new Vector(dataset.getNumCol());
                    for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                        int n2 = dataset.getRowIndex(stringArray2[i3]);
                        if (n2 == -1) {
                            this.log.warn("Missing probe -- no row in datasetB for the mapped B probe: " + stringArray2[i3]);
                            continue;
                        }
                        Vector vector2 = dataset.getRow(n2);
                        vector.sum(vector2);
                        ++n;
                    }
                    if (n == 0) {
                        this.log.warn("For probe A: " + stringArray[i2] + " none of the mapped B probes " + stringArray2.length + " were found in the dataset B being mapped: " + dataset.getName());
                    } else {
                        vector.divide(n);
                        bl = true;
                    }
                } else if (probeMergeMode != ProbeMergeMode.OMIT_MULTI_PROBES) {
                    throw new RuntimeException("Unknown mappingmode: " + probeMergeMode);
                }
            } else if (stringArray2.length == 1) {
                n = dataset.getRowIndex(stringArray2[0]);
                if (n == -1) {
                    this.log.warn("B probe with a valid mapping to DatasetA was not found in DatasetB: >" + stringArray2[0] + "<");
                } else {
                    vector = dataset.getRow(n);
                    bl = true;
                }
            }
            if (!bl) continue;
            arrayList.add(stringArray[i2]);
            arrayList2.add(vector);
        }
        Matrix matrix = new Matrix(arrayList2.size(), dataset.getNumCol());
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            matrix.setRow(i4, (Vector)arrayList2.get(i4));
        }
        return new DefaultDataset("mapped_" + dataset.getName(), matrix, arrayList, dataset.getColumnNames(), true, true, false, null);
    }

    public final Dataset extract(Dataset dataset, State state) {
        return this.extractColumns(state.getName(), dataset, state.getSampleNames());
    }

    public final Dataset extractColumns(String string, Dataset dataset, List list) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter sampleNames cannot be null");
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (e2 == null) {
                throw new IllegalArgumentException("Null sample name at: " + i2);
            }
            int n = dataset.getColumnIndex(e2.toString());
            if (n == -1) {
                throw new RuntimeException("No such sample/column: >" + e2 + "<" + " in dataset: >" + dataset.getName() + "<" + "\nColumn names are:\n" + dataset.getColumnNames());
            }
            matrix.setColumn(i2, dataset.getColumn(n));
        }
        return new DefaultDataset(string, matrix, dataset.getRowNames(), list, true, false, false, dataset.getAnnot());
    }

    public final Dataset extractColumns(String string, Dataset dataset, TIntIntHashMap tIntIntHashMap) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        if (tIntIntHashMap == null) {
            throw new IllegalArgumentException("Parameter oldPosNewPosMap cannot be null");
        }
        Matrix matrix = new Matrix(dataset.getNumRow(), dataset.getNumCol());
        ArrayList<String> arrayList = new ArrayList<String>();
        TIntHashSet tIntHashSet = new TIntHashSet();
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            int n = tIntIntHashMap.get(i2);
            if (tIntHashSet.contains(n)) {
                throw new IllegalArgumentException("Duplicted new col position: " + n);
            }
            String string2 = dataset.getColumnName(n);
            arrayList.add(string2);
            matrix.setColumn(i2, dataset.getColumn(n));
        }
        return new DefaultDataset(string, matrix, dataset.getRowNames(), arrayList, true, false, true, dataset.getAnnot());
    }

    public final Dataset extractColumns(String string, Dataset dataset, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Parameter sampleNames cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return this.extractColumns(string, dataset, arrayList);
    }

    public final Dataset extractColumns(String string, Dataset dataset, String[] stringArray, boolean bl) {
        if (bl) {
            return this.extractColumns(string, dataset, stringArray);
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Parameter sampleNames cannot be null");
        }
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            String string2 = dataset.getColumnName(i2);
            if (list.contains(string2)) continue;
            arrayList.add(string2);
        }
        return this.extractColumns(string, dataset, arrayList);
    }

    public final Dataset extractColumns(String string, Dataset dataset, int[] nArray, boolean bl) {
        int[] nArray2 = XMath.toIndices(dataset.getNumCol(), false);
        nArray2 = XMath.toIndices(nArray2, nArray, bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            arrayList.add(dataset.getColumnName(nArray2[i2]));
        }
        return this.extractColumns(string, dataset, arrayList);
    }

    public final Dataset extract(String string, Dataset dataset, int[] nArray, int[] nArray2) {
        Dataset dataset2 = this.extractRows(string, dataset, nArray);
        return this.extractColumns(string, dataset2, nArray2, true);
    }

    public final Dataset imputeDataset(Imputer imputer, File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        Dataset dataset = new MissingValueDatasetParser().parseDataset(file.getName(), fileInputStream);
        DatasetBuilder datasetBuilder = new DatasetBuilder(file.getName() + "_imputed_" + imputer.getName(), dataset.getColumnNames());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            Vector vector = dataset.getRow(i2);
            datasetBuilder.addRow(dataset.getRowName(i2), imputer.impute(vector));
        }
        return datasetBuilder.generate(dataset.getAnnot());
    }
}

