/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.GeneSetGenerators$GeneSet_RL_IntersectionStruc;
import edu.mit.broad.genome.alg.GeneSetStats;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixPair;
import edu.mit.broad.genome.objects.GeneSetMatrixPairImpl;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedFeature;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.DatasetWrapper;
import edu.mit.broad.genome.objects.strucs.GeneSetRandomizerType;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeneSetGenerators {
    private static Logger klog = XLogger.getLogger(GeneSetGenerators.class);

    private GeneSetGenerators() {
    }

    public static final GeneSetPair createGeneSetFromMarkers(int n, Dataset dataset, Template template) {
        return new DatasetMetrics().scoreDataset(dataset, template).getNamesOfUpAndDnXRanks(n);
    }

    public static final GeneSet[] createLeaveOneOutIntersectionSets(GeneSet[] geneSetArray) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet[] geneSetArray3 = new GeneSet[geneSetArray.length - 1];
            int n = 0;
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (i2 == i3) continue;
                geneSetArray3[n++] = geneSetArray[i3];
            }
            geneSetArray2[i2] = GeneSetGenerators.createIntersectionGeneSet(geneSetArray[i2].getName(true) + "_lov", geneSetArray3);
        }
        return geneSetArray2;
    }

    public static final Dataset createIntersection_dataset(GeneSet[] geneSetArray) {
        Matrix matrix = new Matrix(geneSetArray.length, geneSetArray.length);
        String[] stringArray = new String[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            stringArray[i2] = geneSetArray[i2].getName(true);
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                matrix.setElement(i2, i3, geneSetArray[i2].getNumMembers(geneSetArray[i3]));
            }
        }
        return new DefaultDataset("inter", matrix, stringArray, stringArray, true);
    }

    public static final GeneSetGenerators$GeneSet_RL_IntersectionStruc[] createLeaveOneOutIntersectionSets(GeneSet[] geneSetArray, int n) {
        GeneSetGenerators$GeneSet_RL_IntersectionStruc[] geneSetGenerators$GeneSet_RL_IntersectionStrucArray = new GeneSetGenerators$GeneSet_RL_IntersectionStruc[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length - 1];
            int n2 = 0;
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (i2 == i3) continue;
                geneSetArray2[n2++] = geneSetArray[i3];
            }
            geneSetGenerators$GeneSet_RL_IntersectionStrucArray[i2] = GeneSetGenerators.createIntersectionGeneSet(geneSetArray[i2].getName(true) + "_lov", geneSetArray2, n);
        }
        return geneSetGenerators$GeneSet_RL_IntersectionStrucArray;
    }

    public static final GeneSet createIntersectionGeneSet(GeneSet geneSet, GeneSet geneSet2) {
        return GeneSetGenerators.createIntersectionGeneSet(geneSet.getName(true) + "_intersect_" + geneSet2.getName(true), new GeneSet[]{geneSet, geneSet2});
    }

    public static final GeneSet createIntersectionGeneSet(String string, GeneSet[] geneSetArray) {
        GeneSet geneSet = AlgUtils.unionAll(string + "tmpunion", geneSetArray);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string2 = geneSet.getMember(i2);
            boolean bl = true;
            for (int i3 = 0; i3 < geneSetArray.length; ++i3) {
                if (geneSetArray[i3].isMember(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashSet.add(string2);
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet createGeneSetInAButNotInB(GeneSet geneSet, GeneSet geneSet2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            if (geneSet2.isMember(string)) continue;
            hashSet.add(string);
        }
        return new FSet("uniq_to_" + geneSet.getName(), hashSet);
    }

    public static final GeneSetGenerators$GeneSet_RL_IntersectionStruc createIntersectionGeneSet(String string, GeneSet[] geneSetArray, int n) {
        RankedList rankedList = new GeneSetStats().getFeatureFrequency_rl(geneSetArray, Order.DESCENDING);
        return new GeneSetGenerators$GeneSet_RL_IntersectionStruc(string, n, rankedList);
    }

    public static final GeneSetMatrixPair createGeneSets(Dataset dataset, int n, int n2, Order order) {
        if (XMath.isNegative(n)) {
            throw new IllegalArgumentException("Cant do for negative topX: " + n);
        }
        if (XMath.isNegative(n2)) {
            throw new IllegalArgumentException("Cant do for negative botX: " + n);
        }
        GeneSet[] geneSetArray = new GeneSet[dataset.getNumCol()];
        GeneSet[] geneSetArray2 = new GeneSet[dataset.getNumCol()];
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            LabelledVector labelledVector = dataset.getColumnLV(i2);
            RankedList rankedList = labelledVector.sort(SortMode.REAL, order);
            geneSetArray[i2] = rankedList.getNamesOfUpOrDnXRanks_gs(n, true);
            geneSetArray2[i2] = rankedList.getNamesOfUpOrDnXRanks_gs(n2, false);
            if (i2 % 25 != 0) continue;
            klog.info("Done column " + (i2 + 1) + " / " + dataset.getNumCol());
        }
        return new GeneSetMatrixPairImpl(new DefaultGeneSetMatrix("up_" + dataset.getName(), geneSetArray), new DefaultGeneSetMatrix("dn_" + dataset.getName(), geneSetArray2));
    }

    public static final GeneSet[] createGeneSets(RankedList[] rankedListArray, int n, boolean bl) {
        GeneSet[] geneSetArray = new GeneSet[rankedListArray.length];
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            geneSetArray[i2] = rankedListArray[i2].getNamesOfUpOrDnXRanks_gs(n, bl);
        }
        return geneSetArray;
    }

    public static final GeneSetMatrixPair createGeneSets(Dataset dataset, float f2, float f3) {
        klog.debug("createGeneSets valueCutoffUp: " + f2 + " valueCutoffDn: " + f3);
        GeneSet[] geneSetArray = new GeneSet[dataset.getNumCol()];
        GeneSet[] geneSetArray2 = new GeneSet[dataset.getNumCol()];
        for (int i2 = 0; i2 < dataset.getNumCol(); ++i2) {
            LabelledVector labelledVector = dataset.getColumnLV(i2);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i3 = 0; i3 < labelledVector.getSize(); ++i3) {
                float f4 = labelledVector.getScore(i3);
                if (f4 >= f2) {
                    arrayList.add(labelledVector.getLabel(i3));
                    continue;
                }
                if (!(f4 <= f3)) continue;
                arrayList2.add(labelledVector.getLabel(i3));
            }
            geneSetArray[i2] = new FSet(dataset.getColumnName(i2) + " _up_" + arrayList.size(), arrayList, false);
            geneSetArray2[i2] = new FSet(dataset.getColumnName(i2) + " _dn_" + arrayList2.size(), arrayList2, false);
            if (i2 % 25 != 0) continue;
            klog.info("Done column " + (i2 + 1) + " / " + dataset.getNumCol());
        }
        klog.debug("createGeneSets upSets: " + geneSetArray.length + " dnSets: " + geneSetArray2.length);
        return new GeneSetMatrixPairImpl(new DefaultGeneSetMatrix("up_" + dataset.getName(), geneSetArray), new DefaultGeneSetMatrix("dn_" + dataset.getName(), geneSetArray2));
    }

    public static final GeneSet createIntersectionSpace(String string, Dataset[] datasetArray) {
        GeneSet[] geneSetArray = new GeneSet[datasetArray.length];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            geneSetArray[i2] = datasetArray[i2].getRowNamesGeneSet();
        }
        return GeneSetGenerators.createIntersectionGeneSet(string, geneSetArray);
    }

    public static final GeneSet createIntersectionSpace(String string, DatasetWrapper[] datasetWrapperArray, boolean bl) {
        GeneSet geneSet = null;
        for (int i2 = 0; i2 < datasetWrapperArray.length; ++i2) {
            System.out.println("\n\n----------> PROCESSING FILES: " + datasetWrapperArray[i2].getFile());
            Dataset dataset = datasetWrapperArray[i2].getDataset(bl);
            GeneSet geneSet2 = dataset.getRowNamesGeneSet();
            geneSet = geneSet == null ? geneSet2 : AlgUtils.intersect("foo", geneSet, geneSet2);
        }
        if (geneSet != null) {
            return geneSet.cloneShallow(string);
        }
        throw new IllegalArgumentException("Empty DatasetWrapper: " + datasetWrapperArray.length);
    }

    public static final GeneSet removeIntersection(GeneSet geneSet, GeneSet geneSet2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            if (geneSet2.isMember(geneSet.getMember(i2))) continue;
            arrayList.add(geneSet.getMember(i2));
        }
        return new FSet(geneSet.getName(true) + "_minus_" + geneSet2.getName(true), arrayList, false);
    }

    public static final GeneSet[] removeAffxProbes(GeneSet[] geneSetArray) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray2[i2] = GeneSetGenerators.removeAffxProbes(geneSetArray[i2]);
        }
        return geneSetArray2;
    }

    public static final GeneSet removeAffxProbes(GeneSet geneSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            if (string.startsWith("AFFX")) continue;
            hashSet.add(string);
        }
        return new FSet(geneSet.getName(), hashSet);
    }

    public static final GeneSet[] createByRestrictingProbesPerGene(GeneSet[] geneSetArray, Chip chip, int n) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray2[i2] = geneSetArray[i2].cloneShallow();
            geneSetArray2[i2] = GeneSetGenerators.createByRestrictingProbesPerGene(geneSetArray2[i2], chip, n);
        }
        return geneSetArray2;
    }

    public static final GeneSet createByRestrictingProbesPerGene(GeneSet geneSet, Chip chip, int n) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Param gset cannot be null");
        }
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        HashSet<String> hashSet = new HashSet<String>();
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            Gene gene = chip.getHugo(string);
            if (gene == null) {
                hashSet.add(geneSet.getMember(i2));
                continue;
            }
            String string2 = gene.getSymbol();
            if (string2 != null) {
                int n2 = tObjectIntHashMap.get(string2);
                if (++n2 > n) continue;
                hashSet.add(geneSet.getMember(i2));
                tObjectIntHashMap.put(string2, n2);
                continue;
            }
            hashSet.add(geneSet.getMember(i2));
        }
        return new FSet(geneSet.getName(), hashSet);
    }

    public static final GeneSet subtractGeneSet(GeneSet geneSet, GeneSet geneSet2) {
        HashSet hashSet = new HashSet(geneSet.getMembersS());
        for (int i2 = 0; i2 < geneSet2.getNumMembers(); ++i2) {
            hashSet.remove(geneSet2.getMember(i2));
        }
        return new FSet(geneSet.getName() + "_minus" + geneSet2.getName(), hashSet);
    }

    public static final GeneSet subtractGeneSet(GeneSet geneSet, Set set) {
        HashSet hashSet = new HashSet(geneSet.getMembersS());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            hashSet.remove(string);
        }
        return new FSet(geneSet.getName() + "_minus" + set.size(), hashSet);
    }

    public static final GeneSet[] createLovGeneSet(int n, GeneSet[] geneSetArray) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (i2 == n) continue;
            geneSetArray2[n2++] = geneSetArray[i2];
        }
        return geneSetArray2;
    }

    public static final GeneSetMatrix restrictMatrix(GeneSet geneSet, GeneSetMatrix geneSetMatrix) {
        GeneSet[] geneSetArray = new GeneSet[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            GeneSet geneSet2 = geneSetMatrix.getGeneSet(i2);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i3 = 0; i3 < geneSet2.getNumMembers(); ++i3) {
                if (!geneSet.isMember(geneSet2.getMember(i3))) continue;
                hashSet.add(geneSet2.getMember(i3));
            }
            geneSetArray[i2] = new FSet(geneSet2.getName(), hashSet);
        }
        return new DefaultGeneSetMatrix(geneSetMatrix.getName() + "_red_" + geneSet.getName(), geneSetArray);
    }

    public static final GeneSetMatrix restrictMatrix(int n, GeneSetMatrix geneSetMatrix) {
        GeneSetStats geneSetStats = new GeneSetStats();
        LabelledVector labelledVector = geneSetStats.getFeatureFrequency_lv(geneSetMatrix);
        GeneSet[] geneSetArray = new GeneSet[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            GeneSet geneSet = geneSetMatrix.getGeneSet(i2);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i3 = 0; i3 < geneSet.getNumMembers(); ++i3) {
                String string = geneSet.getMember(i3);
                int n2 = (int)labelledVector.getScore(string);
                if (n2 < n) continue;
                hashSet.add(string);
            }
            geneSetArray[i2] = new FSet(geneSet.getName(), hashSet);
        }
        return new DefaultGeneSetMatrix(geneSetMatrix.getName() + "_red_" + n, geneSetArray);
    }

    public static final GeneSet[] restrictGeneSets2MaxSize(int n, GeneSet[] geneSetArray, Dataset dataset, boolean bl) {
        return GeneSetGenerators.restrictGeneSets2MaxSize(n, geneSetArray, dataset.getRowNames(), bl);
    }

    public static final GeneSet[] restrictGeneSets2MaxSize(int n, GeneSet[] geneSetArray, List list, boolean bl) {
        ArrayList<FSet> arrayList = new ArrayList<FSet>();
        klog.info("restricting genesets to size: " + n);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2].getNumMembers(list) >= n) {
                FSet fSet = new FSet(geneSetArray[i2].getName() + "_" + n, geneSetArray[i2].getNameEnglish(), geneSetArray[i2].getMembers().subList(0, n), false);
                arrayList.add(fSet);
            }
            if (i2 % 100 != 0) continue;
            System.out.println("restricted: " + i2 + " / " + geneSetArray.length);
        }
        klog.info("input #: " + geneSetArray.length + " after restriction: " + arrayList.size());
        if (bl && geneSetArray.length == 0) {
            throw new IllegalArgumentException("After size restriction, 0 gene sets passed! Size: " + n);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] restrictGeneSets2MaxSize(int n, GeneSet[] geneSetArray, boolean bl) {
        ArrayList<FSet> arrayList = new ArrayList<FSet>();
        klog.info("restricting genesets to size: " + n);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2].getNumMembers() >= n) {
                FSet fSet = new FSet(geneSetArray[i2].getName() + "_" + n, geneSetArray[i2].getNameEnglish(), geneSetArray[i2].getMembers().subList(0, n), false);
                arrayList.add(fSet);
            }
            if (i2 % 100 != 0) continue;
            System.out.println("restricted: " + i2 + " / " + geneSetArray.length);
        }
        klog.info("input #: " + geneSetArray.length + " after restriction: " + arrayList.size());
        if (bl && geneSetArray.length == 0) {
            throw new IllegalArgumentException("After size restriction, 0 gene sets passed! Size: " + n);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet createProbeNameGeneSet(String string, Probe[] probeArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < probeArray.length; ++i2) {
            hashSet.add(probeArray[i2].getName());
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet createGeneSet(int n, int n2, boolean bl, GeneSet geneSet) {
        return new FSet(geneSet.getName() + "_" + n + "_to_" + n2, geneSet.getNameEnglish(), geneSet.getMembers().subList(n, n2), bl);
    }

    public static final GeneSet createGeneSet(GeneSetMatrix geneSetMatrix) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            hashSet.addAll(geneSetMatrix.getGeneSet(i2).getMembersS());
        }
        return new FSet(geneSetMatrix.getName() + "_setized", hashSet);
    }

    public static final GeneSet[] createGeneSets(String[] stringArray) {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = ParseUtils.string2strings(stringArray[i2], "\t", true);
            if (stringArray2 != null && stringArray2.length == 2) {
                Object object = hashMap.get(stringArray2[0]);
                if (object == null) {
                    object = new HashSet();
                }
                ((Set)object).add(stringArray2[1]);
                hashMap.put(stringArray2[0], object);
                continue;
            }
            klog.warn("Ignoring row: " + i2 + ">" + stringArray[i2]);
        }
        return GeneSetGenerators.createGeneSets(hashMap);
    }

    public static final GeneSet[] createGeneSets(Map map) {
        GeneSet[] geneSetArray = new GeneSet[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            Set set = (Set)map.get(k2);
            geneSetArray[n++] = new FSet(k2.toString(), set);
        }
        return geneSetArray;
    }

    public static final GeneSet[] createGeneSets_by_hashing_values(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = map.get(string).toString();
            Object object = hashMap.get(string2);
            if (object == null) {
                object = new HashSet();
            }
            ((Set)object).add(string);
            hashMap.put(string2, object);
        }
        return GeneSetGenerators.createGeneSets(hashMap);
    }

    public static final GeneSet[] createRandomGeneSetsFixedSize(int n, RankedList rankedList, GeneSet geneSet, RandomSeedGenerator randomSeedGenerator) {
        String string = NamingConventions.removeExtension(geneSet);
        int n2 = geneSet.getNumMembers(rankedList);
        GeneSet[] geneSetArray = new GeneSet[n];
        for (int i2 = 0; i2 < n; ++i2) {
            int[] nArray = XMath.randomlySampleWithoutReplacement(n2, rankedList.getSize(), randomSeedGenerator);
            if (nArray.length != n2) {
                throw new IllegalStateException("random indices generated: " + nArray.length + " not equal to # members: " + n2);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i3 = 0; i3 < n2; ++i3) {
                hashSet.add(rankedList.getRankName(nArray[i3]));
            }
            if (hashSet.size() != n2) {
                klog.warn("Bad randomization -- repeated rnd members were made members: " + hashSet.size() + " but wanted: " + n2);
            }
            geneSetArray[i2] = new FSet(string + "_" + i2, hashSet);
        }
        return geneSetArray;
    }

    public static final GeneSet[] createRandomGeneSets(int n, Dataset dataset, GeneSet geneSet, RandomSeedGenerator randomSeedGenerator) {
        int n2 = geneSet.getNumMembers(dataset);
        return GeneSetGenerators.createRandomGeneSets(n, dataset, n2, randomSeedGenerator);
    }

    public static final GeneSet[] createRandomGeneSets(int n, Dataset dataset, int n2, RandomSeedGenerator randomSeedGenerator) {
        GeneSet[] geneSetArray = new GeneSet[n];
        for (int i2 = 0; i2 < n; ++i2) {
            int[] nArray = XMath.randomlySampleWithoutReplacement(n2, dataset.getNumRow(), randomSeedGenerator);
            if (nArray.length != n2) {
                throw new IllegalStateException("random indices generated: " + nArray.length + " not equal to # members: " + n2);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i3 = 0; i3 < n2; ++i3) {
                hashSet.add(dataset.getRowName(nArray[i3]));
            }
            if (hashSet.size() != n2) {
                klog.warn("Bad randomization -- repeated rnd members were made members: " + hashSet.size() + " but wanted: " + n2);
            }
            geneSetArray[i2] = new FSet(dataset.getName() + "_" + i2, hashSet);
        }
        return geneSetArray;
    }

    public static final GeneSet[] createRandomGeneSets(int n, Dataset dataset, GeneSet geneSet, int n2, RandomSeedGenerator randomSeedGenerator, GeneSetRandomizerType geneSetRandomizerType) {
        if (geneSetRandomizerType == GeneSetRandomizerType.RANDOM_TAGS_FIXED_SIZE) {
            return GeneSetGenerators.createRandomGeneSets(n, dataset, geneSet, randomSeedGenerator);
        }
        if (geneSetRandomizerType == GeneSetRandomizerType.RANDOM_TAGS_RANDOM_SIZE) {
            return GeneSetGenerators.createRandomGeneSetsWithRandomSizesUptoSize(n, dataset, n2, geneSet, randomSeedGenerator);
        }
        throw new IllegalArgumentException("Unknown RandomizerType: " + geneSetRandomizerType);
    }

    public static final GeneSet[] createRandomGeneSets(int n, int n2, GeneSet geneSet, RandomSeedGenerator randomSeedGenerator) {
        String string = NamingConventions.removeExtension(geneSet);
        int n3 = geneSet.getNumMembers();
        GeneSet[] geneSetArray = new GeneSet[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] nArray = XMath.randomlySampleWithoutReplacement(n, geneSet.getNumMembers(), randomSeedGenerator);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                hashSet.add(geneSet.getMember(nArray[i3]));
            }
            if (hashSet.size() != nArray.length) {
                klog.warn("Bad randomization -- repeated rnd members were made members: " + hashSet.size() + " but wanted: " + n3);
            }
            geneSetArray[i2] = new FSet(string + "_" + i2, hashSet);
        }
        return geneSetArray;
    }

    public static final GeneSet[] createRandomGeneSetsWithRandomSizesUptoSize(int n, Dataset dataset, int n2, GeneSet geneSet, RandomSeedGenerator randomSeedGenerator) {
        String string = NamingConventions.removeExtension(geneSet);
        int n3 = geneSet.getNumMembers(dataset);
        return GeneSetGenerators.createRandomGeneSetsWithRandomSizesUptoSize(string, n, dataset, n2, n3, randomSeedGenerator);
    }

    public static final GeneSet[] createRandomGeneSetsWithRandomSizesUptoSize(String string, int n, Dataset dataset, int n2, int n3, RandomSeedGenerator randomSeedGenerator) {
        return GeneSetGenerators.createRandomGeneSetsWithRandomSizesUptoSize(string, n, dataset.getRowNames(), n2, n3, randomSeedGenerator);
    }

    public static final GeneSet[] createRandomGeneSetsWithRandomSizesUptoSize(String string, int n, GeneSet geneSet, int n2, int n3, RandomSeedGenerator randomSeedGenerator) {
        return GeneSetGenerators.createRandomGeneSetsWithRandomSizesUptoSize(string, n, geneSet.getMembers(), n2, n3, randomSeedGenerator);
    }

    public static final GeneSet[] createRandomGeneSetsWithRandomSizesUptoSize(String string, int n, List list, int n2, int n3, RandomSeedGenerator randomSeedGenerator) {
        GeneSet[] geneSetArray = new GeneSet[n];
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = randomSeedGenerator.getRandom().nextInt(n3)) == 0 || n5 < n2) {
                continue;
            }
            int[] nArray = XMath.randomlySampleWithoutReplacement(n5, list.size(), randomSeedGenerator);
            if (nArray.length != n5) {
                throw new IllegalStateException("random indices generated: " + nArray.length + " not equal to # members: " + n3);
            }
            HashSet hashSet = new HashSet(n5);
            for (int i2 = 0; i2 < n5; ++i2) {
                hashSet.add(list.get(nArray[i2]));
            }
            geneSetArray[n4] = new FSet(string + "_" + n4 + "_" + n5, hashSet);
            if (++n4 >= n) break;
        }
        return geneSetArray;
    }

    public static final GeneSet createRandomGeneSet(String string, int n, Dataset dataset, RandomSeedGenerator randomSeedGenerator) {
        int[] nArray = XMath.randomlySampleWithoutReplacement(n, dataset.getNumRow(), randomSeedGenerator);
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            hashSet.add(dataset.getRowName(nArray[i2]));
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet createRandomGeneSet(String string, int n, Dataset dataset, Random random) {
        int[] nArray = XMath.randomlySampleWithoutReplacement(n, dataset.getNumRow(), random);
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            hashSet.add(dataset.getRowName(nArray[i2]));
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet createRandomGeneSet(String string, int n, Dataset dataset) {
        int[] nArray = XMath.randomlySampleWithoutReplacement(n, dataset.getNumRow(), new Random());
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            hashSet.add(dataset.getRowName(nArray[i2]));
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet createRandomGeneSet(String string, int n, GeneSet geneSet, RandomSeedGenerator randomSeedGenerator) {
        int[] nArray = XMath.randomlySampleWithoutReplacement(n, geneSet.getNumMembers(), randomSeedGenerator);
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            hashSet.add(geneSet.getMember(nArray[i2]));
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet[] createRandomGeneSets(String string, int n, Dataset dataset, int n2, RandomSeedGenerator randomSeedGenerator) {
        GeneSet[] geneSetArray = new GeneSet[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            geneSetArray[i2] = GeneSetGenerators.createRandomGeneSet(string, n, dataset, randomSeedGenerator);
        }
        return geneSetArray;
    }

    public static final GeneSet[] createPans(int n, int n2, int n3, GeneSet geneSet) {
        if (n2 > geneSet.getNumMembers()) {
            throw new IllegalArgumentException("stop rank: " + n2 + " cannot be > that gset size: " + geneSet.getNumMembers());
        }
        Range[] rangeArray = RangeFactory.createPans(n, n2, n3, true);
        return GeneSetGenerators._createGeneSets(rangeArray, geneSet);
    }

    public static final GeneSet[] createPans(int n, GeneSet geneSet) {
        return GeneSetGenerators.createPans(0, geneSet.getNumMembers(), n, geneSet);
    }

    public static final GeneSet[] createPans(int n, int n2, int n3, ScoredDataset scoredDataset) {
        FSet fSet = new FSet(scoredDataset.getName(), null, scoredDataset.getRankedNames(), false);
        return GeneSetGenerators.createPans(n, n2, n3, fSet);
    }

    public static final GeneSet[] createPans(int n, ScoredDataset scoredDataset) {
        FSet fSet = new FSet(scoredDataset.getName(), null, scoredDataset.getRankedNames(), false);
        return GeneSetGenerators.createPans(0, scoredDataset.getNumRow(), n, fSet);
    }

    public static final GeneSet[] createWindows(int n, int n2, int n3, int n4, GeneSet geneSet) {
        Range[] rangeArray = RangeFactory.createWindows(n, n2, n3, n4);
        return GeneSetGenerators._createGeneSets(rangeArray, geneSet);
    }

    private static GeneSet[] _createGeneSets(Range[] rangeArray, GeneSet geneSet) {
        ArrayList<FSet> arrayList = new ArrayList<FSet>(rangeArray.length);
        List list = geneSet.getMembers();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            List list2 = list.subList((int)rangeArray[i2].getMin(), (int)rangeArray[i2].getMax());
            arrayList.add(new FSet(geneSet.getName() + "_" + rangeArray[i2].getMin() + "_" + rangeArray[i2].getMax(), geneSet.getNameEnglish(), list2, false));
        }
        return arrayList.toArray(new FSet[arrayList.size()]);
    }

    public static final GeneSet[] createWindows(int n, int n2, GeneSet geneSet) {
        return GeneSetGenerators.createWindows(0, geneSet.getNumMembers(), n, n2, geneSet);
    }

    public static final GeneSet[] createWindows(int n, int n2, int n3, int n4, ScoredDataset scoredDataset) {
        FSet fSet = new FSet(scoredDataset.getName(), null, scoredDataset.getRankedNames(), false);
        return GeneSetGenerators.createWindows(n, n2, n3, n4, fSet);
    }

    public static final List createWindowsL(int n, int n2, int n3, int n4, ScoredDataset scoredDataset) {
        GeneSet[] geneSetArray = GeneSetGenerators.createWindows(n, n2, n3, n4, scoredDataset);
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>(geneSetArray.length);
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            arrayList.add(geneSetArray[i2]);
        }
        return arrayList;
    }

    public static final GeneSet createGeneSet(String string, RankedFeature[] rankedFeatureArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < rankedFeatureArray.length; ++i2) {
            hashSet.add(rankedFeatureArray[i2].getName());
        }
        return new FSet(string, hashSet);
    }

    public static final GeneSet[] qualifyGeneSets(GeneSet[] geneSetArray, Dataset dataset, boolean bl) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray2[i2] = geneSetArray[i2].cloneDeep(dataset);
            if (bl) {
                geneSetArray2[i2] = geneSetArray2[i2].cloneShallow(AuxUtils.getAuxNameOnlyNoHash(geneSetArray2[i2].getName()));
            }
            if (i2 == 0 || i2 % 100 != 0) continue;
            System.out.println("qualfied gset: " + geneSetArray[i2].getName() + " " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return geneSetArray2;
    }

    public static final GeneSet[] qualifyGeneSets2(GeneSet[] geneSetArray, Dataset dataset, boolean bl) {
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            geneSetArray2[i2] = geneSetArray[i2].cloneDeep(dataset);
            if (bl) {
                geneSetArray2[i2] = geneSetArray2[i2].cloneShallow(AuxUtils.getAuxNameOnlyNoHash(geneSetArray2[i2].getName()) + "_" + geneSetArray2[i2].getNumMembers());
            }
            if (i2 == 0 || i2 % 100 != 0) continue;
            System.out.println("qualfied gset: " + geneSetArray[i2].getName() + " " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return geneSetArray2;
    }

    public static final GeneSet[] removeGeneSetsSmallerThan(GeneSet[] geneSetArray, int n) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2].getNumMembers() < n) continue;
            arrayList.add(geneSetArray[i2]);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsSmallerThan(GeneSet[] geneSetArray, int n, Object object, boolean bl) {
        if (object instanceof Dataset) {
            return GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, n, (Dataset)object, bl);
        }
        return GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, n, (RankedList)object, bl);
    }

    public static final GeneSet[] removeGeneSetsSmallerThan(GeneSet[] geneSetArray, int n, RankedList rankedList, boolean bl) {
        GeneSet[] geneSetArray2 = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, n);
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray2.length; ++i2) {
            GeneSet geneSet = bl ? geneSetArray2[i2].cloneDeep(rankedList) : geneSetArray2[i2];
            int n2 = geneSet.getNumMembers();
            if (n2 >= n) {
                arrayList.add(geneSet);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsSmallerThan: " + n + " for: " + (i2 + 1) + " / " + geneSetArray2.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsSmallerThan(GeneSet[] geneSetArray, int n, Dataset dataset, boolean bl) {
        GeneSet[] geneSetArray2 = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, n);
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray2.length; ++i2) {
            GeneSet geneSet = bl ? geneSetArray2[i2].cloneDeep(dataset) : geneSetArray2[i2];
            int n2 = geneSet.getNumMembers();
            if (n2 >= n) {
                arrayList.add(geneSet);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsSmallerThan: " + n + " for: " + (i2 + 1) + " / " + geneSetArray2.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsLargerThan(GeneSet[] geneSetArray, int n, Object object, boolean bl) {
        if (object instanceof Dataset) {
            return GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, n, (Dataset)object, bl);
        }
        return GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, n, (RankedList)object, bl);
    }

    public static final GeneSet[] removeGeneSetsLargerThan(GeneSet[] geneSetArray, int n, RankedList rankedList, boolean bl) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet geneSet = bl ? geneSetArray[i2].cloneDeep(rankedList) : geneSetArray[i2];
            int n2 = AlgUtils.getNumOfMembers(rankedList, geneSet);
            if (n2 <= n) {
                arrayList.add(geneSet);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsLargerThan " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsLargerThan(GeneSet[] geneSetArray, int n, Dataset dataset, boolean bl) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet geneSet = bl ? geneSetArray[i2].cloneDeep(dataset) : geneSetArray[i2];
            int n2 = AlgUtils.getNumOfMembers(dataset, geneSet);
            if (n2 <= n) {
                arrayList.add(geneSet);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsLargerThan " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsBySize(GeneSetMatrix geneSetMatrix, int n, int n2, Dataset dataset) {
        return GeneSetGenerators.removeGeneSetsBySize(geneSetMatrix.getGeneSets(), n, n2, dataset);
    }

    public static final GeneSet[] removeGeneSetsBySize(GeneSet[] geneSetArray, int n, int n2, Dataset dataset) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            GeneSet geneSet = geneSetArray[i2].cloneDeep(dataset);
            int n3 = geneSet.getNumMembers();
            if (n3 >= n && n3 <= n2) {
                arrayList.add(geneSet);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsBySize " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsBySize(GeneSet[] geneSetArray, int n, int n2) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            int n3 = geneSetArray[i2].getNumMembers();
            if (n3 >= n && n3 <= n2) {
                arrayList.add(geneSetArray[i2]);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsBySize " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSetMatrix removeGeneSetsBySize(GeneSetMatrix geneSetMatrix, int n, int n2) {
        return new DefaultGeneSetMatrix(geneSetMatrix.getName() + "_" + n + "_" + n2, GeneSetGenerators.removeGeneSetsBySize(geneSetMatrix.getGeneSets(), n, n2));
    }

    public static final GeneSet[] removeGeneSetsBySize(GeneSet[] geneSetArray, int n, int n2, Set set) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            int n3 = AlgUtils.getNumOfMembers(set, geneSetArray[i2]);
            if (n3 >= n && n3 <= n2) {
                arrayList.add(geneSetArray[i2]);
            }
            if (i2 == 0 || i2 % 500 != 0) continue;
            System.out.println("Done removeGeneSetsBySize " + (i2 + 1) + " / " + geneSetArray.length);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] removeGeneSetsLargerThan(GeneSet[] geneSetArray, int n) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2].getNumMembers() > n) continue;
            arrayList.add(geneSetArray[i2]);
        }
        return arrayList.toArray(new FSet[arrayList.size()]);
    }
}

