/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.cluster;

import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.HClustDataset;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.gsea.HCLViewer;
import xtools.api.param.ClusterAxisParam;
import xtools.api.param.ClusterDistanceParam;
import xtools.api.param.LinkageParam;

public class ClusteringAlgs {
    private ClusteringAlgs() {
    }

    public static final HClustDataset cluster(Dataset dataset) {
        IExpressionData iExpressionData = GPWrappers.createIExpressionData(dataset);
        int n = -1;
        boolean bl = true;
        int n2 = 2;
        return ClusteringAlgs.toHCD(iExpressionData, dataset.getAnnot(), -1, 1, 2);
    }

    public static final HClustDataset cluster_cols(Dataset dataset) {
        IExpressionData iExpressionData = GPWrappers.createIExpressionData(dataset);
        int n = -1;
        boolean bl = true;
        boolean bl2 = true;
        return ClusteringAlgs.toHCD(iExpressionData, dataset.getAnnot(), -1, 1, 1);
    }

    public static final HClustDataset cluster(Dataset dataset, LinkageParam linkageParam, ClusterDistanceParam clusterDistanceParam, ClusterAxisParam clusterAxisParam) {
        int n = linkageParam.getModeIndex();
        int n2 = clusterDistanceParam.getModeIndex();
        int n3 = clusterAxisParam.getModeIndex();
        return ClusteringAlgs.cluster(dataset, n, n2, n3);
    }

    public static final HClustDataset cluster(Dataset dataset, int n, int n2, int n3) {
        if (dataset == null) {
            throw new IllegalArgumentException("Param dataset cannot be null");
        }
        if (dataset.getNumRow() == 0) {
            throw new IllegalArgumentException("Cannot cluster a dataset with 0 rows: " + dataset.getQuickInfo());
        }
        if (dataset.getNumCol() == 0) {
            throw new IllegalArgumentException("Cannot cluster a dataset with 0 columns: " + dataset.getQuickInfo());
        }
        IExpressionData iExpressionData = GPWrappers.createIExpressionData(dataset);
        return ClusteringAlgs.toHCD(iExpressionData, dataset.getAnnot(), n, n2, n3);
    }

    public static final HClustDataset cluster(GeneSetMatrix geneSetMatrix) {
        Dataset dataset = new BitSetDataset(geneSetMatrix).toDataset(true, false);
        return ClusteringAlgs.cluster(dataset);
    }

    private static HClustDataset toHCD(IExpressionData iExpressionData, Annot annot, int n, int n2, int n3) {
        HCLViewer hCLViewer = new HCLViewer(iExpressionData, n, n2, n3);
        IExpressionData iExpressionData2 = hCLViewer.getReorderedData();
        Dataset dataset = GPWrappers.createDataset(iExpressionData2, annot);
        return new HClustDataset(dataset, hCLViewer.getArrayTreePanel(), hCLViewer.getGeneTreePanel());
    }
}

