/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$AbstractScoringTable;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;

public class GeneSetScoringTables$WeightedDoubleSided
extends GeneSetScoringTables$AbstractScoringTable {
    private static final String NAME = "weighted_double_sided";
    float totalPosWeight_of_hits;
    float totalNegWeight_of_hits;
    float numPosScores;
    float numNegScores;
    float nhExpected;
    float nhPosActual;
    float nhNegActual;
    float nhPos_by_nh;
    float nhNeg_by_nh;
    float miss_pos_score;
    float miss_neg_score;
    private GeneSet gset;
    private RankedList rankedList;

    public GeneSetScoringTables$WeightedDoubleSided() {
    }

    GeneSetScoringTables$WeightedDoubleSided(GeneSet geneSet, RankedList rankedList) {
        int n;
        this.gset = geneSet;
        this.rankedList = rankedList;
        this.nhExpected = geneSet.getNumMembers();
        if (this.nhExpected == 0.0f) {
            throw new IllegalArgumentException("Numberof members in gene set cannot be 0: " + geneSet.getName());
        }
        for (n = 0; n < this.gset.getNumMembers(); ++n) {
            float f2 = rankedList.getScore(this.gset.getMember(n));
            if (XMath.isPositive(f2)) {
                this.totalPosWeight_of_hits += f2;
                this.nhPosActual += 1.0f;
                continue;
            }
            this.totalNegWeight_of_hits += f2;
            this.nhNegActual += 1.0f;
        }
        for (n = 0; n < rankedList.getSize(); ++n) {
            if (XMath.isPositive(rankedList.getScore(n))) {
                this.numPosScores += 1.0f;
                continue;
            }
            this.numNegScores += 1.0f;
        }
        this.nhPos_by_nh = this.nhPosActual / this.nhExpected;
        this.nhNeg_by_nh = this.nhNegActual / this.nhExpected;
        this.miss_pos_score = this.nhPos_by_nh * (1.0f / (this.numPosScores - this.nhPosActual));
        this.miss_neg_score = this.nhNeg_by_nh * (1.0f / (this.numNegScores - this.nhNegActual));
    }

    @Override
    public final GeneSetScoringTable createTable(GeneSet geneSet, RankedList rankedList, RankedList rankedList2) {
        return new GeneSetScoringTables$WeightedDoubleSided(geneSet, rankedList);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    public final boolean isTwoSidedEs() {
        return false;
    }

    @Override
    public final RankedList getRankedList() {
        return this.rankedList;
    }

    @Override
    public final float getHitScore(String string) {
        float f2 = this.rankedList.getScore(string);
        if (XMath.isPositive(f2)) {
            float f3 = f2 / this.totalPosWeight_of_hits;
            return f3 * this.nhPos_by_nh;
        }
        float f4 = f2 / this.totalNegWeight_of_hits;
        return f4 * this.nhNeg_by_nh;
    }

    @Override
    public final float getMissScore(String string) {
        float f2 = this.rankedList.getScore(string);
        if (XMath.isPositive(f2)) {
            return this.miss_pos_score;
        }
        return this.miss_neg_score;
    }
}

