/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables;
import edu.mit.broad.genome.alg.gsea.GeneSetScoringTables$AbstractScoringTable;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;

public class GeneSetScoringTables$WeightedDoubleSidedAs1
extends GeneSetScoringTables$AbstractScoringTable {
    private static final String NAME = "weighted_as_1";
    private float totalPosWeight_of_hits;
    private float totalNegWeight_of_hits;
    private float numPosScores;
    private float numNegScores;
    private float nhExpected;
    private float nhPosActual;
    private float nhNegActual;
    private float nhPos_by_nh;
    private float nhNeg_by_nh;
    private float miss_pos_score;
    private float miss_neg_score;
    private int maxPosRealRank;
    private GeneSet gset;
    private RankedList rankedList;
    static int cnt = 0;

    public final void setReal(RankedList rankedList) {
        this.rankedList = rankedList;
    }

    public GeneSetScoringTables$WeightedDoubleSidedAs1() {
    }

    public GeneSetScoringTables$WeightedDoubleSidedAs1(GeneSet geneSet, RankedList rankedList, RankedList rankedList2) {
        int n;
        this.gset = geneSet;
        this.rankedList = rankedList;
        this.nhExpected = geneSet.getNumMembers();
        if (this.nhExpected == 0.0f) {
            throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + geneSet.getName());
        }
        if (rankedList2 == null) {
            GeneSetScoringTables.access$200().warn("Null real_rl so assuming real: " + rankedList.getName());
            this.maxPosRealRank = rankedList.getMetricWeightStruc().getTotalPosLength();
        } else {
            this.maxPosRealRank = rankedList2.getMetricWeightStruc().getTotalPosLength();
        }
        for (n = 0; n < this.gset.getNumMembers(); ++n) {
            String string = this.gset.getMember(n);
            float f2 = rankedList.getScore(string);
            int n2 = rankedList.getRank(string);
            if (XMath.isPositive(f2)) {
                if (n2 <= this.maxPosRealRank) {
                    this.totalPosWeight_of_hits += f2;
                    this.nhPosActual += 1.0f;
                    continue;
                }
                this.totalNegWeight_of_hits += 0.0f;
                this.nhNegActual += 1.0f;
                continue;
            }
            if (n2 <= this.maxPosRealRank) {
                this.totalPosWeight_of_hits += 0.0f;
                this.nhPosActual += 1.0f;
                continue;
            }
            this.totalNegWeight_of_hits += f2;
            this.nhNegActual += 1.0f;
        }
        for (n = 0; n < rankedList.getSize(); ++n) {
            float f3 = rankedList.getScore(n);
            if (XMath.isPositive(f3) && n <= this.maxPosRealRank) {
                this.numPosScores += 1.0f;
                continue;
            }
            this.numNegScores += 1.0f;
        }
        if (this.nhPosActual + this.nhNegActual != this.nhExpected) {
            throw new IllegalArgumentException("nhPosActual: " + this.nhPosActual + " nhNegActual: " + this.nhNegActual + " nhExpected: " + this.nhExpected);
        }
        this.nhPos_by_nh = 1.0f;
        this.nhNeg_by_nh = 1.0f;
        this.miss_pos_score = this.nhPos_by_nh * (1.0f / (this.numPosScores - this.nhPosActual));
        this.miss_neg_score = this.nhNeg_by_nh * (1.0f / (this.numNegScores - this.nhNegActual));
        if (cnt % 250 == 0) {
            System.out.println("xover: " + this.maxPosRealRank + " nhPos_by_nh: " + this.nhPos_by_nh + " nhNeg_by_nh: " + this.nhNeg_by_nh);
        }
        ++cnt;
    }

    @Override
    public final GeneSetScoringTable createTable(GeneSet geneSet, RankedList rankedList, RankedList rankedList2) {
        return new GeneSetScoringTables$WeightedDoubleSidedAs1(geneSet, rankedList, rankedList2);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    public final boolean isTwoSidedEs() {
        return false;
    }

    @Override
    public final RankedList getRankedList() {
        return this.rankedList;
    }

    @Override
    public final float getHitScore(String string) {
        float f2 = this.rankedList.getScore(string);
        int n = this.rankedList.getRank(string);
        if (XMath.isPositive(f2)) {
            if (n <= this.maxPosRealRank) {
                float f3 = f2 / this.totalPosWeight_of_hits;
                return f3 * this.nhPos_by_nh;
            }
            return 0.0f;
        }
        if (n <= this.maxPosRealRank) {
            return 0.0f;
        }
        float f4 = f2 / this.totalNegWeight_of_hits;
        return f4 * this.nhNeg_by_nh;
    }

    @Override
    public final float getMissScore(String string) {
        float f2 = this.rankedList.getScore(string);
        if (XMath.isPositive(f2)) {
            return this.miss_pos_score;
        }
        return this.miss_neg_score;
    }
}

