/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.alg.gsea.MhtMode;
import edu.mit.broad.genome.alg.gsea.MhtModes;
import edu.mit.broad.genome.alg.gsea.MhtModes$Base;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;

public class MhtModes$VarMean
extends MhtModes$Base {
    private float[] fRVars;
    private float[] fMeans;
    private float[] fRVars_mw;
    private float[] fMeans_mw;

    public MhtModes$VarMean() {
        super("varmean_norm");
    }

    public MhtModes$VarMean(EnrichmentResult[] enrichmentResultArray) {
        this();
        this.setData(enrichmentResultArray);
    }

    @Override
    public final MhtMode cloneShallow() {
        return new MhtModes$VarMean();
    }

    @Override
    public final void setData(EnrichmentResult[] enrichmentResultArray) {
        int n;
        super.setData(enrichmentResultArray);
        int n2 = MhtModes.checkAndGetNumPerms(enrichmentResultArray);
        this.fRndMatrix = new Matrix(enrichmentResultArray.length, n2);
        this.fRndMatrix_mw = new Matrix(enrichmentResultArray.length, n2);
        this.fRVars = new float[enrichmentResultArray.length];
        this.fMeans = new float[enrichmentResultArray.length];
        this.fRVars_mw = new float[enrichmentResultArray.length];
        this.fMeans_mw = new float[enrichmentResultArray.length];
        for (n = 0; n < enrichmentResultArray.length; ++n) {
            if (enrichmentResultArray[n] == null) {
                throw new IllegalArgumentException("dtgs cannot be null at: " + n);
            }
            Vector vector = enrichmentResultArray[n].getRndESS();
            this.fRVars[n] = (float)Math.sqrt(vector.var(false, false));
            this.fMeans[n] = (float)vector.mean();
        }
        for (n = 0; n < enrichmentResultArray.length; ++n) {
            if (enrichmentResultArray[n] == null) {
                throw new IllegalArgumentException("dtgs cannot be null at: " + n);
            }
            this.fRndMatrix.setRow(n, this.getRndNES(n));
            this.fRndMatrix_mw.setRow(n, this.getRndNMW(n));
        }
    }

    @Override
    public final Vector getRndNES(int n) {
        Vector vector = this.fDtgs[n].getRndESS();
        vector.subtract(this.fMeans[n]);
        vector.divide(this.fRVars[n]);
        return vector;
    }

    @Override
    public final float getRealNES(int n) {
        return (this.fDtgs[n].getScore().getES() - this.fMeans[n]) / this.fRVars[n];
    }

    @Override
    public final float getRealNMW(int n) {
        return Float.NaN;
    }

    @Override
    public final Vector getRndNMW(int n) {
        throw new NotImplementedException();
    }

    @Override
    public final float calcNes(float f2, Vector vector, ScoreMode scoreMode) {
        Vector vector2 = vector.extract(f2, scoreMode);
        float f3 = (float)vector2.mean();
        float f4 = (float)Math.sqrt(vector2.var(false, false));
        return (f2 - f3) / f4;
    }

    @Override
    public final Vector calcNes(Vector vector, ScoreMode scoreMode) {
        Vector vector2 = new Vector(vector, scoreMode);
        float f2 = (float)vector2.mean();
        float f3 = (float)Math.sqrt(vector2.var(false, false));
        vector2.subtract(f2);
        vector2.divide(f3);
        vector2.setImmutable();
        return vector2;
    }

    @Override
    public final float calcVar(Vector vector, ScoreMode scoreMode) {
        return (float)Math.sqrt(vector.extract(scoreMode).var(false, false));
    }

    @Override
    public final float calcMean(Vector vector, ScoreMode scoreMode) {
        return (float)vector.extract(scoreMode).mean();
    }
}

