/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts.jfreechart.editor;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.charts.jfreechart.editor.GenomeChartPropertyEditPanel;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;

public class GenomeChartPanel
extends ChartPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
Printable,
ChartChangeListener {
    protected JFreeChart chart;
    protected final List chartMouseListeners;
    protected final boolean useBuffer;
    protected boolean refreshBuffer;
    protected Image chartBuffer;
    protected int chartBufferHeight;
    protected int chartBufferWidth;
    protected int minimumDrawWidth;
    protected int minimumDrawHeight;
    protected int maximumDrawWidth;
    protected int maximumDrawHeight;
    protected JPopupMenu popup;
    protected final ChartRenderingInfo info;
    protected double scaleX;
    protected double scaleY;
    protected Rectangle2D zoomRectangle = null;
    protected Point2D zoomPoint = null;
    protected boolean fillZoomRectangle = false;
    protected boolean horizontalZoom = false;
    protected boolean verticalZoom = false;
    protected boolean horizontalAxisTrace = false;
    protected boolean verticalAxisTrace = false;
    protected JMenuItem zoomInBothAxesMenuItem;
    protected JMenuItem zoomInHorizontalMenuItem;
    protected JMenuItem zoomInVerticalMenuItem;
    protected JMenuItem zoomOutBothMenuItem;
    protected JMenuItem zoomOutHorizontalMenuItem;
    protected JMenuItem zoomOutVerticalMenuItem;
    protected JMenuItem autoRangeBothMenuItem;
    protected JMenuItem autoRangeHorizontalMenuItem;
    protected JMenuItem autoRangeVerticalMenuItem;
    private final Rectangle2D available = new Rectangle2D.Double();
    private final Rectangle2D chartArea = new Rectangle2D.Double();
    private Line2D verticalTraceLine;
    private Line2D horizontalTraceLine;
    private GenomeChartPropertyEditPanel fChartEdit;

    public GenomeChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public GenomeChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300, 200, 800, 600, false, bl, bl2, bl3, bl4, bl5);
    }

    public GenomeChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(jFreeChart);
        this.chart = jFreeChart;
        this.chartMouseListeners = new ArrayList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.chart.addChangeListener(this);
        this.minimumDrawWidth = n3;
        this.minimumDrawHeight = n4;
        this.maximumDrawWidth = n5;
        this.maximumDrawHeight = n6;
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setGenerateToolTips(bl6);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(true);
    }

    @Override
    public final JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public final void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
        }
        this.chart = jFreeChart;
        this.chart.addChangeListener(this);
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    @Override
    public final int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    @Override
    public final void setMinimumDrawWidth(int n) {
        this.minimumDrawWidth = n;
    }

    @Override
    public final int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    @Override
    public final void setMaximumDrawWidth(int n) {
        this.maximumDrawWidth = n;
    }

    @Override
    public final void setMinimumDrawHeight(int n) {
        this.minimumDrawHeight = n;
    }

    @Override
    public final int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    @Override
    public final int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    @Override
    public final void setMaximumDrawHeight(int n) {
        this.maximumDrawHeight = n;
    }

    @Override
    public final void setMouseZoomable(boolean bl) {
        this.setMouseZoomable(bl, true);
    }

    @Override
    public final void setMouseZoomable(boolean bl, boolean bl2) {
        this.setHorizontalZoom(bl);
        this.setVerticalZoom(bl);
        this.setFillZoomRectangle(bl2);
    }

    public final void setHorizontalZoom(boolean bl) {
        this.horizontalZoom = bl;
    }

    @Override
    public final void setFillZoomRectangle(boolean bl) {
        this.fillZoomRectangle = bl;
    }

    public final void setVerticalZoom(boolean bl) {
        this.verticalZoom = bl;
    }

    @Override
    public final void setHorizontalAxisTrace(boolean bl) {
        this.horizontalAxisTrace = bl;
    }

    @Override
    public final void setVerticalAxisTrace(boolean bl) {
        this.verticalAxisTrace = bl;
    }

    public final void setGenerateToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        return "na";
    }

    @Override
    public final void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        if (graphics == null) {
            TraceUtils.showTrace();
            return;
        }
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d2 = this.available.getWidth();
        double d3 = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d2 < (double)this.minimumDrawWidth) {
            this.scaleX = d2 / (double)this.minimumDrawWidth;
            d2 = this.minimumDrawWidth;
            bl = true;
        } else if (d2 > (double)this.maximumDrawWidth) {
            this.scaleX = d2 / (double)this.maximumDrawWidth;
            d2 = this.maximumDrawWidth;
            bl = true;
        }
        if (d3 < (double)this.minimumDrawHeight) {
            this.scaleY = d3 / (double)this.minimumDrawHeight;
            d3 = this.minimumDrawHeight;
            bl = true;
        } else if (d3 > (double)this.maximumDrawHeight) {
            this.scaleY = d3 / (double)this.maximumDrawHeight;
            d3 = this.maximumDrawHeight;
            bl = true;
        }
        this.chartArea.setRect(0.0, 0.0, d2, d3);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D graphics2D2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (bl) {
                    AffineTransform affineTransform2 = graphics2D2.getTransform();
                    graphics2D2.transform(affineTransform);
                    this.chart.draw(graphics2D2, this.chartArea, this.info);
                    graphics2D2.setTransform(affineTransform2);
                } else {
                    this.chart.draw(graphics2D2, double_, this.info);
                }
                this.refreshBuffer = false;
            }
            graphics.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform affineTransform3 = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.right);
            if (bl) {
                graphics2D.transform(affineTransform);
            }
            this.chart.draw(graphics2D, this.chartArea, this.info);
            graphics2D.setTransform(affineTransform3);
        }
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    @Override
    public final void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        this.repaint();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (string.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                System.err.println("GenomeChartPanel.doSaveAs: i/o exception = " + iOException.getMessage());
            }
        } else if (string.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (string.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_IN_DOMAIN")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_IN_RANGE")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (string.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (string.equals("ZOOM_DOMAIN_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (string.equals("ZOOM_RANGE_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        }
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.zoomRectangle == null && mouseEvent.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity(n, n2);
        ChartMouseEvent chartMouseEvent = new ChartMouseEvent(this.chart, mouseEvent, chartEntity);
        for (ChartMouseListener chartMouseListener : this.chartMouseListeners) {
            chartMouseListener.chartMouseClicked(chartMouseEvent);
        }
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(mouseEvent.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(mouseEvent.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity(n, n2);
        ChartMouseEvent chartMouseEvent = new ChartMouseEvent(this.chart, mouseEvent, chartEntity);
        for (ChartMouseListener chartMouseListener : this.chartMouseListeners) {
            chartMouseListener.chartMouseMoved(chartMouseEvent);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        Rectangle2D rectangle2D = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double d2 = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            double d3 = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d2 - this.zoomPoint.getX(), d3 - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public final void zoomInBoth(double d2, double d3) {
        this.zoomInHorizontal(d2);
        this.zoomInVertical(d3);
    }

    public final void zoomInHorizontal(double d2) {
    }

    public final void zoomInVertical(double d2) {
    }

    @Override
    public final void zoomOutBoth(double d2, double d3) {
        this.zoomOutHorizontal(d2);
        this.zoomOutVertical(d3);
    }

    public final void zoomOutHorizontal(double d2) {
    }

    public final void zoomOutVertical(double d2) {
    }

    @Override
    public final void zoom(Rectangle2D rectangle2D) {
    }

    public final void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public final void autoRangeHorizontal() {
    }

    public final void autoRangeVertical() {
    }

    public final Rectangle2D getScaledDataArea() {
        Rectangle2D rectangle2D = this.info.getChartArea();
        Insets insets = this.getInsets();
        double d2 = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d3 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d4 = rectangle2D.getWidth() * this.scaleX;
        double d5 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    private void drawHorizontalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinX() < n && n < (int)rectangle2D.getMaxX()) {
            if (this.verticalTraceLine != null) {
                graphics2D.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            }
            graphics2D.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int n) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Rectangle2D rectangle2D = this.getScaledDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinY() < n && n < (int)rectangle2D.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                graphics2D.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            }
            graphics2D.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        boolean bl;
        if (this.fChartEdit == null) {
            this.fChartEdit = new GenomeChartPropertyEditPanel(this.chart);
        }
        if (bl = Application.getWindowManager().showConfirm("Update Chart Properties?")) {
            this.fChartEdit.updateChartProperties();
        }
    }

    @Override
    public final void doSaveAs() {
        throw new NotImplementedException();
    }

    @Override
    public final void createChartPrintJob() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Application.getWindowManager().showError(printerException);
            }
        }
    }

    @Override
    public final int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = pageFormat.getImageableX();
        double d3 = pageFormat.getImageableY();
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d2, d3, d4, d5), null);
        return 0;
    }

    @Override
    public final void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.add(chartMouseListener);
    }

    @Override
    public final void removeChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.remove(chartMouseListener);
    }

    @Override
    protected final JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        boolean bl5 = false;
        if (bl) {
            jMenuItem = new JMenuItem("Properties...");
            jMenuItem.setActionCommand("PROPERTIES");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl2) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Save as...");
            jMenuItem.setActionCommand("SAVE");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenuItem("Print...");
            jMenuItem.setActionCommand("PRINT");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                jPopupMenu.addSeparator();
                bl5 = false;
            }
            jMenuItem = new JMenu("Zoom In");
            JMenuItem jMenuItem2 = new JMenuItem("Both Axes");
            jMenuItem2.setActionCommand("ZOOM_IN_BOTH");
            jMenuItem2.addActionListener(this);
            ((JMenu)jMenuItem).add(jMenuItem2);
            ((JMenu)jMenuItem).addSeparator();
            this.zoomInHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_RANGE");
            this.zoomInHorizontalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_DOMAIN");
            this.zoomInVerticalMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInVerticalMenuItem);
            jPopupMenu.add(jMenuItem);
            JMenu jMenu = new JMenu("Zoom Out");
            JMenuItem jMenuItem3 = new JMenuItem("Both Axes");
            jMenuItem3.setActionCommand("ZOOM_OUT_BOTH");
            jMenuItem3.addActionListener(this);
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_RANGE_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_DOMAIN_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutVerticalMenuItem);
            jPopupMenu.add(jMenu);
            JMenu jMenu2 = new JMenu("Auto Range");
            this.autoRangeBothMenuItem = new JMenuItem("Both Axes");
            this.autoRangeBothMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeBothMenuItem);
            jMenu2.addSeparator();
            this.autoRangeHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.autoRangeHorizontalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.autoRangeVerticalMenuItem.addActionListener(this);
            jMenu2.add(this.autoRangeVerticalMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenu2);
        }
        return jPopupMenu;
    }

    @Override
    protected final void displayPopupMenu(int n, int n2) {
    }
}

