/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.utils.containers.ClassNamePair;

public class ScaleMode {
    public static final ScaleMode REL_MEAN = new ScaleMode("Relative & Mean");
    public static final ScaleMode REL_MEDIAN = new ScaleMode("Relative & Median");
    public static final ScaleMode ABSOLUTE = new ScaleMode("Absolute");
    public static final ScaleMode REL_MEAN_ZERO_OMITTED = new ScaleMode("Relative & Mean (zero omitted)");
    public static final ScaleMode[] ALL = new ScaleMode[]{REL_MEAN, REL_MEDIAN, ABSOLUTE, REL_MEAN_ZERO_OMITTED};
    public static final ClassNamePair[] ALL_CNP = new ClassNamePair[]{new ClassNamePair(REL_MEAN.getClass(), ScaleMode.REL_MEAN.fType), new ClassNamePair(REL_MEDIAN.getClass(), ScaleMode.REL_MEDIAN.fType), new ClassNamePair(ABSOLUTE.getClass(), ScaleMode.ABSOLUTE.fType)};
    private final String fType;

    private ScaleMode(String string) {
        this.fType = string;
    }

    public final String toString() {
        return this.fType;
    }

    public final boolean isMean() {
        return this.equals(REL_MEAN) || this.equals(REL_MEAN_ZERO_OMITTED);
    }

    public final boolean isMedian() {
        return this.equals(REL_MEDIAN);
    }

    public final boolean isRelative() {
        return this.equals(REL_MEAN) || this.equals(REL_MEDIAN) || this.equals(REL_MEAN_ZERO_OMITTED);
    }

    public final boolean isAbsolute() {
        return this.equals(ABSOLUTE);
    }

    public final boolean equals(Object object) {
        return object instanceof ScaleMode && ((ScaleMode)object).fType.equals(this.fType);
    }

    public final int hashCode() {
        return this.fType.hashCode();
    }

    public static final ScaleMode lookup(Object object) {
        if (object == null) {
            throw new NullPointerException("Null mode cabbot be looked up");
        }
        if (object instanceof ScaleMode) {
            return (ScaleMode)object;
        }
        String string = object.toString();
        if (string.equalsIgnoreCase(ScaleMode.REL_MEAN.fType)) {
            return REL_MEAN;
        }
        if (string.equalsIgnoreCase(REL_MEDIAN.toString())) {
            return REL_MEDIAN;
        }
        if (string.equalsIgnoreCase(ABSOLUTE.toString())) {
            return ABSOLUTE;
        }
        throw new IllegalArgumentException("Unable to lookup ScaleMode: " + object);
    }
}

