/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath$Const;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.StringDataframe;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.log4j.Logger;

public class XMath {
    private static final Logger klog = XLogger.getLogger(XMath.class);
    public static XMath$Const SCORE = new XMath$Const("score", null);
    public static XMath$Const RANK = new XMath$Const("rank", null);

    private XMath() {
    }

    public static final float distance2similarity(float f2) {
        if (XMath.isPositive(f2)) {
            return 1.0f - f2;
        }
        float f3 = 1.0f - Math.abs(f2);
        return -1.0f * f3;
    }

    public static final boolean isAscending(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
            int n = nArray[i2 + 1];
            int n2 = nArray[i2];
            if (n >= n2) continue;
            return false;
        }
        return true;
    }

    public static final boolean isContiguous(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
            int n = nArray[i2 + 1];
            int n2 = nArray[i2];
            if (n == n2 + 1) continue;
            return false;
        }
        return true;
    }

    public static final float getFWERTwoTailed(float f2, Matrix matrix) {
        if (XMath.isPositive(f2)) {
            return XMath.getFWER(f2, matrix, true);
        }
        return XMath.getFWERLessThan(f2, matrix);
    }

    public static final float getFWER(float f2, Matrix matrix, boolean bl) {
        Vector vector = bl ? matrix.getColumnMaxes() : matrix.getColumnMins();
        double d2 = bl ? XMath.getPValue(f2, vector) : XMath.getPValueLessThan(f2, vector);
        return (float)d2;
    }

    public static final float getFWERLessThan(float f2, Matrix matrix) {
        Vector vector = new Vector(matrix.getNumCol());
        for (int i2 = 0; i2 < matrix.getNumCol(); ++i2) {
            vector.setElement(i2, matrix.getColumnV(i2).min());
        }
        return (float)XMath.getPValueLessThan(f2, vector);
    }

    public static final int sum(int[] nArray) {
        int n = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n += nArray[i2];
        }
        return n;
    }

    public static final float sum(float[] fArray) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        return f2;
    }

    public static final float sum_nan_aware(float[] fArray, float f2) {
        float f3 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                f3 += f2;
                continue;
            }
            f3 += fArray[i2];
        }
        return f3;
    }

    public static final double sum(double[] dArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2];
        }
        return d2;
    }

    public static final double varMeanNorm(float f2, Vector vector) {
        return ((double)f2 - vector.mean()) / vector.var(false, false);
    }

    public static final double log2(double d2) {
        return Math.log(d2) / Math.log(2.0);
    }

    public static final double log10(double d2) {
        return Math.log(d2) / Math.log(10.0);
    }

    public static final float[] toFloats(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return fArray;
    }

    public static final float[] toFloats(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        return fArray;
    }

    public static final boolean isSameSign(TFloatArrayList tFloatArrayList) {
        if (tFloatArrayList.size() == 0) {
            return true;
        }
        float f2 = tFloatArrayList.get(0);
        for (int i2 = 0; i2 < tFloatArrayList.size(); ++i2) {
            if (XMath.isSameSign(f2, tFloatArrayList.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSameSign(float[] fArray) {
        if (fArray.length == 0) {
            return true;
        }
        float f2 = fArray[0];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (XMath.isSameSign(f2, fArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSameSign(float f2, float f3) {
        if (f2 < 0.0f && f3 < 0.0f) {
            return true;
        }
        if (f2 == 0.0f && f3 == 0.0f) {
            return true;
        }
        return f2 > 0.0f && f3 > 0.0f;
    }

    public static final int[] splitTwoSided(int n) {
        int n2 = n / 2;
        int n3 = n - n2;
        return new int[]{n3, n2};
    }

    public static final boolean isEven(int n) {
        return (float)(n / 2) == (float)n / 2.0f;
    }

    public static final boolean isPositive(int n) {
        return n >= 0;
    }

    public static final boolean isPositive(String string) {
        return XMath.isPositive(Float.parseFloat(string));
    }

    public static final boolean isPositive(float f2) {
        return f2 >= 0.0f;
    }

    public static final boolean isPositiveBoth(float f2, float f3) {
        return XMath.isPositive(f2) && XMath.isPositive(f3);
    }

    public static final boolean isNegativeBoth(float f2, float f3) {
        return XMath.isNegative(f2) && XMath.isNegative(f3);
    }

    public static final boolean isPositive(double d2) {
        return d2 >= 0.0;
    }

    public static final boolean isNegative(int n) {
        return n <= 0;
    }

    public static final boolean isNegative(String string) {
        return XMath.isNegative(Float.parseFloat(string));
    }

    public static final boolean isNegative(float f2) {
        return f2 <= 0.0f;
    }

    public static final boolean isDivisibleBy(int n, int n2) {
        return (float)(n / n2) == (float)n / (float)n2;
    }

    public static final boolean isNumeric(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                Float.parseFloat(objectArray[i2].toString());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static final boolean isNumeric(Object object) {
        if (object == null) {
            return false;
        }
        try {
            Float.parseFloat(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static final int[] randomlyPickIndicesWithoutReplacement(int n, int n2, RandomSeedGenerator randomSeedGenerator) {
        int[] nArray = XMath.randomlySampleWithoutReplacement(n, n2, randomSeedGenerator);
        if (nArray.length != n) {
            throw new IllegalStateException("Prog error: indices length " + nArray.length + " but wanted to pick: " + n + " highIndexExclusive: " + n2);
        }
        return nArray;
    }

    public static final int[] toIndices(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("Specified max for indices must be more than 0, got: " + n);
        }
        int n2 = bl ? n + 1 : n;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public static final int[] toIndices(int[] nArray, int[] nArray2, boolean bl) {
        int n;
        TIntArrayList tIntArrayList = new TIntArrayList(nArray);
        TIntArrayList tIntArrayList2 = new TIntArrayList(nArray2);
        TIntArrayList tIntArrayList3 = new TIntArrayList();
        if (bl) {
            for (n = 0; n < nArray.length; ++n) {
                if (tIntArrayList2.contains(nArray[n])) continue;
                tIntArrayList3.add(nArray[n]);
            }
        } else {
            for (n = 0; n < nArray.length; ++n) {
                if (!tIntArrayList2.contains(nArray[n])) continue;
                tIntArrayList3.add(nArray[n]);
            }
        }
        for (n = 0; n < tIntArrayList3.size(); ++n) {
            int n2 = tIntArrayList.indexOf(tIntArrayList3.get(n));
            if (n2 == -1) {
                throw new IllegalStateException("Strangely this values doesnt exist in all: " + tIntArrayList3.get(n));
            }
            tIntArrayList.remove(n2);
            if (tIntArrayList.indexOf(tIntArrayList3.get(n)) == -1) continue;
            throw new IllegalArgumentException("There were duplicates in the all array: " + Printf.format(nArray));
        }
        return tIntArrayList.toNativeArray();
    }

    public static final boolean equals(int n, int n2, int n3) {
        return Math.abs(n2 - n3) <= n;
    }

    public static final double rad2deg(double d2) {
        return d2 * 360.0 / (Math.PI * 2);
    }

    public static final double deg2rad(double d2) {
        return d2 * (Math.PI * 2) / 360.0;
    }

    public static final int[] randomizeWithoutReplacement(int n, RandomSeedGenerator randomSeedGenerator) {
        return XMath.randomizeWithoutReplacement(n, randomSeedGenerator.getRandom());
    }

    public static final int[] randomizeWithoutReplacement(int n, Random random) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = random.nextInt(n);
            if (arrayList.contains(new Integer(n4))) continue;
            arrayList.add(new Integer(n4));
            nArray[n2++] = n4;
            if (n2 != n) continue;
            break;
        }
        return nArray;
    }

    public static final int[] randomlySampleWithoutReplacement(int n, int n2, RandomSeedGenerator randomSeedGenerator) {
        return XMath.randomlySampleWithoutReplacement(n, n2, randomSeedGenerator.getRandom());
    }

    public static final int[] randomlySampleWithoutReplacement(int n, int n2, Random random) {
        if (n2 == n) {
            return XMath.toIndices(n2, false);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Cannot pick more numbers (no replacement) numRndNeeded: " + n + " than max possible number maxRndNumExclusive: " + n2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = random.nextInt(n2);
            if (arrayList.contains(new Integer(n5))) continue;
            arrayList.add(new Integer(n5));
            nArray[n3++] = n5;
            if (n3 != n) continue;
            break;
        }
        return nArray;
    }

    public static final int[] randomlySampleWithoutReplacement(int n, int[] nArray, Random random) {
        int[] nArray2 = XMath.randomlySampleWithoutReplacement(n, nArray.length, random);
        int[] nArray3 = new int[nArray2.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray3[i2] = nArray[nArray2[i2]];
        }
        return nArray3;
    }

    public static final int[] randomlySampleWithoutReplacement(int n, int[] nArray, RandomSeedGenerator randomSeedGenerator) {
        return XMath.randomlySampleWithoutReplacement(n, nArray, randomSeedGenerator.getRandom());
    }

    public static final int[] randomlySampleWithReplacement(int n, int n2, RandomSeedGenerator randomSeedGenerator) {
        return XMath.randomlySampleWithReplacement(n, n2, randomSeedGenerator.getRandom());
    }

    public static final int[] randomlySampleWithReplacement(int n, int n2, Random random) {
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nArray[i2] = random.nextInt(n2);
        }
        return nArray;
    }

    public static final double getPValue(int n, int n2) {
        return (double)n2 / (double)n;
    }

    public static final double getPValue(double d2, double[] dArray) {
        int n = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > d2)) continue;
            ++n;
        }
        return (double)n / (double)dArray.length;
    }

    public static final double getPValue(float f2, TFloatArrayList tFloatArrayList) {
        int n = 0;
        for (int i2 = 0; i2 < tFloatArrayList.size(); ++i2) {
            if (!(tFloatArrayList.getQuick(i2) > f2)) continue;
            ++n;
        }
        return (double)n / (double)tFloatArrayList.size();
    }

    public static final double getPValue(float f2, float[] fArray) {
        int n = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            ++n;
        }
        return (double)n / (double)fArray.length;
    }

    public static final double getPValueLessThan(float f2, float[] fArray) {
        int n = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] < f2)) continue;
            ++n;
        }
        return (double)n / (double)fArray.length;
    }

    public static final double getPValue(int n, int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n) continue;
            ++n2;
        }
        return (double)n2 / (double)nArray.length;
    }

    public static final double getPValue(float f2, Vector vector, boolean bl) {
        if (bl) {
            return XMath.getPValue(f2, vector);
        }
        return XMath.getPValueLessThan(f2, vector);
    }

    public static final double getPValue(float f2, Vector vector) {
        return XMath.getPValue(f2, vector.elementData);
    }

    public static final double getPValueLessThan(float f2, Vector vector) {
        return XMath.getPValueLessThan(f2, vector.elementData);
    }

    public static final double getPValueLessThan(float f2, Matrix matrix) {
        return XMath.getPValueLessThan(f2, matrix.elementData);
    }

    public static final double getPValue(float f2, Matrix matrix) {
        return XMath.getPValue(f2, matrix.elementData);
    }

    public static final double getPValue(double d2, Vector vector) {
        return XMath.getPValue((float)d2, vector);
    }

    public static final double getPValueTwoTailed(float f2, float[] fArray) {
        int n = 0;
        if (f2 >= 0.0f) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                if (!(fArray[i2] > f2)) continue;
                ++n;
            }
        } else {
            for (int i3 = 0; i3 < fArray.length; ++i3) {
                if (!(fArray[i3] < f2)) continue;
                ++n;
            }
        }
        return (double)n / (double)fArray.length;
    }

    public static final double getPValueTwoTailed(int n, int[] nArray) {
        int n2 = 0;
        if (n >= 0) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] <= n) continue;
                ++n2;
            }
        } else {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray[i3] >= n) continue;
                ++n2;
            }
        }
        return (double)n2 / (double)nArray.length;
    }

    public final float maxDevFrom0(float[] fArray) {
        Vector vector = new Vector(fArray, true);
        return vector.maxDevFrom0();
    }

    public static final double getPValueTwoTailed(float f2, Vector vector) {
        return XMath.getPValueTwoTailed(f2, vector.elementData);
    }

    public static final double getPValueTwoTailed(float f2, Matrix matrix) {
        return XMath.getPValueTwoTailed(f2, matrix.elementData);
    }

    public static final float getPValueTwoTailed_pos_neg_seperate(float f2, Vector vector) {
        Vector vector2 = vector.extract(f2, ScoreMode.POS_AND_NEG_SEPERATELY);
        return (float)XMath.getPValueTwoTailed(f2, vector2);
    }

    public static final int getPValueCnt(float f2, float[] fArray) {
        int n = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            ++n;
        }
        return n;
    }

    public static final int getPValueCnt(float f2, Vector vector) {
        return XMath.getPValueCnt(f2, vector.elementData);
    }

    public static final int getPValueCnt(double d2, Vector vector) {
        return XMath.getPValueCnt((float)d2, vector);
    }

    public static final double roundOff(double d2, int n) {
        BigDecimal bigDecimal = new BigDecimal(d2);
        return bigDecimal.setScale(n, 4).doubleValue();
    }

    public static final int min(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length < objectArray2.length) {
            return objectArray.length;
        }
        return objectArray2.length;
    }

    public static final int max(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length > objectArray2.length) {
            return objectArray.length;
        }
        return objectArray2.length;
    }

    public static final int max(int[] nArray) {
        if (nArray.length == 0) {
            klog.warn("FIX ME Zero length array");
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int n = nArray[0];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n >= nArray[i2]) continue;
            n = nArray[i2];
        }
        return n;
    }

    public static final int max_allow_zero_length(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n >= nArray[i2]) continue;
            n = nArray[i2];
        }
        return n;
    }

    public static final float max(float[] fArray) {
        if (fArray.length == 0) {
            klog.warn("FIX ME Zero length array");
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float f2 = fArray[0];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(f2 < fArray[i2])) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static final float max(TFloatArrayList tFloatArrayList) {
        if (tFloatArrayList.size() == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float f2 = tFloatArrayList.get(0);
        for (int i2 = 0; i2 < tFloatArrayList.size(); ++i2) {
            float f3 = tFloatArrayList.get(i2);
            if (!(f2 < f3)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static final float max(TIntArrayList tIntArrayList) {
        return XMath.max(tIntArrayList.toNativeArray());
    }

    public static final float min(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float f2 = fArray[0];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(f2 > fArray[i2])) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static final float min(TFloatArrayList tFloatArrayList) {
        if (tFloatArrayList.size() == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float f2 = tFloatArrayList.get(0);
        for (int i2 = 0; i2 < tFloatArrayList.size(); ++i2) {
            float f3 = tFloatArrayList.get(i2);
            if (!(f2 > f3)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static final float maxAbs(float[] fArray) {
        return fArray[XMath.maxAbsIndex(fArray)];
    }

    public static final int maxAbsIndex(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float f2 = fArray[0];
        int n = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(Math.abs(f2) < Math.abs(fArray[i2]))) continue;
            f2 = fArray[i2];
            n = i2;
        }
        return n;
    }

    public static final float max(float f2, float f3) {
        return XMath.max(new float[]{f2, f3});
    }

    public static final int max(int n, int n2) {
        return XMath.max(new int[]{n, n2});
    }

    public static final float maxAbs(float f2, float f3) {
        return XMath.maxAbs(new float[]{f2, f3});
    }

    public static final float min(float f2, float f3) {
        return XMath.min(new float[]{f2, f3});
    }

    public static final int min(int n, int n2) {
        return XMath.min(new int[]{n, n2});
    }

    public static final int max(Vector[] vectorArray) {
        if (vectorArray.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int n = vectorArray[0].getSize();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (n >= vectorArray[i2].getSize()) continue;
            n = vectorArray[i2].getSize();
        }
        return n;
    }

    public static final int min(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int n = nArray[0];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n <= nArray[i2]) continue;
            n = nArray[i2];
        }
        return n;
    }

    public static final int[] minmax(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int n = nArray[0];
        int n2 = nArray[0];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n > nArray[i2]) {
                n = nArray[i2];
            }
            if (n2 >= nArray[i2]) continue;
            n2 = nArray[i2];
        }
        return new int[]{n, n2};
    }

    private static void enforceEqualSize(Vector vector, Vector vector2) {
        if (vector.getSize() != vector2.getSize()) {
            throw new IllegalArgumentException("Vector lengths not equal x=" + vector.getSize() + " and y=" + vector2.getSize());
        }
    }

    private static void enforceEqualSize(Vector[] vectorArray) {
        if (vectorArray.length == 0) {
            return;
        }
        int n = vectorArray[0].getSize();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            if (vectorArray[i2].getSize() == n) continue;
            throw new IllegalArgumentException("Vector lengths not equal first=" + n + " and y=" + vectorArray[i2].getSize() + " at index " + i2);
        }
    }

    private static void enforceEqualSize(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Vector lengths not equal x=" + fArray.length + " and y=" + fArray2.length);
        }
    }

    private static void enforceEqualSize(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("int[] Arrays lengths not equal x=" + nArray.length + " and y=" + nArray2.length);
        }
    }

    public static final double euclidean(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f3 = vector.getElement(i2) - vector2.getElement(i2);
            f2 += f3 * f3;
        }
        return Math.sqrt(f2);
    }

    public static final double euclidean_exclude_nan(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            if (Float.isNaN(vector.getElement(i2)) || Float.isNaN(vector2.getElement(i2))) continue;
            float f3 = vector.getElement(i2) - vector2.getElement(i2);
            f2 += f3 * f3;
        }
        return Math.sqrt(f2);
    }

    public static final double manhatten(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            d2 += (double)Math.abs(vector.getElement(i2) - vector2.getElement(i2));
        }
        return d2;
    }

    public static final double meansdiff(Vector vector, Vector vector2) {
        return vector.mean() - vector2.mean();
    }

    public static final double meansratio(Vector vector, Vector vector2) {
        return vector.mean() / vector2.mean();
    }

    public static final double mediansratio(Vector vector, Vector vector2) {
        return vector.median() / vector2.median();
    }

    public static final double meanOrMedianRatio(Vector vector, Vector vector2, boolean bl) {
        return vector.meanOrMedian(bl) / vector2.meanOrMedian(bl);
    }

    public static final double meanOrMedianDiff(Vector vector, Vector vector2, boolean bl) {
        return vector.meanOrMedian(bl) - vector2.meanOrMedian(bl);
    }

    public static final double mediansdiff(Vector vector, Vector vector2) {
        return vector.median() - vector2.median();
    }

    public static final Vector meanVector(Vector[] vectorArray) {
        XMath.enforceEqualSize(vectorArray);
        int n = vectorArray[0].getSize();
        float[] fArray = new float[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Vector vector = new Vector(vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                vector.setElement(i3, vectorArray[i3].getElement(i2));
            }
            fArray[i2] = (float)vector.mean();
        }
        return new Vector(fArray, true);
    }

    public static final Vector medianVector(Vector[] vectorArray) {
        XMath.enforceEqualSize(vectorArray);
        int n = vectorArray[0].getSize();
        float[] fArray = new float[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Vector vector = new Vector(vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                vector.setElement(i3, vectorArray[i3].getElement(i2));
            }
            fArray[i2] = (float)vector.median();
        }
        return new Vector(fArray);
    }

    public static final Vector maxVector(Vector[] vectorArray) {
        XMath.enforceEqualSize(vectorArray);
        int n = vectorArray[0].getSize();
        float[] fArray = new float[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Vector vector = new Vector(vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                vector.setElement(i3, vectorArray[i3].getElement(i2));
            }
            fArray[i2] = vector.max();
        }
        return new Vector(fArray);
    }

    public static final Vector maxVector_TTTT(Vector[] vectorArray, String string) {
        XMath.enforceEqualSize(vectorArray);
        int n = vectorArray[0].getSize();
        float[] fArray = new float[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Vector vector = new Vector(vectorArray.length);
            for (int i3 = 0; i3 < vectorArray.length; ++i3) {
                vector.setElement(i3, vectorArray[i3].getElement(i2));
            }
            fArray[i2] = vector.max_TTTT(string);
        }
        return new Vector(fArray);
    }

    public static final float mean_of_means(Vector[] vectorArray) {
        double[] dArray = new double[vectorArray.length];
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            dArray[i2] = vectorArray[i2].mean();
        }
        return XMath.mean(dArray);
    }

    public static final float median_of_medians(Vector[] vectorArray) {
        float[] fArray = new float[vectorArray.length];
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            fArray[i2] = (float)vectorArray[i2].median();
        }
        return XMath.median(fArray);
    }

    public static final float mean(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Parameter x[] cannot be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Parameter x[] cannot be of 0 length");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        return f2 / (float)fArray.length;
    }

    public static final float meanmed(TFloatArrayList tFloatArrayList, boolean bl) {
        if (bl) {
            return XMath.mean(tFloatArrayList.toNativeArray());
        }
        return XMath.median(tFloatArrayList.toNativeArray());
    }

    public static final float mean_nan_aware(float[] fArray, float f2) {
        if (fArray == null) {
            throw new IllegalArgumentException("Parameter x[] cannot be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Parameter x[] cannot be of 0 length");
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                f3 += f2;
                continue;
            }
            f3 += fArray[i2];
        }
        return f3 / (float)fArray.length;
    }

    public static final float mean(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Parameter x[] cannot be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Parameter x[] cannot be of 0 length");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            f2 = (float)((double)f2 + dArray[i2]);
        }
        return f2 / (float)dArray.length;
    }

    public static final float median(float[] fArray) {
        if (fArray.length == 0) {
            return Float.NaN;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        Arrays.sort(fArray2);
        int n2 = (n - 1) / 2;
        if (XMath.isEven(n)) {
            return (fArray2[n2] + fArray2[n / 2]) / 2.0f;
        }
        return fArray2[n2];
    }

    public static final float median(int[] nArray) {
        if (nArray.length == 0) {
            return Float.NaN;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        Arrays.sort(nArray2);
        int n2 = (n - 1) / 2;
        if (XMath.isEven(n)) {
            return (nArray2[n2] + nArray2[n / 2]) / 2;
        }
        return nArray2[n2];
    }

    public static final double pearson(float[] fArray, float[] fArray2) {
        return XMath.pearson(new Vector(fArray, true), new Vector(fArray2, true));
    }

    public static final double pearson(int[] nArray, int[] nArray2) {
        return XMath.pearson(new Vector(nArray), new Vector(nArray2));
    }

    public static final double pearson(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        double d2 = vector.getSize();
        if (d2 == 0.0 || d2 == 1.0) {
            return Double.NaN;
        }
        double d3 = vector.sumprod(vector2) - vector.sum() * vector2.sum() / d2;
        double d4 = (vector.squaresum() - vector.sum() * vector.sum() / d2) * (vector2.squaresum() - vector2.sum() * vector2.sum() / d2);
        d4 = Math.sqrt(d4);
        return d3 / d4;
    }

    public static final double pearson_exclude_nan(Vector vector, Vector vector2) {
        Vector[] vectorArray = XMath.removeNaNsSynched(vector, vector2);
        return XMath.pearson(vectorArray[0], vectorArray[1]);
    }

    public static final double hamming_exclude_0_only_if_both(Vector vector, Vector vector2) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f4 = vector.getElement(i2);
            for (int i3 = 0; i3 < vector2.getSize(); ++i3) {
                float f5 = vector2.getElement(i3);
                if (f4 == 1.0f && f5 == 0.0f) {
                    f2 = (float)((double)f2 + 0.5);
                    f3 += 1.0f;
                    continue;
                }
                if (f4 == -1.0f && f5 == 0.0f) {
                    f2 = (float)((double)f2 + -0.5);
                    f3 += 1.0f;
                    continue;
                }
                if (f4 == 1.0f && f5 == 1.0f) {
                    f2 += 1.0f;
                    f3 += 1.0f;
                    continue;
                }
                if (f4 != 1.0f || f5 != -1.0f) continue;
                f2 += -1.0f;
                f3 += 1.0f;
            }
        }
        return f2 / f3;
    }

    public static final SimpleRegression regression(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        SimpleRegression simpleRegression = new SimpleRegression();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            simpleRegression.addData(vector.getElement(i2), vector2.getElement(i2));
        }
        return simpleRegression;
    }

    public static final double regressionSlope(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        SimpleRegression simpleRegression = new SimpleRegression();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            simpleRegression.addData(vector.getElement(i2), vector2.getElement(i2));
        }
        return simpleRegression.getSlope();
    }

    public static final double regressionSlope(Vector vector, Vector vector2, Vector[] vectorArray, boolean bl, boolean bl2) {
        XMath.enforceEqualSize(vector, vector2);
        double d2 = vector.sum();
        double d3 = vector.getSize();
        double d4 = d3 * vector.sumprod(vector2);
        double d5 = d2 * vector2.sum();
        double d6 = d3 * vector.squaresum();
        double d7 = d2 * d2;
        double d8 = (d4 - d5) / (d6 - d7);
        double d9 = 0.0;
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            d9 += vectorArray[i2].stddev(bl, bl2);
        }
        if (d9 == 0.0) {
            return Double.NaN;
        }
        return d8 / d9;
    }

    public static final Vector[] removeNaNsSynched(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f2 = vector.getElement(i2);
            float f3 = vector2.getElement(i2);
            if (Float.isNaN(f2) || Float.isNaN(f3)) continue;
            tFloatArrayList.add(f2);
            tFloatArrayList2.add(f3);
        }
        return new Vector[]{new Vector(tFloatArrayList), new Vector(tFloatArrayList2)};
    }

    public static final Vector[] remove0sSynched_only_if_both_are_0(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        TFloatArrayList tFloatArrayList2 = new TFloatArrayList();
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f2 = vector.getElement(i2);
            float f3 = vector2.getElement(i2);
            if (f2 == 0.0f && f3 == 0.0f) continue;
            tFloatArrayList.add(f2);
            tFloatArrayList2.add(f3);
        }
        return new Vector[]{new Vector(tFloatArrayList), new Vector(tFloatArrayList2)};
    }

    public static final double kenvar(Vector vector, Vector vector2, float f2) {
        XMath.enforceEqualSize(vector, vector2);
        int n = 0;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            float f3 = vector.getElement(i2) / vector2.getElement(i2);
            if (f3 < 1.0f) {
                f3 = 1.0f / f3;
            }
            if (!(f3 > f2)) continue;
            ++n;
        }
        return n;
    }

    public static final double kenvar(float[] fArray, float[] fArray2, float f2) {
        XMath.enforceEqualSize(fArray, fArray2);
        int n = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = fArray[i2] / fArray2[i2];
            if (f3 < 1.0f) {
                f3 = 1.0f / f3;
            }
            if (!(f3 > f2)) continue;
            ++n;
        }
        return n;
    }

    public static final double kendallstau(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = 0;
            int n5 = 0;
            if (nArray[n2] <= 0 || nArray[n2] > nArray.length + 1) {
                throw new IllegalArgumentException("Ranks must be from 1 to n found: " + nArray[n2]);
            }
            for (int i2 = n2 + 1; i2 < nArray.length; ++i2) {
                if (nArray[n2] == nArray[i2]) {
                    throw new IllegalArgumentException("Ditto ranks not allowed rank at: " + n2 + " is: " + nArray[n2] + " same as rank at: " + i2 + " rank: " + nArray[i2]);
                }
                if (nArray[n2] > nArray[i2]) {
                    ++n;
                } else {
                    ++n5;
                }
                n3 += n;
                n4 += n5;
            }
        }
        n2 = nArray.length;
        n = n2 * (n2 - 1) / 2;
        klog.debug("denom: " + n);
        return (n3 - n4) / n;
    }

    public static final double spearman(int[] nArray, int[] nArray2) {
        int n;
        XMath.enforceEqualSize(nArray, nArray2);
        double d2 = 0.0;
        int n2 = nArray.length;
        int n3 = n2 * (n2 + 1) / 2;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            n4 += nArray[n];
        }
        if (n3 != n4) {
            throw new IllegalArgumentException("Bad sums expected: " + n3 + " but got: " + n4 + " (expect ranks from 1 to n and not 0 to n-1)");
        }
        n4 = 0;
        for (n = 0; n < n2; ++n) {
            n4 += nArray2[n];
        }
        if (n3 != n4) {
            throw new IllegalArgumentException("Bad sums expected: " + n3 + " but got: " + n4);
        }
        for (n = 0; n < nArray.length; ++n) {
            double d3 = nArray[n] - nArray2[n];
            d2 += d3 * d3;
        }
        double d4 = nArray.length;
        double d5 = d4 * (d4 * d4 - 1.0);
        d2 = 6.0 * d2 / d5;
        return 1.0 - d2;
    }

    public static final double cosine(Vector vector, Vector vector2) {
        return XMath.cosine(vector.elementData, vector2.elementData);
    }

    public static final double cosine(float[] fArray, float[] fArray2) {
        XMath.enforceEqualSize(fArray, fArray2);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            d2 += (double)(fArray[i2] * fArray[i2]);
            d3 += (double)(fArray2[i2] * fArray2[i2]);
            d4 += (double)(fArray[i2] * fArray2[i2]);
        }
        return 1.0 - d4 / Math.sqrt(d2 * d3);
    }

    public static final double s2n(Vector vector, Vector vector2, boolean bl, boolean bl2, boolean bl3) {
        double d2 = bl2 ? (vector.median() - vector2.median()) / (vector.stddev(bl, bl3) + vector2.stddev(bl, bl3)) : (vector.mean() - vector2.mean()) / (vector.stddev(bl, bl3) + vector2.stddev(bl, bl3));
        return d2;
    }

    public static final double tTest(Vector vector, Vector vector2, boolean bl, boolean bl2, boolean bl3) {
        double d2 = bl2 ? vector.median() - vector2.median() : vector.mean() - vector2.mean();
        double d3 = bl ? Math.sqrt(vector.var(bl, bl3) / (double)(vector.getSize() - 1) + vector2.var(bl, bl3) / (double)(vector2.getSize() - 1)) : Math.sqrt(vector.var(bl, bl3) / (double)vector.getSize() + vector2.var(bl, bl3) / (double)vector2.getSize());
        return d2 / d3;
    }

    public static final double bhat(Vector vector, Vector vector2, boolean bl, boolean bl2) {
        double d2 = (vector2.mean() - vector.mean()) * (0.5 / (vector.var(bl, bl2) + vector2.var(bl, bl2))) * (vector2.mean() - vector.mean());
        double d3 = 0.5 * Math.log((vector.var(bl, bl2) + vector2.var(bl, bl2)) / 2.0 / Math.sqrt(vector.var(bl, bl2) * vector2.var(bl, bl2)));
        return d2 + d3;
    }

    public static final double pearsonD(Vector vector, Vector vector2) {
        XMath.enforceEqualSize(vector, vector2);
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            if (vector.getElement(i2) == -1.0f && vector.getElement(i2) == 1.0f) continue;
            throw new IllegalArgumentException("MinusPlus vector has invalid element: " + vector.getElement(i2) + " only -1 and +1 allowed");
        }
        Vector vector3 = new Vector(vector2);
        vector3.pnormalize();
        return 1.0 - XMath.pearson(vector, vector3);
    }

    public static final double mannWhitney(int[] nArray, int n) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            d2 += (double)nArray[i2];
        }
        double d3 = nArray.length;
        double d4 = d2 / d3;
        double d5 = n * (n - 1) / 2;
        double d6 = n;
        double d7 = (d5 - d2) / (d6 - d3);
        double d8 = d4 - d7;
        return -1.0 * d8;
    }

    public static final double maxAbsDiff(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("cdf's must be of equal length -- a: " + dArray.length + " b: " + dArray2.length);
        }
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = Math.abs(dArray[i2] - dArray2[i2]);
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static final float getSignificanceLevel(SortMode sortMode, Order order, Vector vector, float f2) {
        if (vector.getSize() == 0) {
            return Float.NaN;
        }
        vector.sort(sortMode, order);
        int n = (int)(f2 * (float)vector.getSize());
        return vector.getElement(n);
    }

    public static final float getSignificanceLevelASIS(Vector vector, float f2) {
        if (vector.getSize() == 0) {
            return Float.NaN;
        }
        int n = (int)(f2 * (float)vector.getSize());
        return vector.getElement(n);
    }

    public static final double hypergeometric(int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid hypergeometric k < 0: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid hypergeometric N <= 0: " + n2);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid hypergeometric n < 0: " + n4);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid hypergeometric K < 0: " + n3);
        }
        if (n3 > n2) {
            throw new IllegalArgumentException("Invalid hypergeometric r > n " + n3 + " " + n2);
        }
        if (n4 > n2) {
            throw new IllegalArgumentException("Invalid hypergeometric m > n: " + n4 + " " + n2);
        }
        if (n4 > n2 / 2) {
            n4 = n2 - n4;
            n = n3 - n;
        }
        if (n3 > n2 / 2) {
            n3 = n2 - n3;
            n = n4 - n;
        }
        if (n4 > n3) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        if (n < n4 + n3 - n2 || n > n4) {
            return 0.0;
        }
        if (n3 == n2) {
            if (n == n4) {
                return 1.0;
            }
            return 0.0;
        }
        if (n3 == n2 - 1) {
            if (n == n4) {
                return (double)(n2 - n4) / (double)n2;
            }
            if (n == n4 - 1) {
                return (double)n4 / (double)n2;
            }
            return 0.0;
        }
        if (n4 == 1) {
            if (n == 0) {
                return (double)(n2 - n3) / (double)n2;
            }
            if (n == 1) {
                return (double)n3 / (double)n2;
            }
            return 0.0;
        }
        if (n4 == 0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (n == 0) {
            double d2 = 1.0;
            for (int i2 = 0; i2 < n4; ++i2) {
                d2 *= (double)(n2 - n3 - i2);
                d2 /= (double)(n2 - i2);
            }
            return d2;
        }
        double d3 = 1.0;
        int n6 = n2 - n3;
        int n7 = n2;
        while (n6 > n2 - n3 - (n4 - n)) {
            d3 *= (double)n6;
            d3 /= (double)n7;
            --n6;
            --n7;
        }
        for (n6 = 0; n6 < n; ++n6) {
            d3 *= (double)(n4 - n6);
            d3 /= (double)(n2 - (n4 - n6) + 1);
            d3 *= (double)(n3 - n6);
            d3 /= (double)(n6 + 1);
        }
        return d3;
    }

    public static final double oneTailedFishersExact(int n, int n2, int n3, int n4) {
        if (n < 0 || n < n4 + n3 - n2 || n > n3 || n > n4 || n3 > n2 || n4 > n2) {
            throw new IllegalArgumentException("Invalid Fisher's exact: k=" + n + " n=" + n2 + " r=" + n3 + " m=" + n4 + " k<0=" + (n < 0) + " k<(m+r)-n=" + (n < n4 + n3 - n2) + " k>r=" + (n > n3) + " k>m=" + (n > n4) + " r>n=" + (n3 > n2) + "m>n=" + (n4 > n2));
        }
        if (n4 > n2 / 2) {
            n4 = n2 - n4;
            n = n3 - n;
        }
        if (n3 > n2 / 2) {
            n3 = n2 - n3;
            n = n4 - n;
        }
        if (n4 > n3) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        double d2 = 0.0;
        if (n > n4 / 2) {
            for (int i2 = n; i2 <= n4; ++i2) {
                d2 += XMath.hypergeometric(i2, n2, n3, n4);
            }
        } else {
            int n6;
            for (int i3 = n6 = Math.max(0, n4 + n3 - n2); i3 < n; ++i3) {
                d2 += XMath.hypergeometric(i3, n2, n3, n4);
            }
            d2 = 1.0 - d2;
        }
        return d2;
    }

    public static final double chiSquare2by2(int n, int n2, int n3, int n4) {
        int[][] nArrayArray = new int[][]{{n, n3 - n}, {n4 - n, n2 - (n + (n3 - n) + (n4 - n))}};
        int[] nArray = new int[]{n3, n2 - n3};
        int[] nArray2 = new int[]{n4, n2 - n4};
        double d2 = 0.0;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 2; ++i3) {
                double d3 = (double)nArray[i2] * (double)nArray2[i3] / (double)n2;
                d2 += ((double)nArrayArray[i2][i3] - d3) * ((double)nArrayArray[i2][i3] - d3) / d3;
            }
        }
        return d2;
    }

    public static final int Minimum(int n, int n2, int n3) {
        int n4 = n;
        if (n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        return n4;
    }

    public static final int levenshtein(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c2 = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c3 = string2.charAt(n - 1);
                int n5 = c2 == c3 ? 0 : 1;
                nArray[n2][n] = XMath.Minimum(nArray[n2 - 1][n] + 1, nArray[n2][n - 1] + 1, nArray[n2 - 1][n - 1] + n5);
            }
        }
        return nArray[n3][n4];
    }

    public static final int getMoreThanCount(float f2, Vector vector) {
        int n = 0;
        for (int i2 = 0; i2 < vector.getSize() && !(f2 > vector.getElement(i2)); ++i2) {
            ++n;
        }
        return n;
    }

    public static final int getLessThanCount(float f2, Vector vector) {
        int n = 0;
        for (int i2 = 0; i2 < vector.getSize() && !(f2 < vector.getElement(i2)); ++i2) {
            ++n;
        }
        return n;
    }

    public static final StringMatrix median(StringDataframe[] stringDataframeArray) {
        StringMatrix[] stringMatrixArray = new StringMatrix[stringDataframeArray.length];
        for (int i2 = 0; i2 < stringDataframeArray.length; ++i2) {
            stringMatrixArray[i2] = stringDataframeArray[i2].getMatrix();
        }
        return XMath.median(stringMatrixArray);
    }

    public static final Matrix median(Dataset[] datasetArray) {
        Matrix[] matrixArray = new Matrix[datasetArray.length];
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            matrixArray[i2] = datasetArray[i2].getMatrix();
        }
        return XMath.median(matrixArray);
    }

    public static final StringMatrix stdev(StringDataframe[] stringDataframeArray) {
        StringMatrix[] stringMatrixArray = new StringMatrix[stringDataframeArray.length];
        for (int i2 = 0; i2 < stringDataframeArray.length; ++i2) {
            stringMatrixArray[i2] = stringDataframeArray[i2].getMatrix();
        }
        return XMath.stdev(stringMatrixArray);
    }

    public static final StringMatrix median(StringMatrix[] stringMatrixArray) {
        if (stringMatrixArray.length == 0) {
            throw new IllegalArgumentException("Cannot median 0 sms");
        }
        StringMatrix stringMatrix = new StringMatrix(stringMatrixArray[0].getNumRow(), stringMatrixArray[0].getNumCol());
        for (int i2 = 0; i2 < stringMatrix.getNumCol(); ++i2) {
            for (int i3 = 0; i3 < stringMatrix.getNumRow(); ++i3) {
                TFloatArrayList tFloatArrayList = new TFloatArrayList();
                for (int i4 = 0; i4 < stringMatrixArray.length; ++i4) {
                    float f2 = Float.parseFloat(stringMatrixArray[i4].getElement(i3, i2));
                    tFloatArrayList.add(f2);
                }
                Vector vector = new Vector(tFloatArrayList);
                stringMatrix.setElement(i3, i2, (float)vector.median());
            }
        }
        return stringMatrix;
    }

    public static final Matrix median(Matrix[] matrixArray) {
        if (matrixArray.length == 0) {
            throw new IllegalArgumentException("Cannot median 0 mss");
        }
        Matrix matrix = new Matrix(matrixArray[0].getNumRow(), matrixArray[0].getNumCol());
        for (int i2 = 0; i2 < matrix.getNumCol(); ++i2) {
            for (int i3 = 0; i3 < matrix.getNumRow(); ++i3) {
                TFloatArrayList tFloatArrayList = new TFloatArrayList();
                for (int i4 = 0; i4 < matrixArray.length; ++i4) {
                    float f2 = matrixArray[i4].getElement(i3, i2);
                    tFloatArrayList.add(f2);
                }
                Vector vector = new Vector(tFloatArrayList);
                matrix.setElement(i3, i2, (float)vector.median());
            }
        }
        return matrix;
    }

    public static final StringMatrix stdev(StringMatrix[] stringMatrixArray) {
        if (stringMatrixArray.length == 0) {
            throw new IllegalArgumentException("Cannot median 0 sms");
        }
        StringMatrix stringMatrix = new StringMatrix(stringMatrixArray[0].getNumRow(), stringMatrixArray[0].getNumCol());
        for (int i2 = 0; i2 < stringMatrix.getNumCol(); ++i2) {
            for (int i3 = 0; i3 < stringMatrix.getNumRow(); ++i3) {
                TFloatArrayList tFloatArrayList = new TFloatArrayList();
                for (int i4 = 0; i4 < stringMatrixArray.length; ++i4) {
                    float f2 = Float.parseFloat(stringMatrixArray[i4].getElement(i3, i2));
                    tFloatArrayList.add(f2);
                }
                Vector vector = new Vector(tFloatArrayList);
                stringMatrix.setElement(i3, i2, (float)vector.stddev(false, false));
            }
        }
        return stringMatrix;
    }
}

