/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.MSigDB;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class MSigDBModel
extends AbstractTableModel {
    private final Logger log = XLogger.getLogger(MSigDBModel.class);
    private MSigDB fMSigDB;
    public static final int COL_PUBMEDID = 10;
    private static String[] COL_NAMES = new String[]{"", "NAME", "# GENES", "DESCRIPTION", "COLLECTION", "ORGANISM", "CHIP", "CONTRIBUTER", "PUBMED ID", "EXTERNAL URL"};

    public MSigDBModel(MSigDB mSigDB) {
        if (mSigDB == null) {
            throw new IllegalArgumentException("Param msigdb cannot be null");
        }
        this.fMSigDB = mSigDB;
    }

    public final MSigDB getMSigDB() {
        return this.fMSigDB;
    }

    @Override
    public final int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public final int getRowCount() {
        return this.fMSigDB.getNumGeneSets();
    }

    @Override
    public final String getColumnName(int n) {
        return COL_NAMES[n];
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        GeneSetAnnotation geneSetAnnotation = this.fMSigDB.getGeneSetAnnotation(n);
        if (n2 == 0) {
            return "" + (n + 1);
        }
        if (n2 == 1) {
            return geneSetAnnotation.getStandardName();
        }
        if (n2 == 2) {
            return "" + geneSetAnnotation.getGeneSet(true).getNumMembers();
        }
        if (n2 == 3) {
            return geneSetAnnotation.getDescription().getBrief();
        }
        if (n2 == 4) {
            return geneSetAnnotation.getCategory().getName();
        }
        if (n2 == 5) {
            return geneSetAnnotation.getOrganism().toString();
        }
        if (n2 == 6) {
            return geneSetAnnotation.getChipOriginal_name();
        }
        if (n2 == 7) {
            return geneSetAnnotation.getContributor().getName();
        }
        if (n2 == 8) {
            return geneSetAnnotation.getExternalLinks().getPMID();
        }
        if (n2 == 9) {
            return geneSetAnnotation.getExternalLinks().getExtDetailsURL();
        }
        return "huh";
    }

    public final Class getColumnClass(int n) {
        Class clazz = n == 0 || n == 3 ? Integer.class : String.class;
        return clazz;
    }

    public final boolean isEditable() {
        return false;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return false;
    }
}

