/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class GeneSetMatrixHelper {
    private GeneSetMatrixHelper() {
    }

    static final GeneSet[] getGeneSets(GeneSetMatrix geneSetMatrix, int n, int n2) {
        List list = GeneSetMatrixHelper.getGeneSetsL(geneSetMatrix, n, n2);
        return list.toArray(new GeneSet[list.size()]);
    }

    static final List getGeneSetsL(GeneSetMatrix geneSetMatrix, int n, int n2) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            GeneSet geneSet = geneSetMatrix.getGeneSet(i2);
            if (geneSet.getNumMembers() < n || geneSet.getNumMembers() > n2) continue;
            arrayList.add(geneSet);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static final int getMaxMemberCount(List list) {
        int n = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneSet geneSet = (GeneSet)list.get(i2);
            if (n >= geneSet.getNumMembers()) continue;
            n = geneSet.getNumMembers();
        }
        return n;
    }

    static final String[] getAllMemberNames(List list) {
        Set set = GeneSetMatrixHelper.getAllMemberNamesS(list);
        return set.toArray(new String[set.size()]);
    }

    static final Set getAllMemberNamesS(List list) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneSet geneSet = (GeneSet)list.get(i2);
            hashSet.addAll(geneSet.getMembers());
        }
        return hashSet;
    }

    static final List getAllMemberNameOccurrencesL(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneSet geneSet = (GeneSet)list.get(i2);
            arrayList.addAll(geneSet.getMembers());
        }
        return arrayList;
    }

    static final String[] getAllMemberNameOccurrences(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            GeneSet geneSet = (GeneSet)list.get(i2);
            arrayList.addAll(geneSet.getMembers());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static final String[] getAllGeneSetNames(GeneSetMatrix geneSetMatrix) {
        String[] stringArray = new String[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            stringArray[i2] = geneSetMatrix.getGeneSet(i2).getName();
        }
        return stringArray;
    }

    static final String[] getGeneSetMembershipNames(String string, GeneSetMatrix geneSetMatrix) {
        GeneSet[] geneSetArray = GeneSetMatrixHelper.getGeneSetMemberships(string, geneSetMatrix);
        String[] stringArray = new String[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            stringArray[i2] = geneSetArray[i2].getName();
        }
        return stringArray;
    }

    static final BitSet getGeneSetMembershipBitSet(String string, GeneSetMatrix geneSetMatrix) {
        BitSet bitSet = new BitSet(geneSetMatrix.getNumGeneSets());
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            if (!geneSetMatrix.getGeneSet(i2).isMember(string)) continue;
            bitSet.set(i2, true);
        }
        return bitSet;
    }

    static final BitSetDataset getGeneSetMembershipBitSetDataset(String string, String[] stringArray, GeneSetMatrix geneSetMatrix) {
        BitSet[] bitSetArray = new BitSet[stringArray.length];
        for (int i2 = 0; i2 < bitSetArray.length; ++i2) {
            bitSetArray[i2] = GeneSetMatrixHelper.getGeneSetMembershipBitSet(stringArray[i2], geneSetMatrix);
        }
        return new BitSetDataset(string, bitSetArray, stringArray, geneSetMatrix.getGeneSetNames(true), true);
    }

    static final BitSetDataset getGeneSetMembershipBitSetDataset(GeneSetMatrix geneSetMatrix) {
        return GeneSetMatrixHelper.getGeneSetMembershipBitSetDataset(geneSetMatrix.getName(), geneSetMatrix.getAllMemberNamesOnlyOnce(), geneSetMatrix);
    }

    static final GeneSet[] getGeneSetMemberships(String string, GeneSetMatrix geneSetMatrix) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            if (!geneSetMatrix.getGeneSet(i2).isMember(string)) continue;
            arrayList.add(geneSetMatrix.getGeneSet(i2));
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    static final GeneSet[] getGeneSets(Set set, GeneSetMatrix geneSetMatrix) {
        GeneSet[] geneSetArray = new GeneSet[set.size()];
        int n = 0;
        for (Object e2 : set) {
            geneSetArray[n++] = geneSetMatrix.getGeneSet(e2.toString());
        }
        return geneSetArray;
    }

    static final GeneSetMatrix getGeneSetMatrix(GeneSet geneSet, GeneSetMatrix geneSetMatrix) {
        if (geneSet == null || geneSet.getNumMembers() == 0) {
            throw new IllegalArgumentException("Param gsetNames cannot be null or empty " + geneSet);
        }
        GeneSet[] geneSetArray = new GeneSet[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            geneSetArray[i2] = geneSetMatrix.getGeneSet(geneSet.getMember(i2));
        }
        return new DefaultGeneSetMatrix(geneSet.getName(true), geneSetArray);
    }

    static final GeneSet[] getGeneSets(String[] stringArray, GeneSetMatrix geneSetMatrix) {
        GeneSet[] geneSetArray = new GeneSet[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            geneSetArray[i2] = geneSetMatrix.getGeneSet(stringArray[i2]);
        }
        return geneSetArray;
    }
}

