/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath$Const;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetPair;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;
import java.util.List;

public class RankedListJITImpl
extends AbstractObject
implements RankedList {
    private File fRlFile;
    private RankedList fRl;
    private boolean fUseCache;

    public RankedListJITImpl(File file, boolean bl) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("rlFile doesnt not exist: " + file);
        }
        super.initialize(file.getName());
        this.fUseCache = bl;
        this.fRlFile = file;
    }

    private RankedList _rl() {
        try {
            if (this.fRl == null) {
                this.fRl = ParserFactory.readRankedList(this.fRlFile, this.fUseCache);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.fRl;
    }

    @Override
    public final RankedList cloneShallowRL(String string) {
        return this._rl().cloneShallowRL(string);
    }

    @Override
    public final String getQuickInfo() {
        return this._rl().getQuickInfo();
    }

    @Override
    public final boolean isMember(String string) {
        return this._rl().isMember(string);
    }

    @Override
    public final String getRankName(int n) {
        return this._rl().getRankName(n);
    }

    @Override
    public final List getRankedNames() {
        return this._rl().getRankedNames();
    }

    @Override
    public final String[] getRankedNamesArray() {
        return this._rl().getRankedNamesArray();
    }

    @Override
    public final float getValue(String string, XMath$Const xMath$Const) {
        if (xMath$Const.isScore()) {
            return this.getScore(string);
        }
        return this.getRank(string);
    }

    @Override
    public final int getRank(String string) {
        return this._rl().getRank(string);
    }

    @Override
    public final String toString(char c2) {
        return this._rl().toString(c2);
    }

    @Override
    public final Vector getScoresV(boolean bl) {
        return this._rl().getScoresV(bl);
    }

    @Override
    public final float getScore(int n) {
        return this._rl().getScore(n);
    }

    @Override
    public final float getScore(String string) {
        return this._rl().getScore(string);
    }

    @Override
    public final float[] getScores(GeneSet geneSet) {
        return this._rl().getScores(geneSet);
    }

    @Override
    public final int[] getRanks(GeneSet geneSet) {
        return this._rl().getRanks(geneSet);
    }

    @Override
    public final Vector getRanksV(GeneSet geneSet) {
        return this._rl().getRanksV(geneSet);
    }

    @Override
    public final RankedList extractRanked(GeneSet geneSet) {
        return this._rl().extractRanked(geneSet);
    }

    @Override
    public final RankedList extractRanked(String[] stringArray) {
        return this._rl().extractRanked(stringArray);
    }

    @Override
    public final RankedList extractRanked(List list) {
        return this._rl().extractRanked(list);
    }

    @Override
    public final GeneSet toGeneSet() {
        return this._rl().toGeneSet();
    }

    @Override
    public final String toString(char c2, boolean bl) {
        return this._rl().toString(c2, bl);
    }

    @Override
    public final int getSize() {
        return this._rl().getSize();
    }

    @Override
    public final int getSize(ScoreMode scoreMode) {
        return this._rl().getSize(scoreMode);
    }

    @Override
    public final List getNamesOfUpOrDnXRanks(int n, boolean bl) {
        return this._rl().getNamesOfUpOrDnXRanks(n, bl);
    }

    @Override
    public final String[] getNamesOfUpOrDnXRanks_array(int n, boolean bl) {
        return this._rl().getNamesOfUpOrDnXRanks_array(n, bl);
    }

    @Override
    public final GeneSet getNamesOfUpOrDnXRanks_gs(int n, boolean bl) {
        return this._rl().getNamesOfUpOrDnXRanks_gs(n, bl);
    }

    @Override
    public final GeneSetPair getNamesOfUpAndDnXRanks(int n) {
        return this._rl().getNamesOfUpAndDnXRanks(n);
    }

    @Override
    public final RankedList extractRanked(int n) {
        return this._rl().extractRanked(n);
    }

    @Override
    public final RankedList extractRanked(int n, boolean bl) {
        return this._rl().extractRanked(n, bl);
    }

    @Override
    public final RankedList extractRanked(float f2, float f3) {
        return this._rl().extractRanked(f2, f3);
    }

    @Override
    public final int getNumScores(float f2, float f3) {
        return this._rl().getNumScores(f2, f3);
    }

    @Override
    public final GeneSet getScores_gs(float f2, float f3) {
        return this._rl().getScores_gs(f2, f3);
    }

    @Override
    public final MetricWeightStruc getMetricWeightStruc() {
        return this._rl().getMetricWeightStruc();
    }

    @Override
    public final RankedList extractRanked(ScoreMode scoreMode) {
        return this._rl().extractRanked(scoreMode);
    }
}

