/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.IDataframe$Helper;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringDataframe
extends AbstractObject
implements IDataframe {
    protected StringMatrix fMatrix;
    protected List fRowNames;
    protected List fColNames;
    private String fRowLabelName;

    public StringDataframe(String string, StringMatrix stringMatrix, List list, List list2, boolean bl) {
        this(string, stringMatrix, list, list2, bl, bl, bl);
    }

    public final StringDataframe cloneShallow(String string) {
        super.setName(string);
        return this;
    }

    public final StringDataframe cloneDeep_probes_to_genes(Chip chip) {
        StringMatrix stringMatrix = new StringMatrix(this.getNumRow(), this.getNumCol() + 2);
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            int n = 0;
            stringMatrix.setElement(i2, n++, chip.getSymbol(this.getRowName(i2), Chip.REPLACE_WITH_PROBEID));
            stringMatrix.setElement(i2, n++, chip.getTitle(this.getRowName(i2), Chip.REPLACE_WITH_PROBEID));
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                stringMatrix.setElement(i2, n++, this.getElement(i2, i3));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("GENE");
        arrayList.add("TITLE ");
        arrayList.addAll(this.getColumnNames());
        return new StringDataframe(this.getName() + "_" + chip.getName(), stringMatrix, this.getRowNames(), arrayList, true);
    }

    public final StringDataframe cloneDeep_uppercase() {
        StringMatrix stringMatrix = this.fMatrix.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>(this.fRowNames);
        for (int i2 = 0; i2 < this.fRowNames.size(); ++i2) {
            Object e2 = this.fRowNames.get(i2);
            if (e2 == null) {
                throw new IllegalStateException("Row name is null: " + e2 + " at: " + i2 + "\n" + this.fRowNames);
            }
            arrayList.set(i2, e2.toString().toUpperCase());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(this.fColNames);
        for (int i3 = 0; i3 < this.fColNames.size(); ++i3) {
            arrayList2.set(i3, this.fColNames.get(i3).toString().toUpperCase());
        }
        StringDataframe stringDataframe = new StringDataframe(this.getName(), stringMatrix, arrayList, arrayList2, true);
        if (this.fRowLabelName != null) {
            stringDataframe.fRowLabelName = this.fRowLabelName.toUpperCase();
        }
        return stringDataframe;
    }

    public final StringDataframe cloneDeep_by_row_names(GeneSet geneSet, boolean bl) {
        return this.cloneDeep_by_row_names(geneSet.getMembersArray(), bl);
    }

    public final StringDataframe cloneDeep_by_row_names(List list, boolean bl) {
        return this.cloneDeep_by_row_names(list.toArray(new String[list.size()]), bl);
    }

    public final StringDataframe cloneDeep_by_row_names(String[] stringArray, boolean bl) {
        StringMatrix stringMatrix = new StringMatrix(stringArray.length, this.getNumCol());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n = this.getRowIndex(string);
            if (n == -1 && bl) {
                throw new RuntimeException("No row in sdf for name: " + string);
            }
            if (n == -1) continue;
            stringMatrix.setRow(i2, this.getRow(n));
        }
        return new StringDataframe(this.getName() + "_" + stringArray.length, stringMatrix, stringArray, this.getColumnNamesArray(), false);
    }

    public StringDataframe(String string, StringMatrix stringMatrix, String[] stringArray, String[] stringArray2, boolean bl) {
        this(string, stringMatrix, StringDataframe.toList(stringArray), StringDataframe.toList(stringArray2), bl, bl, bl);
    }

    public StringDataframe(String string, StringDataframe[] stringDataframeArray) {
        this(string, new StringMatrix(StringDataframe.extractMatrices(stringDataframeArray)), StringDataframe.extractRowNames(stringDataframeArray), stringDataframeArray[0].getColumnNames(), true);
    }

    public StringDataframe(String string, List list) {
        this(string, new StringMatrix(StringDataframe.extractMatrices(list)), StringDataframe.extractRowNames(list), ((StringDataframe)list.get(0)).getColumnNames(), true);
    }

    public StringDataframe(Dataset dataset) {
        this.init(dataset.getName(), new StringMatrix(dataset.getMatrix()), dataset.getRowNames(), dataset.getColumnNames());
    }

    public StringDataframe(String string, LabelledVector[] labelledVectorArray, boolean bl, int n) {
        if (labelledVectorArray == null) {
            throw new IllegalArgumentException("Param lvs cannot be null");
        }
        if (labelledVectorArray.length == 0) {
            throw new IllegalArgumentException("Param lvs cannot be 0 length array: " + labelledVectorArray.length);
        }
        if (bl) {
            if (labelledVectorArray.length == 0) {
                throw new IllegalArgumentException("Zero length lvs not allowed: " + labelledVectorArray.length);
            }
            List list = labelledVectorArray[0].getLabels();
            int n2 = labelledVectorArray[0].getSize();
            StringMatrix stringMatrix = new StringMatrix(list.size(), labelledVectorArray.length);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
                if (labelledVectorArray[i2].getSize() != n2) {
                    throw new IllegalArgumentException("UNequal length lvs: " + labelledVectorArray[i2].getSize() + " expecting: " + n2 + " at index pos: " + i2);
                }
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    stringMatrix.setElement(i3, i2, Printf.format(labelledVectorArray[i2].getScore(list.get(i3).toString()), n));
                }
                arrayList.add(labelledVectorArray[i2].getName());
            }
            this.init(string, stringMatrix, list, arrayList);
        } else {
            if (labelledVectorArray.length == 0) {
                throw new IllegalArgumentException("Zero length lvs not allowed: " + labelledVectorArray.length);
            }
            LabelledVector labelledVector = LabelledVector.getMaxSize_lv(labelledVectorArray);
            int n3 = labelledVector.getSize();
            List list = labelledVector.getLabels();
            StringMatrix stringMatrix = new StringMatrix(n3, labelledVectorArray.length);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i4 = 0; i4 < labelledVectorArray.length; ++i4) {
                for (int i5 = 0; i5 < n3; ++i5) {
                    String string2 = (String)list.get(i5);
                    if (labelledVectorArray[i4].isMember(string2)) {
                        stringMatrix.setElement(i5, i4, Printf.format(labelledVectorArray[i4].getScore(string2), n));
                        continue;
                    }
                    stringMatrix.setElement(i5, i4, "na");
                }
                arrayList.add(labelledVectorArray[i4].getName());
            }
            this.init(string, stringMatrix, list, arrayList);
        }
    }

    public StringDataframe(String string, LabelledVector[] labelledVectorArray) {
        if (labelledVectorArray == null) {
            throw new IllegalArgumentException("Param lvs cannot be null");
        }
        if (labelledVectorArray.length == 0) {
            throw new IllegalArgumentException("Param lvs cannot be 0 length array: " + labelledVectorArray.length);
        }
        if (labelledVectorArray.length == 0) {
            throw new IllegalArgumentException("Zero length lvs not allowed: " + labelledVectorArray.length);
        }
        LabelledVector labelledVector = LabelledVector.getMaxSize_lv(labelledVectorArray);
        int n = labelledVector.getSize();
        StringMatrix stringMatrix = new StringMatrix(n, labelledVectorArray.length * 2);
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = labelledVector.getLabels();
        int n2 = 0;
        for (int i2 = 0; i2 < labelledVectorArray.length; ++i2) {
            stringMatrix.setColumn(n2++, labelledVectorArray[i2].getLabels(), true);
            stringMatrix.setColumn(n2++, labelledVectorArray[i2].getScoresV(false), true);
            arrayList.add(labelledVectorArray[i2].getName());
            arrayList.add(labelledVectorArray[i2].getName() + "_score");
        }
        this.init(string, stringMatrix, list, arrayList);
    }

    public StringDataframe(String string, StringMatrix stringMatrix, String[] stringArray, boolean bl) {
        this(string, stringMatrix, StringDataframe.createSeriesStrings(0, stringMatrix.getNumRow(), "row_"), StringDataframe.toList(stringArray), bl, bl, bl);
    }

    public StringDataframe(String string, StringMatrix stringMatrix, List list, boolean bl) {
        this(string, stringMatrix, StringDataframe.createSeriesStrings(0, stringMatrix.getNumRow(), "row_"), list, bl, true, bl);
    }

    public StringDataframe(String string, StringMatrix stringMatrix, boolean bl) {
        this(string, stringMatrix, StringDataframe.createSeriesStrings(0, stringMatrix.getNumRow()), StringDataframe.createSeriesStrings(0, stringMatrix.getNumCol(), "col_"), bl, true, true);
    }

    public StringDataframe(String string, StringMatrix stringMatrix, List arrayList, List arrayList2, boolean bl, boolean bl2, boolean bl3) {
        if (stringMatrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (arrayList == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        if (arrayList2 == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        StringMatrix stringMatrix2 = bl ? stringMatrix : stringMatrix.cloneDeep();
        ArrayList arrayList3 = bl2 ? arrayList : new ArrayList(arrayList);
        ArrayList arrayList4 = bl3 ? arrayList2 : new ArrayList(arrayList2);
        this.init(string, stringMatrix2, arrayList3, arrayList4);
    }

    public StringDataframe(String string, List[] listArray, String[] stringArray) {
        int n;
        if (listArray == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            if (n2 >= listArray[i2].size()) continue;
            n2 = listArray[i2].size();
        }
        StringMatrix stringMatrix = new StringMatrix(n2, listArray.length);
        for (int i3 = 0; i3 < listArray.length; ++i3) {
            for (n = 0; n < listArray[i3].size(); ++n) {
                stringMatrix.setElement(n, i3, listArray[i3].get(n).toString());
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            arrayList.add("row_" + (n + 1));
        }
        this.init(string, stringMatrix, arrayList, Arrays.asList(stringArray));
    }

    public StringDataframe(String string, RankedList[] rankedListArray) {
        int n = AlgUtils.getMaxSize(rankedListArray);
        List list = StringDataframe.createSeriesStrings(0, n, "row_");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringMatrix stringMatrix = new StringMatrix(n, rankedListArray.length * 2);
        int n2 = 0;
        for (int i2 = 0; i2 < rankedListArray.length; ++i2) {
            arrayList.add(rankedListArray[i2].getName());
            arrayList.add(rankedListArray[i2].getName() + "_SCORE");
            stringMatrix.setColumn(n2++, StringDataframe.buffer(rankedListArray[i2].getRankedNames(), n));
            stringMatrix.setColumn(n2++, StringDataframe.buffer(rankedListArray[i2].getScoresV(false), n));
        }
        this.init(string, stringMatrix, list, arrayList);
    }

    private static String[] buffer(List list, int n) {
        String[] stringArray = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = i2 < list.size() ? list.get(i2).toString() : "";
        }
        return stringArray;
    }

    private static Vector buffer(Vector vector, int n) {
        Vector vector2 = new Vector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 < vector.getSize()) {
                vector2.setElement(i2, vector.getElement(i2));
                continue;
            }
            vector2.setElement(i2, Float.NaN);
        }
        return vector2;
    }

    public StringDataframe(String string, StringMatrix stringMatrix, List list, String[] stringArray, boolean bl, boolean bl2) {
        this(string, stringMatrix, list, StringDataframe.toList(stringArray), bl, bl2, true);
    }

    public StringDataframe(String string, List list, List arrayList, boolean bl) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        StringMatrix stringMatrix;
        int n;
        if (arrayList.size() != list.size()) {
            throw new IllegalArgumentException("Mismatched sizes: " + arrayList.size() + " and " + list.size());
        }
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) == null) continue;
            if (!(list.get(n) instanceof String[])) {
                throw new IllegalArgumentException("List elements must all be String[] objects");
            }
            String[] stringArray = (String[])list.get(n);
            if (n2 >= stringArray.length) continue;
            n2 = stringArray.length;
        }
        if (bl) {
            int n3;
            n = list.size();
            int n4 = n2;
            stringMatrix = new StringMatrix(n, n4);
            for (n3 = 0; n3 < n; ++n3) {
                stringMatrix.setRow(n3, (String[])list.get(n3));
            }
            arrayList3 = new ArrayList<String>();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayList3.add(n3 + "");
            }
            arrayList2 = arrayList;
        } else {
            int n5;
            int n6 = list.size();
            n = n2;
            stringMatrix = new StringMatrix(n, n6);
            for (n5 = 0; n5 < n6; ++n5) {
                String[] stringArray = (String[])list.get(n5);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringMatrix.setElement(i2, n5, stringArray[i2]);
                }
            }
            arrayList3 = arrayList;
            arrayList2 = new ArrayList<String>();
            for (n5 = 0; n5 < n; ++n5) {
                arrayList2.add(n5 + "");
            }
        }
        this.init(string, stringMatrix, arrayList2, arrayList3);
    }

    protected final void init(String string, StringMatrix stringMatrix, List list, List list2) {
        super.initialize(string);
        if (stringMatrix.getNumRow() != list.size()) {
            throw new IllegalArgumentException("Matrix: " + stringMatrix.getNumRow() + " and rowNames: " + list.size() + " do not match in size");
        }
        if (stringMatrix.getNumCol() != list2.size()) {
            throw new IllegalArgumentException("Matrix: " + stringMatrix.getNumCol() + " and colNames: " + list2.size() + " do not match in size");
        }
        if (stringMatrix.getNumCol() == 0) {
            this.log.warn("zero cols in StringMatrix");
        }
        if (stringMatrix.getNumRow() == 0) {
            this.log.debug("zero rows in StringMatrix");
        }
        this.fMatrix = stringMatrix;
        this.fMatrix.setImmutable();
        this.fRowNames = list;
        this.fColNames = list2;
    }

    public final String[] getRow(int n) {
        return this.fMatrix.getRow(n);
    }

    public final String[] getRow(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter rowName cannot be null");
        }
        int n = this.getRowIndex(string);
        if (n == -1) {
            n = this.getRowIndex(AuxUtils.getAuxNameOnlyNoHash(string));
        }
        if (n == -1) {
            throw new IllegalArgumentException("No such row name: " + string + "\nRow Names are: " + Printf.outs(this.getRowNames()));
        }
        return this.getRow(n);
    }

    public final String[] getColumn(int n) {
        return this.fMatrix.getColumn(n);
    }

    public final boolean hasColumn(String string) {
        int n = this.getColumnIndex(string);
        return n != -1;
    }

    public final String[] getColumn(String string) {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            throw new IllegalArgumentException("No such column: >" + string + "<");
        }
        return this.fMatrix.getColumn(n);
    }

    @Override
    public final String[] getColumnAsStrings(int n) {
        return IDataframe$Helper.getColumnAsStrings((IDataframe)this, n);
    }

    @Override
    public final String[] getColumnAsStrings(String string) {
        return IDataframe$Helper.getColumnAsStrings((IDataframe)this, string);
    }

    public final Vector getColumnAsVector(String string, boolean bl) {
        return this.getColumnAsVector(this.getColumnIndex(string), bl);
    }

    public final Vector getColumnAsVector(int n, boolean bl) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            String string = this.getElement(i2, n);
            if (string == null && bl) continue;
            if (string == null && !bl) {
                tFloatArrayList.add(Float.NaN);
                continue;
            }
            tFloatArrayList.add(Float.parseFloat(string));
        }
        return new Vector(tFloatArrayList);
    }

    public final LabelledVector getColumnAsLV(int n) {
        return new LabelledVector("col_" + n, this.getRowNamesArray(), this.getColumnAsVector(n, false));
    }

    public final LabelledVector getColumnAsLV(String string) {
        return new LabelledVector(string, this.getRowNamesArray(), this.getColumnAsVector(string, false));
    }

    public final RankedList getColumnAsRL(String string) {
        return new LabelledVector(string, this.getRowNamesArray(), this.getColumnAsVector(string, false)).sort(SortMode.REAL, Order.DESCENDING);
    }

    public final List getColumnAsList(int n) {
        return this.fMatrix.getColumnL(n);
    }

    public final Set getColumnAsSet(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            hashSet.add(this.fMatrix.getElement(i2, n));
        }
        return hashSet;
    }

    public final String getElement(int n, int n2) {
        return this.fMatrix.getElement(n, n2);
    }

    public final float getElementAsFloat(int n, int n2) {
        return Float.parseFloat(this.fMatrix.getElement(n, n2));
    }

    public final float getElementAsFloat(int n, String string) {
        return Float.parseFloat(this.fMatrix.getElement(n, this.getColumnIndex(string)));
    }

    public final String getElement(String string, int n) {
        return this.fMatrix.getElement(this.getRowIndex(string), n);
    }

    public final String getElement(int n, String string) {
        return this.fMatrix.getElement(n, this.getColumnIndex(string));
    }

    @Override
    public final Object getElementObj(int n, int n2) {
        return this.getElement(n, n2);
    }

    @Override
    public final String getRowName(int n) {
        return (String)this.fRowNames.get(n);
    }

    @Override
    public final List getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public final int getRowIndex(String string) {
        return this.fRowNames.indexOf(string);
    }

    @Override
    public final String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public final List getColumnNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public final int getColumnIndex(String string) {
        int n = this.fColNames.indexOf(string);
        return n;
    }

    @Override
    public final String[] getColumnNamesArray() {
        return this.fColNames.toArray(new String[this.fColNames.size()]);
    }

    @Override
    public final String getColumnName(int n) {
        return this.fColNames.get(n).toString();
    }

    @Override
    public final int getNumRow() {
        return this.fMatrix.getNumRow();
    }

    @Override
    public final int getNumCol() {
        return this.fMatrix.getNumCol();
    }

    public final void setRowLabelName(String string) {
        this.fRowLabelName = string;
    }

    public final String getRowLabelName() {
        return this.fRowLabelName;
    }

    public final StringMatrix getMatrix() {
        this.fMatrix.setImmutable();
        return this.fMatrix;
    }

    public final String[] getUniqueElements() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < this.getNumCol(); ++i3) {
                hashSet.add(this.getElement(i2, i3));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public final String getQuickInfo() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return stringBuffer.toString();
    }

    public static final List createSeriesStrings(int n, int n2, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
        for (int i2 = n; i2 < n2; ++i2) {
            arrayList.add(string + i2);
        }
        return arrayList;
    }

    private static List toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    private static StringMatrix[] extractMatrices(StringDataframe[] stringDataframeArray) {
        ArrayList<StringMatrix> arrayList = new ArrayList<StringMatrix>(stringDataframeArray.length);
        for (int i2 = 0; i2 < stringDataframeArray.length; ++i2) {
            arrayList.add(stringDataframeArray[i2].getMatrix());
        }
        return arrayList.toArray(new StringMatrix[arrayList.size()]);
    }

    private static StringMatrix[] extractMatrices(List list) {
        ArrayList<StringMatrix> arrayList = new ArrayList<StringMatrix>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.add(((StringDataframe)list.get(i2)).getMatrix());
        }
        return arrayList.toArray(new StringMatrix[arrayList.size()]);
    }

    private static List createSeriesStrings(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
        for (int i2 = n; i2 < n2; ++i2) {
            arrayList.add(i2 + "");
        }
        return arrayList;
    }

    private static List extractRowNames(StringDataframe[] stringDataframeArray) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < stringDataframeArray.length; ++i2) {
            arrayList.addAll(stringDataframeArray[i2].getRowNames());
        }
        return arrayList;
    }

    private static List extractRowNames(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.addAll(((StringDataframe)list.get(i2)).getRowNames());
        }
        return arrayList;
    }

    public final void replace(String string, String string2) {
        this.fMatrix.replace(string, string2);
    }
}

