/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.ColumnsImpl;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateCohort$Comp;
import edu.mit.broad.genome.objects.strucs.NamedColor;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TemplateCohort
extends AbstractObject {
    private TemplateCohort$Comp[] fComps;
    private static final Logger klog = XLogger.getLogger(TemplateCohort.class);
    private SampleAnnot fSampleAnnot;
    private List fCompNames;
    private Map compNameCompMap;

    public TemplateCohort(String string, TemplateCohort$Comp[] templateCohort$CompArray) {
        super.initialize(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < templateCohort$CompArray.length; ++i2) {
            if (hashSet.contains(templateCohort$CompArray[i2].getName())) {
                throw new IllegalArgumentException("Duplicate comp name: " + templateCohort$CompArray[i2].getName() + " at " + i2);
            }
            hashSet.add(templateCohort$CompArray[i2].getName());
        }
        this.fComps = templateCohort$CompArray;
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    public final SampleAnnot getSampleAnnot() {
        if (this.fSampleAnnot == null) {
            ColumnsImpl columnsImpl = new ColumnsImpl(this.getNamedColors());
            this.fSampleAnnot = new SampleAnnotImpl(this.getName(), this.getCompNames(), (ColorMap$Columns)columnsImpl);
        }
        return this.fSampleAnnot;
    }

    public final int getNumComps() {
        return this.fComps.length;
    }

    public final TemplateCohort$Comp getComp(int n) {
        return this.fComps[n];
    }

    public final String[] getCompNames() {
        if (this.fCompNames == null) {
            this.fCompNames = new ArrayList();
            for (int i2 = 0; i2 < this.getNumComps(); ++i2) {
                this.fCompNames.add(this.getComp(i2).getName());
            }
        }
        return this.fCompNames.toArray(new String[this.fCompNames.size()]);
    }

    public final NamedColor[] getNamedColors() {
        NamedColor[] namedColorArray = new NamedColor[this.getNumComps()];
        for (int i2 = 0; i2 < this.getNumComps(); ++i2) {
            namedColorArray[i2] = new NamedColor(this.getComp(i2).getClassAShortName(), this.getComp(i2).getColor());
        }
        return namedColorArray;
    }

    public final TemplateCohort$Comp getComp(String string) {
        this.initCompMap();
        Object v = this.compNameCompMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("No such comp: " + string);
        }
        return (TemplateCohort$Comp)v;
    }

    private void initCompMap() {
        if (this.compNameCompMap == null) {
            this.compNameCompMap = new HashMap();
            for (int i2 = 0; i2 < this.getNumComps(); ++i2) {
                this.compNameCompMap.put(this.getComp(i2).getName(), this.getComp(i2));
            }
        }
    }

    public final boolean hasComp(String string) {
        this.initCompMap();
        return this.compNameCompMap.containsKey(string);
    }

    public final Template[] createAllTemplates(SampleAnnot sampleAnnot) {
        Template[] templateArray = new Template[this.getNumComps()];
        for (int i2 = 0; i2 < this.getNumComps(); ++i2) {
            templateArray[i2] = this.getComp(i2).createTemplate(sampleAnnot);
        }
        return templateArray;
    }

    public final String[] getAllSampleNamesArray(SampleAnnot sampleAnnot) {
        Set set = this.getAllSampleNames(sampleAnnot);
        return set.toArray(new String[set.size()]);
    }

    public final Set getAllSampleNames(SampleAnnot sampleAnnot) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < this.getNumComps(); ++i2) {
            hashSet.addAll(this.getComp(i2).getSampleNames(sampleAnnot, true));
            hashSet.addAll(this.getComp(i2).getSampleNames(sampleAnnot, false));
        }
        return hashSet;
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

