/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.Template$Class;
import edu.mit.broad.genome.objects.Template$Item;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames$MyTemplateDerivative;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class TemplateImplFromSampleNames
extends AbstractObject
implements Template {
    private Template fCreatedTemplate;
    private TemplateImplFromSampleNames fInstance = this;
    private String fClassAName;
    private String[] fClassASampleNames;
    private String fClassBName;
    private String[] fClassBSampleNames;

    public TemplateImplFromSampleNames(String string, String string2, String[] stringArray, String string3, String[] stringArray2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Param classAName cannot be null or zero length");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("Param classBName cannot be null or zero length");
        }
        super.initialize(string);
        if (string2.equalsIgnoreCase(string3)) {
            throw new IllegalArgumentException("Class names cannot be the same classAName: " + string2 + " classBName: " + string3);
        }
        List<String> list = Arrays.asList(stringArray);
        Errors errors = new Errors();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (!list.contains(stringArray2[i2])) continue;
            errors.add("This sample is in both classes: " + stringArray2[i2]);
        }
        errors.barfIfNotEmptyRuntime();
        this.fClassAName = string2;
        this.fClassASampleNames = TemplateImplFromSampleNames._toUniques(stringArray);
        this.fClassBName = string3;
        this.fClassBSampleNames = TemplateImplFromSampleNames._toUniques(stringArray2);
    }

    public final TemplateDerivative getAsTemplateDerivative() {
        return new TemplateImplFromSampleNames$MyTemplateDerivative(this);
    }

    @Override
    public final boolean isSampleNamesFromDataset() {
        return true;
    }

    public final String[] getClassASampleNames() {
        return this.fClassASampleNames;
    }

    public final String[] getClassBSampleNames() {
        return this.fClassASampleNames;
    }

    public final Template createTemplate(Dataset dataset) {
        this.fCreatedTemplate = TemplateFactory.createCategoricalTemplate(NamingConventions.removeExtension(this.getName()) + "_" + dataset.getName(), dataset, this.fClassAName, this.fClassASampleNames, this.fClassBName, this.fClassBSampleNames);
        return this.fCreatedTemplate;
    }

    @Override
    public final Template cloneDeep(String string) {
        if (this._got_ct()) {
            return this._ct().cloneDeep(string);
        }
        return new TemplateImplFromSampleNames(string, this.fClassAName, this.fClassASampleNames, this.fClassBName, this.fClassBSampleNames);
    }

    public final Template cloneDeepReversed(String string) {
        return new TemplateImplFromSampleNames(string, this.fClassBName, this.fClassBSampleNames, this.fClassAName, this.fClassASampleNames);
    }

    @Override
    public final void makeImmutable() {
        if (this._got_ct()) {
            this._ct().makeImmutable();
        }
    }

    @Override
    public final String getQuickInfo() {
        if (this._got_ct()) {
            return this.fCreatedTemplate.getQuickInfo();
        }
        return this.fClassAName + " (" + this.fClassASampleNames.length + ") " + this.fClassBName + " (" + this.fClassBSampleNames.length + ")";
    }

    @Override
    public final boolean isAux() {
        return false;
    }

    @Override
    public final boolean isContinuous() {
        return false;
    }

    @Override
    public final boolean isCategorical() {
        return true;
    }

    @Override
    public final String getClassName(int n) {
        if (n == 0) {
            return this.fClassAName;
        }
        if (n == 1) {
            return this.fClassBName;
        }
        throw new IllegalArgumentException("Too large: " + n);
    }

    @Override
    public final int getClassIndex(String string) {
        if (string.equals(this.fClassAName)) {
            return 0;
        }
        return 1;
    }

    @Override
    public final int getClassIndex(Template$Class template$Class) {
        return this.getClassIndex(template$Class.getName());
    }

    @Override
    public final int getNumClasses() {
        return 2;
    }

    @Override
    public final boolean isMemberClass(Template$Class template$Class) {
        return template$Class.getName().equals(this.fClassAName) || template$Class.getName().equals(this.fClassBName);
    }

    private Template _ct() {
        if (this.fCreatedTemplate == null) {
            throw new IllegalArgumentException("Dataset not set!!");
        }
        return this.fCreatedTemplate;
    }

    private boolean _got_ct() {
        return this.fCreatedTemplate != null;
    }

    @Override
    public final Template cloneDeep() {
        return this._ct().cloneDeep();
    }

    @Override
    public final Color getItemColor(int n) {
        return this._ct().getItemColor(n);
    }

    @Override
    public final boolean equalsShallow(Template template) {
        return this._ct().equalsShallow(template);
    }

    @Override
    public final boolean isAscendingProfilePositions() {
        return this._ct().isAscendingProfilePositions();
    }

    @Override
    public final boolean isClassesContiguous() {
        return this._ct().isClassesContiguous();
    }

    @Override
    public final Template$Class getClass(Template$Item template$Item) {
        return this._ct().getClass(template$Item);
    }

    @Override
    public final Template$Class getClass(int n) {
        return this._ct().getClass(n);
    }

    @Override
    public final Template$Class getClass(String string) {
        return this._ct().getClass(string);
    }

    @Override
    public final Template$Class getClassByProfilePos(int n) {
        return this._ct().getClassByProfilePos(n);
    }

    @Override
    public final String getClassOfInterestName() {
        return this._ct().getClassOfInterestName();
    }

    @Override
    public final Template$Class getClassOfInterest() {
        return this._ct().getClassOfInterest();
    }

    @Override
    public final int getClassOfInterestIndex() {
        return this._ct().getClassOfInterestIndex();
    }

    @Override
    public final void setClassOfInterestIndex(int n) {
        this._ct().setClassOfInterestIndex(n);
    }

    @Override
    public final int[] getProfilePositionsOrdered() {
        return this._ct().getProfilePositionsOrdered();
    }

    @Override
    public final Template$Item getItemByProfilePos(int n) {
        return this._ct().getItemByProfilePos(n);
    }

    @Override
    public final Template$Item[] getItemsOrderedByProfilePos() {
        return this._ct().getItemsOrderedByProfilePos();
    }

    @Override
    public final Template$Item[] getItemsOrderedByClassFirstAndThenProfilePos() {
        return this._ct().getItemsOrderedByClassFirstAndThenProfilePos();
    }

    @Override
    public final boolean hasItemWithId(String string) {
        return this._ct().hasItemWithId(string);
    }

    @Override
    public final int getNumItems() {
        return this._ct().getNumItems();
    }

    @Override
    public final Vector toVector() {
        return this._ct().toVector();
    }

    @Override
    public final String getAsString(boolean bl) {
        return this._ct().getAsString(bl);
    }

    @Override
    public final Vector[] splitByTemplateClass(Vector vector) {
        return this._ct().splitByTemplateClass(vector);
    }

    @Override
    public final Set[] splitByTemplateClass(List list) {
        return this._ct().splitByTemplateClass(list);
    }

    @Override
    public final String getColumnName(Template$Item template$Item, Dataset dataset) {
        return this._ct().getColumnName(template$Item, dataset);
    }

    @Override
    public final List extractColumnNames(Dataset dataset) {
        return this._ct().extractColumnNames(dataset);
    }

    @Override
    public final Vector extractProfile(String string, Dataset dataset) {
        return this._ct().extractProfile(string, dataset);
    }

    @Override
    public final Vector extractProfile(int n, Dataset dataset) {
        return this._ct().extractProfile(n, dataset);
    }

    @Override
    public final LabelledVector extractProfile_lv(String string, Dataset dataset) {
        return this._ct().extractProfile_lv(string, dataset);
    }

    @Override
    public final LabelledVector extractProfile_lv(int n, Dataset dataset) {
        return this._ct().extractProfile_lv(n, dataset);
    }

    @Override
    public final Vector synchProfile(Vector vector) {
        return this._ct().synchProfile(vector);
    }

    private static String[] _toUniques(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].trim();
            if (string.length() == 0 || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static final /* synthetic */ TemplateImplFromSampleNames access$000(TemplateImplFromSampleNames templateImplFromSampleNames) {
        return templateImplFromSampleNames.fInstance;
    }
}

