/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.DataType;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.HClustDatasetStanford;
import edu.mit.broad.genome.objects.HClustTree;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.Nedb;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateCohort;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.esmatrix.db.DtgDataset;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.parsers.ChipParser;
import edu.mit.broad.genome.parsers.ClsParser;
import edu.mit.broad.genome.parsers.DChipDatasetParser;
import edu.mit.broad.genome.parsers.DataFormat$1;
import edu.mit.broad.genome.parsers.DataFormat$2;
import edu.mit.broad.genome.parsers.DataFormat$ExtFormat;
import edu.mit.broad.genome.parsers.DataFormat$ParsableFileFilter;
import edu.mit.broad.genome.parsers.DataFormat$ParsableFileView;
import edu.mit.broad.genome.parsers.DataframeParser;
import edu.mit.broad.genome.parsers.DtgDatasetParser;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.FSetParser;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.parsers.GinParser_xls;
import edu.mit.broad.genome.parsers.GmtParser;
import edu.mit.broad.genome.parsers.GmxParser;
import edu.mit.broad.genome.parsers.HClustDatasetParser;
import edu.mit.broad.genome.parsers.HClustTreeParser;
import edu.mit.broad.genome.parsers.MSigDBParser;
import edu.mit.broad.genome.parsers.MatrixParser;
import edu.mit.broad.genome.parsers.Parser;
import edu.mit.broad.genome.parsers.PclParser;
import edu.mit.broad.genome.parsers.RankedListParser;
import edu.mit.broad.genome.parsers.ReportParser;
import edu.mit.broad.genome.parsers.ResParser;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.parsers.TxtDatasetParser;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.msigdb.MSigDB;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.apache.log4j.Logger;

public class DataFormat
extends DataType
implements Constants {
    private static final Logger klog = XLogger.getLogger(DataFormat.class);
    public static final DataFormat XLS_FORMAT = new DataFormat(DataFormat$ExtFormat.class, "Excel", "Microsoft Excel", "xls", JarResources.getIcon("Xls.gif"));
    public static final DataFormat TXT_FORMAT = new DataFormat(DataFormat$ExtFormat.class, "Text", "Plain Text", "txt", JarResources.getIcon("Txt.gif"));
    public static final DataFormat XML_FORMAT = new DataFormat(DataFormat$ExtFormat.class, "XML", "Extensible Markup Language", "xml", JarResources.getIcon("Xml.gif"));
    public static final DataFormat RES_FORMAT = new DataFormat(Dataset.class, "Dataset", "MIT Format for a Dataset with P-Calls", "res", JarResources.getIcon("Res16.gif"), ResParser.class);
    public static final DataFormat GCT_FORMAT = new DataFormat(Dataset.class, "Dataset", "MIT Format for a Dataset", "gct", JarResources.getIcon("Gct16.gif"), GctParser.class);
    public static final DataFormat TXT_DATASET_FORMAT = new DataFormat(Dataset.class, "Dataset", "generic Txt Format for Datasets", "txt", JarResources.getIcon("Txt.gif"), TxtDatasetParser.class);
    public static final DataFormat DCHIP_FORMAT = new DataFormat(Dataset.class, "Dataset", "DChip dataset format", "dchip", JarResources.getIcon("Txt.gif"), DChipDatasetParser.class);
    public static final DataFormat PCL_FORMAT = new DataFormat(Dataset.class, "Dataset", "Stanford Format for a Dataset", "pcl", JarResources.getIcon("Pcl.gif"), PclParser.class);
    public static final DataFormat CDT_FORMAT = new DataFormat(Dataset.class, "HClustDataset", "Clustered Dataset Format", "cdt", JarResources.getIcon("Cdt.png"), HClustDatasetParser.class);
    public static final DataFormat ATR_FORMAT = new DataFormat(Dataset.class, "ArrayTree", "Array Tree Format", "atr", JarResources.getIcon("Atr.png"), HClustTreeParser.class);
    public static final DataFormat GTR_FORMAT = new DataFormat(Dataset.class, "GeneTree", "GeneTree Format", "gtr", JarResources.getIcon("Gtr.png"), HClustTreeParser.class);
    public static final DataFormat MAT_FORMAT = new DataFormat(Matrix.class, "Matrix", "Matrix Format", "mat", JarResources.getIcon("Mat.gif"), MatrixParser.class);
    public static final DataFormat CLS_FORMAT = new DataFormat(Template.class, "Template", "MIT Format for Class Labels", "cls", JarResources.getIcon("Cls.gif"), ClsParser.class);
    public static final DataFormat SIN_FORMAT = new DataFormat(SampleAnnot.class, "Annotation", "Formatted sampl annnotation", "sin", JarResources.getIcon("Table16b.gif"), Object.class);
    public static final DataFormat GRP_FORMAT = new DataFormat(GeneSet.class, "GeneSet", "MIT GeneSet Format", "grp", JarResources.getIcon("Grp.gif"), FSetParser.class);
    public static final DataFormat RNK_FORMAT = new DataFormat(RankedList.class, "RankedList", "MIT RankedList Format", "rnk", JarResources.getIcon("Rnk.png"), RankedListParser.class);
    public static final DataFormat GMX_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix", "MIT format for a Matrix of Gene Sets", "gmx", JarResources.getIcon("Gmx.png"), GmxParser.class);
    public static final DataFormat GMT_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix_Transposed", "MIT format for a Matrix of Gene Sets", "gmt", JarResources.getIcon("Gmt.png"), GmtParser.class);
    public static final DataFormat EDB_FORMAT = new DataFormat(EnrichmentDb.class, "Enrichment-Database", "MIT format for an enrichment database", "edb", JarResources.getIcon("Edb.png"), EdbFolderParser.class);
    public static final DataFormat DTGDS_FORMAT = new DataFormat(DtgDataset.class, "Dtg Dataset", "MIT format for an enrichment database", "dtgds", JarResources.getIcon("DtgDs.gif"), DtgDatasetParser.class);
    public static final DataFormat MSIGDB_FORMAT = new DataFormat(MSigDB.class, "MSigDB", "MSigDB format for a database of gene sets and their annotations", "xml", JarResources.getIcon("Xml.gif"), MSigDBParser.class);
    public static final DataFormat DFR_FORMAT = new DataFormat(Dataframe.class, "Dataframe", "Format of a Dataframe - R compatible", "dfr", JarResources.getIcon("Dfr16.gif"), DataframeParser.class);
    public static final DataFormat SDF_FORMAT = new DataFormat(StringDataframe.class, "StringDataframe", "Dataframe of Strings", "sdf", JarResources.getIcon("Sdf16.gif"), StringDataframeParser.class);
    public static final DataFormat RPT_FORMAT = new DataFormat(Report.class, "Report", "Report for a program", "rpt", JarResources.getIcon("Rpt.gif"), ReportParser.class);
    public static final DataFormat CHIP_FORMAT = new DataFormat(Chip.class, "Chip", "Chip", "chip", JarResources.getIcon("Chip16.png"), ChipParser.class);
    public static final DataFormat GIN_FORMAT = new DataFormat(GenesOfInterest.class, "GenesOfInterest", "MIT Format for a Database of Genes of Interest", "gin", JarResources.getIcon("Gin16.png"), GinParser_xls.class);
    private static final DataFormat[] ALL = new DataFormat[]{RES_FORMAT, GCT_FORMAT, TXT_DATASET_FORMAT, DCHIP_FORMAT, PCL_FORMAT, CLS_FORMAT, CDT_FORMAT, ATR_FORMAT, GTR_FORMAT, SIN_FORMAT, GRP_FORMAT, GMT_FORMAT, GMX_FORMAT, MAT_FORMAT, RNK_FORMAT, MSIGDB_FORMAT, RPT_FORMAT, DFR_FORMAT, SDF_FORMAT, EDB_FORMAT, DTGDS_FORMAT, CHIP_FORMAT, GIN_FORMAT, XLS_FORMAT, TXT_FORMAT, XML_FORMAT};
    public static final DataFormat[] ALL_DATASET_FORMATS = new DataFormat[]{GCT_FORMAT, RES_FORMAT, TXT_DATASET_FORMAT, DCHIP_FORMAT, PCL_FORMAT};
    public static final DataFormat[] ALL_TEMPLATE_FORMATS = new DataFormat[]{CLS_FORMAT};
    public static final DataFormat[] ALL_GENESET_FORMATS = new DataFormat[]{GRP_FORMAT, GMX_FORMAT, GMT_FORMAT};
    public static final DataFormat[] ALL_GENESETMATRIX_FORMATS = new DataFormat[]{GMX_FORMAT, GMT_FORMAT};
    private static Set kParsableExts;
    private static Map kPobClassDataFormatMap;
    private static FileFilter kParsableFileFilter;
    private static final Map kClassExtMap;
    private static final Map kExtDfMap;
    private static final Map kClassIconMap;
    private static final Map kClassNameMap;
    private String fName;
    private String fDesc;
    private Icon fIcon;
    private String fExt;
    private Class fParserClass;
    private FilenameFilter fFilt;

    public DataFormat() {
    }

    public static final DataFormat[] getPossibleDataFormats(String string) {
        Class clazz = DataFormat.getRepresentationClass(string);
        if (clazz == null) {
            return new DataFormat[0];
        }
        return DataFormat.getPossibleDataFormats(clazz);
    }

    public static final DataFormat[] getPossibleDataFormats(Class clazz) {
        DataFormat._initParsableExts();
        Object v = kPobClassDataFormatMap.get(clazz);
        if (v == null) {
            klog.debug("No data formats found for: " + clazz);
            return new DataFormat[0];
        }
        return (DataFormat[])v;
    }

    public static final DataFormat[] getPossibleDataFormats(File file) {
        return DataFormat.getPossibleDataFormats(NamingConventions.getExtension(file));
    }

    public static final DataFormat[] getPossibleDataFormats(PersistentObject persistentObject) {
        Class clazz = DataFormat.getRepresentationClass(persistentObject);
        return DataFormat.getPossibleDataFormats(clazz);
    }

    public static final boolean isParsable(File file) {
        if (file == null) {
            return false;
        }
        String string = NamingConventions.getExtension(file);
        DataFormat._initParsableExts();
        return kParsableExts.contains(string);
    }

    public static final String[] getParsableExtensions() {
        DataFormat._initParsableExts();
        return kParsableExts.toArray(new String[kParsableExts.size()]);
    }

    private static void _initParsableExts() {
        if (kParsableExts != null) {
            return;
        }
        klog.debug("Initing parsable extensions");
        kParsableExts = new HashSet();
        kParsableExts.add("res");
        kParsableExts.add("res".toUpperCase());
        kParsableExts.add("gct");
        kParsableExts.add("gct".toUpperCase());
        kParsableExts.add("dchip");
        kParsableExts.add("dchip".toUpperCase());
        kParsableExts.add("pcl");
        kParsableExts.add("pcl".toUpperCase());
        kParsableExts.add("sdf");
        kParsableExts.add("sdf".toUpperCase());
        kParsableExts.add("dtgds");
        kParsableExts.add("dtgds".toUpperCase());
        kParsableExts.add("cdt");
        kParsableExts.add("cdt".toUpperCase());
        kParsableExts.add("atr");
        kParsableExts.add("atr".toUpperCase());
        kParsableExts.add("gtr");
        kParsableExts.add("gtr".toUpperCase());
        kParsableExts.add("cls");
        kParsableExts.add("cls".toUpperCase());
        kParsableExts.add("comp");
        kParsableExts.add("comp".toUpperCase());
        kParsableExts.add("chip");
        kParsableExts.add("chip".toUpperCase());
        kParsableExts.add("grp");
        kParsableExts.add("grp".toUpperCase());
        kParsableExts.add("rnk");
        kParsableExts.add("rnk".toUpperCase());
        kParsableExts.add("gmx");
        kParsableExts.add("gmx".toUpperCase());
        kParsableExts.add("gmt");
        kParsableExts.add("gmt".toUpperCase());
        kParsableExts.add("dfr");
        kParsableExts.add("dfr".toUpperCase());
        kParsableExts.add("map");
        kParsableExts.add("map".toUpperCase());
        kParsableExts.add("edb");
        kParsableExts.add("edb".toUpperCase());
        kParsableExts.add("rpt");
        kParsableExts.add("rpt".toUpperCase());
        kParsableExts.add("sin");
        kParsableExts.add("sin".toUpperCase());
        kPobClassDataFormatMap = new HashMap();
        kPobClassDataFormatMap.put(Dataset.class, new DataFormat[]{RES_FORMAT, GCT_FORMAT, TXT_DATASET_FORMAT, DCHIP_FORMAT, PCL_FORMAT});
        kPobClassDataFormatMap.put(HClustDatasetStanford.class, new DataFormat[]{CDT_FORMAT, RES_FORMAT, GCT_FORMAT, TXT_DATASET_FORMAT, DCHIP_FORMAT});
        kPobClassDataFormatMap.put(Template.class, new DataFormat[]{CLS_FORMAT});
        kPobClassDataFormatMap.put(GeneSetMatrix.class, new DataFormat[]{GMX_FORMAT, GMT_FORMAT});
        kPobClassDataFormatMap.put(DefaultGeneSetMatrix.class, new DataFormat[]{GMX_FORMAT, GMT_FORMAT});
        kPobClassDataFormatMap.put(GeneSet.class, new DataFormat[]{GRP_FORMAT});
        kPobClassDataFormatMap.put(FSet.class, new DataFormat[]{GRP_FORMAT});
        kPobClassDataFormatMap.put(RankedList.class, new DataFormat[]{RNK_FORMAT});
        kPobClassDataFormatMap.put(LabelledVector.class, new DataFormat[]{RNK_FORMAT});
    }

    public static final FileFilter getParsableFileFilter() {
        if (kParsableFileFilter == null) {
            kParsableFileFilter = new DataFormat$ParsableFileFilter();
        }
        return kParsableFileFilter;
    }

    public static final FileView getParsableFileView() {
        return new DataFormat$ParsableFileView();
    }

    public static final DataFormat getExtension(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        String string = object instanceof DataFormat ? ((DataFormat)object).getExtension() : object.toString();
        for (int i2 = 0; i2 < ALL.length; ++i2) {
            if (ALL[i2].getExtension().equalsIgnoreCase(string)) {
                return ALL[i2];
            }
            if (!ALL[i2].toString().equalsIgnoreCase(string)) continue;
            return ALL[i2];
        }
        throw new IllegalArgumentException("No DataFormat found for: " + string);
    }

    public DataFormat(Class clazz, String string, String string2, String string3, Icon icon) {
        this(clazz, string, string2, string3, icon, null);
    }

    public DataFormat(Class clazz, String string, String string2, String string3, Icon icon, Class clazz2) {
        super(clazz, string3);
        if (string == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Param desc cannot be null");
        }
        if (!SystemUtils.isHeadless() && icon == null) {
            throw new IllegalArgumentException("Param icon cannot be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Null extension is not allowed: " + string3);
        }
        if (string3.startsWith(".")) {
            throw new IllegalArgumentException("DataFormat extension cannot begin with a period '.' " + string3);
        }
        if (string3.length() <= 0) {
            throw new IllegalArgumentException("DataFormat extension cannot have zero length " + string3);
        }
        this.fExt = string3;
        this.fIcon = icon;
        this.fName = string;
        this.fDesc = string2;
        this.fParserClass = clazz2;
    }

    public final String getName() {
        return this.fName;
    }

    public final String getDesc() {
        return this.fDesc;
    }

    public final FilenameFilter getFilenameFilter() {
        if (this.fFilt == null) {
            this.fFilt = DataFormat.createFnf(this.fExt);
        }
        return this.fFilt;
    }

    public static final FilenameFilter createFilenameFilter_for_dataset() {
        return DataFormat.createFilenameFilter(ALL_DATASET_FORMATS);
    }

    public static final FilenameFilter createFilenameFilter_for_template() {
        return DataFormat.createFilenameFilter(ALL_TEMPLATE_FORMATS);
    }

    public static final FilenameFilter createFilenameFilter_for_genesetmatrix() {
        return DataFormat.createFilenameFilter(ALL_GENESETMATRIX_FORMATS);
    }

    public static final FilenameFilter createFilenameFilter_for_geneset() {
        return DataFormat.createFilenameFilter(ALL_GENESET_FORMATS);
    }

    public static final FilenameFilter createFilenameFilter(DataFormat[] dataFormatArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < dataFormatArray.length; ++i2) {
            hashSet.add(dataFormatArray[i2].getExtension());
        }
        return DataFormat.createFnf(hashSet);
    }

    public static final FilenameFilter createFilenameFilter(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return DataFormat.createFnf(hashSet);
    }

    private static FilenameFilter createFnf(String string) {
        return new DataFormat$1(string);
    }

    private static FilenameFilter createFnf(Set set) {
        return new DataFormat$2(set);
    }

    public final String getExtension() {
        return this.fExt;
    }

    public final Icon getIcon() {
        return this.fIcon;
    }

    public final Parser createParser() {
        if (this.fParserClass == null) {
            return null;
        }
        return (Parser)this.fParserClass.newInstance();
    }

    @Override
    public final String toString() {
        return new StringBuffer(this.getName()).append("[").append(this.getExtension()).append("]").toString();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DataFormat) {
            return ((DataFormat)object).fExt.equals(this.fExt);
        }
        return this.fExt.equalsIgnoreCase(object.toString());
    }

    public static final String getExtension(Class clazz) {
        Class clazz2 = DataFormat._deconvClass(clazz);
        Object v = kClassExtMap.get(clazz2);
        if (v != null) {
            return v.toString();
        }
        klog.warn("No extension found for class: " + clazz2);
        return "txt";
    }

    public static final String getExtension(PersistentObject persistentObject) {
        if (persistentObject == null) {
            return null;
        }
        return DataFormat.getExtension(persistentObject.getClass());
    }

    public static final boolean isKnownExtension(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(".")) {
            string = string.substring(1, string.length());
        }
        return kExtDfMap.containsKey(string);
    }

    public static final DataFormat getDataFormat(String string) {
        Object v = kExtDfMap.get(string);
        if (v != null) {
            return (DataFormat)v;
        }
        return null;
    }

    public static final Class getRepresentationClass(String string) {
        Object v = kExtDfMap.get(string);
        if (v != null) {
            return ((DataFormat)v).getRepresentationClass();
        }
        return null;
    }

    public static final Icon getIcon(String string) {
        DataFormat dataFormat = DataFormat.getDataFormat(string);
        if (dataFormat != null) {
            return dataFormat.getIcon();
        }
        return JarResources.ICON_UNKNOWN_DATA_FORMAT;
    }

    public static final Icon getIconOrNull(String string) {
        DataFormat dataFormat = DataFormat.getDataFormat(string);
        if (dataFormat != null) {
            return dataFormat.getIcon();
        }
        return null;
    }

    public static final String getDesc(String string) {
        DataFormat dataFormat = DataFormat.getDataFormat(string);
        if (dataFormat != null) {
            return dataFormat.getDesc();
        }
        return null;
    }

    public static final String getDesc(File file) {
        String string = NamingConventions.getExtension(file).toLowerCase();
        DataFormat dataFormat = DataFormat.getDataFormat(string);
        if (dataFormat != null) {
            return dataFormat.getDesc();
        }
        return null;
    }

    public static final String getName(Class clazz) {
        Class clazz2 = DataFormat._deconvClass(clazz);
        Object v = kClassNameMap.get(clazz2);
        if (v != null) {
            return (String)v;
        }
        return "Unkown";
    }

    private static Class _deconvClass(Class clazz) {
        if (kClassNameMap.containsKey(clazz)) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Object v = kClassNameMap.get(classArray[i2]);
            if (v == null) continue;
            return classArray[i2];
        }
        if (clazz.equals(DefaultGeneSetMatrix.class)) {
            return GeneSetMatrix.class;
        }
        if (clazz.equals(TemplateImpl.class)) {
            return Template.class;
        }
        return clazz;
    }

    public static final Icon getIcon(Object object) {
        if (object == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        if (object instanceof File) {
            return DataFormat.getIcon(NamingConventions.getExtension((File)object));
        }
        if (object instanceof String) {
            return DataFormat.getIcon(NamingConventions.getExtension(object.toString()));
        }
        Object v = kClassIconMap.get(object.getClass());
        if (v == null && object instanceof PersistentObject) {
            Class clazz = DataFormat.getRepresentationClass((PersistentObject)object);
            v = kClassIconMap.get(clazz);
        }
        if (v == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        return (Icon)v;
    }

    public static final Icon getIcon(Class clazz) {
        Class clazz2 = DataFormat._deconvClass(clazz);
        Object v = kClassIconMap.get(clazz2);
        if (v == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        return (Icon)v;
    }

    public static final Class getRepresentationClass(PersistentObject persistentObject) {
        if (persistentObject instanceof GenesOfInterest) {
            return GenesOfInterest.class;
        }
        if (persistentObject instanceof HClustDatasetStanford) {
            return HClustDatasetStanford.class;
        }
        if (persistentObject instanceof HClustTree) {
            return HClustTree.class;
        }
        if (persistentObject instanceof Template) {
            return Template.class;
        }
        if (persistentObject instanceof FeatureAnnot) {
            return FeatureAnnot.class;
        }
        if (persistentObject instanceof GeneSet) {
            return GeneSet.class;
        }
        if (persistentObject instanceof RankedList) {
            return RankedList.class;
        }
        if (persistentObject instanceof Dataframe) {
            return Dataframe.class;
        }
        if (persistentObject instanceof Matrix) {
            return Matrix.class;
        }
        if (persistentObject instanceof GeneSetMatrix) {
            return GeneSetMatrix.class;
        }
        if (persistentObject instanceof StringDataframe) {
            return StringDataframe.class;
        }
        if (persistentObject instanceof Report) {
            return Report.class;
        }
        if (persistentObject instanceof EnrichmentDb) {
            return EnrichmentDb.class;
        }
        if (persistentObject instanceof Nedb) {
            return Nedb.class;
        }
        if (persistentObject instanceof Chip) {
            return Chip.class;
        }
        if (persistentObject instanceof DtgDataset) {
            return DtgDataset.class;
        }
        if (persistentObject instanceof Dataset) {
            return Dataset.class;
        }
        if (persistentObject instanceof SampleAnnot) {
            return SampleAnnot.class;
        }
        if (persistentObject instanceof TemplateCohort) {
            return TemplateCohort.class;
        }
        if (persistentObject instanceof RankedListDb) {
            return RankedListDb.class;
        }
        if (persistentObject instanceof MSigDB) {
            return MSigDB.class;
        }
        throw new IllegalArgumentException("Unknown object: " + persistentObject);
    }

    public static final Icon getIcon(File file) {
        String string = NamingConventions.getExtension(file);
        return DataFormat.getIcon(string);
    }

    public static final Icon getIconOrNull(File file) {
        String string = NamingConventions.getExtension(file).toLowerCase();
        return DataFormat.getIconOrNull(string);
    }

    private static int findMax(Object[] objectArray) {
        int n = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            File[] fileArray = (File[])objectArray[i2];
            if (fileArray.length <= n) continue;
            n = fileArray.length;
        }
        return n;
    }

    public static final boolean isCompatibleRepresentationClass(PersistentObject[] persistentObjectArray, Class clazz) {
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            if (DataFormat.isCompatibleRepresentationClass((Object)persistentObjectArray[i2], clazz)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isCompatibleRepresentationClass(Object object, Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!DataFormat.isCompatibleRepresentationClass(object, classArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isCompatibleRepresentationClass(Object object, Class clazz) {
        int n;
        if (object == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter cl cannot be null");
        }
        if (object.getClass().getName().equals(clazz.getName())) {
            return true;
        }
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!clazz.getName().equals(classArray[i2].getName())) continue;
            return true;
        }
        Class<?>[] classArray2 = clazz.getInterfaces();
        for (n = 0; n < classArray2.length; ++n) {
            if (!object.getClass().getName().equals(classArray2[n].getName())) continue;
            return true;
        }
        for (n = 0; n < classArray.length; ++n) {
            for (int i3 = 0; i3 < classArray2.length; ++i3) {
                if (!classArray[n].getName().equals(classArray2[i3].getName())) continue;
                return true;
            }
        }
        if (object instanceof GeneSetMatrix) {
            return true;
        }
        return object instanceof Dataset;
    }

    static final /* synthetic */ void access$000() {
        DataFormat._initParsableExts();
    }

    static final /* synthetic */ Set access$100() {
        return kParsableExts;
    }

    static {
        kParsableFileFilter = null;
        kClassExtMap = new HashMap();
        kExtDfMap = new HashMap();
        kClassIconMap = new HashMap();
        kClassNameMap = new HashMap();
        for (int i2 = 0; i2 < ALL.length; ++i2) {
            kExtDfMap.put(ALL[i2].getExtension(), ALL[i2]);
            Class<?> clazz = ALL[i2].getRepresentationClass();
            if (DataFormat$ExtFormat.class.isAssignableFrom(clazz)) continue;
            if (!kClassNameMap.containsKey(clazz)) {
                kClassNameMap.put(ALL[i2].getRepresentationClass(), ALL[i2].getName());
            }
            if (!kClassExtMap.containsKey(clazz)) {
                kClassExtMap.put(ALL[i2].getRepresentationClass(), ALL[i2].getExtension());
            }
            if (kClassIconMap.containsKey(clazz)) continue;
            kClassIconMap.put(ALL[i2].getRepresentationClass(), ALL[i2].getIcon());
        }
    }
}

