/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.AnnotImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnotImpl;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnotImpl;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class MissingValueDatasetParser
extends AbstractParser {
    public MissingValueDatasetParser() {
        super(Dataset.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        int n;
        PrintWriter printWriter = this.startExport(persistentObject, file);
        Dataset dataset = (Dataset)persistentObject;
        printWriter.println("#1.2");
        printWriter.println(dataset.getNumRow() + "\t" + dataset.getNumCol());
        printWriter.print("NAME\tDESCRIPTION\t");
        for (n = 0; n < dataset.getNumCol(); ++n) {
            printWriter.print(dataset.getColumnName(n));
            if (n == dataset.getNumCol() - 1) continue;
            printWriter.print('\t');
        }
        printWriter.println();
        for (n = 0; n < dataset.getNumRow(); ++n) {
            printWriter.print(dataset.getRowName(n));
            printWriter.print('\t');
            printWriter.print("na\t");
            printWriter.println(dataset.getRow(n).toString('\t'));
        }
        printWriter.close();
        this.doneExport();
    }

    public final List parse(String string, String string2) {
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        return this._parse(string, bufferedReader);
    }

    public final List parse(String string) {
        String string2 = NamingConventions.generateName("res");
        return this.parse(string2, string);
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader);
    }

    public final Dataset parseDataset(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return (Dataset)this._parse(string, bufferedReader).get(0);
    }

    private List _parse(String string, BufferedReader bufferedReader) {
        String string2 = this.nextLine(bufferedReader);
        int[] nArray = ParseUtils.string2ints(string2, " \t");
        if (nArray.length != 2) {
            throw new ParserException("Gct file with bad row/col info on line: " + string2);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        string2 = this.nextLine(bufferedReader);
        List list = ParseUtils.string2stringsList(string2, "\t");
        list.remove(0);
        list.remove(0);
        if (list.size() != n2) {
            throw new ParserException("Bad gct format -- expected ncols from specification on header line: " + n2 + " but found in data: " + list.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            arrayList.add(string2);
            string2 = this.nextLine(bufferedReader);
        }
        if (arrayList.size() != n) {
            throw new ParserException("Bad gct format -- exepcted nrows from specification on header line: " + n + " but found in data: " + arrayList.size());
        }
        bufferedReader.close();
        return this._parseHasDesc(string, arrayList, list);
    }

    private List _parseHasDesc(String string, List list, List list2) {
        Object object;
        Object object2;
        Matrix matrix = new Matrix(list.size(), list2.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (String)list.get(i2);
            object = ParseUtils.string2stringsList((String)object2, "\t");
            if (object.size() != list2.size() + 1 + 1) {
                throw new ParserException("Bad format - expect ncols: " + (list2.size() + 1 + 1) + " but found: " + object.size() + " on line: " + (String)object2 + "\nIf this dataset has missing values, use ImputeDataset to fill these in before importing as a Dataset");
            }
            String string2 = (String)object.get(0);
            String string3 = (String)object.get(1);
            arrayList.add(string2);
            arrayList2.add(string3);
            for (int i3 = 2; i3 < object.size(); ++i3) {
                String string4 = object.get(i3).toString();
                if (string4.equalsIgnoreCase("na")) {
                    matrix.setElement(i2, i3 - 2, Float.NaN);
                    continue;
                }
                matrix.setElement(i2, i3 - 2, Float.parseFloat(string4));
            }
        }
        FeatureAnnotImpl featureAnnotImpl = new FeatureAnnotImpl(string, arrayList, arrayList2);
        object2 = new SampleAnnotImpl(string, list2, null);
        object = new DefaultDataset(string, matrix, arrayList, list2, true, (Annot)new AnnotImpl(featureAnnotImpl, (SampleAnnot)object2));
        ((AbstractObject)object).addComment(this.fComment.toString());
        featureAnnotImpl.addComment(this.fComment.toString());
        this.doneImport();
        return MissingValueDatasetParser.unmodlist(new PersistentObject[]{object, featureAnnotImpl});
    }
}

