/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.io.FTPUtils;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.HClustDatasetStanford;
import edu.mit.broad.genome.objects.HClustTree;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.RankedListDb;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImplFromSampleNames;
import edu.mit.broad.genome.objects.esmatrix.db.DtgDataset;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImpl_one_shared_rl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbMulti;
import edu.mit.broad.genome.objects.strucs.TxtAffy;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ChipParser;
import edu.mit.broad.genome.parsers.ClsBySampleNameParser;
import edu.mit.broad.genome.parsers.ClsParser;
import edu.mit.broad.genome.parsers.DChipDatasetParser;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.DataframeParser;
import edu.mit.broad.genome.parsers.DtgDatasetParser;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.FSetParser;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.parsers.GinParser_xls;
import edu.mit.broad.genome.parsers.GmtParser;
import edu.mit.broad.genome.parsers.GmxParser;
import edu.mit.broad.genome.parsers.HClustDatasetParser;
import edu.mit.broad.genome.parsers.HClustTreeParser;
import edu.mit.broad.genome.parsers.MSigDBParser;
import edu.mit.broad.genome.parsers.MatrixParser;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.parsers.ObjectCache;
import edu.mit.broad.genome.parsers.Parser;
import edu.mit.broad.genome.parsers.ParserFactory$1;
import edu.mit.broad.genome.parsers.ParserFactory$ProgressMonitorHook;
import edu.mit.broad.genome.parsers.PclParser;
import edu.mit.broad.genome.parsers.RMADatasetParser;
import edu.mit.broad.genome.parsers.RankedListParser;
import edu.mit.broad.genome.parsers.ReportParser;
import edu.mit.broad.genome.parsers.ResParser;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.parsers.TxtAffyParser;
import edu.mit.broad.genome.parsers.TxtDatasetParser;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.msigdb.MSigDB;
import edu.mit.broad.vdb.sampledb.AbstractSampleAnnot;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.SampleAnnotGcm;
import edu.mit.broad.vdb.sampledb.SampleAnnotGnf;
import edu.mit.broad.vdb.sampledb.SampleAnnotNCI60;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import xapps.gsea.GseaWebResources;

public class ParserFactory
implements Constants {
    private static final Logger klog = XLogger.getLogger(ParserFactory.class);
    private static ParserFactory$ProgressMonitorHook kProgressMonitorHook = null;
    private static final ObjectCache kDefaultObjectCache = new ObjectCache();

    private ParserFactory() {
    }

    private static final ObjectCache _getCache() {
        return kDefaultObjectCache;
    }

    public static final ObjectCache getCache() {
        return ParserFactory._getCache();
    }

    public static final GeneSet extractGeneSet(Dataset dataset) {
        GeneSet geneSet = dataset.getRowNamesGeneSet();
        if (ParserFactory._getCache().isCached(dataset)) {
            ParserFactory._getCache().add(ParserFactory._getCache().getSourceFile(dataset), (PersistentObject)geneSet, GeneSet.class);
        }
        return geneSet;
    }

    public static final void extractGeneSets(GeneSetMatrix geneSetMatrix) {
        ParserFactory._getCache().makeVisible(geneSetMatrix.getGeneSets(), GeneSet.class);
    }

    public static final GeneSet combineIntoOne(GeneSetMatrix geneSetMatrix) {
        Set set = geneSetMatrix.getAllMemberNamesOnlyOnceS();
        FSet fSet = new FSet("combo_" + set.size() + "_" + geneSetMatrix.getName(), set);
        ParserFactory._getCache().makeVisible(fSet, GeneSet.class);
        return fSet;
    }

    public static final void installProgressMonitorHook(ParserFactory$ProgressMonitorHook parserFactory$ProgressMonitorHook) {
        klog.debug("Installing ProgressMonitorHook: " + parserFactory$ProgressMonitorHook);
        kProgressMonitorHook = parserFactory$ProgressMonitorHook;
    }

    public static final void uninstallProgressMonitorHook() {
        klog.debug("Uninstalling ProgressMonitorHook: " + kProgressMonitorHook);
        kProgressMonitorHook = null;
    }

    public static final void registerWithCache(Template template, Template template2) {
        ParserFactory.registerWithCache(template, new Template[]{template2});
    }

    public static final void registerWithCache(Template template, Template[] templateArray) {
        File file = ParserFactory._getCache().getSourceFile(template);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            File file2 = new File(file.getParentFile(), templateArray[i2].getName());
            ParserFactory._getCache().add(file2, (PersistentObject)templateArray[i2], Template.class, false);
        }
        ParserFactory._getCache().add(file, (PersistentObject)template, Template.class, true);
    }

    public static final void registerWithCache(File file, GeneSet[] geneSetArray) {
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            File file2 = new File(file.getParentFile(), geneSetArray[i2].getName());
            ParserFactory._getCache().add(file2, (PersistentObject)geneSetArray[i2], GeneSet.class, false);
        }
        ParserFactory._getCache().sortModel(GeneSet.class);
    }

    public static final void registerWithCache(File file, GeneSetMatrix geneSetMatrix, boolean bl) {
        ParserFactory._getCache().add(file, (PersistentObject)geneSetMatrix, GeneSetMatrix.class, bl);
    }

    public static final void registerWithCache(File file, Dataset dataset) {
        ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class, false);
    }

    public static final Dataset readDatasetFromMatrix(File file, boolean bl, boolean bl2) {
        Matrix matrix = ParserFactory.readMatrix(file.getPath(), ParserFactory.createInputStream(file), bl, true);
        String string = NamingConventions.removeExtension(file.getName());
        DefaultDataset defaultDataset = new DefaultDataset(string, matrix, null);
        if (bl2) {
            ParserFactory._getCache().add(file.getPath(), (PersistentObject)defaultDataset, Dataset.class);
        }
        return defaultDataset;
    }

    public static final Matrix readMatrix(File file, boolean bl) {
        return ParserFactory.readMatrix(file.getPath(), ParserFactory.createInputStream(file), bl, true);
    }

    public static final Matrix readMatrix(File file, boolean bl, boolean bl2) {
        return ParserFactory.readMatrix(file.getPath(), ParserFactory.createInputStream(file), bl, bl2);
    }

    public static final Matrix readMatrix(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readMatrix(string, inputStream, bl, true);
    }

    public static final Matrix readMatrix(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Matrix.class) && bl) {
            inputStream.close();
            return (Matrix)ParserFactory._getCache().get(string, Matrix.class);
        }
        MatrixParser matrixParser = new MatrixParser();
        Matrix matrix = (Matrix)matrixParser.parse(string, inputStream).get(0);
        if (bl2) {
            System.out.println(">>>> ### ADDED TO CACHE " + matrix.getQuickInfo());
            ParserFactory._getCache().add(string, (PersistentObject)matrix, Matrix.class);
        }
        inputStream.close();
        return matrix;
    }

    public static final Dataset readDataset(File file, boolean bl) {
        return ParserFactory.readDataset(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDataset(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readDataset(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, bl3);
    }

    public static final Dataset readDataset(File file, boolean bl, boolean bl2) {
        return ParserFactory.readDataset(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, false);
    }

    public static final Dataset readDataset(Element element, boolean bl) {
        return ParserFactory.readDataset(ParserFactory.toFile(element, "DATASET"), bl);
    }

    public static final Dataset readDataset(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDataset(string, inputStream, bl, true);
    }

    public static final Dataset readDataset(String string, InputStream inputStream, boolean bl, boolean bl2) {
        return ParserFactory.readDataset(string, inputStream, bl, bl2, false);
    }

    public static final Dataset readDataset(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            inputStream.close();
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2.equals("gct")) {
            return ParserFactory.readDatasetGct(string, inputStream, bl, bl2, bl3);
        }
        if (string2.equals("pcl")) {
            return ParserFactory.readDatasetPcl(string, inputStream, bl, bl2);
        }
        if (string2.equals("dchip")) {
            return ParserFactory.readDatasetDChip(string, inputStream, bl, bl2);
        }
        ResParser resParser = new ResParser();
        resParser.setSilentMode(bl3);
        List list = resParser.parse(ParserFactory.toName(string), inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final Dataset readDatasetGct(File file, boolean bl) {
        return ParserFactory.readDatasetGct(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDatasetGct(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readDatasetGct(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, bl3, false);
    }

    public static final Dataset readDatasetGct(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDatasetGct(string, inputStream, bl, true);
    }

    public static final Dataset readDatasetGct(String string, InputStream inputStream, boolean bl, boolean bl2) {
        return ParserFactory.readDatasetGct(string, inputStream, bl, bl2, false, false);
    }

    public static final Dataset readDatasetGct(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readDatasetGct(string, inputStream, bl, bl2, false, bl3);
    }

    public static final Dataset readDatasetGct(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2.equals("res")) {
            return ParserFactory.readDataset(string, inputStream, bl);
        }
        if (string2.equals("pcl")) {
            return ParserFactory.readDatasetPcl(string, inputStream, bl);
        }
        if (string2.equals("dchip")) {
            return ParserFactory.readDatasetDChip(string, inputStream, bl);
        }
        GctParser gctParser = new GctParser();
        gctParser.setSilentMode(bl4);
        List list = bl3 ? gctParser.parseFlippedNameDesc(ParserFactory.toName(string), inputStream) : gctParser.parse(ParserFactory.toName(string), inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final Dataset readDatasetTXT(File file, boolean bl) {
        return ParserFactory.readDatasetTXT(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDatasetTXT(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDatasetTXT(string, inputStream, bl, true);
    }

    public static final Dataset readDatasetTXT(String string, InputStream inputStream, boolean bl, boolean bl2) {
        return ParserFactory.readDatasetTXT(string, inputStream, bl, bl2, false, false);
    }

    public static final Dataset readDatasetTXT(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readDatasetTXT(string, inputStream, bl, bl2, false, bl3);
    }

    public static final Dataset readDatasetTXT(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2.equals("res")) {
            return ParserFactory.readDataset(string, inputStream, bl);
        }
        if (string2.equals("gct")) {
            return ParserFactory.readDatasetGct(string, inputStream, bl);
        }
        if (string2.equals("pcl")) {
            return ParserFactory.readDatasetPcl(string, inputStream, bl);
        }
        if (string2.equals("dchip")) {
            return ParserFactory.readDatasetDChip(string, inputStream, bl);
        }
        TxtDatasetParser txtDatasetParser = new TxtDatasetParser();
        txtDatasetParser.setSilentMode(bl4);
        List list = txtDatasetParser.parse(ParserFactory.toName(string), inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final Dataset readDatasetPcl(File file, boolean bl) {
        return ParserFactory.readDatasetPcl(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDatasetPcl(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDatasetPcl(string, inputStream, bl, true);
    }

    public static final Dataset readDatasetPcl(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2.equals("res")) {
            return ParserFactory.readDataset(string, inputStream, bl);
        }
        if (string2.equals("gct")) {
            return ParserFactory.readDatasetGct(string, inputStream, bl);
        }
        if (string2.equals("dchip")) {
            return ParserFactory.readDatasetDChip(string, inputStream, bl);
        }
        PclParser pclParser = new PclParser();
        List list = pclParser.parse(string, inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final Dataset readDatasetDChip(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        return ParserFactory.readDatasetDChip(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDatasetDChip(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDatasetDChip(string, inputStream, bl, true);
    }

    public static final Dataset readDatasetDChip(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2.equals("res")) {
            return ParserFactory.readDataset(string, inputStream, bl);
        }
        if (string2.equals("gct")) {
            return ParserFactory.readDatasetGct(string, inputStream, bl);
        }
        if (string2.equals("pcl")) {
            return ParserFactory.readDatasetPcl(string, inputStream, bl);
        }
        DChipDatasetParser dChipDatasetParser = new DChipDatasetParser();
        List list = dChipDatasetParser.parse(string, inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final Dataset readDatasetRMA(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        return ParserFactory.readDatasetRMA(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Dataset readDatasetRMA(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDatasetRMA(string, inputStream, bl, true);
    }

    public static final Dataset readDatasetRMA(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataset.class) && bl) {
            return (Dataset)ParserFactory._getCache().get(string, Dataset.class);
        }
        RMADatasetParser rMADatasetParser = new RMADatasetParser();
        List list = rMADatasetParser.parse(string, inputStream);
        Dataset dataset = (Dataset)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataset, Dataset.class);
        }
        inputStream.close();
        return dataset;
    }

    public static final HClustDatasetStanford readHClustDataset(File file, boolean bl) {
        return ParserFactory.readHClustDataset(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final HClustDatasetStanford readHClustDataset(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, HClustDatasetStanford.class) && bl) {
            inputStream.close();
            return (HClustDatasetStanford)ParserFactory._getCache().get(string, HClustDatasetStanford.class);
        }
        HClustDatasetParser hClustDatasetParser = new HClustDatasetParser();
        List list = hClustDatasetParser.parse(ParserFactory.toName(string), inputStream);
        HClustDatasetStanford hClustDatasetStanford = (HClustDatasetStanford)list.get(0);
        ParserFactory._getCache().add(string, (PersistentObject)hClustDatasetStanford, HClustDatasetStanford.class);
        ParserFactory._getCache().add(string, (PersistentObject)hClustDatasetStanford.getDataset(), Dataset.class);
        inputStream.close();
        return hClustDatasetStanford;
    }

    public static final HClustTree readHClustTree(File file, boolean bl) {
        return ParserFactory.readHClustTree(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final HClustTree readHClustTree(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, HClustTree.class) && bl) {
            inputStream.close();
            return (HClustTree)ParserFactory._getCache().get(string, HClustTree.class);
        }
        HClustTreeParser hClustTreeParser = new HClustTreeParser();
        List list = hClustTreeParser.parse(ParserFactory.toName(string), inputStream);
        HClustTree hClustTree = (HClustTree)list.get(0);
        ParserFactory._getCache().add(string, (PersistentObject)hClustTree, HClustTree.class);
        inputStream.close();
        return hClustTree;
    }

    public static final Dataframe readDataframe(File file, boolean bl, boolean bl2) {
        return ParserFactory.readDataframe(file.getPath(), ParserFactory.createInputStream(file), bl, bl2);
    }

    public static final Dataframe readDataframe(File file, boolean bl) {
        return ParserFactory.readDataframe(file.getPath(), ParserFactory.createInputStream(file), bl, true);
    }

    public static final Dataframe readDataframe(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readDataframe(string, inputStream, bl, true);
    }

    public static final Dataframe readDataframe(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Dataframe.class) && bl) {
            inputStream.close();
            return (Dataframe)ParserFactory._getCache().get(string, Dataframe.class);
        }
        DataframeParser dataframeParser = new DataframeParser();
        List list = dataframeParser.parse(ParserFactory.toName(string), inputStream);
        Dataframe dataframe = (Dataframe)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)dataframe, Dataframe.class);
        }
        inputStream.close();
        return dataframe;
    }

    public static final Dataframe readDataframe(String string) {
        return (Dataframe)new DataframeParser().parse(string).get(0);
    }

    public static final StringDataframe readStringDataframe(File file, boolean bl) {
        return ParserFactory.readStringDataframe(file.getPath(), ParserFactory.createInputStream(file), bl, true);
    }

    public static final StringDataframe readStringDataframe(File file, boolean bl, boolean bl2) {
        return ParserFactory.readStringDataframe(file.getPath(), ParserFactory.createInputStream(file), bl, bl2);
    }

    public static final StringDataframe readStringDataframe(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readStringDataframe(string, inputStream, bl, true);
    }

    public static final StringDataframe readStringDataframe(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, StringDataframe.class) && bl) {
            inputStream.close();
            return (StringDataframe)ParserFactory._getCache().get(string, StringDataframe.class);
        }
        StringDataframeParser stringDataframeParser = new StringDataframeParser();
        List list = stringDataframeParser.parse(ParserFactory.toName(string), inputStream);
        StringDataframe stringDataframe = (StringDataframe)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)stringDataframe, StringDataframe.class);
        }
        inputStream.close();
        return stringDataframe;
    }

    public static final StringDataframe readStringDataframe(String string) {
        return new StringDataframeParser().parse(string);
    }

    public static final SampleAnnot readSampleAnnot(String string, boolean bl) {
        return ParserFactory.readSampleAnnot(string, ParserFactory.createInputStream(string), bl);
    }

    public static final SampleAnnot readSampleAnnot(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readSampleAnnot(string, inputStream, bl, true);
    }

    public static final SampleAnnot readSampleAnnot(File file, boolean bl, boolean bl2) {
        return ParserFactory.readSampleAnnot(file.getPath(), ParserFactory.createInputStream(file), bl, bl2);
    }

    public static final SampleAnnot readSampleAnnot(String string, InputStream inputStream, boolean bl, boolean bl2) {
        AbstractSampleAnnot abstractSampleAnnot;
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, SampleAnnot.class) && bl) {
            return (SampleAnnot)ParserFactory._getCache().get(string, SampleAnnot.class);
        }
        MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc = MiscParsers.excel2sdf_and_colors(new File(string));
        StringDataframe stringDataframe = miscParsers$ExcelSdfColorStruc.sdf;
        if (!stringDataframe.hasColumn("SCHEMA")) {
            throw new IllegalArgumentException("The sin file has no SCHEMA file >" + string + "<");
        }
        String string2 = stringDataframe.getElement(0, "SCHEMA").toUpperCase();
        klog.debug("Schema: " + string2);
        if (string2.equalsIgnoreCase("GCM")) {
            abstractSampleAnnot = SampleAnnotGcm.parse(miscParsers$ExcelSdfColorStruc);
        } else if (string2.equalsIgnoreCase("GNF")) {
            abstractSampleAnnot = SampleAnnotGnf.parse(miscParsers$ExcelSdfColorStruc);
        } else if (string2.equalsIgnoreCase("NCI60")) {
            abstractSampleAnnot = SampleAnnotNCI60.parse(miscParsers$ExcelSdfColorStruc);
        } else {
            throw new IllegalArgumentException("Unknown sample annot schema: >" + string2 + "<");
        }
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)abstractSampleAnnot, SampleAnnot.class);
        }
        return abstractSampleAnnot;
    }

    public static final Template readTemplate(File file) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(file2), true, true, false);
    }

    public static final Template readTemplate(File file, boolean bl) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(file2), bl, true, false);
    }

    public static final Template readTemplate(File file, boolean bl, boolean bl2) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(file2), bl, true, bl2);
    }

    public static final Template readTemplate(File file, boolean bl, boolean bl2, boolean bl3) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(file2), bl, bl2, bl3);
    }

    public static final Template readTemplate(Element element, boolean bl) {
        return ParserFactory.readTemplate(ParserFactory.toFile(element, "TEMPLATE"), bl, false);
    }

    public static final Template[] readTemplates(File file, boolean bl) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory._readTemplates(file.getPath(), ParserFactory.createInputStream(file2), true, true, bl);
    }

    public static final Template[] readTemplates(File file, boolean bl, boolean bl2, boolean bl3) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory._readTemplates(file.getPath(), ParserFactory.createInputStream(file2), bl, bl2, bl3);
    }

    public static final Template[] readTemplates(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory._readTemplates(string, inputStream, bl, bl2, bl3);
    }

    public static final Template readTemplate(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("Param path_and_aux cannot be null");
        }
        Template[] templateArray = ParserFactory.readTemplates(string, inputStream, bl, bl2, bl3);
        if (AuxUtils.isAux(string)) {
            inputStream.close();
            return ParserFactory.findTemplate(ParserFactory.toName(string), templateArray);
        }
        inputStream.close();
        return templateArray[0];
    }

    public static final Template[] _readTemplates(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        Template[] templateArray;
        ArrayList<Template> arrayList;
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        HashSet hashSet = new HashSet();
        String string2 = AuxUtils.getBasePathFromAuxPath(string);
        File file = new File(string2);
        if (bl && ParserFactory._getCache().isCached(string2, Template.class)) {
            arrayList = ParserFactory._getCache().get(string2, Template.class);
            hashSet.add(arrayList);
            inputStream.close();
        } else {
            arrayList = new ClsParser();
            arrayList.setSilentMode(bl3);
            if (AuxUtils.isAux(string)) {
                file = AuxUtils.getBaseFileFromAuxFile(new File(string));
                templateArray = arrayList.parse(file.getName(), file);
                hashSet.addAll(templateArray);
            } else {
                templateArray = arrayList.parse(ParserFactory.toName(string), inputStream);
                hashSet.addAll(templateArray);
                file = new File(string);
            }
        }
        inputStream.close();
        arrayList = new ArrayList<Template>();
        templateArray = hashSet.toArray(new Template[hashSet.size()]);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            boolean bl4;
            Template[] templateArray2 = TemplateFactory.extractAllPossibleTemplates(templateArray[i2], true);
            for (bl4 = false; bl4 < templateArray2.length; bl4 += 1) {
                arrayList.add(templateArray2[bl4]);
            }
            if (!bl3) {
                klog.debug("From: " + string + " (and its supers & auxes) total # of templates made: " + arrayList.size());
            }
            if (!bl2) continue;
            bl4 = false;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Template template = (Template)arrayList.get(i3);
                if (i3 == arrayList.size() - 1) {
                    bl4 = true;
                }
                if (bl3) {
                    bl4 = false;
                }
                if (template.isAux()) {
                    File file2 = new File(file.getParentFile(), template.getName());
                    ParserFactory._getCache().add(file2, (PersistentObject)template, Template.class, bl4);
                    continue;
                }
                ParserFactory._getCache().add(file, (PersistentObject)template, Template.class, bl4);
            }
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public static final HClustTree getDefaultGeneTreeForHClustDataset(HClustDatasetStanford hClustDatasetStanford) {
        return ParserFactory._getDefaultXTreeForHClustDataset(hClustDatasetStanford, "gtr");
    }

    public static final HClustTree getDefaultGeneTreeForHClustDatasetOrNull(HClustDatasetStanford hClustDatasetStanford) {
        try {
            return ParserFactory.getDefaultGeneTreeForHClustDataset(hClustDatasetStanford);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final HClustTree getDefaultArrayTreeForHClustDataset(HClustDatasetStanford hClustDatasetStanford) {
        return ParserFactory._getDefaultXTreeForHClustDataset(hClustDatasetStanford, "atr");
    }

    public static final HClustTree getDefaultArrayTreeForHClustDatasetOrNull(HClustDatasetStanford hClustDatasetStanford) {
        try {
            return ParserFactory.getDefaultArrayTreeForHClustDataset(hClustDatasetStanford);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static HClustTree _getDefaultXTreeForHClustDataset(HClustDatasetStanford hClustDatasetStanford, String string) {
        if (hClustDatasetStanford == null) {
            throw new IllegalArgumentException("Parameter cds cannot be null");
        }
        File file = ParserFactory._getCache().getSourceFile(hClustDatasetStanford);
        if (file == null) {
            throw new IllegalArgumentException("CDT file for HClustDataset does not exist: " + hClustDatasetStanford.getName());
        }
        String string2 = FileUtils.removeExtension(file.getName());
        File file2 = new File(file.getParentFile(), string2 + "." + string);
        return ParserFactory.readHClustTree(file2, true);
    }

    public static final GeneSet readGeneSet(File file, boolean bl) {
        return ParserFactory.readGeneSet(file, bl, true);
    }

    public static final GeneSet readGeneSet(File file, boolean bl, boolean bl2) {
        InputStream inputStream = ParserFactory.createInputStream(file);
        return ParserFactory.readGeneSet(file.getPath(), inputStream, bl, bl2);
    }

    public static final GeneSet readGeneSet(Element element, boolean bl) {
        return ParserFactory.readGeneSet(ParserFactory.toFile(element, "GENESET"), bl);
    }

    public static final GeneSet readGeneSet(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readGeneSet(string, inputStream, bl, true);
    }

    public static final GeneSet readGeneSet(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, GeneSet.class) && bl) {
            inputStream.close();
            return (GeneSet)ParserFactory._getCache().get(string, GeneSet.class);
        }
        if (AuxUtils.isAux(string)) {
            String string2 = AuxUtils.getAuxNameOnlyNoHash(string);
            int n = string.indexOf("gin.xls");
            if (n != -1) {
                File file = AuxUtils.getBaseFileFromFullPath(string);
                GenesOfInterest genesOfInterest = ParserFactory.readGenesOfInterest(file, bl);
                return genesOfInterest.getGeneSet(string2);
            }
            File file = AuxUtils.getBaseFileFromAuxFile(new File(string));
            GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(file, bl, true, bl2);
            return geneSetMatrix.getGeneSet(string2);
        }
        if (string.endsWith("gin.xls")) {
            GenesOfInterest genesOfInterest = ParserFactory.readGenesOfInterest(string, bl);
            GeneSet geneSet = genesOfInterest.getAsOneGeneSet();
            ParserFactory._getCache().addInvisibly(string, (PersistentObject)geneSet);
            return geneSet;
        }
        FSetParser fSetParser = new FSetParser();
        GeneSet geneSet = (GeneSet)fSetParser.parse(ParserFactory.toName(string), inputStream).get(0);
        ParserFactory._getCache().addInvisibly(string, (PersistentObject)new DefaultGeneSetMatrix(geneSet.getName(), new GeneSet[]{geneSet}));
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)geneSet, GeneSet.class);
        }
        inputStream.close();
        return geneSet;
    }

    public static final Report readReport(File file, boolean bl) {
        if (file.isDirectory()) {
            file = FileUtils.findFile(file, ".rpt", true);
        }
        return ParserFactory.readReport(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Report readReport(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Report.class) && bl) {
            inputStream.close();
            return (Report)ParserFactory._getCache().get(string, Report.class);
        }
        ReportParser reportParser = new ReportParser();
        Report report = (Report)reportParser.parse(ParserFactory.toName(string), inputStream).get(0);
        if (bl) {
            ParserFactory._getCache().add(string, (PersistentObject)report, Report.class);
        }
        inputStream.close();
        return report;
    }

    public static final Chip readChip(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        return ParserFactory.readChip(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final Chip readChip(String string, boolean bl) {
        return ParserFactory.readChip(string, ParserFactory.createInputStream(string), bl);
    }

    public static final Chip readChip(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, Chip.class) && bl) {
            inputStream.close();
            return (Chip)ParserFactory._getCache().get(string, Chip.class);
        }
        ChipParser chipParser = new ChipParser();
        Chip chip = (Chip)chipParser.parse(string, inputStream).get(0);
        if (bl) {
            ParserFactory._getCache().add(string, (PersistentObject)chip, Chip.class);
        }
        inputStream.close();
        return chip;
    }

    public static final RankedList readRankedList(File file, boolean bl) {
        return ParserFactory.readRankedList(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final RankedList readRankedList(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readRankedList(file.getPath(), ParserFactory.createInputStream(file), bl, bl, bl2, bl3);
    }

    public static final RankedList readRankedList(String string, boolean bl) {
        return ParserFactory.readRankedList(string, ParserFactory.createInputStream(string), bl);
    }

    public static final RankedList readRankedList(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readRankedList(string, inputStream, bl, true, false, false);
    }

    public static final RankedList readRankedList(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, RankedList.class) && bl) {
            inputStream.close();
            return (RankedList)ParserFactory._getCache().get(string, RankedList.class);
        }
        RankedListParser rankedListParser = new RankedListParser();
        rankedListParser.setSilentMode(bl3);
        RankedList rankedList = bl4 ? (RankedList)rankedListParser.parse_fast_no_sort(string, inputStream).get(0) : (RankedList)rankedListParser.parse(string, inputStream).get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)rankedList, RankedList.class);
        }
        inputStream.close();
        return rankedList;
    }

    public static final GenesOfInterest readGenesOfInterest(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        return ParserFactory.readGenesOfInterest(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final GenesOfInterest readGenesOfInterest(String string, boolean bl) {
        return ParserFactory.readGenesOfInterest(string, ParserFactory.createInputStream(string), bl);
    }

    public static final GenesOfInterest readGenesOfInterest(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, GenesOfInterest.class) && bl) {
            inputStream.close();
            return (GenesOfInterest)ParserFactory._getCache().get(string, GenesOfInterest.class);
        }
        GinParser_xls ginParser_xls = new GinParser_xls();
        GenesOfInterest genesOfInterest = (GenesOfInterest)ginParser_xls.parse(string, inputStream).get(0);
        File file = new File(string).getParentFile();
        for (int i2 = 0; i2 < genesOfInterest.getNumGeneLists(); ++i2) {
            GeneSet geneSet = genesOfInterest.getGeneList(i2).toGeneSet();
            File file2 = new File(file, geneSet.getName());
            ParserFactory._getCache().add(file2, (PersistentObject)geneSet, GeneSet.class);
        }
        if (bl) {
            ParserFactory._getCache().add(string, (PersistentObject)genesOfInterest, GenesOfInterest.class);
        }
        inputStream.close();
        return genesOfInterest;
    }

    public static final TxtAffy readTxtAffy(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readTxtAffy(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, bl3);
    }

    public static final TxtAffy readTxtAffy(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, TxtAffy.class) && bl) {
            return (TxtAffy)ParserFactory._getCache().get(string, TxtAffy.class);
        }
        TxtAffyParser txtAffyParser = new TxtAffyParser();
        txtAffyParser.setSilentMode(bl3);
        List list = txtAffyParser.parse(string, inputStream);
        TxtAffy txtAffy = (TxtAffy)list.get(0);
        if (bl2) {
            ParserFactory._getCache().add(string, (PersistentObject)txtAffy, TxtAffy.class);
        }
        inputStream.close();
        return txtAffy;
    }

    public static final EnrichmentDb readEdb(File file, boolean bl) {
        return ParserFactory.readEdb(file, bl, false);
    }

    public static final EnrichmentDb readEdb(String string, boolean bl) {
        return ParserFactory.readEdb(new File(string), bl, false);
    }

    public static final EnrichmentDb readEdb(File file, boolean bl, boolean bl2) {
        if (file == null) {
            throw new IllegalArgumentException("Param gseaResultDir cannot be null");
        }
        if (ParserFactory._getCache().isCached(file, EnrichmentDb.class) && bl) {
            return (EnrichmentDb)ParserFactory._getCache().get(file, EnrichmentDb.class);
        }
        EdbFolderParser edbFolderParser = new EdbFolderParser();
        edbFolderParser.setSilentMode(bl2);
        EnrichmentDbImpl_one_shared_rl enrichmentDbImpl_one_shared_rl = new EdbFolderParser().parseEdb(file);
        ParserFactory._getCache().add(file, (PersistentObject)enrichmentDbImpl_one_shared_rl, EnrichmentDb.class);
        return enrichmentDbImpl_one_shared_rl;
    }

    public static final DtgDataset readDtgDataset(File file, boolean bl) {
        return ParserFactory.readDtgDataset(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final DtgDataset readDtgDataset(String string, InputStream inputStream, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, DtgDataset.class) && bl) {
            inputStream.close();
            return (DtgDataset)ParserFactory._getCache().get(string, DtgDataset.class);
        }
        DtgDatasetParser dtgDatasetParser = new DtgDatasetParser();
        DtgDataset dtgDataset = (DtgDataset)dtgDatasetParser.parse(ParserFactory.toName(string), inputStream).get(0);
        ParserFactory._getCache().add(string, (PersistentObject)dtgDataset, DtgDataset.class);
        inputStream.close();
        return dtgDataset;
    }

    public static final GeneSetMatrix readGeneSetMatrix(File file, boolean bl) {
        return ParserFactory.readGeneSetMatrix(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final GeneSetMatrix readGeneSetMatrix(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readGeneSetMatrix(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, bl3);
    }

    public static final GeneSetMatrix readGeneSetMatrix(Element element, boolean bl) {
        return ParserFactory.readGeneSetMatrix(ParserFactory.toFile(element, "GENESETMATRIX"), bl);
    }

    public static final GeneSetMatrix readGeneSetMatrix(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readGeneSetMatrix(string, inputStream, bl, true, true);
    }

    private static GeneSetMatrix readGeneSetMatrix(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(string)) {
            string = AuxUtils.getBasePathFromAuxPath(string);
        }
        if ((string2 = NamingConventions.getExtension(string)).equals("gmt")) {
            return ParserFactory.readGeneSetMatrixT(string, inputStream, bl, bl2, bl3);
        }
        if (string2.equals("grp")) {
            GeneSet geneSet = ParserFactory.readGeneSet(string, inputStream, bl, bl3);
            return new DefaultGeneSetMatrix(ParserFactory.toName(string), new GeneSet[]{geneSet});
        }
        if (ParserFactory._getCache().isCached(string, GeneSetMatrix.class) && bl) {
            inputStream.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(string, GeneSetMatrix.class);
        }
        GmxParser gmxParser = new GmxParser();
        gmxParser.setCheckForDuplicates(bl2);
        GeneSetMatrix geneSetMatrix = (GeneSetMatrix)gmxParser.parse(ParserFactory.toName(string), inputStream).get(0);
        if (bl3) {
            ParserFactory._getCache().add(string, (PersistentObject)geneSetMatrix, GeneSetMatrix.class);
        }
        File file = new File(string).getParentFile();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            File file2 = new File(file, geneSetMatrix.getGeneSet(i2).getName());
            if (!bl3) continue;
            ParserFactory._getCache().addInvisibly(file2, (PersistentObject)geneSetMatrix.getGeneSet(i2));
        }
        if (bl3) {
            ParserFactory._getCache().sortModel(GeneSet.class);
            ParserFactory._getCache().hackAddAuxSets(geneSetMatrix);
        }
        inputStream.close();
        return geneSetMatrix;
    }

    public static final GeneSetMatrix readGeneSetMatrixT(File file, boolean bl) {
        return ParserFactory.readGeneSetMatrixT(file.getPath(), ParserFactory.createInputStream(file), bl);
    }

    public static final GeneSetMatrix readGeneSetMatrixT(File file, boolean bl, boolean bl2, boolean bl3) {
        return ParserFactory.readGeneSetMatrixT(file.getPath(), ParserFactory.createInputStream(file), bl, bl2, bl3);
    }

    public static final GeneSetMatrix readGeneSetMatrixT(String string, InputStream inputStream, boolean bl) {
        return ParserFactory.readGeneSetMatrixT(string, inputStream, bl, true, true);
    }

    public static final GeneSetMatrix readGeneSetMatrixT(String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(string)) {
            string = AuxUtils.getBasePathFromAuxPath(string);
        }
        if ((string2 = NamingConventions.getExtension(string)).equals("gmx")) {
            return ParserFactory.readGeneSetMatrix(string, inputStream, bl, bl2, bl3);
        }
        if (string2.equals("grp")) {
            GeneSet geneSet = ParserFactory.readGeneSet(string, inputStream, bl);
            return new DefaultGeneSetMatrix(ParserFactory.toName(string), new GeneSet[]{geneSet});
        }
        if (ParserFactory._getCache().isCached(string, GeneSetMatrix.class) && bl) {
            inputStream.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(string, GeneSetMatrix.class);
        }
        GmtParser gmtParser = new GmtParser();
        GeneSetMatrix geneSetMatrix = (GeneSetMatrix)gmtParser.parse(ParserFactory.toName(string), inputStream).get(0);
        ParserFactory._getCache().add(string, (PersistentObject)geneSetMatrix, GeneSetMatrix.class);
        File file = new File(string).getParentFile();
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            File file2 = new File(file, geneSetMatrix.getGeneSet(i2).getName());
            ParserFactory._getCache().addInvisibly(file2, (PersistentObject)geneSetMatrix.getGeneSet(i2));
        }
        ParserFactory._getCache().hackAddAuxSets(geneSetMatrix);
        inputStream.close();
        return geneSetMatrix;
    }

    public static final MSigDB readMSigDB(File file, boolean bl) {
        return ParserFactory.readMSigDB(file.getPath(), ParserFactory.createInputStream(file), bl, false);
    }

    public static final MSigDB readMSigDB(String string, boolean bl) {
        return ParserFactory.readMSigDB(string, ParserFactory.createInputStream(string), bl, false);
    }

    public static final MSigDB readMSigDB(String string, boolean bl, boolean bl2) {
        return ParserFactory.readMSigDB(string, ParserFactory.createInputStream(string), bl, bl2);
    }

    public static final MSigDB readMSigDB(String string, InputStream inputStream, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (ParserFactory._getCache().isCached(string, MSigDB.class) && bl) {
            return (MSigDB)ParserFactory._getCache().get(string, MSigDB.class);
        }
        MSigDBParser mSigDBParser = new MSigDBParser();
        MSigDB mSigDB = (MSigDB)mSigDBParser.parse(string, inputStream).get(0);
        ParserFactory._getCache().add(string, (PersistentObject)mSigDB, MSigDB.class);
        return mSigDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PersistentObject read(String string, InputStream inputStream, boolean bl) {
        try {
            if (string == null) {
                throw new IllegalArgumentException("Param file cannot be null");
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Param is cannot be null");
            }
            String string2 = ParserFactory.stripAt(string);
            String string3 = NamingConventions.getExtensionLiberal(string2).toLowerCase();
            if (string3.equalsIgnoreCase("res")) {
                Dataset dataset = ParserFactory.readDataset(string, inputStream, bl);
                return dataset;
            }
            if (string3.equalsIgnoreCase("gct")) {
                Dataset dataset = ParserFactory.readDatasetGct(string, inputStream, bl);
                return dataset;
            }
            if (string3.equalsIgnoreCase("txt")) {
                Dataset dataset = ParserFactory.readDatasetTXT(string, inputStream, bl);
                return dataset;
            }
            if (string3.equalsIgnoreCase("mat")) {
                Matrix matrix = ParserFactory.readMatrix(string, inputStream, false);
                return matrix;
            }
            if (string3.equalsIgnoreCase("pcl")) {
                Dataset dataset = ParserFactory.readDatasetPcl(string, inputStream, bl);
                return dataset;
            }
            if (string3.equalsIgnoreCase("cdt")) {
                HClustDatasetStanford hClustDatasetStanford = ParserFactory.readHClustDataset(string, inputStream, bl);
                return hClustDatasetStanford;
            }
            if (string3.equalsIgnoreCase("gtr")) {
                HClustTree hClustTree = ParserFactory.readHClustTree(string, inputStream, bl);
                return hClustTree;
            }
            if (string3.equalsIgnoreCase("atr")) {
                HClustTree hClustTree = ParserFactory.readHClustTree(string, inputStream, bl);
                return hClustTree;
            }
            if (string3.startsWith("cls")) {
                Template template = ParserFactory.readTemplate(string, inputStream, bl, bl, false);
                return template;
            }
            if (string3.equalsIgnoreCase("grp")) {
                GeneSet geneSet = ParserFactory.readGeneSet(string, inputStream, bl);
                return geneSet;
            }
            if (string3.equalsIgnoreCase("rnk")) {
                RankedList rankedList = ParserFactory.readRankedList(string, inputStream, bl);
                return rankedList;
            }
            if (string3.startsWith("gmx")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(string, inputStream, bl);
                return geneSetMatrix;
            }
            if (string3.startsWith("gmt")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrixT(string, inputStream, bl);
                return geneSetMatrix;
            }
            if (string3.equalsIgnoreCase("dfr")) {
                Dataframe dataframe = ParserFactory.readDataframe(string, inputStream, bl);
                return dataframe;
            }
            if (string3.equalsIgnoreCase("edb")) {
                EnrichmentDb enrichmentDb = ParserFactory.readEdb(string, bl);
                return enrichmentDb;
            }
            if (string3.equalsIgnoreCase("rpt")) {
                Report report = ParserFactory.readReport(string, inputStream, bl);
                return report;
            }
            if (string3.equalsIgnoreCase("chip") || string3.equalsIgnoreCase("csv")) {
                Chip chip = ParserFactory.readChip(string, inputStream, bl);
                return chip;
            }
            if (string3.equalsIgnoreCase("dtgds")) {
                DtgDataset dtgDataset = ParserFactory.readDtgDataset(string, inputStream, bl);
                return dtgDataset;
            }
            if (string3.equalsIgnoreCase("gin") || string.endsWith("gin.xls")) {
                GenesOfInterest genesOfInterest = ParserFactory.readGenesOfInterest(string, inputStream, bl);
                return genesOfInterest;
            }
            if (string3.equalsIgnoreCase("sin") || string.endsWith("sin.xls")) {
                SampleAnnot sampleAnnot = ParserFactory.readSampleAnnot(new File(string), bl, bl);
                return sampleAnnot;
            }
            if (string3.equalsIgnoreCase("dchip")) {
                Dataset dataset = ParserFactory.readDatasetDChip(string, inputStream, bl);
                return dataset;
            }
            if (string3.equalsIgnoreCase("sdf")) {
                StringDataframe stringDataframe = ParserFactory.readStringDataframe(string, inputStream, bl);
                return stringDataframe;
            }
            try {
                throw new IllegalArgumentException("Unkown file format: " + string + " no known Parser for ext: " + string3);
            }
            catch (InterruptedIOException interruptedIOException) {
                klog.info("progress exception - possibly cancelled ... ignoring");
                string3 = null;
                return string3;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static final PersistentObject read(File file) {
        return ParserFactory.read(file, true);
    }

    public static final PersistentObject read(File file, boolean bl) {
        File file2 = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.read(file.getPath(), ParserFactory.createInputStream(file2), bl);
    }

    private static String stripAt(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        return stringTokenizer.nextToken();
    }

    public static final PersistentObject[] read(File[] fileArray) {
        PersistentObject[] persistentObjectArray = new PersistentObject[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            persistentObjectArray[i2] = ParserFactory.read(fileArray[i2]);
        }
        return persistentObjectArray;
    }

    public static final void save(File file, DataFormat dataFormat, File file2) {
        ParserFactory.save(file, new DataFormat[]{dataFormat}, file2);
    }

    public static final void save(File file, DataFormat[] dataFormatArray, File file2) {
        PersistentObject persistentObject = ParserFactory.read(file.getPath(), ParserFactory.createInputStream(file), true);
        ParserFactory.save(persistentObject, dataFormatArray, file2);
    }

    public static final void save(Object object, DataFormat[] dataFormatArray, File file) {
        if (object instanceof PersistentObject) {
            ParserFactory.save((PersistentObject)object, dataFormatArray, file);
        } else if (object instanceof File) {
            ParserFactory.save((File)object, dataFormatArray, file);
        } else {
            throw new IllegalArgumentException("Invalid object type only File or Pob allowed. Got: " + object);
        }
    }

    public static final void save(Object object, DataFormat dataFormat, File file) {
        ParserFactory.save(object, new DataFormat[]{dataFormat}, file);
    }

    public static final File[] save(PersistentObject persistentObject, DataFormat[] dataFormatArray, File file) {
        File[] fileArray = new File[dataFormatArray.length];
        for (int i2 = 0; i2 < dataFormatArray.length; ++i2) {
            Parser parser = dataFormatArray[i2].createParser();
            if (parser == null) {
                throw new IllegalArgumentException("No known parser for format: " + dataFormatArray[i2].getExtension());
            }
            String string = FileUtils.removeExtension(persistentObject.getName()) + "." + dataFormatArray[i2].getExtension();
            fileArray[i2] = new File(file, string);
            parser.export(persistentObject, fileArray[i2]);
        }
        return fileArray;
    }

    public static final File save(PersistentObject persistentObject, DataFormat dataFormat, File file) {
        return ParserFactory.save(persistentObject, new DataFormat[]{dataFormat}, file)[0];
    }

    public static final void saveTmp(PersistentObject persistentObject) {
        File file = File.createTempFile(persistentObject.getName() + "_", "." + DataFormat.getExtension(persistentObject));
        ParserFactory.save(persistentObject, file);
    }

    public static final void save(PersistentObject persistentObject, File file) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        if (persistentObject instanceof Dataset) {
            file = ParserFactory.ensureCorrectExt(file, "res");
            ParserFactory.save((Dataset)persistentObject, file);
        } else if (persistentObject instanceof HClustDatasetStanford) {
            file = ParserFactory.ensureCorrectExt(file, "cdt");
            ParserFactory.save((HClustDatasetStanford)persistentObject, file);
        } else if (persistentObject instanceof HClustTree) {
            file = ParserFactory.ensureCorrectExt(file, "gtr");
            ParserFactory.save((HClustTree)persistentObject, file);
        } else if (persistentObject instanceof Template) {
            file = ParserFactory.ensureCorrectExt(file, "cls");
            ParserFactory.save((Template)persistentObject, file);
        } else if (persistentObject instanceof GeneSet) {
            file = ParserFactory.ensureCorrectExt(file, "grp");
            ParserFactory.save((GeneSet)persistentObject, file);
        } else if (persistentObject instanceof RankedList) {
            file = ParserFactory.ensureCorrectExt(file, "rnk");
            ParserFactory.save((RankedList)persistentObject, file);
        } else if (persistentObject instanceof GeneSetMatrix) {
            file = ParserFactory.ensureCorrectExt(file, "gmx");
            ParserFactory.save((GeneSetMatrix)persistentObject, file);
        } else if (persistentObject instanceof Dataframe) {
            file = ParserFactory.ensureCorrectExt(file, "dfr");
            ParserFactory.save((Dataframe)persistentObject, file);
        } else if (persistentObject instanceof StringDataframe) {
            file = ParserFactory.ensureCorrectExt(file, "sdf");
            ParserFactory.save((StringDataframe)persistentObject, file);
        } else if (persistentObject instanceof Report) {
            file = ParserFactory.ensureCorrectExt(file, "rpt");
            ParserFactory.save((Report)persistentObject, file);
        } else if (persistentObject instanceof EnrichmentDb) {
            file = ParserFactory.ensureCorrectExt(file, "edb");
            ParserFactory.save((EnrichmentDb)persistentObject, file);
        } else if (persistentObject instanceof DtgDataset) {
            file = ParserFactory.ensureCorrectExt(file, "dtgds");
            ParserFactory.save((DtgDataset)persistentObject, file);
        } else if (persistentObject instanceof Matrix) {
            file = ParserFactory.ensureCorrectExt(file, "mat");
            MiscParsers.save((Matrix)persistentObject, file);
        } else {
            if (persistentObject instanceof RankedListDb) {
                throw new NotImplementedException();
            }
            if (persistentObject instanceof EnrichmentDbMulti) {
                throw new NotImplementedException();
            }
            throw new IllegalArgumentException("No save method available for: " + persistentObject.getName() + " class: " + persistentObject.getClass());
        }
    }

    protected static final File ensureCorrectExt(File file, String string) {
        String string2 = NamingConventions.getExtension(file);
        if (string2.equals(string)) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + string);
    }

    protected static final File ensureCorrectExt(File file, PersistentObject persistentObject) {
        String string = DataFormat.getExtension(persistentObject);
        String string2 = NamingConventions.getExtension(file);
        if (string2.equals(string)) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + string);
    }

    public static final File save(Dataset dataset, File file) {
        GctParser gctParser = new GctParser();
        gctParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
        return file;
    }

    public static final File saveGct(Dataset dataset, File file) {
        return ParserFactory.saveGct(dataset, file, true);
    }

    public static final File saveGct(Dataset dataset, File file, boolean bl) {
        GctParser gctParser = new GctParser();
        gctParser.export((PersistentObject)dataset, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
        }
        return file;
    }

    public static final File saveRes(Dataset dataset, File file, boolean bl) {
        ResParser resParser = new ResParser();
        resParser.export((PersistentObject)dataset, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
        }
        return file;
    }

    public static final File saveCls(String string, String[] stringArray, String string2, String[] stringArray2, File file, boolean bl) {
        ClsBySampleNameParser clsBySampleNameParser = new ClsBySampleNameParser();
        clsBySampleNameParser.export(string, stringArray, string2, stringArray2, file);
        if (bl) {
            Template template = (Template)clsBySampleNameParser.parse(file.getName(), ParserFactory.createInputStream(file)).get(0);
            ParserFactory._getCache().add(file, (PersistentObject)template, Template.class);
        }
        return file;
    }

    public static final File saveCls(TemplateImplFromSampleNames templateImplFromSampleNames, File file, boolean bl) {
        ClsBySampleNameParser clsBySampleNameParser = new ClsBySampleNameParser();
        clsBySampleNameParser.export(templateImplFromSampleNames.getClassName(0), templateImplFromSampleNames.getClassASampleNames(), templateImplFromSampleNames.getClassName(1), templateImplFromSampleNames.getClassBSampleNames(), file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)templateImplFromSampleNames, Template.class);
        }
        return file;
    }

    public static final void savePcl(Dataset dataset, File file) {
        PclParser pclParser = new PclParser();
        pclParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
    }

    public static final void save(Chip chip, File file) {
        ChipParser chipParser = new ChipParser();
        chipParser.export((PersistentObject)chip, file);
        ParserFactory._getCache().add(file, (PersistentObject)chip, Chip.class);
    }

    public static final void saveInvisibly2CacheGct(Dataset dataset, File file) {
        GctParser gctParser = new GctParser();
        gctParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)dataset);
    }

    public static final void saveTxt(Dataset dataset, File file) {
        TxtDatasetParser txtDatasetParser = new TxtDatasetParser();
        txtDatasetParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
    }

    public static final void saveInvisibly2CacheTxt(Dataset dataset, File file) {
        TxtDatasetParser txtDatasetParser = new TxtDatasetParser();
        txtDatasetParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)dataset);
    }

    public static final void saveDChip(Dataset dataset, File file) {
        DChipDatasetParser dChipDatasetParser = new DChipDatasetParser();
        dChipDatasetParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().add(file, (PersistentObject)dataset, Dataset.class);
    }

    public static final void saveInvisibly2CacheDChip(Dataset dataset, File file) {
        DChipDatasetParser dChipDatasetParser = new DChipDatasetParser();
        dChipDatasetParser.export((PersistentObject)dataset, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)dataset);
    }

    public static final void save(DtgDataset dtgDataset, File file) {
        DtgDatasetParser dtgDatasetParser = new DtgDatasetParser();
        dtgDatasetParser.export((PersistentObject)dtgDataset, file);
        ParserFactory._getCache().add(file, (PersistentObject)dtgDataset, DtgDataset.class);
    }

    public static final void save(HClustDatasetStanford hClustDatasetStanford, File file) {
        HClustDatasetParser hClustDatasetParser = new HClustDatasetParser();
        hClustDatasetParser.export((PersistentObject)hClustDatasetStanford, file);
        ParserFactory._getCache().add(file, (PersistentObject)hClustDatasetStanford, HClustDatasetStanford.class);
    }

    public static final void save(HClustTree hClustTree, File file) {
        HClustTreeParser hClustTreeParser = new HClustTreeParser();
        hClustTreeParser.export((PersistentObject)hClustTree, file);
        ParserFactory._getCache().add(file, (PersistentObject)hClustTree, HClustTree.class);
    }

    public static final void save(IDataframe iDataframe, File file) {
        if (iDataframe == null) {
            throw new IllegalArgumentException("Param idf cannot be null");
        }
        if (iDataframe instanceof Dataframe) {
            ParserFactory.save((Dataframe)iDataframe, file, false);
        } else if (iDataframe instanceof StringDataframe) {
            ParserFactory.save((StringDataframe)iDataframe, file);
        } else if (iDataframe instanceof RichDataframe) {
            StringDataframe stringDataframe = (StringDataframe)((RichDataframe)iDataframe).getDataframe();
            ParserFactory.save(stringDataframe, file);
        } else {
            throw new NotImplementedException("class was for: " + iDataframe.getClass());
        }
    }

    public static final void saveInvisibly2Cache(IDataframe iDataframe, File file) {
        if (iDataframe instanceof Dataframe) {
            ParserFactory.saveInvisibly2Cache((Dataframe)iDataframe, file);
        } else if (iDataframe instanceof StringDataframe) {
            ParserFactory.saveInvisibly2Cache((StringDataframe)iDataframe, file);
        } else {
            throw new NotImplementedException();
        }
    }

    public static final void save(Dataframe dataframe, File file, boolean bl) {
        DataframeParser dataframeParser = new DataframeParser();
        dataframeParser.export((PersistentObject)dataframe, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)dataframe, Dataframe.class);
        }
    }

    public static final void saveInvisibly2Cache(Dataframe dataframe, File file) {
        DataframeParser dataframeParser = new DataframeParser();
        dataframeParser.export((PersistentObject)dataframe, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)dataframe);
    }

    public static final void saveWithRowDescs(Dataframe dataframe, List list, File file) {
        DataframeParser dataframeParser = new DataframeParser();
        dataframeParser.exportWithDescs(dataframe, list, file);
        ParserFactory._getCache().add(file, (PersistentObject)dataframe, Dataframe.class);
    }

    public static final void save(Dataset[] datasetArray, File file) {
        for (int i2 = 0; i2 < datasetArray.length; ++i2) {
            ParserFactory.save(datasetArray[i2], new File(file, datasetArray[i2].getName() + "." + "res"));
        }
    }

    public static final void save(EnrichmentDb enrichmentDb, File file) {
        EdbFolderParser edbFolderParser = new EdbFolderParser();
        edbFolderParser.export((PersistentObject)enrichmentDb, file);
        ParserFactory._getCache().add(file, (PersistentObject)enrichmentDb, EnrichmentDb.class);
    }

    public static final void saveInvisibly2Cache(EnrichmentDb enrichmentDb, File file) {
        EdbFolderParser edbFolderParser = new EdbFolderParser();
        edbFolderParser.export((PersistentObject)enrichmentDb, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)enrichmentDb);
    }

    public static final void save(RankedList rankedList, File file) {
        ParserFactory.save(rankedList, file, false);
    }

    public static final void save(RankedList rankedList, File file, boolean bl) {
        RankedListParser rankedListParser = new RankedListParser();
        rankedListParser.export((PersistentObject)rankedList, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)rankedList, RankedList.class);
        }
    }

    public static final void save(Template template, File file) {
        ParserFactory.save(template, false, file);
    }

    public static final void save(Template template, boolean bl, File file) {
        ClsParser clsParser = new ClsParser();
        clsParser.export(template, bl, file);
        ParserFactory._getCache().add(file, (PersistentObject)template, Template.class);
    }

    public static final void save(Template template, File file, boolean bl) {
        ClsParser clsParser = new ClsParser();
        clsParser.export((PersistentObject)template, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)template, Template.class);
        }
    }

    public static final void saveInvisibly2Cache(Template template, File file) {
        ClsParser clsParser = new ClsParser();
        clsParser.export((PersistentObject)template, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)template);
    }

    public static final void save(Template[] templateArray, File file) {
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            ParserFactory.save(templateArray[i2], new File(file, templateArray[i2].getName() + "." + "cls"));
        }
    }

    public static final void save(GeneSet geneSet, File file) {
        FSetParser fSetParser = new FSetParser();
        fSetParser.export((PersistentObject)geneSet, file);
        ParserFactory._getCache().add(file, (PersistentObject)geneSet, GeneSet.class);
    }

    public static final void saveGmt(GeneSetMatrix geneSetMatrix, File file) {
        GmtParser gmtParser = new GmtParser();
        gmtParser.export((PersistentObject)geneSetMatrix, file);
        ParserFactory._getCache().add(file, (PersistentObject)geneSetMatrix, GeneSetMatrix.class);
    }

    public static final void saveGmt(GeneSetMatrix geneSetMatrix, File file, boolean bl) {
        GmtParser gmtParser = new GmtParser();
        gmtParser.export((PersistentObject)geneSetMatrix, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)geneSetMatrix, GeneSetMatrix.class);
        }
    }

    public static final void save(GeneSetMatrix geneSetMatrix, File file) {
        ParserFactory.save(geneSetMatrix, file, true);
    }

    public static final void save(GeneSetMatrix geneSetMatrix, File file, boolean bl) {
        GmxParser gmxParser = new GmxParser();
        gmxParser.export((PersistentObject)geneSetMatrix, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)geneSetMatrix, GeneSetMatrix.class);
        }
    }

    public static final void save(Report report, File file) {
        ParserFactory.save(report, file, true);
    }

    public static final void save(Report report, File file, boolean bl) {
        ReportParser reportParser = new ReportParser();
        reportParser.export((PersistentObject)report, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)report, Report.class);
        }
    }

    public static final void save(StringDataframe stringDataframe, File file) {
        ParserFactory.save(stringDataframe, file, true);
    }

    public static final void save(StringDataframe stringDataframe, File file, boolean bl) {
        StringDataframeParser stringDataframeParser = new StringDataframeParser();
        stringDataframeParser.export((PersistentObject)stringDataframe, file);
        if (bl) {
            ParserFactory._getCache().add(file, (PersistentObject)stringDataframe, StringDataframe.class);
        }
    }

    public static final void saveInvisibly2Cache(StringDataframe stringDataframe, File file) {
        StringDataframeParser stringDataframeParser = new StringDataframeParser();
        stringDataframeParser.export((PersistentObject)stringDataframe, file);
        ParserFactory._getCache().addInvisibly(file, (PersistentObject)stringDataframe);
    }

    public static final Template findTemplate(String string, Template[] templateArray) {
        if (AuxUtils.getAuxNameOnlyNoHash(string).equals(AuxUtils.getBaseStringFromAux(string))) {
            string = AuxUtils.getAuxNameOnlyNoHash(string);
        }
        if (AuxUtils.isAux(string) && string.endsWith(".cls")) {
            string = string.substring(0, string.length() - 4);
        }
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            if (templateArray[i2].getName().equals(string)) {
                return templateArray[i2];
            }
            if (!templateArray[i2].isContinuous()) continue;
            String string2 = AuxUtils.getAuxNameOnlyNoHash(string);
            if (!templateArray[i2].getName().equals(string2)) continue;
            return templateArray[i2];
        }
        StringBuffer stringBuffer = new StringBuffer("<html>\n<body>\n<p>No template for name: " + string + "</p>" + "<p>The Available templates are:</p>\n");
        for (int i3 = 0; i3 < templateArray.length; ++i3) {
            stringBuffer.append(templateArray[i3].getName()).append("<br>\n");
        }
        stringBuffer.append("</body></html>");
        throw new IllegalArgumentException(stringBuffer.toString());
    }

    private static String toName(String string) {
        return new File(string).getName();
    }

    private static InputStream createInputStream(File file) {
        String string = file.getPath();
        if (NamingConventions.isURL(file.getPath())) {
            return ParserFactory.createInputStream(new URL(file.getPath()));
        }
        if (AuxUtils.isAuxFile(file)) {
            file = AuxUtils.getBaseFileFromAuxFile(file);
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IOException("Specified path is a Directory (expecting a File): " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Check file permissions - cannot read data from file: " + file.getAbsolutePath());
        }
        if (kProgressMonitorHook != null) {
            return kProgressMonitorHook.getProgressMonitorInputStream(file, "Parsing: " + file.getPath());
        }
        return new FileInputStream(file);
    }

    private static InputStream createInputStream(URL uRL) {
        klog.debug("Parsing URL: " + uRL.getPath() + " >> " + uRL.toString());
        if (kProgressMonitorHook != null) {
            return kProgressMonitorHook.getProgressMonitorInputStream(uRL, "Parsing URL: " + uRL.getPath());
        }
        if (uRL.getProtocol().equalsIgnoreCase("ftp") && uRL.getHost().equalsIgnoreCase(GseaWebResources.getGseaFTPServer())) {
            try {
                return FTPUtils.ftpDownloadAndCreateInputStream(uRL);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        return uRL.openStream();
    }

    public static final InputStream createInputStream(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (object instanceof File) {
            return ParserFactory.createInputStream((File)object);
        }
        if (object instanceof URL) {
            return ParserFactory.createInputStream((URL)object);
        }
        String string = object.toString();
        if (NamingConventions.isURL(string)) {
            if (string.startsWith("ftp.")) {
                string = "ftp://" + string;
            } else if (string.startsWith("gseaftp.")) {
                string = "ftp://" + string;
            }
            return ParserFactory.createInputStream(new URL(string));
        }
        File file = new File(string);
        if (file.exists()) {
            return ParserFactory.createInputStream(file);
        }
        throw new IOException("Bad data source -- neither file nor url exists for: " + object);
    }

    protected static final File toFile(Element element, String string) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter el cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter attrName cannot be null");
        }
        Attribute attribute = element.attribute(string);
        if (attribute == null) {
            throw new IllegalArgumentException("Element specified: " + element.getName() + " has no attribute called: " + string + "\nText: " + element.getText());
        }
        String string2 = attribute.getValue();
        if (string2 == null) {
            throw new IllegalArgumentException("Element had no value for attribute_name: DATASET");
        }
        return new File(string2);
    }

    public static final Runnable createImportTask(File[] fileArray) {
        return new ParserFactory$1(fileArray);
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

