/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.strucs.TxtAffy;
import edu.mit.broad.genome.objects.strucs.TxtAffy$Value;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TxtAffyParser
extends AbstractParser {
    private static final String PROBE_SET_NAME = "Probe Set Name";
    private static final String SIGNAL = "Signal";
    private static final String DETECTION_PVALUE = "Detection p-value";
    private static final String DETECTION = "Detection";

    public TxtAffyParser() {
        super(TxtAffy.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        throw new NotImplementedException();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        this.startImport(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this._parse(string, bufferedReader);
    }

    private List _parse(String string, BufferedReader bufferedReader) {
        String[] stringArray;
        String string2 = bufferedReader.readLine();
        boolean bl = false;
        if (string2.toUpperCase().startsWith("DESCRIPTION")) {
            return this._parse_joshs_mas5_txt(string, string2, bufferedReader);
        }
        if (string2.toUpperCase().startsWith("^SAMPLE")) {
            return this._parse_geo_sample_soft(string, string2, bufferedReader);
        }
        List<String> list = Arrays.asList(string2.split("\t"));
        if (list.indexOf("Probe Set") != -1 || list.indexOf(PROBE_SET_NAME) != -1) {
            return this._parse_true_affy_txt(string, string2, bufferedReader);
        }
        if (string2.toUpperCase().startsWith("EXPRESSION")) {
            bl = true;
        }
        if ((stringArray = ParseUtils.string2strings(string2, "\t", false)).length < 2) {
            bl = true;
        }
        if (!bl) {
            return this._parse_simple_only_txt(string, string2, bufferedReader);
        }
        return this._parse_true_affy_cx(string, string2, bufferedReader);
    }

    private List _parse_joshs_mas5_txt(String string, String string2, BufferedReader bufferedReader) {
        Object object;
        ArrayList<TxtAffy$Value> arrayList = new ArrayList<TxtAffy$Value>();
        string = NamingConventions.removeExtension(new File(string).getName());
        string2 = this.nextLine(bufferedReader);
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            object = ParseUtils.string2strings(string2, "\t", false);
            if (((String[])object).length < 2) {
                throw new ParserException("Bad file format exception - expected at least 2 fields but got: " + ((String[])object).length + " line>" + string2 + "<");
            }
            String string3 = object[0];
            float f2 = Float.parseFloat(object[1]);
            char c2 = ((String[])object).length >= 3 ? object[2].charAt(0) : (char)'\u0000';
            arrayList.add(new TxtAffy$Value(string3, c2, Float.NaN, f2));
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        object = new TxtAffy(string, arrayList.toArray(new TxtAffy$Value[arrayList.size()]));
        return TxtAffyParser.unmodlist(new PersistentObject[]{object});
    }

    private List _parse_geo_sample_soft(String string, String string2, BufferedReader bufferedReader) {
        Object object;
        ArrayList<TxtAffy$Value> arrayList = new ArrayList<TxtAffy$Value>();
        string = NamingConventions.removeExtension(new File(string).getName());
        while (string2 != null && !string2.toUpperCase().startsWith("!SAMPLE_TABLE_BEGIN")) {
            string2 = bufferedReader.readLine();
        }
        string2 = this.nextLine(bufferedReader);
        string2 = this.nextLine(bufferedReader);
        while (string2 != null) {
            object = ParseUtils.string2strings(string2, "\t", false);
            if (((String[])object).length < 2) {
                throw new ParserException("Bad file format exception - expected at least 2 fields but got: " + ((String[])object).length + " line>" + string2 + "<");
            }
            String string3 = object[0];
            float f2 = Float.parseFloat(object[1]);
            char c2 = ((String[])object).length >= 3 ? object[2].charAt(0) : (char)'\u0000';
            arrayList.add(new TxtAffy$Value(string3, c2, Float.NaN, f2));
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        object = new TxtAffy(string, arrayList.toArray(new TxtAffy$Value[arrayList.size()]));
        return TxtAffyParser.unmodlist(new PersistentObject[]{object});
    }

    private List _parse_simple_only_txt(String string, String string2, BufferedReader bufferedReader) {
        Object object;
        ArrayList<TxtAffy$Value> arrayList = new ArrayList<TxtAffy$Value>();
        string = NamingConventions.removeExtension(new File(string).getName());
        while (string2 != null) {
            object = ParseUtils.string2strings(string2, "\t", false);
            if (((String[])object).length < 2) {
                throw new ParserException("Bad file format exception - expected at least 2 fields but got: " + ((String[])object).length + " line>" + string2 + "<");
            }
            String string3 = object[0];
            float f2 = Float.parseFloat(object[1]);
            char c2 = ((String[])object).length >= 3 ? object[2].charAt(0) : (char)'\u0000';
            arrayList.add(new TxtAffy$Value(string3, c2, Float.NaN, f2));
            string2 = this.nextLine(bufferedReader);
        }
        bufferedReader.close();
        this.doneImport();
        object = new TxtAffy(string, arrayList.toArray(new TxtAffy$Value[arrayList.size()]));
        return TxtAffyParser.unmodlist(new PersistentObject[]{object});
    }

    private List _parse_true_affy_cx(String string, String string2, BufferedReader bufferedReader) {
        while (string2 != null && !string2.toUpperCase().startsWith("EXPRESSION")) {
            string2 = bufferedReader.readLine();
        }
        String string3 = bufferedReader.readLine();
        if (string3.trim().length() == 0) {
            string3 = bufferedReader.readLine();
        }
        return this._parse_true_affy_txt(string, string3, bufferedReader);
    }

    private List _parse_true_affy_txt(String string, String string2, BufferedReader bufferedReader) {
        Object object;
        String string3;
        if (string2 == null) {
            throw new IOException("Header line is null.");
        }
        List<String> list = Arrays.asList(string2.split("\t"));
        int n = list.indexOf(PROBE_SET_NAME);
        if (n == -1) {
            n = list.indexOf("Probe Set");
        }
        if (n == -1) {
            throw new IOException("Probe Set Name column not found. File: " + string);
        }
        int n2 = list.indexOf(SIGNAL);
        if (n2 == -1) {
            throw new IOException("Signal column not found. File: " + string);
        }
        int n3 = list.indexOf(DETECTION_PVALUE);
        if (n3 == -1) {
            throw new IOException("Detection p-value column not found. File: " + string);
        }
        int n4 = list.indexOf(DETECTION);
        if (n4 == -1) {
            throw new IOException("Detection column not found. File: " + string);
        }
        ArrayList<TxtAffy$Value> arrayList = new ArrayList<TxtAffy$Value>();
        while ((string3 = bufferedReader.readLine()) != null) {
            object = string3.split("\t");
            String string4 = object[n];
            float f2 = Float.parseFloat(object[n2]);
            char c2 = object[n4].charAt(0);
            float f3 = Float.parseFloat(object[n3]);
            arrayList.add(new TxtAffy$Value(string4, c2, f3, f2));
        }
        this.doneImport();
        object = new TxtAffy(string, arrayList.toArray(new TxtAffy$Value[arrayList.size()]));
        return TxtAffyParser.unmodlist(new PersistentObject[]{object});
    }
}

