/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.meg.Unigene;
import edu.mit.broad.vdb.meg.Unigene$Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class UnigeneParser
extends AbstractParser {
    private static final String ID = "ID";
    private static final String SYMBOL = "GENE";
    private static final String TITLE = "TITLE";
    private static final String CYTOBAND = "CYTOBAND";
    private static final String LOCUSLINK = "LOCUSLINK";
    private static final String SEQUENCE = "SEQUENCE";
    private static final String SEQTYPEMRNA = "SEQTYPE=mRNA";

    public UnigeneParser() {
        super(Unigene.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        throw new NotImplementedException();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        return UnigeneParser.unmodlist(this.parseUnigene(new File(string), true));
    }

    public final Unigene parseUnigene(File file, boolean bl) {
        BufferedReader bufferedReader = ParseUtils.buf(file);
        ArrayList<String> arrayList = null;
        ArrayList<Unigene$Record> arrayList2 = new ArrayList<Unigene$Record>();
        int n = 0;
        String string = ParseUtils.nextLine(bufferedReader);
        boolean bl2 = true;
        while (string != null) {
            ++n;
            if (bl2 && !string.startsWith(ID)) {
                throw new IllegalArgumentException("Bad format pn line, expected : ID but got >" + string + "< > linenum: " + n);
            }
            if (string.startsWith(ID)) {
                arrayList = new ArrayList<String>();
                bl2 = false;
            }
            if (string.equals("//")) {
                Unigene$Record unigene$Record = UnigeneParser.parseOneRecord(arrayList, bl);
                arrayList2.add(unigene$Record);
                if (arrayList2.size() % 10000 == 0) {
                    System.out.println("Done unigene record #: " + arrayList2.size());
                }
                bl2 = true;
            }
            if (arrayList != null) {
                arrayList.add(string);
            }
            string = ParseUtils.nextLine(bufferedReader);
        }
        this.log.info("Total # of unigene records: " + arrayList2.size());
        return new Unigene(file, new Version("Oct2005"), arrayList2.toArray(new Unigene$Record[arrayList2.size()]));
    }

    private static Unigene$Record parseOneRecord(List list, boolean bl) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Parameter lines cannot be null nor empty");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Set set = new HashSet();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string6 = list.get(i2).toString();
            if (string6.startsWith(ID)) {
                string = UnigeneParser._parse(string6, ID, string);
            }
            if (string6.startsWith(SYMBOL)) {
                string2 = UnigeneParser._parse(string6, SYMBOL, string2);
            }
            if (string6.startsWith(CYTOBAND)) {
                string3 = UnigeneParser._parse(string6, CYTOBAND, string3);
            }
            if (string6.startsWith(TITLE)) {
                string4 = UnigeneParser._parse(string6, TITLE, string4);
            }
            if (string6.startsWith(LOCUSLINK)) {
                string5 = UnigeneParser._parse(string6, LOCUSLINK, string5);
            }
            if (!string6.startsWith(SEQUENCE)) continue;
            UnigeneParser._parseAccessions(string6, set, bl);
        }
        set = UnigeneParser.removeAccessionExtensions(set);
        return new Unigene$Record(string, string2, string4, string3, string5, set);
    }

    private static String _parse(String string, String string2, String string3) {
        if (!string.startsWith(string2)) {
            throw new IllegalArgumentException("Does not start with startsWith: " + string2);
        }
        if (string3 != null) {
            throw new IllegalArgumentException("Current value is not null for field " + string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string4 = stringTokenizer.nextToken().trim();
        if (!string4.equals(string2)) {
            throw new IllegalArgumentException("Does not start with startsWith: " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    private static Set removeAccessionExtensions(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 2) {
                throw new ParserException("Bad accession format: " + string + " invalid num tokens: " + stringTokenizer.countTokens());
            }
            hashSet.add(stringTokenizer.nextToken().trim());
        }
        return hashSet;
    }

    private static void _parseAccessions(String string, Set set, boolean bl) {
        if (!string.startsWith(SEQUENCE)) {
            throw new IllegalArgumentException("Does not start with startsWith: SEQUENCE");
        }
        if (bl && string.indexOf(SEQTYPEMRNA) == -1) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;");
        String string2 = stringTokenizer.nextToken().trim();
        if (!string2.equals(SEQUENCE)) {
            throw new IllegalArgumentException("Does not start with startsWith: SEQUENCE");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("ACC")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            if (stringTokenizer2.countTokens() != 2) {
                throw new ParserException("Bad format on acc line: " + string3);
            }
            stringTokenizer2.nextToken();
            set.add(stringTokenizer2.nextToken().trim());
        }
    }
}

