/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Divs;
import edu.mit.broad.genome.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.IMG;

public class PicFile {
    private String srcName;
    private String name;
    private Object chartOrbi;
    private String title;
    private String caption;
    private int width;
    private int height;
    private int currPicCnt;
    private File fSavedFile;
    private static int kImageCounter = 1;

    public PicFile(XChart xChart, int n, int n2, int n3) {
        String string = PicFile.generateName(xChart) + ".png";
        this.init(string, xChart.getName(), xChart.getTitle(), xChart.getCaption(), xChart, n, n2, n3);
    }

    public PicFile(String string, String string2, String string3, BufferedImage bufferedImage, int n, int n2, int n3) {
        String string4 = PicFile.generateNameForImage(string) + ".png";
        this.init(string4, string, string2, string3, bufferedImage, n, n2, n3);
    }

    public static final String generateName(XChart xChart) {
        return PicFile.createSafeFileName(xChart.getName()) + "_" + kImageCounter++;
    }

    public static final String generateNameForImage(String string) {
        return PicFile.createSafeFileName(string) + "_" + kImageCounter++;
    }

    public static final File createSafeFile(File file, String string) {
        return new File(file, PicFile.createSafeFileName(string));
    }

    public static final String createSafeFileName(String string) {
        string = string.trim();
        String string2 = string.replace('@', '_');
        string2 = string2.replace('#', '_');
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('%', '_');
        string2 = string2.replace('$', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace('*', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('/', '_');
        if ((string2 = string2.replace('\u001c', '_')).length() >= 125) {
            String string3 = PicFile.getExtension(string2);
            string2 = string2.substring(0, 125) + "." + string3;
        }
        return string2;
    }

    public static final String getExtension(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n == -1 ? "" : string.substring(n + 1);
        if (string.indexOf(".meta.") != -1) {
            return "meta." + string2;
        }
        return string2;
    }

    private final void init(String string, String string2, String string3, String string4, Object object, int n, int n2, int n3) {
        this.srcName = string;
        this.name = string2;
        if (string == null) {
            throw new IllegalArgumentException("Parameter srcName cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Parameter title cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Parameter chartOrbi cannot be null");
        }
        this.title = string3;
        this.caption = string4;
        this.chartOrbi = object;
        this.width = n;
        this.height = n2;
        this.currPicCnt = n3;
    }

    public final Div createIMG() {
        Div div = HtmlFormat$Divs.image();
        IMG iMG = new IMG(this.srcName, this.name);
        iMG.addElement(new BR());
        iMG.addElement(new BR());
        String string = "Fig " + this.currPicCnt + ": " + this.title;
        if (this.caption != null) {
            string = string + " &nbsp&nbsp <br> " + this.caption;
        }
        iMG.addElement(HtmlFormat.caption(string));
        div.addElement(iMG);
        return div;
    }

    public final File save(File file) {
        if (this.chartOrbi instanceof XChart) {
            this.fSavedFile = new File(file, this.srcName);
            ((XChart)this.chartOrbi).saveAsPNG(this.fSavedFile, this.width, this.height);
        } else {
            this.fSavedFile = new File(file, this.srcName);
            ImageUtils.savePng((BufferedImage)this.chartOrbi, this.fSavedFile);
        }
        return this.fSavedFile;
    }

    public final File getFile() {
        if (this.fSavedFile == null) {
            throw new IllegalStateException("Not yet saved");
        }
        return this.fSavedFile;
    }
}

