/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.strucs.Hyperlink;
import edu.mit.broad.genome.objects.strucs.Linked;
import org.apache.ecs.Doctype$Html401Transitional;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Caption;
import org.apache.ecs.html.Head;
import org.apache.ecs.html.Link;
import org.apache.ecs.html.Meta;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.Title;
import org.apache.log4j.Logger;
import xapps.gsea.GseaWebResources;

public class HtmlFormat {
    private static final Logger klog = XLogger.getLogger(HtmlFormat.class);
    private static final String CENTER = "center";
    private static final String image = "image";
    private static final String footer = "footer";
    private static final String error = "error";
    private static final String richTable = "richTable";
    private static final String dataTable = "dataTable";
    private static final String keyValTable = "keyValTable";
    private static final String indexTable = "indexTable";
    private static final String table = "table";
    private static final String lessen = "lessen";
    private static final String highlight = "highlight";
    public static final Link CSS_XTOOLS_CANNED_REPORTS = new Link();
    public static final Link ICON_CANNED_REPORTS = new Link();

    public static final String createHoverStyle() {
        return "<style type=\"text/css\">\n\ndiv#hover1,div#test2 {\n\tborder: 0px solid #000000;\n\tmargin-left: 10%;\n\twidth: 0px;\n}\n\ndiv a:hover {\n\ttext-decoration: none;\n}\n\ndiv a span {\n\tdisplay: none;\n\tpadding: 5px;\n\tcolor: #FF0000;\n\tbackground-color: #E6EDF5;\n\tfont-size: 12px;\n\twidth: 250px;\n}\n\ndiv a:hover span {\n\tdisplay: block;\n}\n\n</style>";
    }

    public static final void addMeta(String string, String string2, Head head) {
        Meta meta = new Meta();
        meta.setName(string);
        meta.setContent(string2);
        head.addElement(meta);
    }

    public static final void setCommonDocThings(String string, Document document) {
        document.setDoctype(new Doctype$Html401Transitional());
        document.setTitle(new Title(string));
        document.appendHead(CSS_XTOOLS_CANNED_REPORTS);
        document.appendHead(ICON_CANNED_REPORTS);
    }

    private HtmlFormat() {
    }

    public static final Caption caption(String string) {
        Caption caption = new Caption();
        caption.addElement(string);
        return caption;
    }

    public static final TD _td(String string) {
        if (string != null) {
            string = string.replace('\u001c', ' ');
        }
        TD tD = new TD(string);
        if (string == null || string.equals("-")) {
            tD.setAlign(CENTER);
        }
        return tD;
    }

    private static boolean isNullOrNA(String string) {
        return string == null || string.length() == 0 || string.equalsIgnoreCase("na") || string.equalsIgnoreCase("NULL");
    }

    public static final TD _td(String string, String string2, Linked linked) {
        TD tD = HtmlFormat._td(string);
        if (linked != null) {
            Hyperlink[] hyperlinkArray = linked.createAllLinks();
            if (hyperlinkArray.length > 1) {
                tD.addElement(new BR());
                for (int i2 = 0; i2 < hyperlinkArray.length; ++i2) {
                    if (HtmlFormat.isNullOrNA(hyperlinkArray[i2].getURL())) {
                        tD.addElement(new StringElement(hyperlinkArray[i2].getDisplayName()));
                    } else {
                        A a2 = new A(hyperlinkArray[i2].getURL(), hyperlinkArray[i2].getDisplayName());
                        tD.addElement(a2);
                    }
                    if (i2 == hyperlinkArray.length - 1) continue;
                    tD.addElement(", &nbsp");
                }
            } else if (hyperlinkArray.length == 1) {
                if (HtmlFormat.isNullOrNA(hyperlinkArray[0].getURL())) {
                    tD = new TD(new StringElement(string));
                } else {
                    A a3 = new A(hyperlinkArray[0].getURL(), string);
                    tD = new TD(a3);
                }
            }
        }
        if (string2 != null) {
            tD = tD.setBgColor(string2);
        }
        return tD;
    }

    protected static final TD _td(float f2) {
        return new TD(Float.toString(f2));
    }

    protected static final TD _td(Float f2) {
        return HtmlFormat._td(f2.floatValue());
    }

    protected static final TD _td(int n) {
        return HtmlFormat._td(n + "");
    }

    protected static final TD _td(Double d2) {
        return HtmlFormat._td(d2.floatValue());
    }

    protected static final TD _td(Element element) {
        return HtmlFormat._td(element.toString());
    }

    protected static final TD _td(Linked linked) {
        if (HtmlFormat.isNullOrNA(linked.createDefaultLink().getURL())) {
            return HtmlFormat._td(new StringElement(linked.getText()));
        }
        A a2 = new A(linked.createDefaultLink().getURL(), linked.getText());
        return HtmlFormat._td(a2);
    }

    protected static final TD _td(Hyperlink hyperlink) {
        if (HtmlFormat.isNullOrNA(hyperlink.getURL())) {
            return HtmlFormat._td(new StringElement(hyperlink.getDisplayName()));
        }
        A a2 = new A(hyperlink.getURL(), hyperlink.getDisplayName());
        return HtmlFormat._td(a2);
    }

    protected static final TD _td(Object object) {
        if (object instanceof Linked) {
            return HtmlFormat._td((Linked)object);
        }
        if (object instanceof Hyperlink) {
            return HtmlFormat._td((Hyperlink)object);
        }
        if (object instanceof Element) {
            return HtmlFormat._td((Element)object);
        }
        if (object == null) {
            TD tD = HtmlFormat._td("-");
            tD.setAlign(CENTER);
            return tD;
        }
        return HtmlFormat._td(object.toString());
    }

    protected static final A _a(String string, String string2) {
        A a2 = new A();
        a2.setHref(string);
        a2.setName(string2);
        return a2;
    }

    protected static final String _toPage(String string, Element element) {
        return HtmlFormat._toDocument(string, new Element[]{element}).toString();
    }

    protected static final Document _toDocument(String string, Element[] elementArray) {
        Document document = new Document();
        document.appendHead(string);
        for (int i2 = 0; i2 < elementArray.length; ++i2) {
            document.appendBody(elementArray[i2]);
            document.appendBody(new BR());
        }
        return document;
    }

    protected static final String _toHtml(Document document) {
        return document.toString();
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }

    static {
        CSS_XTOOLS_CANNED_REPORTS.setRel("stylesheet");
        CSS_XTOOLS_CANNED_REPORTS.setHref("xtools.css");
        ICON_CANNED_REPORTS.setRel("shortcut icon");
        ICON_CANNED_REPORTS.setHref(GseaWebResources.getGseaBaseURL() + "/images/XBench.gif");
    }
}

