/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Links;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.genome.utils.SystemUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ecs.Element;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.UL;
import org.apache.log4j.Logger;
import xapps.gsea.GseaWebResources;

public class HtmlReportIndexPage
extends HtmlPage {
    private final transient Logger log = XLogger.getLogger(HtmlReportIndexPage.class);
    private ToolReport fToolReport;
    private List fErrors;
    private boolean fFooterAdded;
    private boolean browseFooter = true;

    public HtmlReportIndexPage(ToolReport toolReport, String string) {
        this(toolReport, null, string);
    }

    public HtmlReportIndexPage(ToolReport toolReport, String string, String string2) {
        super("index", HtmlReportIndexPage._makeTitle(toolReport, string));
        this.fToolReport = toolReport;
        this.addHeader(string2);
    }

    private static String _makeTitle(ToolReport toolReport, String string) {
        String string2 = "Index for " + toolReport.getProducerName() + " " + toolReport.getReportDir().getName();
        if (string != null && string.length() > 0) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    @Override
    public final void addError(String string) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(string);
    }

    public final void addIndexTable(String string, KeyValTable keyValTable) {
        super.addTable(string, keyValTable);
    }

    private void addHeader(String string) {
        if (string == null) {
            return;
        }
        this.getDoc().appendBody(string);
    }

    public final void setAddBrowseFooter(boolean bl) {
        this.browseFooter = bl;
    }

    private void addFooter() {
        if (!this.fFooterAdded) {
            Object object;
            Div div = new Div();
            div.addElement(new BR());
            if (this.browseFooter) {
                object = new UL();
                ((UL)object).addElement(new LI(HtmlFormat$Links.hyperDir("Browse result folder", this.fToolReport.getReportDir(), "")));
                ((UL)object).addElement(new LI(HtmlFormat$Links.hyper("View parameters used for this report", this.fToolReport.getParamsFile(), "", this.fToolReport.getReportDir())));
                div.addElement((Element)object);
            }
            this.addBlock(div, false);
            object = DateUtils.toDayMonYear(this.fToolReport.getTimestamp()) + " " + DateUtils.toHourMin(this.fToolReport.getTimestamp());
            StringBuffer stringBuffer = new StringBuffer("<hr class=\"solid_line\"/>\n");
            stringBuffer.append("<div id=\"footer\">\n");
            stringBuffer.append("Report: ").append(this.fToolReport.getName()).append("&nbsp&nbsp ");
            stringBuffer.append("by user: ").append(SystemUtils.getUserName()).append("&nbsp&nbsp");
            stringBuffer.append("<div class=\"date\">").append(this.fToolReport.getProducerName()).append("&nbsp[").append((String)object).append(']').append("</div>\n");
            stringBuffer.append("<div class=\"contact\">Website: <a href=\"").append(GseaWebResources.getGseaBaseURL()).append("\">").append(GseaWebResources.getGseaURLDisplayName()).append("</a>\n");
            stringBuffer.append("Questions & Suggestions: <a href=\"mailto:").append(GseaWebResources.getGseaEmail()).append("\">Email</a></div>\n");
            stringBuffer.append("<div class=\"spacer\">&nbsp;</div>\n");
            stringBuffer.append("</div>\n");
            this.getDoc().appendBody(stringBuffer.toString());
            this.fFooterAdded = true;
        }
    }

    @Override
    public final PicFile[] write(OutputStream outputStream, File file) {
        this.addFooter();
        return super.write(outputStream, file);
    }
}

