/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.swing.EqualFlowLayout;
import edu.mit.broad.genome.swing.RendererFactory$ClassNamePairListCellRenderer;
import edu.mit.broad.genome.swing.TextIconPair;
import edu.mit.broad.genome.swing.UIFSplitPane;
import edu.mit.broad.genome.utils.containers.ClassNamePair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class GuiHelper
implements Constants {
    public static final Icon ICON_ERROR16 = JarResources.getIcon("Error.gif");
    public static final Icon ICON_REFRESH16 = JarResources.getIcon("Refresh16.png");
    public static final Icon ICON_START16 = JarResources.getIcon("Run16.png");
    public static final Icon ICON_PAUSE16 = JarResources.getIcon("Pause16.gif");
    public static final Icon ICON_INTEGER = JarResources.getIcon("Integer.gif");
    public static final Icon ICON_FLOAT = JarResources.getIcon("Float.gif");
    public static final Icon ICON_STRING = JarResources.getIcon("String.gif");
    public static final Icon ICON_DATE = JarResources.getIcon("Date.gif");
    public static final Icon ICON_BOOLEAN = JarResources.getIcon("Boolean.gif");
    public static final Icon ICON_COPY16 = JarResources.getIcon("Copy16.gif");
    public static final Icon ICON_COPY24 = JarResources.getIcon("Copy24.gif");
    public static final Icon ICON_HELP24 = JarResources.getIcon("Help24.gif");
    public static final Icon ICON_HELP16 = JarResources.getIcon("Help16_v2.gif");
    public static final Icon ICON_BACK16 = JarResources.getIcon("back16.png");
    public static final Icon ICON_TREE_CLOSED = JarResources.getIcon("TreeClosed.png");
    public static final Icon ICON_TREE_OPENED = JarResources.getIcon("TreeOpen.png");
    public static final Icon ICON_ELLIPSIS = JarResources.getIcon("Ellipsis.png");
    public static final Icon ICON_OPTIONPANE_ERROR = UIManager.getIcon("OptionPane.errorIcon");
    public static final Icon ICON_OPTIONPANE_ERROR16 = JarResources.getIcon("Error16.gif");
    public static final Icon ICON_OPTIONPANE_INFO = UIManager.getIcon("OptionPane.informationIcon");
    public static final Icon ICON_OPTIONPANE_INFO16 = JarResources.getIcon("Inform16.gif");
    public static final Icon ICON_OPTIONPANE_WARNING = UIManager.getIcon("OptionPane.warningIcon");
    public static final Icon ICON_OPTIONPANE_QUESTION = UIManager.getIcon("OptionPane.questionIcon");
    public static final Icon ICON_SAVE16 = JarResources.getIcon("Save16.gif");
    public static final Icon ICON_SAVE24 = JarResources.getIcon("Save24.gif");
    public static final Icon ICON_RESTORE16 = JarResources.getIcon("RestoreDefaults16.gif");
    public static final Icon ICON_RESTORE24 = JarResources.getIcon("Undo24.gif");
    public static final Icon ICON_DELETE16 = JarResources.getIcon("Delete16.gif");
    public static final Icon ICON_DELETE24 = JarResources.getIcon("Delete24.gif");
    public static final Dimension DIMENSION_STANDARD_WINDOW = new Dimension(500, 500);
    public static final Dimension DIMENSION_BIGGER_DIALOG = new Dimension(500, 400);
    public static final Dimension DIMENSION_BIGGER_BIGGER_DIALOG = new Dimension(500, 500);
    public static final Dimension DIMENSION_BIGGER_BIGGER_BIGGER_DIALOG = new Dimension(600, 600);
    public static final Dimension DIMENSION_STANDARD_FILE_CHOOSER = new Dimension(400, 350);
    public static final JComponent[] EMPTY_CONTROLS = new JComponent[0];
    public static final Font FONT_DEFAULT_BOLD = new Font("Helvetica", 1, 12);
    public static final Font FONT_DEFAULT = new Font("Helvetica", 0, 12);
    public static final Font FONT_FIXED_TEXT = new Font("Courier", 0, 12);
    public static final Font FONT_FIXED_TEXT_BOLD = new Font("Courier", 1, 12);
    public static final Font FONT_SMALL_FIXED_TEXT = new Font("Courier", 0, 8);
    public static final Color COLOR_LIGHT_GREEN = new Color(153, 247, 121);
    public static final Color COLOR_LIGHT_ORANGE = new Color(255, 172, 89);
    public static final Color COLOR_LIGHT_YELLOW = Color.decode("#FFFF99");
    public static final Color COLOR_DARK_GREEN = new Color(0, 81, 0);
    public static final Color COLOR_LIGHT_RED = new Color(255, 108, 108);
    public static Color COLOR_LIGHT_BLUE = new Color(150, 150, 255);
    public static final Color COLOR_DARK_BROWN = new Color(128, 64, 64);
    public static final Color COLOR_VERY_LIGHT_GRAY = new Color(239, 239, 239);
    public static final Color COLOR_DARK_BLUE = new Color(63, 64, 124);
    public static final GradientPaint COLOR_GRAY_BLUE_VERTICAL = new GradientPaint(0.0f, 0.0f, COLOR_DARK_BLUE, 0.0f, 50.0f, new Color(105, 120, 141));
    public static final GradientPaint COLOR_GRAY_BLUE_HORIZONTAL = new GradientPaint(0.0f, 0.0f, COLOR_DARK_BLUE, 300.0f, 0.0f, new Color(105, 120, 141));
    public static final GradientPaint COLOR_LIGHT_BLUE_TO_BLUE_HORIZONTAL = new GradientPaint(0.0f, 0.0f, new Color(150, 150, 255), 300.0f, 0.0f, Color.BLUE);
    public static final GradientPaint COLOR_RED_TO_BLUE_HORIZONTAL = new GradientPaint(0.0f, 0.0f, Color.RED, 300.0f, 0.0f, Color.BLUE);
    public static final GradientPaint COLOR_LIGHT_RED_TO_RED_HORIZONTAL = new GradientPaint(0.0f, 0.0f, COLOR_LIGHT_RED, 300.0f, 0.0f, Color.RED);
    public static final GradientPaint COLOR_GRAY_BROWN_HORIZONTAL = new GradientPaint(0.0f, 0.0f, new Color(128, 64, 64), 300.0f, 0.0f, new Color(105, 120, 141));
    private static final Logger klog = XLogger.getLogger(GuiHelper.class);
    private static final Dimension kPlaceholderSize = new Dimension(200, 50);
    private static final String DND_TOOL_TIP_TEXT = "Drag and drop objects here to change view";
    private static final Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private static final int MAX_LENGTH = 200;

    private GuiHelper() {
    }

    public static final JScrollPane createStrippedScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return jScrollPane;
    }

    public static final JSplitPane createStrippedSplitPane(int n, Component component, Component component2, double d2) {
        UIFSplitPane uIFSplitPane = UIFSplitPane.createStrippedSplitPane(n, component, component2);
        uIFSplitPane.setResizeWeight(d2);
        return uIFSplitPane;
    }

    public static final AbstractButton createToolBarButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setFocusPainted(false);
        jButton.setMargin(TOOLBAR_BUTTON_MARGIN);
        jButton.setText("");
        return jButton;
    }

    public static final TitledBorder createTitledBorderForComponent(String string) {
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        return BorderFactory.createTitledBorder(border, string, 0, 2, FONT_DEFAULT, Color.GRAY);
    }

    public static final void centerComponent(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        component.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static final void buffer(JPanel jPanel) {
        GuiHelper.fill(jPanel, GuiHelper.createNaPlaceholder());
    }

    public static final void buffer(JComponent jComponent) {
        GuiHelper.fill(jComponent, GuiHelper.createNaPlaceholder());
    }

    public static final void buffer(JScrollPane jScrollPane) {
        jScrollPane.getViewport().add((Component)GuiHelper.createNaPlaceholder(), null);
    }

    public static final void disable(JPanel jPanel) {
        GuiHelper.fill(jPanel, GuiHelper.createDisabledPlaceholder());
    }

    public static final void fill(JComponent jComponent, JComponent jComponent2) {
        jComponent.removeAll();
        if (jComponent instanceof JScrollPane) {
            ((JScrollPane)jComponent).getViewport().add((Component)jComponent2, null);
        } else {
            jComponent.setLayout(new GridLayout(1, 1));
            jComponent.add(jComponent2);
        }
        jComponent.revalidate();
    }

    public static final JPanel createPlaceholderPanel(Dimension dimension, String string) {
        return GuiHelper._createPanel(dimension, string, null);
    }

    public static final JPanel createPlaceholderPanel(Dimension dimension, TextIconPair textIconPair) {
        return GuiHelper._createPanel(dimension, textIconPair.text, textIconPair.icon);
    }

    public static final JPanel createPlaceholderPanel(Dimension dimension, String string, Icon icon) {
        return GuiHelper._createPanel(dimension, string, icon);
    }

    public static final JPanel createNaPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.NA_COMPONENT);
    }

    public static final JPanel createDisabledPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.DISABLED_COMPONENT);
    }

    public static final Component createEmptyFiller() {
        return Box.createRigidArea(kPlaceholderSize);
    }

    public static final JPanel createWaitingPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.WAITING_FOR_TASK);
    }

    public static final JPanel createErrorPanel() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.ERROR_COMPONENT);
    }

    private static JPanel _createPanel(Dimension dimension, String string, Icon icon) {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(dimension);
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(dimension);
        jLabel.setIcon(icon);
        jPanel.setLayout(new EqualFlowLayout(1));
        jPanel.add(jLabel);
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    public static final JComponent createDndComponent(Icon icon) {
        return GuiHelper.createDndComponent(new Icon[]{icon});
    }

    public static final JComponent createDndComponent(Icon[] iconArray) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(JarResources.getIcon("Dnd.gif"));
        jLabel.setToolTipText(DND_TOOL_TIP_TEXT);
        jPanel.add(jLabel);
        for (int i2 = 0; i2 < iconArray.length; ++i2) {
            JLabel jLabel2 = new JLabel(iconArray[i2]);
            jLabel2.setToolTipText(DND_TOOL_TIP_TEXT);
            jPanel.add(jLabel2);
        }
        return jPanel;
    }

    public static final Class getSelectedClass(JComboBox jComboBox) {
        if (jComboBox.getSelectedIndex() != -1) {
            return ((ClassNamePair)jComboBox.getSelectedItem()).getPairClass();
        }
        if (jComboBox.getSelectedIndex() == -1 && jComboBox.getModel().getSize() > 0) {
            return ((ClassNamePair)jComboBox.getModel().getElementAt(0)).getPairClass();
        }
        return null;
    }

    public static final Class getSelectedClass(JList jList) {
        if (jList.getSelectedIndex() != -1) {
            return ((ClassNamePair)jList.getSelectedValue()).getPairClass();
        }
        if (jList.getSelectedIndex() == -1 && jList.getModel().getSize() > 0) {
            return ((ClassNamePair)jList.getModel().getElementAt(0)).getPairClass();
        }
        return null;
    }

    public static final Class[] getSelectedClasses(JList jList) {
        if (jList.getSelectedIndex() != -1) {
            Object[] objectArray = jList.getSelectedValues();
            Class[] classArray = new Class[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                classArray[i2] = ((ClassNamePair)objectArray[i2]).getPairClass();
            }
            return classArray;
        }
        if (jList.getSelectedIndex() == -1 && jList.getModel().getSize() > 0) {
            Class[] classArray = new Class[]{((ClassNamePair)jList.getModel().getElementAt(0)).getPairClass()};
            return classArray;
        }
        return null;
    }

    public static final String getSelectedClassName(JComboBox jComboBox) {
        if (jComboBox.getSelectedIndex() != -1) {
            return ((ClassNamePair)jComboBox.getSelectedItem()).getPairName();
        }
        if (jComboBox.getSelectedIndex() == -1 && jComboBox.getModel().getSize() > 0) {
            return ((ClassNamePair)jComboBox.getModel().getElementAt(0)).getPairName();
        }
        return null;
    }

    public static final String getSelectedClassName(JList jList) {
        if (jList.getSelectedIndex() != -1) {
            return ((ClassNamePair)jList.getSelectedValue()).getPairName();
        }
        if (jList.getSelectedIndex() == -1 && jList.getModel().getSize() > 0) {
            return ((ClassNamePair)jList.getModel().getElementAt(0)).getPairName();
        }
        return null;
    }

    public static final void safeSelect(JList jList) {
        if (jList.getSelectedIndex() != -1) {
            return;
        }
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
    }

    public static final void safeSelect(JComboBox jComboBox) {
        if (jComboBox.getSelectedIndex() != -1) {
            return;
        }
        if (jComboBox.getModel().getSize() > 0) {
            jComboBox.setSelectedIndex(0);
        }
    }

    public static final void bind(JComboBox jComboBox, ClassNamePair[] classNamePairArray) {
        jComboBox.setModel(new DefaultComboBoxModel<ClassNamePair>(classNamePairArray));
        jComboBox.setRenderer(new RendererFactory$ClassNamePairListCellRenderer());
    }

    public static final void bind(JComboBox jComboBox, Object[] objectArray) {
        jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    public static final void bind(JList jList, ClassNamePair[] classNamePairArray) {
        DefaultComboBoxModel<ClassNamePair> defaultComboBoxModel = new DefaultComboBoxModel<ClassNamePair>(classNamePairArray);
        jList.setModel(defaultComboBoxModel);
        if (defaultComboBoxModel.getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        jList.setCellRenderer(new RendererFactory$ClassNamePairListCellRenderer());
    }

    public static final void bind(JList jList, Object[] objectArray) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        jList.setModel(defaultComboBoxModel);
        if (defaultComboBoxModel.getSize() > 0) {
            jList.setSelectedIndex(0);
        }
    }

    public static final DefaultComboBoxModel bind(JComboBox jComboBox, String[] stringArray) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        jComboBox.setModel(defaultComboBoxModel);
        if (defaultComboBoxModel.getSize() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        return defaultComboBoxModel;
    }

    public static final DefaultComboBoxModel bind(JList jList, String[] stringArray) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        jList.setModel(defaultComboBoxModel);
        if (defaultComboBoxModel.getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        return defaultComboBoxModel;
    }

    public static final void bind(JComboBox jComboBox, List list, ListCellRenderer listCellRenderer) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object t = ((Class)list.get(i2)).newInstance();
            defaultComboBoxModel.addElement(t);
        }
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setRenderer(listCellRenderer);
    }

    public static final void bind(JList jList, List list, ListCellRenderer listCellRenderer) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object t = ((Class)list.get(i2)).newInstance();
            defaultComboBoxModel.addElement(t);
        }
        jList.setModel(defaultComboBoxModel);
        jList.setCellRenderer(listCellRenderer);
    }

    public static final String formatObjectToolTipText(String string, Id id, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<html>Name: ").append(string).append("<br>");
        stringBuffer.append("Id: ").append(id.id()).append("<br>");
        if (string2 == null) {
            string2 = "no summary available";
        }
        if (string2.length() > 200) {
            string2 = string2.substring(0, 200);
        }
        int n = 80;
        for (int i2 = 0; i2 < string2.length(); i2 += n) {
            int n2 = i2 + n;
            if (n2 >= string2.length()) {
                n2 = string2.length() - 1;
            }
            stringBuffer.append(string2.substring(i2, n2)).append("<br>");
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

