/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import com.jgoodies.looks.LookUtils;
import edu.mit.broad.genome.swing.GradientPanel;
import edu.mit.broad.genome.swing.SimpleInternalPanel$RaisedHeaderBorder;
import edu.mit.broad.genome.swing.SimpleInternalPanel$ShadowBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class SimpleInternalPanel
extends JPanel {
    private JLabel titleLabel;
    private GradientPanel gradientPanel;
    private JPanel headerPanel;
    private boolean isSelected = false;
    private Color fGradientColor;

    public SimpleInternalPanel(String string) {
        this(null, string, null, null, null, null);
    }

    public SimpleInternalPanel(String string, JButton jButton) {
        this(null, string, jButton, null, null, null);
    }

    public SimpleInternalPanel(String string, Color color) {
        this(null, string, null, null, null, color);
    }

    public SimpleInternalPanel(Icon icon, String string) {
        this(icon, string, null, null, null, null);
    }

    public SimpleInternalPanel(String string, JToolBar jToolBar, JComponent jComponent) {
        this(null, string, null, jToolBar, jComponent, null);
    }

    public SimpleInternalPanel(Icon icon, String string, JButton jButton, JToolBar jToolBar, JComponent jComponent, Color color) {
        super(new BorderLayout());
        this.fGradientColor = color;
        this.titleLabel = new JLabel(string, icon, 10);
        JPanel jPanel = this.buildHeader(this.titleLabel, jButton, jToolBar);
        this.add((Component)jPanel, "North");
        if (jComponent != null) {
            this.setContent(jComponent);
        }
        this.setBorder(new SimpleInternalPanel$ShadowBorder(null));
        this.setSelected(true);
        this.updateHeader();
    }

    public final Icon getFrameIcon() {
        return this.titleLabel.getIcon();
    }

    public final void setFrameIcon(Icon icon) {
        Icon icon2 = this.getFrameIcon();
        this.titleLabel.setIcon(icon);
        this.firePropertyChange("frameIcon", icon2, icon);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public final void setTitle(String string) {
        String string2 = this.getTitle();
        this.titleLabel.setText(string);
        this.firePropertyChange("title", string2, string);
    }

    public final JToolBar getToolBar() {
        return this.headerPanel.getComponentCount() > 1 ? (JToolBar)this.headerPanel.getComponent(1) : null;
    }

    public final void setToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = this.getToolBar();
        if (jToolBar2 == jToolBar) {
            return;
        }
        if (jToolBar2 != null) {
            this.headerPanel.remove(jToolBar2);
        }
        if (jToolBar != null) {
            jToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.add((Component)jToolBar, "East");
        }
        this.updateHeader();
        this.firePropertyChange("toolBar", jToolBar2, jToolBar);
    }

    public final Component getContent() {
        return this.hasContent() ? this.getComponent(1) : null;
    }

    public final void setContent(Component component) {
        Component component2 = this.getContent();
        if (this.hasContent()) {
            this.remove(component2);
        }
        this.add(component, "Center");
        this.firePropertyChange("content", component2, component);
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        this.isSelected = bl;
        this.updateHeader();
        this.firePropertyChange("selected", bl2, bl);
    }

    private JPanel buildHeader(JLabel jLabel, JButton jButton, JToolBar jToolBar) {
        this.gradientPanel = new GradientPanel(new BorderLayout(), this.getHeaderBackground(), this.getGradientColor());
        jLabel.setOpaque(false);
        this.gradientPanel.add((Component)jLabel, "Center");
        if (jButton != null) {
            this.gradientPanel.add((Component)jButton, "East");
        }
        this.gradientPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.add((Component)this.gradientPanel, "Center");
        this.setToolBar(jToolBar);
        this.headerPanel.setBorder(new SimpleInternalPanel$RaisedHeaderBorder(null));
        this.headerPanel.setOpaque(false);
        return this.headerPanel;
    }

    private void updateHeader() {
        this.gradientPanel.setBackground(this.getHeaderBackground());
        this.gradientPanel.setOpaque(this.isSelected());
        this.titleLabel.setForeground(this.getTextForeground(this.isSelected()));
        this.headerPanel.repaint();
    }

    @Override
    public final void updateUI() {
        super.updateUI();
        if (this.titleLabel != null) {
            this.updateHeader();
        }
    }

    private boolean hasContent() {
        return this.getComponentCount() > 1;
    }

    protected final Color getTextForeground(boolean bl) {
        Color color = UIManager.getColor(bl ? "SimpleInternalFrame.activeTitleForeground" : "SimpleInternalFrame.inactiveTitleForeground");
        if (color != null) {
            return color;
        }
        return UIManager.getColor(bl ? "InternalFrame.activeTitleForeground" : "Label.foreground");
    }

    protected final Color getGradientColor() {
        return this.fGradientColor;
    }

    public final void setGradientColor(Color color) {
        this.fGradientColor = color;
    }

    protected final Color getHeaderBackground() {
        Color color = UIManager.getColor("SimpleInternalFrame.activeTitleBackground");
        if (color != null) {
            return color;
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            color = UIManager.getColor("InternalFrame.activeTitleGradient");
        }
        return color != null ? color : UIManager.getColor("InternalFrame.activeTitleBackground");
    }
}

