/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import org.apache.log4j.Logger;

public class Timer {
    protected static final Logger klog = XLogger.getLogger(Timer.class);
    private long fStart = 0L;
    private long fStop = 0L;
    private boolean stopped = false;

    public final void start() {
        this.fStart = System.currentTimeMillis();
        this.stopped = false;
    }

    public final void stop() {
        this.fStop = System.currentTimeMillis();
        this.stopped = true;
    }

    public final void printTimeTaken() {
        klog.info(this._timeTaken(null));
    }

    public final void printTimeTakenS() {
        System.out.println(this._timeTaken(null));
    }

    public final void printTimeTaken_ms() {
        System.out.println(this.fStop - this.fStart);
    }

    public final void printTimeTaken_ms(String string) {
        System.out.println(string + " " + (this.fStop - this.fStart));
    }

    public final void printTimeTaken(String string) {
        klog.info(this._timeTaken(string));
    }

    public final void printTimeTakenS(String string) {
        System.out.println(this._timeTaken(string));
    }

    private String _timeTaken(String string) {
        if (!this.stopped) {
            this.stop();
        }
        long l2 = this.fStop - this.fStart;
        if (string != null) {
            if (l2 > 1000L) {
                return "Time taken for " + string + ": " + l2 / 1000L + " secs";
            }
            return "Time taken for " + string + ": " + l2 + " ms";
        }
        if (l2 > 1000L) {
            return "Time taken: " + l2 / 1000L + " secs";
        }
        return "Time taken: " + l2 + " ms";
    }

    public final long getTimeTaken() {
        return this.fStop - this.fStart;
    }

    public final long getStartTime() {
        return this.fStart;
    }

    public final long getStopTime() {
        return this.fStop;
    }
}

