/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.MemoryMonitor;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.viewers.AboutViewer$1;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class AboutViewer
extends JPanel
implements Widget {
    public static final String NAME = "About";
    public static final Icon ICON = JarResources.getIcon("About.gif");
    private JButton bForceGc;
    private MemoryMonitor fMonitor;

    public AboutViewer() {
        this(AboutViewer.createDefaultXomicsAppInfoPanel());
    }

    public AboutViewer(JComponent jComponent) {
        this.init(new String[]{"Application info"}, new JComponent[]{jComponent});
    }

    public AboutViewer(String[] stringArray, JComponent[] jComponentArray) {
        this.init(stringArray, jComponentArray);
    }

    private void init(String[] stringArray, JComponent[] jComponentArray) {
        if (jComponentArray == null) {
            throw new IllegalArgumentException("Param appInfoPanels cannot be null");
        }
        this.jbInit(stringArray, jComponentArray);
        this.bForceGc.addActionListener(new AboutViewer$1(this));
    }

    @Override
    public final String getTitle() {
        return NAME;
    }

    private void jbInit(String[] stringArray, JComponent[] jComponentArray) {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            jTabbedPane.addTab(stringArray[i2], jComponentArray[i2]);
        }
        jTabbedPane.addTab("System info", this.getSystemInfo());
        jTabbedPane.addTab("Memory usage", this.getMemoryPanel());
        this.add(jTabbedPane);
    }

    private static JComponent createDefaultXomicsAppInfoPanel() {
        StringBuffer stringBuffer = new StringBuffer("XOMICS development toolkit\n\n");
        stringBuffer.append("Debug mode (for development)  : ").append(Conf.isDebugMode()).append('\n');
        stringBuffer.append("Application: ").append(Application.getName()).append('\n');
        stringBuffer.append("\nMemory available on machine : ").append(Runtime.getRuntime().maxMemory() / 1000000L).append("Mb\n");
        stringBuffer.append("(At least 256Mb of RAM is recommended. More the better!)\n");
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        return new JScrollPane(jTextArea);
    }

    private JPanel getMemoryPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.fMonitor = new MemoryMonitor();
        jPanel.add((Component)this.fMonitor, "Center");
        this.fMonitor.surf.start();
        this.bForceGc = new JButton("Force memory cleanup", GuiHelper.ICON_DELETE24);
        this.bForceGc.setToolTipText("Make Java perform garbage collection -- use to free up memory when the application is sluggish");
        jPanel.add((Component)this.bForceGc, "South");
        return jPanel;
    }

    private JComponent getSystemInfo() {
        JTable jTable = new JTable(SystemUtils.asTableModel());
        return new JScrollPane(jTable);
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final JComponent getWindowUI() {
        return this;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    public final void finalize() {
        super.finalize();
        if (this.fMonitor != null) {
            this.fMonitor.surf.stop();
        }
    }

    @Override
    public final Icon getIcon() {
        return ICON;
    }
}

