/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.EntrezGeneWebPageParser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.EntrezWebChip$AccessionLookup;
import edu.mit.broad.vdb.chip.EntrezWebChip$ProbeWithSource;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.chip.SimpleProbe;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.meg.Gene$Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntrezWebChip {
    private static final Logger klog = XLogger.getLogger(EntrezWebChip.class);
    private Chip fChip_local;
    private Map fAccHugoMap = new HashMap();
    private final EntrezGeneWebPageParser parser = new EntrezGeneWebPageParser();

    public EntrezWebChip(Chip chip) {
        this.fChip_local = chip;
    }

    public final String getSymbol(String string, boolean bl, boolean bl2) {
        Probe probe = this.getProbe(string, bl, bl2);
        if (probe != null && !Gene$Helper.isNull(probe.getGene())) {
            return probe.getGene().getSymbol();
        }
        return null;
    }

    public final Probe getProbe(String string, boolean bl, boolean bl2) {
        string = string.toUpperCase();
        string = this._removeExtension(string);
        Probe probe = null;
        String string2 = null;
        if (this.fChip_local.isProbe(string)) {
            probe = this.fChip_local.getProbe(string);
            string2 = "local";
        }
        if (probe == null && bl2 && VdbRuntimeResources.getChip_Affy().isProbe(string)) {
            probe = VdbRuntimeResources.getChip_Affy().getProbe(string);
            string2 = "affy";
        }
        if (probe == null && bl) {
            Object object = this.fAccHugoMap.get(string);
            if (object == null) {
                String string3 = this.parser.parseSymbol(string);
                if (string3 == null) {
                    object = new SimpleProbe(string, Gene.NULL_GENE.getSymbol(), Gene.NULL_GENE.getTitle());
                } else {
                    object = new SimpleProbe(string, string3, VdbRuntimeResources.getChip_Gene_Symbol().getTitle(string3, Chip.OMIT_NULLS));
                    string2 = "ezweb";
                }
                this.fAccHugoMap.put(string, object);
            }
            probe = (Probe)object;
        }
        return new EntrezWebChip$ProbeWithSource(probe, string2);
    }

    private String _removeExtension(String string) {
        if (string == null) {
            return null;
        }
        String string2 = NamingConventions.getExtension(string);
        if (string2 != null && NamingConventions.isInteger(string2)) {
            string = NamingConventions.removeExtension(string);
        }
        return string;
    }

    public final GeneSet symbolize(GeneSet geneSet, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = this.getSymbol(geneSet.getMember(i2), bl, bl2);
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return new FSet(geneSet.getName(), arrayList, false);
    }

    public final EntrezWebChip$AccessionLookup symbolize_with_details(GeneSet geneSet, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        EntrezWebChip$AccessionLookup entrezWebChip$AccessionLookup = new EntrezWebChip$AccessionLookup();
        String[] stringArray = new String[]{"SYMBOL", "SOURCE", "TITLE"};
        StringMatrix stringMatrix = new StringMatrix(geneSet.getNumMembers(), stringArray.length);
        int n = 0;
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            Probe probe = this.getProbe(string, true, bl);
            if (probe != null && probe.getGene().getSymbol() != null) {
                stringMatrix.setElement(i2, 0, probe.getGene().getSymbol());
                stringMatrix.setElement(i2, 1, ((EntrezWebChip$ProbeWithSource)probe).source);
                stringMatrix.setElement(i2, 2, probe.getGene().getTitle());
                if (!NamingConventions.isNull(probe.getGene().getTitle())) {
                    ++n;
                }
                hashSet.add(probe.getGene().getSymbol());
                hashSet3.add(geneSet.getMember(i2));
            } else {
                hashSet2.add(geneSet.getMember(i2));
            }
            if (i2 % 100 != 0) continue;
            System.out.println("Done lookup: " + (i2 + 1) + " " + geneSet.getNumMembers());
        }
        entrezWebChip$AccessionLookup.unknownAccessions = new FSet(geneSet.getName(true) + "_unknown", hashSet2);
        entrezWebChip$AccessionLookup.knownAccessions = new FSet(geneSet.getName(true) + "_known", hashSet3);
        entrezWebChip$AccessionLookup.deconReport = new StringDataframe("lookup", stringMatrix, geneSet.getMembersArray(), stringArray, true);
        entrezWebChip$AccessionLookup.symbols = new FSet(geneSet.getName(true) + "_symbolized", hashSet);
        klog.info("# accessions in: " + geneSet.getNumMembers() + " known: " + hashSet3.size() + " UNknown: " + hashSet2.size() + " known_valid_symbols: " + n);
        return entrezWebChip$AccessionLookup;
    }
}

