/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnot$Helper;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.strucs.Linked;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.vdb.chip.Chip;

public class FeatureAnnotChipImpl
extends AbstractObject
implements FeatureAnnot {
    private Chip fChip;
    private ColorMap$Rows fColorMap_opt;
    private FeatureAnnot$Helper fHelper;

    public FeatureAnnotChipImpl(Chip chip, ColorMap$Rows colorMap$Rows) {
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        super.initialize(chip.getName());
        this.fChip = chip;
        this.fColorMap_opt = colorMap$Rows;
        this.fHelper = new FeatureAnnot$Helper();
    }

    public FeatureAnnotChipImpl(Chip chip) {
        this(chip, (GenesOfInterest)null);
    }

    public FeatureAnnotChipImpl(Chip chip, GenesOfInterest genesOfInterest) {
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        super.initialize(chip.getName());
        if (genesOfInterest != null) {
            this.fColorMap_opt = genesOfInterest.getAsColorMap();
        }
        this.fChip = chip;
        this.fHelper = new FeatureAnnot$Helper();
    }

    @Override
    public final Chip getChip() {
        return this.fChip;
    }

    @Override
    public final void setChip(Chip chip, ColorMap$Rows colorMap$Rows) {
        if (chip != null) {
            FeatureAnnot$Helper.checkChip(this.fChip, chip);
            this.fChip = chip;
            this.fColorMap_opt = colorMap$Rows;
        }
    }

    @Override
    public final String getQuickInfo() {
        return this.fChip.getQuickInfo();
    }

    @Override
    public final String[] getNames() {
        try {
            return this.fChip.getProbeNamesArr();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final ColorMap$Rows getColorMap() {
        return this.fColorMap_opt;
    }

    @Override
    public final int getNumFeatures() {
        try {
            return this.fChip.getNumProbes();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final boolean hasNativeDescriptions() {
        return false;
    }

    @Override
    public final String getNativeDesc(String string) {
        return null;
    }

    @Override
    public final String getGeneSymbol(String string) {
        return this.fHelper.getGeneSymbol(string, this.fChip);
    }

    @Override
    public final String getGeneTitle(String string) {
        return this.fHelper.getGeneTitle(string, this.fChip);
    }

    @Override
    public final Linked getLink(String string) {
        return LinkedFactory.createLinkedGeneSymbol(string);
    }
}

