/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.ParseException;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapperAbstract;
import edu.mit.broad.vdb.map.MapUtils$Struc;
import edu.mit.broad.vdb.map.MappingDbType;
import edu.mit.broad.vdb.map.MappingDbTypes;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Set;

public class Chip2ChipMapperSlimJit
extends Chip2ChipMapperAbstract {
    private static final long serialVersionUID = 3328220991976115699L;
    private File fMapFile;
    private MapUtils$Struc fStruc;
    private boolean fInited;

    public Chip2ChipMapperSlimJit(File file) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Param serFile cannot be null or non existant: " + file);
        }
        this.fMapFile = file;
        this.fStruc = new MapUtils$Struc(this.fMapFile);
    }

    @Override
    public final String getChipsId() {
        return this.fStruc.createChipId();
    }

    @Override
    public final String getName() {
        return this.fStruc.createId();
    }

    @Override
    protected final void checkAndInit() {
        if (this.fInited) {
            return;
        }
        try {
            THashMap tHashMap = this._parse();
            super.init(this.fStruc.sourceChipName, this.fStruc.targetChipName, this.fStruc.getMappingDbType(), tHashMap);
            this.fInited = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    private THashMap _parse() {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fMapFile));
        String string = bufferedReader.readLine();
        int n = 1;
        THashMap tHashMap = new THashMap();
        while (string != null) {
            String[] stringArray = ParseUtils.string2strings(string = string.trim(), "\t", false);
            if (stringArray.length != 2) {
                throw new ParseException("Bad format for map file: " + this.fMapFile + " on line: " + n + " >" + string + "<");
            }
            Set set = ParseUtils.string2stringsSet(stringArray[1], "", false);
            Object object = tHashMap.get(stringArray[0]);
            if (object == null) {
                tHashMap.put(stringArray[0], set);
            } else {
                ((Set)object).addAll(set);
                tHashMap.put(stringArray[0], object);
            }
            string = bufferedReader.readLine();
            ++n;
        }
        bufferedReader.close();
        return tHashMap;
    }

    @Override
    public final MappingDbType getMappingDbType() {
        if (this.fInited) {
            return super.getMappingDbType();
        }
        return MappingDbTypes.lookupMappingType(this.fStruc.mappingDbType);
    }

    @Override
    public final Chip getSourceChip() {
        if (this.fInited) {
            return super.getSourceChip();
        }
        return VdbRuntimeResources.getChip(this.fStruc.sourceChipName);
    }

    @Override
    public final Chip getTargetChip() {
        if (this.fInited) {
            return super.getTargetChip();
        }
        return VdbRuntimeResources.getChip(this.fStruc.targetChipName);
    }

    @Override
    public final boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType) {
        if (this.fInited) {
            return super.equals(chip, chip2, mappingDbType);
        }
        return this.fStruc.equals(chip, chip2, mappingDbType);
    }

    @Override
    public final boolean equals(Chip chip, Chip chip2) {
        if (this.fInited) {
            return super.equals(chip, chip2);
        }
        return this.fStruc.equals(chip, chip2);
    }

    @Override
    public final int getNumSourceProbes() {
        this.checkAndInit();
        return super.getNumSourceProbes();
    }

    @Override
    public final Set map(String string) {
        this.checkAndInit();
        return super.map(string);
    }

    @Override
    public final String[] getSourceProbes() {
        this.checkAndInit();
        return super.getSourceProbes();
    }
}

