/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.vdb.Organism;
import edu.mit.broad.vdb.Vdb;
import edu.mit.broad.vdb.chip.GeneProbe;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.EntrezGene;
import edu.mit.broad.vdb.meg.Gene$Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntrezGeneDb
extends AbstractObject
implements Vdb {
    private String fSourcePath;
    private Version fVersion;
    private EntrezGene[] fEntrezGenes;
    private Map fGeneSymbolEntrezGeneMap;
    private Map fGeneIdEntrezGeneMap;
    private Map fEntrezIdGeneSymbolMap;

    public final EntrezGeneDb cloneShallow(Map map) {
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            EntrezGene entrezGene = this.getEntrezGene(i2);
            Object v = map.get(entrezGene.getEntrezID() + "");
            if (v == null) continue;
            Set set = (Set)v;
            entrezGene.cloneShallow(set);
        }
        return this;
    }

    public EntrezGeneDb(String string, Version version, EntrezGene[] entrezGeneArray) {
        this.init(string, version, entrezGeneArray);
    }

    public EntrezGeneDb(File file, Version version, EntrezGene[] entrezGeneArray) {
        this.init(file.getPath(), version, entrezGeneArray);
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    public final EntrezGeneDb extract(Organism organism) {
        ArrayList<EntrezGene> arrayList = new ArrayList<EntrezGene>();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            if (!this.getEntrezGene(i2).isOrg(organism)) continue;
            arrayList.add(this.getEntrezGene(i2));
        }
        return new EntrezGeneDb(this.getSourcePath() + "_" + organism.getName(), this.getVersion(), arrayList.toArray(new EntrezGene[arrayList.size()]));
    }

    public final Probe[] createProbes_by_symbol(Organism organism) {
        ArrayList<EntrezGene> arrayList = new ArrayList<EntrezGene>();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            if (!this.getEntrezGene(i2).isOrg(organism)) continue;
            arrayList.add(this.getEntrezGene(i2));
        }
        return arrayList.toArray(new Probe[arrayList.size()]);
    }

    public final Probe[] createProbes_by_symbol() {
        ArrayList<EntrezGene> arrayList = new ArrayList<EntrezGene>();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            arrayList.add(this.getEntrezGene(i2));
        }
        return arrayList.toArray(new Probe[arrayList.size()]);
    }

    public final Probe[] createProbes_by_accession() {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            arrayList.addAll(this.createProbes_by_accession(this.getEntrezGene(i2)));
        }
        return arrayList.toArray(new Probe[arrayList.size()]);
    }

    public final Probe[] createProbes_by_accession(Organism organism) {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            if (!this.getEntrezGene(i2).isOrg(organism)) continue;
            arrayList.addAll(this.createProbes_by_accession(this.getEntrezGene(i2)));
        }
        return arrayList.toArray(new Probe[arrayList.size()]);
    }

    public final List createProbes_by_accession(EntrezGene entrezGene) {
        Set set = entrezGene.getSeqAccessions();
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GeneProbe> arrayList = new ArrayList<GeneProbe>();
        for (Object e2 : set) {
            arrayList.add(new GeneProbe(e2.toString(), entrezGene));
        }
        return arrayList;
    }

    private void init(String string, Version version, EntrezGene[] entrezGeneArray) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version cannot be null");
        }
        if (entrezGeneArray == null) {
            throw new IllegalArgumentException("Parameter entrezs cannot be null");
        }
        super.initialize(string);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Long> hashSet2 = new HashSet<Long>();
        ArrayList<EntrezGene> arrayList = new ArrayList<EntrezGene>();
        for (int i2 = 0; i2 < entrezGeneArray.length; ++i2) {
            if (hashSet.contains(entrezGeneArray[i2].getEntrezID())) {
                hashSet2.add(entrezGeneArray[i2].getEntrezID());
                continue;
            }
            arrayList.add(entrezGeneArray[i2]);
            hashSet.add(entrezGeneArray[i2].getSymbol());
        }
        if (!hashSet2.isEmpty()) {
            this.log.warn("There were Duplicate Entrez records (which were discarded): " + hashSet2.size());
        }
        this.fVersion = version;
        this.fSourcePath = string;
        this.fEntrezGenes = arrayList.toArray(new EntrezGene[arrayList.size()]);
    }

    public final void printfInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of unique entrez records: ").append(this.fEntrezGenes.length);
        System.out.println(stringBuffer.toString());
    }

    @Override
    public final String getSourcePath() {
        return this.fSourcePath;
    }

    public final EntrezGene[] getEntrezGenes() {
        return this.fEntrezGenes;
    }

    public final EntrezGene getEntrezGene(int n) {
        return this.fEntrezGenes[n];
    }

    public final EntrezGene getEntrezGene(long l2) {
        this.initGeneIdMap();
        Object v = this.fGeneIdEntrezGeneMap.get(l2);
        if (v != null) {
            return (EntrezGene)v;
        }
        throw new IllegalArgumentException("No such Entrez ID: >" + l2 + "<");
    }

    @Override
    public final int getNumRecords() {
        return this.fEntrezGenes.length;
    }

    @Override
    public final Version getVersion() {
        return this.fVersion;
    }

    public final Map createGeneSymbolEntrezGeneMap() {
        this.initGeneSymbolMap();
        return new HashMap(this.fGeneSymbolEntrezGeneMap);
    }

    private void initGeneSymbolMap() {
        if (this.fGeneSymbolEntrezGeneMap == null) {
            this.fGeneSymbolEntrezGeneMap = new HashMap();
            for (int i2 = 0; i2 < this.fEntrezGenes.length; ++i2) {
                this.fGeneSymbolEntrezGeneMap.put(this.fEntrezGenes[i2].getSymbol(), this.fEntrezGenes[i2]);
            }
        }
    }

    private void initGeneIdMap() {
        if (this.fGeneIdEntrezGeneMap == null) {
            this.fGeneIdEntrezGeneMap = new HashMap();
            for (int i2 = 0; i2 < this.fEntrezGenes.length; ++i2) {
                this.fGeneIdEntrezGeneMap.put(this.fEntrezGenes[i2].getEntrezID(), this.fEntrezGenes[i2]);
            }
        }
    }

    public final boolean isSymbol(String string) {
        this.initGeneSymbolMap();
        return this.fGeneSymbolEntrezGeneMap.containsKey(string);
    }

    public final EntrezGene getEntrezGene(String string) {
        this.initGeneSymbolMap();
        Object v = this.fGeneSymbolEntrezGeneMap.get(string);
        if (v != null) {
            return (EntrezGene)v;
        }
        return null;
    }

    public final Map createGeneSymbolAccessionMap() {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            Set set;
            EntrezGene entrezGene = this.getEntrezGene(i2);
            if (entrezGene.getSymbol() == null || (set = entrezGene.getSeqAccessions()) == null || set.isEmpty()) continue;
            Object object = hashMap.get(entrezGene.getSymbol());
            if (object == null) {
                object = new HashSet();
            }
            ((Set)object).addAll(set);
            hashMap.put(entrezGene.getSymbol(), object);
        }
        return hashMap;
    }

    public final Map createEntrezIdGeneSymbolMap() {
        if (this.fEntrezIdGeneSymbolMap == null) {
            HashMap<Long, String> hashMap = new HashMap<Long, String>();
            for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
                EntrezGene entrezGene = this.getEntrezGene(i2);
                if (Gene$Helper.isNull(entrezGene)) continue;
                hashMap.put(entrezGene.getEntrezID(), entrezGene.getSymbol());
            }
            this.fEntrezIdGeneSymbolMap = hashMap;
        }
        return this.fEntrezIdGeneSymbolMap;
    }

    public final String getSymbol(String string) {
        this.createEntrezIdGeneSymbolMap();
        Object v = this.fEntrezIdGeneSymbolMap.get(string);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public final Set getSymbols(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e2 : set) {
            String string = this.getSymbol(e2.toString());
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public final Set getSymbols() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            EntrezGene entrezGene = this.getEntrezGene(i2);
            if (Gene$Helper.isNull(entrezGene)) continue;
            hashSet.add(this.getEntrezGene(i2).getSymbol());
        }
        return hashSet;
    }
}

