/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.vdb.Vdb;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.FileInMemoryChip;
import edu.mit.broad.vdb.meg.Unigene$Record;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Unigene
extends AbstractObject
implements Vdb {
    private String fSourcePath;
    private Version fVersion;
    private Unigene$Record[] fUnigenes;
    private Chip fChip;
    private Map fSymbolRecordMap;

    public Unigene(String string, Version version, Unigene$Record[] unigene$RecordArray) {
        this.init(string, version, unigene$RecordArray);
    }

    public Unigene(File file, Version version, Unigene$Record[] unigene$RecordArray) {
        this.init(file.getPath(), version, unigene$RecordArray);
    }

    private void init(String string, Version version, Unigene$Record[] unigene$RecordArray) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version cannot be null");
        }
        if (unigene$RecordArray == null) {
            throw new IllegalArgumentException("Parameter unigenes cannot be null");
        }
        super.initialize(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < unigene$RecordArray.length; ++i2) {
            if (hashSet.contains(unigene$RecordArray[i2].getUnigeneId())) {
                throw new IllegalArgumentException("Duplicate Unigene record: " + unigene$RecordArray[i2].getUnigeneId());
            }
            hashSet.add(unigene$RecordArray[i2].getUnigeneId());
        }
        this.fVersion = version;
        this.fSourcePath = string;
        this.fUnigenes = unigene$RecordArray;
    }

    @Override
    public final String getQuickInfo() {
        return this.fVersion + " " + this.getNumRecords();
    }

    public final Chip createChip() {
        if (this.fChip == null) {
            this.fChip = new FileInMemoryChip("Unigene", null, this.getRecords());
        }
        return this.fChip;
    }

    @Override
    public final int getNumRecords() {
        return this.fUnigenes.length;
    }

    public final Unigene$Record getRecord(int n) {
        return this.fUnigenes[n];
    }

    public final Unigene$Record[] getRecords() {
        return this.fUnigenes;
    }

    public final Map createGeneSymbolAccessionMap() {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            Object object;
            Unigene$Record unigene$Record = this.getRecord(i2);
            if (unigene$Record.getGeneSymbol() == null) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(unigene$Record.getUnigeneId());
            Set set = unigene$Record.getSeqAccessions();
            if (set != null) {
                hashSet.addAll(set);
            }
            if ((object = hashMap.get(unigene$Record.getGeneSymbol())) == null) {
                object = new HashSet();
            }
            ((Set)object).addAll(hashSet);
            hashMap.put(unigene$Record.getGeneSymbol(), object);
        }
        return hashMap;
    }

    private void createGeneSymbolRecordMap() {
        if (this.fSymbolRecordMap == null) {
            this.fSymbolRecordMap = new HashMap();
            for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
                Unigene$Record unigene$Record = this.getRecord(i2);
                if (unigene$Record.getGeneSymbol() == null) continue;
                this.fSymbolRecordMap.put(unigene$Record.getGeneSymbol(), unigene$Record);
            }
        }
    }

    public final Unigene$Record getRecord(String string) {
        this.createGeneSymbolRecordMap();
        Object v = this.fSymbolRecordMap.get(string);
        if (v != null) {
            return (Unigene$Record)v;
        }
        return null;
    }

    public final void printfInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of unique unigene records by symbol: ").append(this.fUnigenes.length);
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.fUnigenes.length; ++i2) {
            String string = this.fUnigenes[i2].getGeneSymbol();
            if (string == null) continue;
            Object object = hashMap.get(string);
            if (object == null) {
                object = new HashSet();
            }
            ((Set)object).add(this.fUnigenes[i2]);
            hashMap.put(string, object);
        }
        stringBuffer.append("# of hugos with unigenes: ").append(hashMap.size());
        System.out.println(stringBuffer.toString());
    }

    @Override
    public final String getSourcePath() {
        return this.fSourcePath;
    }

    public final Unigene$Record[] getUnigenes() {
        return this.fUnigenes;
    }

    @Override
    public final Version getVersion() {
        return this.fVersion;
    }
}

