/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.msigdb;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.FileInMemoryChip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.chip.SimpleProbe;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.msigdb.DeconAccessions$Lookup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeconAccessions {
    private static final Logger klog = XLogger.getLogger(DeconAccessions.class);

    private DeconAccessions() {
    }

    public static final GeneSetMatrix symbolize(GeneSetMatrix geneSetMatrix, boolean bl, boolean bl2) {
        GeneSet[] geneSetArray = new GeneSet[geneSetMatrix.getNumGeneSets()];
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            geneSetArray[i2] = DeconAccessions.symbolize(geneSetMatrix.getGeneSet(i2), bl, bl2);
        }
        return new DefaultGeneSetMatrix(geneSetMatrix.getName() + "_symbolized", geneSetArray);
    }

    public static final GeneSet symbolize(GeneSet geneSet, boolean bl, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            DeconAccessions$Lookup deconAccessions$Lookup = DeconAccessions.creatLookup(string);
            if (!deconAccessions$Lookup.hasSymbolMatch()) {
                if (bl) continue;
                hashSet.add(string);
                continue;
            }
            hashSet.add(deconAccessions$Lookup.getMatch().getSymbol());
        }
        String string = bl2 ? geneSet.getName(true) + "_symbolized" : geneSet.getName(true);
        return new FSet(string, hashSet);
    }

    public static final GeneSet getOnlyExactMatches(GeneSet geneSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            DeconAccessions$Lookup deconAccessions$Lookup = DeconAccessions.creatLookup(string);
            if (!deconAccessions$Lookup.isDitto()) continue;
            hashSet.add(deconAccessions$Lookup.getMatch().getSymbol());
        }
        return new FSet(geneSet.getName() + "_only_exact_matches", hashSet);
    }

    public static final GeneSet getOnlyAliases(GeneSet geneSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            DeconAccessions$Lookup deconAccessions$Lookup = DeconAccessions.creatLookup(string);
            if (!deconAccessions$Lookup.isAlias()) continue;
            hashSet.add(deconAccessions$Lookup.getMatch().getSymbol());
        }
        return new FSet(geneSet.getName() + "_only_aliases", hashSet);
    }

    public static final GeneSet getOnlyInvalids(GeneSet geneSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string = geneSet.getMember(i2);
            DeconAccessions$Lookup deconAccessions$Lookup = DeconAccessions.creatLookup(string);
            if (deconAccessions$Lookup.hasSymbolMatch()) continue;
            hashSet.add(string);
        }
        return new FSet(geneSet.getName() + "_only_invalids", hashSet);
    }

    public static final StringDataframe createReport(String string, Set set) {
        return DeconAccessions.createReport(new FSet(string, set));
    }

    public static final StringDataframe createReport(Chip chip) {
        return DeconAccessions.createReport(new FSet(chip.getName(), chip.getSymbols(Chip.OMIT_NULLS)));
    }

    public static final StringDataframe createReport(GeneSet geneSet) {
        String[] stringArray = new String[]{"STATUS", "LOOKED_UP_SYMBOL", "TITLE"};
        String[] stringArray2 = new String[geneSet.getNumMembers()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringMatrix stringMatrix = new StringMatrix(stringArray2.length, stringArray.length);
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string;
            stringArray2[i2] = string = geneSet.getMember(i2);
            DeconAccessions$Lookup deconAccessions$Lookup = DeconAccessions.creatLookup(string);
            if (deconAccessions$Lookup.isDitto()) {
                stringMatrix.setElement(i2, 0, "valid_symbol");
                stringMatrix.setElement(i2, 1, deconAccessions$Lookup.getMatch().getSymbol());
                stringMatrix.setElement(i2, 2, deconAccessions$Lookup.getMatch().getTitle());
                continue;
            }
            if (!deconAccessions$Lookup.hasSymbolMatch()) {
                ++n;
                stringMatrix.setElement(i2, 0, "no_match");
                continue;
            }
            if (deconAccessions$Lookup.isAlias()) {
                ++n2;
                stringMatrix.setElement(i2, 0, "alias");
                stringMatrix.setElement(i2, 1, deconAccessions$Lookup.getMatch().getSymbol());
                stringMatrix.setElement(i2, 2, deconAccessions$Lookup.getMatch().getTitle());
                continue;
            }
            ++n3;
            stringMatrix.setElement(i2, 0, "accession");
            stringMatrix.setElement(i2, 1, deconAccessions$Lookup.getMatch().getSymbol());
            stringMatrix.setElement(i2, 2, deconAccessions$Lookup.getMatch().getTitle());
        }
        klog.info("# unique symbols: " + geneSet.getNumMembers() + " #aliased: " + n2 + " #accessions " + n3 + " #invalid: " + n);
        return new StringDataframe(geneSet.getName(), stringMatrix, stringArray2, stringArray, true);
    }

    public static final Chip createDeconChip(Chip chip) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        for (int i2 = 0; i2 < chip.getNumProbes(); ++i2) {
            Object object;
            Probe probe = chip.getProbe(i2);
            String string = probe.getName();
            Gene gene = probe.getGene();
            String string2 = null;
            String string3 = null;
            if (!NamingConventions.isNull(gene)) {
                string2 = gene.getSymbol();
                string3 = gene.getTitle();
                object = DeconAccessions.creatLookup(string2);
                if (((DeconAccessions$Lookup)object).isAlias()) {
                    Gene gene2 = ((DeconAccessions$Lookup)object).getMatch();
                    string2 = gene2.getSymbol();
                    string3 = gene2.getTitle();
                    ++n;
                }
            }
            object = new SimpleProbe(string, string2, string3);
            arrayList.add(object);
        }
        klog.info("For chip: " + chip.getName() + " # changed: " + n + " / " + chip.getNumProbes() + " probes");
        return new FileInMemoryChip(chip.getName(), "combo_dummy_source", arrayList.toArray(new Probe[arrayList.size()]));
    }

    public static final DeconAccessions$Lookup[] createLookups(GeneSet geneSet) {
        DeconAccessions$Lookup[] deconAccessions$LookupArray = new DeconAccessions$Lookup[geneSet.getNumMembers()];
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            deconAccessions$LookupArray[i2] = DeconAccessions.creatLookup(geneSet.getMember(i2));
        }
        return deconAccessions$LookupArray;
    }

    public static final DeconAccessions$Lookup creatLookup(String string) {
        Gene gene = null;
        boolean bl = false;
        if (VdbRuntimeResources.getChip_Gene_Symbol().isProbe(string)) {
            gene = VdbRuntimeResources.getChip_Gene_Symbol().getProbe(string).getGene();
            bl = false;
        } else if (VdbRuntimeResources.getAliasDb().isAlias(string)) {
            gene = VdbRuntimeResources.getAliasDb().getHugo(string);
            bl = true;
        } else if (VdbRuntimeResources.getChip_Seq_Accession().isProbe(string)) {
            gene = VdbRuntimeResources.getChip_Seq_Accession().getHugo(string);
            bl = false;
        }
        return new DeconAccessions$Lookup(string, gene, bl);
    }
}

