/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.ColorMap$Columns;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.MiscParsers$ExcelSdfColorStruc;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.sampledb.AbstractSample;
import edu.mit.broad.vdb.sampledb.AbstractSampleAnnot;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.vdb.sampledb.SampleAnnotNCI60$ColorMapImpl;
import edu.mit.broad.vdb.sampledb.SampleAnnotNCI60$LineageComparator;
import edu.mit.broad.vdb.sampledb.SampleNCI60;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleAnnotNCI60
extends AbstractSampleAnnot {
    private static List ALL_CATEGORY_NAMES = new ArrayList();
    private static Set CATEGORICAL_CATEGORY_NAMES = new HashSet();
    private ColorMap$Columns fColorMap;
    private Map fStateColorMap;

    public static final String[] getCommonCategoryNames() {
        return new String[0];
    }

    private SampleAnnotNCI60(String string, Map map, SampleNCI60[] sampleNCI60Array) {
        this.initHere(string, map, sampleNCI60Array);
    }

    private void initHere(String string, Map map, SampleNCI60[] sampleNCI60Array) {
        super.initialize(string);
        this.fSamples = sampleNCI60Array;
        this.fStateColorMap = map;
        this.fColorMap = new SampleAnnotNCI60$ColorMapImpl(this, map);
    }

    @Override
    public final SampleAnnot cloneDeep(String string, String[] stringArray) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(this.getSample(stringArray[i2]));
        }
        return new SampleAnnotNCI60(string, this.fStateColorMap, arrayList.toArray(new SampleNCI60[arrayList.size()]));
    }

    @Override
    public final String[] getAllCategoricalCategoryNames() {
        return CATEGORICAL_CATEGORY_NAMES.toArray(new String[CATEGORICAL_CATEGORY_NAMES.size()]);
    }

    @Override
    public final boolean isValidCategoricalCategory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param categoryName cannot be null");
        }
        return CATEGORICAL_CATEGORY_NAMES.contains(string.toUpperCase());
    }

    public static final String[] getAllCategoryNames() {
        return ALL_CATEGORY_NAMES.toArray(new String[ALL_CATEGORY_NAMES.size()]);
    }

    public static final boolean isCategoryName(String string) {
        return ALL_CATEGORY_NAMES.contains(string);
    }

    @Override
    public final Comparator createDefaultSampleComparator() {
        return new SampleAnnotNCI60$LineageComparator(this);
    }

    @Override
    public final Comparator createDefaultStateComparator(String string) {
        throw new NotImplementedException();
    }

    public final String[] getSampleNames_OrderByLineage() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            arrayList.add(this.getSample(i2));
        }
        Collections.sort(arrayList, new SampleAnnotNCI60$LineageComparator(this));
        return SampleAnnotNCI60._toSampleNames(arrayList);
    }

    @Override
    public final ColorMap$Columns getColorMap() {
        return this.fColorMap;
    }

    public final String[] getLineages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            String string = this._getSample(i2).getLineage();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private SampleNCI60 _getSample(int n) {
        return (SampleNCI60)this.getSample(n);
    }

    public final void saveBrief(Template template, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            SampleNCI60 sampleNCI60 = (SampleNCI60)this.getSample(i2);
            stringBuffer.append(sampleNCI60.getName()).append('\t');
            stringBuffer.append(sampleNCI60.getLineage()).append('\t');
            stringBuffer.append(sampleNCI60.getDataSource()).append('\t');
            stringBuffer.append(sampleNCI60.getChipName()).append('\t');
            if (template != null) {
                stringBuffer.append(template.getItemByProfilePos(i2).getId()).append('\t');
            }
            if (template != null) {
                stringBuffer.append(template.getClassByProfilePos(i2).getName());
            }
            stringBuffer.append('\n');
        }
        FileUtils.write(stringBuffer.toString(), file);
    }

    public static final SampleAnnotNCI60 parse(File file) {
        return SampleAnnotNCI60.parse(MiscParsers.excel2sdf_and_colors(file));
    }

    public static final SampleAnnotNCI60 parse(MiscParsers$ExcelSdfColorStruc miscParsers$ExcelSdfColorStruc) {
        StringDataframe stringDataframe = AbstractSampleAnnot.checkSdf_makeUC_and_remove_bad_qc_samples(miscParsers$ExcelSdfColorStruc);
        Sample[] sampleArray = new SampleNCI60[stringDataframe.getNumRow()];
        for (int i2 = 0; i2 < sampleArray.length; ++i2) {
            String string = SampleAnnotNCI60.make_name_proper(stringDataframe.getRowName(i2));
            sampleArray[i2] = new SampleNCI60(string);
        }
        AbstractSample.setCommonSampleProperties((AbstractSample[])sampleArray, stringDataframe);
        String[] stringArray = stringDataframe.getColumn("LINEAGE");
        for (int i3 = 0; i3 < sampleArray.length; ++i3) {
            ((SampleNCI60)sampleArray[i3]).fLineage = stringArray[i3];
        }
        SampleAnnotNCI60.checkForDuplicates_SampleNames_and_SampleCelFiles(sampleArray);
        return new SampleAnnotNCI60(miscParsers$ExcelSdfColorStruc.sdf.getName(), miscParsers$ExcelSdfColorStruc.stateColorMap, (SampleNCI60[])sampleArray);
    }

    static {
        ALL_CATEGORY_NAMES.add("SAMPLE_NAME");
        ALL_CATEGORY_NAMES.add("LINEAGE");
    }
}

