/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.ext.SystemCall;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.prefs.FilePreference;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Icon;

public class OsExplorerAction
extends ExtAction {
    public OsExplorerAction() {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    public OsExplorerAction(String string) {
        this();
        this.fPath = string;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        FilePreference filePreference = XPreferencesFactory.kOsExplorer;
        try {
            if (this.fPath != null) {
                File file = new File(this.fPath);
                File file2 = file.isDirectory() ? file : file.getParentFile();
                SystemCall.launchExternalApplication(file2, filePreference.getFile().getPath());
            } else {
                SystemCall.launchExternalApplication(filePreference.getFile().getPath());
            }
        }
        catch (Throwable throwable) {
            this.showHelpfulExtError(filePreference, "File Explorer", throwable);
        }
    }

    @Override
    public final String getId() {
        return "OsExplorerAction";
    }

    @Override
    public final String getName() {
        return "File Explorer";
    }

    @Override
    public final Icon getIcon() {
        return JarResources.getIcon("OsExplorer16.gif");
    }

    @Override
    public final String getDescription() {
        return "Launch FileExplorer in an External Process";
    }
}

