/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import javax.swing.Icon;

public class GeneSetRemoveDuplicatesAction
extends FileAction {
    private File fFile;

    public GeneSetRemoveDuplicatesAction() {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    @Override
    public final void setFile(File file) {
        this.fFile = file;
    }

    @Override
    public final Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFile != null) {
                if (!this.fFile.getName().endsWith(".grp")) {
                    Application.getWindowManager().showError("Only .grp files allowed - cannot perform this action on file: " + this.fFile);
                    return null;
                }
                int n = ParseUtils.countLines(this.fFile, true);
                GeneSet geneSet = (GeneSet)ParserFactory.read(this.fFile);
                ParserFactory.save(geneSet, this.fFile);
                Application.getWindowManager().showMessage("Successfully removed duplicates from the GeneSet. Before: " + n + " after: " + geneSet.getNumMembers());
            } else {
                TraceUtils.showTrace();
                Application.getWindowManager().showMessage("No file or object to work on was specified: " + this.fFile);
            }
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Error removing duplicates from GeneSet", throwable);
        }
        return widget;
    }

    @Override
    public final String getId() {
        return "GeneSetRemoveDuplicatesAction";
    }

    @Override
    public final String getName() {
        return "=> Remove duplicates from the GeneSet";
    }

    @Override
    public final Icon getIcon() {
        return null;
    }

    @Override
    public final String getDescription() {
        return "Remove duplicate members from the gene set. The file will be overwritten with the new data.";
    }
}

