/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.InterruptedIOException;
import javax.swing.Icon;

public class LoadAction
extends FileObjectAction {
    private Object fFileOrObject;
    private boolean fUseCache;
    private static final Icon LOAD_ICON = JarResources.getIcon("Parser16.gif");
    private static final Icon RELOAD_ICON = JarResources.getIcon("Refresh16_2.gif");

    public LoadAction(boolean bl) {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
        this.fUseCache = bl;
    }

    @Override
    public final void setFile(File file) {
        this.fFileOrObject = file;
    }

    @Override
    public final void setObject(Object object) {
        this.fFileOrObject = object;
    }

    @Override
    public final Widget getWidget() {
        Widget widget;
        block8: {
            widget = null;
            Object var2_2 = null;
            try {
                if (this.fFileOrObject != null) {
                    File file = this.fFileOrObject instanceof File ? (File)this.fFileOrObject : ParserFactory.getCache().getSourceFile(this.fFileOrObject);
                    PersistentObject persistentObject = ParserFactory.read(file, this.fUseCache);
                    if (persistentObject != null) {
                        if (this.fUseCache) {
                            this.log.info("Loaded: " + persistentObject.getName());
                        } else {
                            Application.getWindowManager().showMessage("<html><body><b>Successfully reloaded: " + persistentObject.getName() + "</b><br>From file: " + file + "</body></html>");
                        }
                    } else {
                        this.log.info("Cancelled data import!!");
                    }
                } else {
                    Application.getWindowManager().showMessage("No file or object to load/reload was specified");
                }
            }
            catch (Throwable throwable) {
                if (var2_2 != null && throwable instanceof InterruptedIOException) break block8;
                Application.getWindowManager().showError("Error loading data from file", throwable);
            }
        }
        return widget;
    }

    @Override
    public final String getId() {
        if (this.fUseCache) {
            return "LoadAction";
        }
        return "ForceReloadAction";
    }

    @Override
    public final String getName() {
        if (this.fUseCache) {
            return "Import data";
        }
        return "Force data reload";
    }

    @Override
    public final Icon getIcon() {
        if (this.fUseCache) {
            return LOAD_ICON;
        }
        return RELOAD_ICON;
    }

    @Override
    public final String getDescription() {
        if (this.fUseCache) {
            return "Load data from source filee";
        }
        return "Reload data from source file overwritting the cache";
    }
}

