/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.ReportStub;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import xtools.api.Tool;

public class ToolManagerImpl
implements ToolManager {
    private static final Logger klog = XLogger.getLogger(ToolManagerImpl.class);
    private static Map kToolNameReporStubMap;

    @Override
    public final String getLastToolName() {
        return XPreferencesFactory.kLastToolName.getString();
    }

    @Override
    public final void setLastToolName(Tool tool) {
        XPreferencesFactory.kLastToolName.setValue(tool.getName());
    }

    @Override
    public final ReportStub getLastReportStub(String string) {
        if (kToolNameReporStubMap == null) {
            kToolNameReporStubMap = new HashMap();
        }
        if (kToolNameReporStubMap.containsKey(string = ClassUtils.shorten(string))) {
            return (ReportStub)kToolNameReporStubMap.get(string);
        }
        File[] fileArray = this._getReportFiles();
        File file = null;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                String string2 = FileUtils.removeExtension(fileArray[i2]);
                if (string2.indexOf(string) == -1) continue;
                if (file == null) {
                    file = fileArray[i2];
                    continue;
                }
                if (file.lastModified() >= fileArray[i2].lastModified()) continue;
                file = fileArray[i2];
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (file != null) {
            ReportStub reportStub = new ReportStub(file);
            kToolNameReporStubMap.put(string, reportStub);
            return reportStub;
        }
        return null;
    }

    @Override
    public final ReportStub[] getReportsInCache() {
        File[] fileArray = this._getReportFiles();
        ArrayList<ReportStub> arrayList = new ArrayList<ReportStub>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                ReportStub reportStub = new ReportStub(fileArray[i2]);
                arrayList.add(reportStub);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList.toArray(new ReportStub[arrayList.size()]);
    }

    private File[] _getReportFiles() {
        File file = Application.getVdbManager().getReportsCacheDir();
        if (!file.exists()) {
            klog.warn("Report cache: " + file + " not found");
            return new File[0];
        }
        return file.listFiles(DataFormat.RPT_FORMAT.getFilenameFilter());
    }
}

