/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.ComparatorFactory$FileExtComparator;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.xbench.core.api.XStore$1;
import edu.mit.broad.xbench.core.api.XStore$AdditionDecider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class XStore
extends AbstractListModel
implements ComboBoxModel {
    private static final Logger klog = XLogger.getLogger(XStore.class);
    private File fFile;
    protected List fLines;
    private int fSelIndex = 0;
    private boolean fLoaded;
    private XStore$AdditionDecider fDecider;

    public XStore(File file, XStore$AdditionDecider xStore$AdditionDecider) {
        this.init(file, xStore$AdditionDecider);
    }

    protected XStore() {
    }

    protected final void init(File file, XStore$AdditionDecider xStore$AdditionDecider) {
        this.fFile = file;
        this.fLines = new ArrayList();
        this.fDecider = xStore$AdditionDecider;
    }

    private void load() {
        if (this.fLoaded) {
            return;
        }
        try {
            if (!this.fFile.exists()) {
                this.fFile.createNewFile();
            }
            List list = ParseUtils.readFfn(this.fFile);
            this.fLines = new ArrayList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string = list.get(i2).toString();
                String string2 = this.fDecider.addThis(string);
                if (string2 == null || string2.length() == 0) continue;
                this.fLines.add(string2);
            }
            this.sort();
            this.fLoaded = true;
            this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
        }
        catch (Throwable throwable) {
            klog.fatal("Could not init store: " + this.fFile, throwable);
        }
    }

    public final void sort(Comparator comparator) {
        Object object = this.getSelectedItem();
        Collections.sort(this.fLines, comparator);
        for (int i2 = 0; i2 < this.fLines.size(); ++i2) {
            Object e2 = this.fLines.get(i2);
            if (e2 != object) continue;
            this.setSelectedItem(e2);
            this.fSelIndex = i2;
            break;
        }
    }

    public final void clearAll() {
        this.fLines.clear();
        this.save();
    }

    public final void add(String string) {
        String string2;
        if (!this.fLoaded) {
            this.load();
        }
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string2 = this.fDecider.addThis(string)) != null && string2.length() != 0) {
            this.fLines.add(string2);
            this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
        }
    }

    public final void save() {
        Thread thread = new Thread(this.append());
        thread.start();
    }

    public final void trim(int n) {
        if (!this.fLoaded) {
            this.load();
        }
        if (this.fLines.size() > n) {
            int n2 = this.fLines.size();
            this.fLines = this.fLines.subList(n2 - n, n2);
        }
        this.save();
        this.fireContentsChanged(this, this.fLines.size() - 1, this.fLines.size());
    }

    public final void removeAndSave(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.fLines.remove(list.get(i2));
        }
        this.save();
    }

    public final void sort() {
        Collections.sort(this.fLines, new ComparatorFactory$FileExtComparator());
    }

    public final void addAndSave(String string) {
        if (!this.fLoaded) {
            this.load();
        }
        if (string == null || string.length() == 0) {
            return;
        }
        this.add(string);
        this.save();
        this.sort();
    }

    private Runnable append() {
        return new XStore$1(this);
    }

    @Override
    public final int getSize() {
        if (!this.fLoaded) {
            this.load();
        }
        return this.fLines.size();
    }

    @Override
    public final Object getElementAt(int n) {
        return this.fLines.get(n);
    }

    public final boolean contains(String string) {
        return this.fLines.contains(string);
    }

    @Override
    public final Object getSelectedItem() {
        if (this.fLines.size() == 0) {
            return null;
        }
        return this.fLines.get(this.fSelIndex);
    }

    public final Object getSelectedValue() {
        if (this.fLines.size() == 0) {
            return null;
        }
        return this.fLines.get(this.fSelIndex);
    }

    @Override
    public final void setSelectedItem(Object object) {
        this.fSelIndex = this.fLines.indexOf(object);
    }

    static final /* synthetic */ File access$000(XStore xStore) {
        return xStore.fFile;
    }

    static final /* synthetic */ Logger access$100() {
        return klog;
    }
}

